/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import java.util.Properties;
import javax.batch.runtime.BatchStatus;

public class RetryListenerTests
extends ServiceEETest {
    private static JobOperatorBridge jobOp = null;

    public static void setup(String[] args, Properties props) throws EETest.Fault {
        String METHOD = "setup";
        TestUtil.logTrace((String)METHOD);
        try {
            jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            RetryListenerTests.handleException(METHOD, e);
        }
    }

    public static void setUp() throws EETest.Fault {
        jobOp = new JobOperatorBridge();
    }

    public void cleanup() {
    }

    public void testRetryReadListener() throws EETest.Fault {
        String METHOD = "testRetryReadListener";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=8,13,22");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "8,13,22");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: job_retry_listener_test.xml");
            TestUtil.logMsg((String)"Invoking startJobAndWaitForResult for Execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_retry_listener_test", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, jobExec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "Retry listener invoked", jobExec.getExitStatus());
        }
        catch (Exception e) {
            RetryListenerTests.handleException(METHOD, e);
        }
    }

    public void testRetryProcessListener() throws EETest.Fault {
        String METHOD = "testRetryProcessListener";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"processrecord.fail=8,13,22");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("processrecord.fail", "8,13,22");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: job_retry_listener_test.xml");
            TestUtil.logMsg((String)"Invoking startJobAndWaitForResult for Execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_retry_listener_test", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, jobExec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "Retry listener invoked", jobExec.getExitStatus());
        }
        catch (Exception e) {
            RetryListenerTests.handleException(METHOD, e);
        }
    }

    public void testRetryWriteListener() throws EETest.Fault {
        String METHOD = "testRetryWriteListener";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"writerecord.fail=8,13,22");
            TestUtil.logMsg((String)"app.arraysize=30");
            jobParams.put("execution.number", "1");
            jobParams.put("writerecord.fail", "8,13,22");
            jobParams.put("app.arraysize", "30");
            TestUtil.logMsg((String)"Locate job XML file: job_retry_listener_test.xml");
            TestUtil.logMsg((String)"Invoking startJobAndWaitForResult for Execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_retry_listener_test", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + ""));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus() + ""));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, jobExec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "Retry listener invoked", jobExec.getExitStatus());
        }
        catch (Exception e) {
            RetryListenerTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws EETest.Fault {
        TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
        TestUtil.printStackTrace((Throwable)e);
        throw new EETest.Fault(methodName + " failed", e);
    }
}

