/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R1012;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jaxrpc.sharedclients.ClientFactory;
import com.sun.ts.tests.jaxrpc.sharedwebservices.faultservice.WSIConstants;
import com.sun.ts.tests.jaxrpc.wsi.constants.SOAPConstants;
import com.sun.ts.tests.jaxrpc.wsi.requests.SOAPRequests;
import com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R1012.W2JRLR1012ClientOne;
import com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R1012.W2JRLR1012ClientTwo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Properties;

public class Client
extends ServiceEETest
implements SOAPConstants,
WSIConstants,
SOAPRequests {
    private static final String STRING_2 = "R1012-2";
    private W2JRLR1012ClientOne client1;
    private W2JRLR1012ClientTwo client2;

    public static void main(String[] args) {
        Client client = new Client();
        Status status = client.run(args, System.out, System.err);
        status.exit();
    }

    public void setup(String[] args, Properties properties) throws EETest.Fault {
        this.client1 = (W2JRLR1012ClientOne)ClientFactory.getClient(W2JRLR1012ClientOne.class, properties);
        this.client2 = (W2JRLR1012ClientTwo)ClientFactory.getClient(W2JRLR1012ClientTwo.class, properties);
        this.logMsg("setup ok");
    }

    public void cleanup() {
        this.logMsg("cleanup");
    }

    public void testResponseEncoding() throws EETest.Fault {
        InputStream is;
        Charset cs;
        block8: {
            cs = Charset.forName("UTF-8");
            try {
                int index;
                is = this.client1.makeHTTPRequest("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<env:Envelope\n\txmlns:enc=\"http://schemas.xmlsoap.org/soap/encoding/\"\n\txmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\"\n\txmlns:ns0=\"http://w2jrlr1012testservice.org/W2JRLR1012TestService.wsdl\"\n\txmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n\t<env:Body>\n\t\t<ns0:echoString>\n\t\t\t<str>\n\t\t\t\t<ans1:p1 xmlns:ans1=\"http://w2jrlr1012testservice.org/xsd\">R1012-1</ans1:p1>\n\t\t\t</str>\n\t\t</ns0:echoString>\n\t</env:Body>\n</env:Envelope>\n", cs);
                String contentType = this.client1.getResponseHeader("Content-Type");
                if (contentType == null || (index = contentType.toLowerCase().indexOf("charset=")) <= 0) break block8;
                String name = contentType.substring(index + 8).trim();
                if (name.charAt(0) == '\"') {
                    name = name.substring(1, name.length() - 1);
                }
                if (name.equalsIgnoreCase("UTF-8") || name.equalsIgnoreCase("UTF-16")) {
                    char c = name.charAt(0);
                    if (c == '\"' || c == '\'') {
                        name = name.substring(1, name.length() - 1);
                    }
                    cs = Charset.forName(name);
                    break block8;
                }
                throw new EETest.Fault("Response encoded in '" + name + "' (BP-R1012)");
            }
            catch (Exception e) {
                throw new EETest.Fault("Unable to invoke echoString operation (BP-R1012)", e);
            }
        }
        InputStreamReader isr = new InputStreamReader(is, cs);
        try {
            int length;
            char[] buffer = new char[1024];
            while ((length = isr.read(buffer)) > 0) {
            }
        }
        catch (IOException e) {
            throw new EETest.Fault("Unable to read response from endpoint (BP-R1012)", e);
        }
    }

    public void testRequestEncoding() throws EETest.Fault {
        String result;
        try {
            result = this.client2.echoString(STRING_2);
        }
        catch (Exception e) {
            throw new EETest.Fault("Unable to invoke echoString operation (BP-R1012)", e);
        }
        if (!result.equals("OK")) {
            if (result.equals("EXCEPTION")) {
                throw new EETest.Fault("Endpoint unable to process request (BP-R1012)");
            }
            throw new EETest.Fault("Request encoding neither 'UTF-8' nor 'UTF-16' (BP-R1012)");
        }
    }
}

