/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.appclient.messageconsumertests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.TextMessageTestImpl;
import com.sun.ts.tests.jms.core20.appclient.messageconsumertests.MyMessageListener;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;

public class Client
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core20.appclient.messageconsumertests.Client";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private transient JmsTool toolForProducer = null;
    transient MessageProducer producer = null;
    transient MessageConsumer consumer = null;
    transient Connection connection = null;
    transient Session session = null;
    transient Destination destination = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    private static final int numMessages = 3;
    private static final int iterations = 5;
    boolean queueTest = false;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            TestUtil.logMsg((String)"Didn't get expected exception");
            throw new Exception("Didn't get expected exception");
        }
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            TestUtil.logMsg((String)"Closing default Connection");
            this.tool.getDefaultConnection().close();
            if (this.queueTest) {
                TestUtil.logMsg((String)"Flush any messages left on Queue");
                this.tool.flushDestination();
            }
            this.tool.closeAllResources();
            if (this.toolForProducer != null) {
                this.toolForProducer.getDefaultConnection().close();
                if (this.queueTest) {
                    TestUtil.logMsg((String)"Flush any messages left on Queue");
                    this.toolForProducer.flushDestination();
                }
                this.toolForProducer.closeAllResources();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("cleanup failed!", e);
        }
    }

    public void queueSendRecvMessageListenerTest() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        try {
            TestUtil.logMsg((String)"Setup JmsTool for COMMON QUEUE");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.toolForProducer = new JmsTool(13, this.user, this.password, this.mode);
            this.logMsg("Initialize variables after JmsTool setup");
            this.producer = this.toolForProducer.getDefaultProducer();
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            TestUtil.logMsg((String)"Create message listener MyMessageListener");
            MyMessageListener listener = new MyMessageListener();
            TestUtil.logMsg((String)"Set message listener MyMessageListener on this MessageConsumer");
            this.consumer.setMessageListener((MessageListener)listener);
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessageTestImpl expTextMessage = new TextMessageTestImpl();
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setText(message);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueSendRecvMessageListenerTest");
            TestUtil.logMsg((String)"Calling MessageProducer.send(Message)");
            this.producer.send((Message)expTextMessage);
            TestUtil.logMsg((String)"Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage (actTextMessage=NULL)");
            }
            TestUtil.logMsg((String)"Check value of message returned");
            if (!actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logErr((String)("Received [" + actTextMessage.getText() + "] expected [" + expTextMessage.getText() + "]"));
                pass = false;
            }
            TestUtil.logMsg((String)"Retreive MessageListener by calling MessageConsumer.getMessageListener()");
            MessageListener messageListener = this.consumer.getMessageListener();
            if (messageListener == null) {
                TestUtil.logErr((String)"getMessageListener() returned NULL");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("queueSendRecvMessageListenerTest", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("queueSendRecvMessageListenerTest failed");
        }
    }

    public void topicSendRecvMessageListenerTest() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        try {
            TestUtil.logMsg((String)"Setup JmsTool for COMMON TOPIC");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.toolForProducer = new JmsTool(14, this.user, this.password, this.mode);
            this.logMsg("Initialize variables after JmsTool setup");
            this.producer = this.toolForProducer.getDefaultProducer();
            this.consumer = this.tool.getDefaultConsumer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            TestUtil.logMsg((String)"Create message listener MyMessageListener");
            MyMessageListener listener = new MyMessageListener();
            TestUtil.logMsg((String)"Set message listener MyMessageListener on this MessageConsumer");
            this.consumer.setMessageListener((MessageListener)listener);
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessageTestImpl expTextMessage = new TextMessageTestImpl();
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setText(message);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicSendRecvMessageListenerTest");
            TestUtil.logMsg((String)"Calling MessageProducer.send(Message)");
            this.producer.send((Message)expTextMessage);
            TestUtil.logMsg((String)"Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage (actTextMessage=NULL)");
            }
            TestUtil.logMsg((String)"Check value of message returned");
            if (!actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logErr((String)("Received [" + actTextMessage.getText() + "] expected [" + expTextMessage.getText() + "]"));
                pass = false;
            }
            TestUtil.logMsg((String)"Retreive MessageListener by calling MessageConsumer.getMessageListener()");
            MessageListener messageListener = this.consumer.getMessageListener();
            if (messageListener == null) {
                TestUtil.logErr((String)"getMessageListener() returned NULL");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("topicSendRecvMessageListenerTest", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("topicSendRecvMessageListenerTest failed");
        }
    }
}

