/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.assembly.classpath.ejb;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.assembly.classpath.ejb.TestBean;
import com.sun.ts.tests.assembly.classpath.ejb.TestBeanHome;
import java.util.Properties;

public class Client
extends EETest {
    public static final String lookupName = "java:comp/env/ejb/TestBean";
    private TSNamingContext nctx = null;
    private Properties props = null;
    private TestBeanHome home;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.logMsg("[Client] setup(): getting Naming Context...");
            this.nctx = new TSNamingContext();
            this.logTrace("[Client] Looking up bean Home...");
            this.home = (TestBeanHome)this.nctx.lookup(lookupName, TestBeanHome.class);
            this.logMsg("[Client] Setup OK!");
        }
        catch (Exception e) {
            throw new EETest.Fault("[Client] Setup failed:" + e, e);
        }
    }

    public void testDirectLibrary() throws EETest.Fault {
        try {
            this.logTrace("[Client] Creating bean instance...");
            TestBean bean = this.home.create();
            bean.initLogging(this.props);
            this.logTrace("[Client] Calling bean...");
            boolean pass = bean.testDirectLibrary();
            if (!pass) {
                throw new EETest.Fault("EJB direct classpath test failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("Caught exception: " + e, e);
        }
    }

    public void testIndirectLibrary() throws EETest.Fault {
        try {
            this.logTrace("[Client] Creating bean instance...");
            TestBean bean = this.home.create();
            bean.initLogging(this.props);
            this.logTrace("[Client] Calling bean...");
            boolean pass = bean.testIndirectLibrary();
            if (!pass) {
                throw new EETest.Fault("EJB indirect classpath test failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("Caught exception: " + e, e);
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("[Client] cleanup()");
    }
}

