/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.lock.query;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.lock.query.Department;
import com.sun.ts.tests.jpa.core.lock.query.Employee;
import com.sun.ts.tests.jpa.core.lock.query.Insurance;
import java.sql.Date;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;

public class Client
extends PMClientBase {
    private final Date d1 = this.getSQLDate("2000-02-14");

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            TestUtil.logTrace((String)"Create Test Data");
            this.removeTestData();
            this.createTestData();
            TestUtil.logTrace((String)"Done creating test data");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getResultListTest1() throws EETest.Fault {
        Object employeeFound;
        List c;
        LockModeType lm;
        Query query;
        EntityManager em;
        boolean pass = true;
        TestUtil.logTrace((String)"Begin getResultListTest1");
        try {
            TestUtil.logTrace((String)"Testing Query version");
            this.getEntityTransaction().begin();
            em = this.getEntityManager();
            query = em.createQuery("select e from Employee e where e.id < 10 ");
            lm = query.getLockMode();
            if (lm == null || lm.equals((Object)LockModeType.NONE)) {
                if (lm == null) {
                    TestUtil.logTrace((String)"Received null when no LockModeType had been set");
                } else {
                    TestUtil.logTrace((String)("Received " + lm.toString() + " when no LockModeType had been specifically set"));
                }
                query.setLockMode(LockModeType.PESSIMISTIC_READ);
                lm = query.getLockMode();
                if (lm.equals((Object)LockModeType.PESSIMISTIC_READ)) {
                    TestUtil.logTrace((String)("Received LockModeType:" + lm.name()));
                } else if (lm.equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                    TestUtil.logTrace((String)("Received LockModeType:" + lm + " inplace of " + LockModeType.PESSIMISTIC_READ.name()));
                } else {
                    TestUtil.logErr((String)("Expected LockModeType:" + LockModeType.PESSIMISTIC_READ.name() + " or " + LockModeType.PESSIMISTIC_WRITE.name() + ", Actual:" + lm));
                    pass = false;
                }
                c = query.getResultList();
                for (Employee e : c) {
                    lm = em.getLockMode((Object)e);
                    if (lm.equals((Object)LockModeType.PESSIMISTIC_READ)) {
                        TestUtil.logTrace((String)("Received LockModeType:" + lm.name()));
                        continue;
                    }
                    if (lm.equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                        TestUtil.logTrace((String)("Received LockModeType:" + lm + " inplace of " + LockModeType.PESSIMISTIC_READ.name()));
                        continue;
                    }
                    TestUtil.logErr((String)("LockMoteType for the Employee[" + e.getId() + "] was wrong - Expected:" + LockModeType.PESSIMISTIC_READ.name() + ", Actual:" + lm));
                    pass = false;
                }
                employeeFound = (Employee)this.getEntityManager().find(Employee.class, (Object)1, LockModeType.PESSIMISTIC_WRITE);
                employeeFound.setSalary(90000.0f);
            } else {
                TestUtil.logErr((String)("Expected null when no LockModeType had been set, Actual:" + lm));
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
                pass = false;
            }
        }
        TestUtil.logTrace((String)"Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            em = this.getEntityManager();
            query = em.createQuery("select e from Employee e where e.id < 10 ", Employee.class);
            lm = query.getLockMode();
            if (lm == null || lm.equals((Object)LockModeType.NONE)) {
                if (lm == null) {
                    TestUtil.logTrace((String)"Received null when no LockModeType had been set");
                } else {
                    TestUtil.logTrace((String)("Received " + lm.toString() + " when no LockModeType had been specifically set"));
                }
                query.setLockMode(LockModeType.PESSIMISTIC_READ);
                lm = query.getLockMode();
                if (lm.equals((Object)LockModeType.PESSIMISTIC_READ)) {
                    TestUtil.logTrace((String)("Received LockModeType:" + lm.name()));
                } else if (lm.equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                    TestUtil.logTrace((String)("Received LockModeType:" + lm + " inplace of " + LockModeType.PESSIMISTIC_READ.name()));
                } else {
                    TestUtil.logErr((String)("Expected LockModeType:" + LockModeType.PESSIMISTIC_READ.name() + " or " + LockModeType.PESSIMISTIC_WRITE.name() + ", Actual:" + lm));
                    pass = false;
                }
                query.setLockMode(LockModeType.PESSIMISTIC_READ);
                lm = query.getLockMode();
                if (lm.equals((Object)LockModeType.PESSIMISTIC_READ)) {
                    TestUtil.logTrace((String)("Received LockModeType:" + lm.name()));
                } else if (lm.equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                    TestUtil.logTrace((String)("Received LockModeType:" + lm + " inplace of " + LockModeType.PESSIMISTIC_READ.name()));
                } else {
                    TestUtil.logErr((String)("Expected LockModeType:" + LockModeType.PESSIMISTIC_READ.name() + " or " + LockModeType.PESSIMISTIC_WRITE.name() + ", Actual:" + lm));
                    pass = false;
                }
                c = query.getResultList();
                for (Employee e : c) {
                    lm = em.getLockMode((Object)e);
                    if (lm.equals((Object)LockModeType.PESSIMISTIC_READ)) {
                        TestUtil.logTrace((String)("Received LockModeType:" + lm.name()));
                        continue;
                    }
                    if (lm.equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                        TestUtil.logTrace((String)("Received LockModeType:" + lm + " inplace of " + LockModeType.PESSIMISTIC_READ.name()));
                        continue;
                    }
                    TestUtil.logErr((String)("LockMoteType for the Employee[" + e.getId() + "] was wrong - Expected:" + LockModeType.PESSIMISTIC_READ.name() + ", Actual:" + lm));
                    pass = false;
                }
                employeeFound = (Employee)this.getEntityManager().find(Employee.class, (Object)1, LockModeType.PESSIMISTIC_WRITE);
                employeeFound.setSalary(90000.0f);
            } else {
                TestUtil.logErr((String)("query.getLockMode() returned a null instead of " + LockModeType.NONE + ", when no LockModeType had been set"));
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
                pass = false;
            }
        }
        if (!pass) {
            throw new EETest.Fault("getResultListTest1 failed");
        }
    }

    public void getLockModeNONSELECTIllegalStateExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Testing Query");
            this.getEntityManager().createQuery("UPDATE Employee e SET e.salary = e.salary * 10.0").getLockMode();
            TestUtil.logErr((String)"IllegalStateException was not thrown");
            this.getEntityTransaction().commit();
        }
        catch (IllegalStateException ise) {
            TestUtil.logTrace((String)"Received expected IllegalStateException");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("getLockModeNONSELECTIllegalStateExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLockModeObjectIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        TestUtil.logTrace((String)"Begin getLockModeObjectIllegalArgumentExceptionTest");
        try {
            this.getEntityTransaction().begin();
            EntityManager em = this.getEntityManager();
            Employee e = new Employee(1, "Alan", "Frechette", this.d1, 35000.0f);
            try {
                em.getLockMode((Object)e);
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("getLockModeObjectIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLockModeObjectTransactionRequiredException1Test() throws EETest.Fault {
        boolean pass = false;
        int expected = 9;
        try {
            this.getEntityTransaction().begin();
            EntityManager em = this.getEntityManager();
            Query query = em.createQuery("select e from Employee e where e.id < 10 ");
            query.setLockMode(LockModeType.PESSIMISTIC_READ);
            List c = query.getResultList();
            this.getEntityTransaction().commit();
            TestUtil.logTrace((String)("isActive=" + this.getEntityTransaction().isActive()));
            int found = 0;
            for (Employee e : c) {
                try {
                    em.getLockMode((Object)e);
                    TestUtil.logErr((String)("Did not get TransactionRequiredException for employee:" + e));
                }
                catch (TransactionRequiredException tre) {
                    ++found;
                }
            }
            if (found == expected) {
                TestUtil.logTrace((String)("Got expected number of TransactionRequiredExceptions:" + expected));
                pass = true;
            } else {
                TestUtil.logErr((String)("Number of TransactionRequiredException Expected:" + c.size() + ", Actual:" + found));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("getLockModeObjectTransactionRequiredException1Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLockModeObjectIllegalArgumentException1Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            EntityManager em = this.getEntityManager();
            Query query = em.createQuery("select e from Employee e where e.id < 10 ");
            TestUtil.logTrace((String)"Setting lock mode to PESSIMISTIC_READ");
            query.setLockMode(LockModeType.PESSIMISTIC_READ);
            List c = query.getResultList();
            int found = 0;
            for (Employee e : c) {
                try {
                    TestUtil.logTrace((String)("Detaching Employee:" + e.getId()));
                    em.detach((Object)e);
                    TestUtil.logTrace((String)"Calling getLockMode()");
                    em.getLockMode((Object)e);
                }
                catch (IllegalArgumentException iae) {
                    ++found;
                }
            }
            if (found == c.size()) {
                pass = true;
            } else {
                TestUtil.logErr((String)("Number of IllegalArgumentException Expected:" + c.size() + ", Actual:" + found));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("getLockModeObjectIllegalArgumentException1Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLockModeIllegalStateException() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"Testing Native version");
        try {
            Query nativeQuery = this.getEntityManager().createNativeQuery("Select ID from DEPARTMENT where ID=1");
            nativeQuery.setLockMode(LockModeType.PESSIMISTIC_READ);
            TestUtil.logErr((String)"IllegalStateException should have been thrown after setLockMode");
        }
        catch (IllegalStateException e) {
            TestUtil.logTrace((String)"Got IllegalStateException as expected");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        TestUtil.logMsg((String)"Testing Query version");
        try {
            Query q = this.getEntityManager().createQuery("UPDATE Employee e SET e.salary = e.salary * 10.0");
            q.setLockMode(LockModeType.PESSIMISTIC_READ);
            TestUtil.logErr((String)"IllegalStateException should have been thrown");
        }
        catch (IllegalStateException e) {
            TestUtil.logTrace((String)"Got IllegalStateException as expected");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setLockModeIllegalStateException failed");
        }
    }

    public void getResultListTest2() throws EETest.Fault {
        Query query;
        boolean pass = true;
        TestUtil.logTrace((String)"Testing Query version");
        try {
            TestUtil.logTrace((String)"Invoking query for getResultListTest2");
            query = this.getEntityManager().createQuery("select e.department from Employee e where e.id < 10 order by e.department.id").setFirstResult(3);
            query.setLockMode(LockModeType.PESSIMISTIC_READ);
            query.getResultList();
            TestUtil.logErr((String)"TransactionRequiredException not thrown");
            pass = false;
        }
        catch (TransactionRequiredException e) {
            TestUtil.logTrace((String)"Got TransactionRequiredException as expected");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        TestUtil.logTrace((String)"Testing TypedQuery version");
        try {
            TestUtil.logTrace((String)"Invoking query for getResultListTest2");
            query = this.getEntityManager().createQuery("select e.department from Employee e where e.id < 10 order by e.department.id", Department.class).setFirstResult(3);
            query.setLockMode(LockModeType.PESSIMISTIC_READ);
            query.getResultList();
            TestUtil.logErr((String)"TransactionRequiredException not thrown");
            pass = false;
        }
        catch (TransactionRequiredException e) {
            TestUtil.logTrace((String)"Got TransactionRequiredException as expected");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("getResultListTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSingleResultTest() throws EETest.Fault {
        boolean pass = false;
        TestUtil.logTrace((String)"Begin getSingleResultTest");
        try {
            this.getEntityTransaction().begin();
            Query query = this.getEntityManager().createQuery("select d.name from Department d where d.id = 1");
            query.setLockMode(LockModeType.PESSIMISTIC_READ);
            query.getSingleResult();
            Department departmentFound = (Department)this.getEntityManager().find(Department.class, (Object)1, LockModeType.PESSIMISTIC_WRITE);
            departmentFound.setName("NewDepartment");
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("getSingleResultTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        TestUtil.logTrace((String)"createTestData");
        Employee[] empRef = new Employee[20];
        Department[] deptRef = new Department[10];
        Insurance[] insRef = new Insurance[5];
        Date d2 = this.getSQLDate("2001-06-27");
        Date d3 = this.getSQLDate("2002-07-07");
        Date d4 = this.getSQLDate("2003-03-03");
        Date d5 = this.getSQLDate("2004-04-10");
        Date d6 = this.getSQLDate("2005-02-18");
        Date d7 = this.getSQLDate("2000-09-17");
        Date d8 = this.getSQLDate("2001-11-14");
        Date d9 = this.getSQLDate("2002-10-04");
        Date d10 = this.getSQLDate("2003-01-25");
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create 5 Departments");
            deptRef[0] = new Department(1, "Engineering");
            deptRef[1] = new Department(2, "Marketing");
            deptRef[2] = new Department(3, "Sales");
            deptRef[3] = new Department(4, "Accounting");
            deptRef[4] = new Department(5, "Training");
            TestUtil.logTrace((String)"Start to persist departments ");
            for (Department department : deptRef) {
                if (department == null) continue;
                this.getEntityManager().persist((Object)department);
                this.doFlush();
                TestUtil.logTrace((String)("persisted department " + department));
            }
            TestUtil.logTrace((String)"Create 3 Insurance Carriers");
            insRef[0] = new Insurance(1, "Prudential");
            insRef[1] = new Insurance(2, "Cigna");
            insRef[2] = new Insurance(3, "Sentry");
            TestUtil.logTrace((String)"Start to persist insurance ");
            for (Department department : insRef) {
                if (department == null) continue;
                this.getEntityManager().persist((Object)department);
                this.doFlush();
                TestUtil.logTrace((String)("persisted insurance " + department));
            }
            TestUtil.logTrace((String)"Create 20 employees");
            empRef[0] = new Employee(1, "Alan", "Frechette", this.d1, 35000.0f);
            empRef[0].setDepartment(deptRef[0]);
            empRef[0].setInsurance(insRef[0]);
            empRef[1] = new Employee(2, "Arthur", "Frechette", d2, 35000.0f);
            empRef[1].setDepartment(deptRef[1]);
            empRef[1].setInsurance(insRef[1]);
            empRef[2] = new Employee(3, "Shelly", "McGowan", d3, 50000.0f);
            empRef[2].setDepartment(deptRef[2]);
            empRef[2].setInsurance(insRef[2]);
            empRef[3] = new Employee(4, "Robert", "Bissett", d4, 55000.0f);
            empRef[3].setDepartment(deptRef[3]);
            empRef[3].setInsurance(insRef[0]);
            empRef[4] = new Employee(5, "Stephen", "DMilla", d5, 25000.0f);
            empRef[4].setDepartment(deptRef[4]);
            empRef[4].setInsurance(insRef[1]);
            empRef[5] = new Employee(6, "Karen", "Tegan", d6, 80000.0f);
            empRef[5].setDepartment(deptRef[0]);
            empRef[5].setInsurance(insRef[2]);
            empRef[6] = new Employee(7, "Stephen", "Cruise", d7, 90000.0f);
            empRef[6].setDepartment(deptRef[1]);
            empRef[6].setInsurance(insRef[0]);
            empRef[7] = new Employee(8, "Irene", "Caruso", d8, 20000.0f);
            empRef[7].setDepartment(deptRef[2]);
            empRef[7].setInsurance(insRef[1]);
            empRef[8] = new Employee(9, "William", "Keaton", d9, 35000.0f);
            empRef[8].setDepartment(deptRef[3]);
            empRef[8].setInsurance(insRef[2]);
            empRef[9] = new Employee(10, "Kate", "Hudson", d10, 20000.0f);
            empRef[9].setDepartment(deptRef[4]);
            empRef[9].setInsurance(insRef[0]);
            empRef[10] = new Employee(11, "Jonathan", "Smith", d10, 40000.0f);
            empRef[10].setDepartment(deptRef[0]);
            empRef[10].setInsurance(insRef[1]);
            empRef[11] = new Employee(12, "Mary", "Macy", d9, 40000.0f);
            empRef[11].setDepartment(deptRef[1]);
            empRef[11].setInsurance(insRef[2]);
            empRef[12] = new Employee(13, "Cheng", "Fang", d8, 40000.0f);
            empRef[12].setDepartment(deptRef[2]);
            empRef[12].setInsurance(insRef[0]);
            empRef[13] = new Employee(14, "Julie", "OClaire", d7, 60000.0f);
            empRef[13].setDepartment(deptRef[3]);
            empRef[13].setInsurance(insRef[1]);
            empRef[14] = new Employee(15, "Steven", "Rich", d6, 60000.0f);
            empRef[14].setDepartment(deptRef[4]);
            empRef[14].setInsurance(insRef[2]);
            empRef[15] = new Employee(16, "Kellie", "Lee", d5, 60000.0f);
            empRef[15].setDepartment(deptRef[0]);
            empRef[15].setInsurance(insRef[0]);
            empRef[16] = new Employee(17, "Nicole", "Martin", d4, 60000.0f);
            empRef[16].setDepartment(deptRef[1]);
            empRef[16].setInsurance(insRef[1]);
            empRef[17] = new Employee(18, "Mark", "Francis", d3, 60000.0f);
            empRef[17].setDepartment(deptRef[2]);
            empRef[17].setInsurance(insRef[2]);
            empRef[18] = new Employee(19, "Will", "Forrest", d2, 60000.0f);
            empRef[18].setDepartment(deptRef[3]);
            empRef[18].setInsurance(insRef[0]);
            empRef[19] = new Employee(20, "Katy", "Hughes", this.d1, 60000.0f);
            empRef[19].setDepartment(deptRef[4]);
            empRef[19].setInsurance(insRef[1]);
            TestUtil.logTrace((String)"Start to persist employees ");
            for (Department department : empRef) {
                if (department == null) continue;
                this.getEntityManager().persist((Object)department);
                this.doFlush();
                TestUtil.logTrace((String)("persisted employee " + department));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception re) {
            TestUtil.logErr((String)"Unexpected Exception in createTestData:", (Throwable)re);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in createTestData while rolling back TX:", (Throwable)re);
            }
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM INSURANCE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DEPARTMENT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

