/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.parser;

import com.sun.ts.tests.interop.csiv2.common.parser.Entry;
import com.sun.ts.tests.interop.csiv2.common.parser.ParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransportAddressEntry
extends Entry {
    private String hostname;
    private int port;

    public TransportAddressEntry(Element element) throws ParseException {
        if (!element.getTagName().equals("trans-addr")) {
            throw new ParseException("Unexpected tag: " + element.getTagName());
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("host-name")) {
                this.hostname = this.getText(node);
                continue;
            }
            if (!node.getNodeName().equals("port")) continue;
            this.port = Integer.parseInt(this.getText(node));
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        String result = "<trans-addr>\n";
        result = result + "<host-name>" + this.hostname + "</host-name>\n";
        result = result + "<port>" + this.port + "</port>\n";
        result = result + "</trans-addr>\n";
        return result;
    }
}

