/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R4001;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jaxrpc.sharedclients.ClientFactory;
import com.sun.ts.tests.jaxrpc.wsi.requests.SOAPRequests;
import com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R4001.W2JRLR4001ClientOne;
import com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R4001.W2JRLR4001ClientTwo;
import java.nio.charset.Charset;
import java.util.Properties;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class Client
extends ServiceEETest
implements SOAPRequests {
    private static final String STRING_2 = "R4001-2";
    private W2JRLR4001ClientOne client1;
    private W2JRLR4001ClientTwo client2;

    public static void main(String[] args) {
        Client client = new Client();
        Status status = client.run(args, System.out, System.err);
        status.exit();
    }

    public void setup(String[] args, Properties properties) throws EETest.Fault {
        this.client1 = (W2JRLR4001ClientOne)ClientFactory.getClient(W2JRLR4001ClientOne.class, properties);
        this.client2 = (W2JRLR4001ClientTwo)ClientFactory.getClient(W2JRLR4001ClientTwo.class, properties);
        this.logMsg("setup ok");
    }

    public void cleanup() {
        this.logMsg("cleanup");
    }

    public void testRequestWithBOM() throws EETest.Fault {
        SOAPMessage response;
        try {
            Charset cs = Charset.forName("UTF-16");
            response = this.client1.makeSaajRequest("<?xml version=\"1.0\" encoding=\"UTF-16\"?>\n\n<env:Envelope\n\txmlns:enc=\"http://schemas.xmlsoap.org/soap/encoding/\"\n\txmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\"\n\txmlns:ns0=\"http://w2jrlr4001testservice.org/W2JRLR4001TestService.wsdl\"\n\txmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n\t<env:Body>\n\t\t<ns0:echoString>\n\t\t\t<str>\n\t\t\t\t<ans1:p1 xmlns:ans1=\"http://w2jrlr4001testservice.org/xsd\">R4001-1</ans1:p1>\n\t\t\t</str>\n\t\t</ns0:echoString>\n\t</env:Body>\n</env:Envelope>\n", cs);
        }
        catch (Exception e) {
            throw new EETest.Fault("Unable to invoke echoString operation (BP-R4001)", e);
        }
        try {
            SOAPBody body = response.getSOAPPart().getEnvelope().getBody();
            if (body.hasFault()) {
                throw new EETest.Fault("Request not processed by endpoint (BP-R4001)");
            }
        }
        catch (SOAPException e) {
            throw new EETest.Fault("Invalid SOAP message returned (BP-R4001)", e);
        }
    }

    public void testResponseWithBOM() throws EETest.Fault {
        String result;
        try {
            result = this.client2.echoString(STRING_2);
        }
        catch (Exception e) {
            throw new EETest.Fault("Unable to invoke echoString operation (BP-R4001)", e);
        }
        if (!STRING_2.equals(result)) {
            throw new EETest.Fault("echoString operation returns '" + result + "' in stead of '" + STRING_2 + "' (BP-R4001)");
        }
    }
}

