/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry_infomodel.User;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import com.sun.ts.tests.jaxr.common.JAXR_Util;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PersonName;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.Slot;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;

public class JAXRClient
extends JAXRCommonClient {
    Locale tsLocale = new Locale("en", "US");

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            super.cleanup();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void user_getEmailAddresses_Test() throws EETest.Fault {
        String testName = "user_getEmailAddresses_Test";
        boolean pass = false;
        Object email = null;
        try {
            Vector<String> emailAddresses = new Vector<String>();
            emailAddresses.add("Barney@Bedrock.org");
            emailAddresses.add("Betty@Bedrock.org");
            User user = this.blm.createUser();
            ArrayList<EmailAddress> emails = new ArrayList<EmailAddress>();
            EmailAddress e = null;
            for (int i = 0; i < emailAddresses.size(); ++i) {
                e = this.blm.createEmailAddress((String)emailAddresses.get(i));
                emails.add(e);
                this.debug.add("Adding this email address to the list: " + emailAddresses.get(i) + "\n");
            }
            user.setEmailAddresses(emails);
            EmailAddress ea2 = null;
            Collection retEmails = user.getEmailAddresses();
            for (EmailAddress ea2 : retEmails) {
                this.debug.add("Got Back this address: " + ea2.getAddress() + " \n");
                if (emailAddresses.contains(ea2.getAddress())) continue;
                this.debug.add("Error: It does not match any of the addresses that were set\n");
                throw new EETest.Fault(testName + " failed ");
            }
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void user_getPersonName_Test() throws EETest.Fault {
        String testName = "user_getPersonName_Test";
        boolean pass = false;
        String person = "Mickey Mouse";
        try {
            User user = this.blm.createUser();
            this.debug.add("Create a PersonName instance for " + person + "\n");
            PersonName myPerson = this.blm.createPersonName(person);
            this.debug.add("Set Name of contact person on User object \n");
            user.setPersonName(myPerson);
            this.debug.add("Call get method to get back person\n");
            PersonName retPersonName = user.getPersonName();
            String thePerson = retPersonName.getFullName();
            this.debug.add("The person returned from getPersonName was: " + thePerson + "\n");
            if (!thePerson.equals(person)) {
                this.debug.add("Error: unexpected person returned \n");
                throw new EETest.Fault(testName + " failed ");
            }
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void user_getOrganization_Test() throws EETest.Fault {
        String testName = "user_getOrganization_Test";
        boolean pass = false;
        String person = "Mickey Mouse";
        String orgName = "TS Default Organization";
        BusinessQueryManager bqm = null;
        Key orgKey = null;
        try {
            bqm = this.rs.getBusinessQueryManager();
            User user2 = this.blm.createUser();
            this.debug.add("Create a PersonName instance for " + person + "\n");
            PersonName myPerson = this.blm.createPersonName(person);
            this.debug.add("Set Name of contact person on User object \n");
            user2.setPersonName(myPerson);
            Organization org = JAXR_Util.createDefaultOrganization(this.blm);
            this.debug.add("Add this User to the default organization\n");
            Collection users = new ArrayList<User>();
            users.add(user2);
            org.addUsers(users);
            this.debug.add("publish the organization to the registry \n");
            orgKey = this.saveMyOrganization(org);
            Organization pubOrg = (Organization)bqm.getRegistryObject(orgKey.getId(), "Organization");
            if (pubOrg == null) {
                this.debug.add("Error - org not found\n");
                throw new EETest.Fault(testName + " Error from saveOrganizations - test did not complete!");
            }
            this.debug.add("Get the Users from this organization \n");
            users.clear();
            users = pubOrg.getUsers();
            this.debug.add("Find the User \n");
            for (User user2 : users) {
                this.debug.add("Searching for the correct User\n");
                myPerson = user2.getPersonName();
                this.debug.add("Found " + myPerson.getFullName() + " \n");
                if (!myPerson.getFullName().equals(person)) continue;
                this.debug.add("Found the User, got the right organization !! \n");
                this.debug.add("And what about getOrg?? " + user2.getOrganization() + "\n");
                break;
            }
            this.debug.add("Now get the organization from the User \n");
            Organization testOrg = user2.getOrganization();
            this.debug.add("testOrg is what? " + testOrg + "\n");
            users = testOrg.getUsers();
            this.debug.add("Find my User \n");
            for (User user2 : users) {
                this.debug.add("Searching for the correct User\n");
                myPerson = user2.getPersonName();
                this.debug.add("Found " + myPerson.getFullName() + " \n");
                if (!myPerson.getFullName().equals(person)) continue;
                this.debug.add("Found the User, getOrganization was a success!! \n");
                pass = true;
                break;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.debug.add("cleanup registry - remove test organization\n");
            ArrayList<Key> keys = new ArrayList<Key>();
            keys.add(orgKey);
            this.cleanUpRegistry(keys, "Organization");
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void user_getType_Test() throws EETest.Fault {
        String testName = "user_getType_Test";
        boolean pass = false;
        String myUseType = "Use Type: Technical Contact";
        try {
            User user = this.blm.createUser();
            this.debug.add("\nSet the type for this User to " + myUseType + "\n");
            user.setType(myUseType);
            this.debug.add("Use the getType method to retrieve the type just set\n");
            String retType = user.getType();
            this.debug.add("getType returned: " + retType + "\n");
            if (retType.equals(myUseType)) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void user_getUrl_Test() throws EETest.Fault {
        int failcount;
        boolean pass;
        String testName;
        block15: {
            testName = "user_getUrl_Test";
            pass = false;
            failcount = 0;
            URL url = null;
            String resource = "http://java.sun.com/FAQ.html";
            try {
                url = new URL(resource);
                this.debug.add("\nCreate a url for this test => " + url.toString() + "\n");
                User user = this.blm.createUser();
                int providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
                this.debug.add("\n The capability level for this provider is: " + providerlevel + "\n");
                try {
                    user.setUrl(url);
                    this.debug.add("Level 0 providers should not get here!\n");
                    if (providerlevel <= 0) {
                        this.debug.add("Error: expected setUrl to throw UnsupportedCapabilityException \n");
                        ++failcount;
                    }
                }
                catch (UnsupportedCapabilityException uc) {
                    TestUtil.printStackTrace((Throwable)uc);
                    if (providerlevel == 0) {
                        this.debug.add("Success! setUrl threw UnsupportedCapabilityException as expected\n");
                    } else {
                        this.debug.add("Error: UnsupportedCapabilityException not expected for this provider\n");
                        ++failcount;
                    }
                }
                catch (Exception e0) {
                    TestUtil.printStackTrace((Throwable)e0);
                    ++failcount;
                    this.debug.add("Error: setUrl threw an unexpected exception \n");
                    this.debug.add("Exception: " + e0.toString() + "\n");
                }
                try {
                    url = user.getUrl();
                    this.debug.add("Level 0 providers should not get here!\n");
                    if (providerlevel <= 0) {
                        this.debug.add("Error: expected getUrl to throw UnsupportedCapabilityException \n");
                        ++failcount;
                    }
                }
                catch (UnsupportedCapabilityException uc) {
                    TestUtil.printStackTrace((Throwable)uc);
                    if (providerlevel == 0) {
                        this.debug.add("Success! getUrl threw UnsupportedCapabilityException as expected\n");
                        break block15;
                    }
                    this.debug.add("Error: UnsupportedCapabilityException not expected for this provider\n");
                    ++failcount;
                }
                catch (Exception e1) {
                    TestUtil.printStackTrace((Throwable)e1);
                    ++failcount;
                    this.debug.add("Error: getUrl threw an unexpected exception \n");
                    this.debug.add("Exception: " + e1.toString() + "\n");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                ++failcount;
            }
        }
        if (failcount == 0) {
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void user_getTelephoneNumbers_Test() throws EETest.Fault {
        String testName = "user_getTelephoneNumbers_Test";
        String telNum = "781-442-1234";
        boolean pass = false;
        try {
            TelephoneNumber number = this.blm.createTelephoneNumber();
            number.setNumber(telNum);
            Collection numbers = new ArrayList<TelephoneNumber>();
            numbers.add(number);
            TelephoneNumber retNum2 = null;
            User user = this.blm.createUser();
            user.setTelephoneNumbers(numbers);
            this.debug.add("\nSet the phone number for this user to: " + telNum + "\n");
            numbers = user.getTelephoneNumbers(null);
            for (TelephoneNumber retNum2 : numbers) {
                this.debug.add("Got this telephone number:  " + retNum2.getNumber() + "\n");
                if (!retNum2.getNumber().equals(telNum)) continue;
                pass = true;
                break;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void user_getPostalAddress_Test() throws EETest.Fault {
        String testName = "user_getPostalAddress_Test";
        boolean pass = false;
        String streetNumber = "1";
        String street = "Amsden";
        String city = "Arlington";
        String stateOrProvince = "MA";
        String country = "US";
        String postalCode = "02174";
        String type = "homebase";
        int failcount = 0;
        try {
            this.debug.add("Issue:  what is slot type supposed to be ????\n");
            PostalAddress pa = this.blm.createPostalAddress(streetNumber, street, city, stateOrProvince, country, postalCode, type);
            ArrayList<String> addressValues = new ArrayList<String>();
            addressValues.add(streetNumber);
            addressValues.add(street);
            addressValues.add(city);
            addressValues.add(stateOrProvince);
            addressValues.add(country);
            addressValues.add(postalCode);
            addressValues.add(type);
            Slot mySlot = this.blm.createSlot("addressLines", addressValues, "WhatIsThisSupposedToBe?");
            pa.addSlot(mySlot);
            this.debug.add("\nSetting Postal Address as follows:\n");
            this.debug.add("streetNumber is " + streetNumber + "\n");
            this.debug.add("street" + street + "\n");
            this.debug.add("city is " + city + "\n");
            this.debug.add("stateOrProvince is " + stateOrProvince + "\n");
            this.debug.add("country is " + country + "\n");
            this.debug.add("postalCode is " + postalCode + "\n");
            this.debug.add("type is " + type + "\n");
            User user = this.blm.createUser();
            ArrayList<PostalAddress> pas = new ArrayList<PostalAddress>();
            pas.add(pa);
            user.setPostalAddresses(pas);
            Collection retPas = user.getPostalAddresses();
            PostalAddress retPa2 = null;
            for (PostalAddress retPa2 : retPas) {
            }
            this.debug.add("User.getPostalAddress returned the following: \n");
            this.debug.add("streetNumber: " + retPa2.getStreetNumber() + "\n");
            this.debug.add("street: " + retPa2.getStreet() + "\n");
            this.debug.add("city: " + retPa2.getCity() + "\n");
            this.debug.add("stateOrProvince: " + retPa2.getStateOrProvince() + "\n");
            this.debug.add("country: " + retPa2.getCountry() + "\n");
            this.debug.add("postalCode: " + retPa2.getPostalCode() + "\n");
            this.debug.add("type: " + retPa2.getType() + "\n");
            if (!retPa2.getStreetNumber().equals(streetNumber)) {
                this.debug.add("Error: getStreetNumber returned: " + retPa2.getStreetNumber() + "\n");
                ++failcount;
            }
            if (!retPa2.getStreet().equals(street)) {
                this.debug.add("Error: getStreet returned: " + retPa2.getStreet() + "\n");
                ++failcount;
            }
            if (!retPa2.getCity().equals(city)) {
                this.debug.add("Error: getCity returned: " + retPa2.getCity() + "\n");
                ++failcount;
            }
            if (!retPa2.getStateOrProvince().equals(stateOrProvince)) {
                this.debug.add("Error: getStateOrProvince returned: " + retPa2.getStateOrProvince() + "\n");
                ++failcount;
            }
            if (!retPa2.getCountry().equals(country)) {
                this.debug.add("Error: getCountry returned: " + retPa2.getCountry() + "\n");
                ++failcount;
            }
            if (!retPa2.getPostalCode().equals(postalCode)) {
                this.debug.add("Error: getPostalCode returned: " + retPa2.getPostalCode() + "\n");
                ++failcount;
            }
            if (!retPa2.getType().equals(type)) {
                this.debug.add("Error: getType returned: " + retPa2.getType() + "\n");
                ++failcount;
            }
            if (failcount == 0) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void user_Test() throws EETest.Fault {
        String testName = "user_Test";
        boolean pass = false;
        String orgName = "TS Default Organization";
        Object email = null;
        String person = "Minnie Mouse";
        String myUseType = "Use Type: Technical Contact";
        String telNum = "781-442-1234";
        String streetNumber = "1";
        String street = "Amsden";
        String city = "Arlington";
        String stateOrProvince = "MA";
        String country = "US";
        String postalCode = "02174";
        String type = "homebase";
        Key orgKey = null;
        try {
            User user = this.blm.createUser();
            Vector<String> emailAddresses = new Vector<String>();
            emailAddresses.add("Barney@Bedrock.org");
            emailAddresses.add("Betty@Bedrock.org");
            ArrayList<EmailAddress> emails = new ArrayList<EmailAddress>();
            EmailAddress e = null;
            for (int i = 0; i < emailAddresses.size(); ++i) {
                e = this.blm.createEmailAddress((String)emailAddresses.get(i));
                emails.add(e);
                this.debug.add("Adding this email address to the list: " + emailAddresses.get(i) + "\n");
            }
            user.setEmailAddresses(emails);
            PersonName myPerson = this.blm.createPersonName(person);
            this.debug.add("Set Name of contact person on User object \n");
            user.setPersonName(myPerson);
            this.debug.add("\nSet the type for this User to " + myUseType + "\n");
            user.setType(myUseType);
            this.debug.add("\nSet the telephone number for this User to " + telNum + "\n");
            TelephoneNumber number = this.blm.createTelephoneNumber();
            number.setNumber(telNum);
            Collection numbers = new ArrayList<TelephoneNumber>();
            numbers.add(number);
            user.setTelephoneNumbers(numbers);
            PostalAddress pa = this.blm.createPostalAddress(streetNumber, street, city, stateOrProvince, country, postalCode, type);
            this.debug.add("\nSetting Postal Address as follows:\n");
            this.debug.add("streetNumber is " + streetNumber + "\n");
            this.debug.add("street" + street + "\n");
            this.debug.add("city is " + city + "\n");
            this.debug.add("stateOrProvince is " + stateOrProvince + "\n");
            this.debug.add("country is " + country + "\n");
            this.debug.add("postalCode is " + postalCode + "\n");
            this.debug.add("type is " + type + "\n");
            ArrayList<PostalAddress> pas = new ArrayList<PostalAddress>();
            pas.add(pa);
            user.setPostalAddresses(pas);
            Organization org = JAXR_Util.createDefaultOrganization(this.blm);
            this.debug.add("Add this User to the default organization\n");
            Collection users = new ArrayList<User>();
            users.add(user);
            org.addUsers(users);
            this.debug.add("publish the organization to the registry \n");
            orgKey = this.saveMyOrganization(org);
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            Organization pubOrg = (Organization)bqm.getRegistryObject(orgKey.getId(), "Organization");
            if (pubOrg == null) {
                this.debug.add("Error - org not found\n");
                throw new EETest.Fault(testName + " Error from saveOrganizations - test did not complete!");
            }
            this.debug.add("Find my User in the Users from this organization \n");
            users.clear();
            users = pubOrg.getUsers();
            Iterator itr = users.iterator();
            boolean found = false;
            while (itr.hasNext()) {
                user = (User)itr.next();
                this.debug.add("Searching for the correct User\n");
                myPerson = user.getPersonName();
                this.debug.add("Found " + myPerson.getFullName() + " \n");
                if (!myPerson.getFullName().equals(person)) continue;
                this.debug.add("Found the User, got the right organization !! \n");
                found = true;
                break;
            }
            if (!found) {
                throw new EETest.Fault(testName + " Error: did not find correct User from retrieved organization ");
            }
            Collection retEmails = user.getEmailAddresses();
            EmailAddress ea2 = null;
            for (EmailAddress ea2 : retEmails) {
                this.debug.add("Got Back this address: " + ea2.getAddress() + " \n");
                if (emailAddresses.contains(ea2.getAddress())) continue;
                this.debug.add("Error: It does not match any of the addresses that were set\n");
                throw new EETest.Fault(testName + " getEmailAddresses failed ");
            }
            PersonName retPersonName = user.getPersonName();
            String thePerson = retPersonName.getFullName();
            this.debug.add("The person returned from getPersonName was: " + thePerson + "\n");
            if (!thePerson.equals(person)) {
                this.debug.add("Error: unexpected person returned \n");
                throw new EETest.Fault(testName + " getPersonName failed ");
            }
            Organization testOrg = user.getOrganization();
            if (!testOrg.getName().getValue(this.tsLocale).equals(orgName)) {
                throw new EETest.Fault(testName + " getOrganization failed ");
            }
            String retType = user.getType();
            this.debug.add("getType returned: " + retType + "\n");
            if (!retType.equals(myUseType)) {
                throw new EETest.Fault(testName + " getType");
            }
            numbers = user.getTelephoneNumbers(null);
            Iterator iter = numbers.iterator();
            TelephoneNumber retNum = null;
            while (iter.hasNext()) {
                retNum = (TelephoneNumber)iter.next();
                this.debug.add("Got this telephone number:  " + retNum.getNumber() + "\n");
                if (retNum.getNumber().equals(telNum)) continue;
                throw new EETest.Fault(testName + " getTelephoneNumbers failed ");
            }
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.debug.add("cleanup registry - remove test organization\n");
            ArrayList<Key> keys = new ArrayList<Key>();
            keys.add(orgKey);
            this.cleanUpRegistry(keys, "Organization");
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }
}

