/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.bb.session.stateful.interceptor.listener.annotated;

import com.sun.ts.tests.ejb30.common.calc.CalculatorException;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.interceptor.AroundInvokeBase;
import com.sun.ts.tests.ejb30.common.interceptor.AroundInvokeIF;
import com.sun.ts.tests.ejb30.common.interceptor.AroundInvokeTestImpl;
import com.sun.ts.tests.ejb30.common.interceptor.Constants;
import com.sun.ts.tests.ejb30.common.interceptor.Interceptor1;
import com.sun.ts.tests.ejb30.common.interceptor.Interceptor2;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.ejb.EJBContext;
import javax.ejb.Remote;
import javax.ejb.Remove;
import javax.ejb.SessionContext;
import javax.ejb.SessionSynchronization;
import javax.ejb.Stateful;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptors;
import javax.interceptor.InvocationContext;

@Stateful(name="AroundInvokeBean")
@Remote(value={AroundInvokeIF.class})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@Interceptors(value={Interceptor1.class, Interceptor2.class})
public class AroundInvokeBean
extends AroundInvokeBase
implements AroundInvokeIF,
SessionSynchronization,
Constants,
Serializable {
    @Resource(name="ejbContext")
    private SessionContext ejbContext;
    private boolean afterCompletionCalled;
    private boolean beforeCompletionCalled;
    private boolean afterBeginCalled;

    @Override
    protected EJBContext getEJBContext() {
        return this.ejbContext;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws Exception {
        Object result = null;
        int orderInChain = 3;
        Method meth = ctx.getMethod();
        String methName = meth.getName();
        if ("afterBeginTest".equals(methName)) {
            if (!this.isAfterBeginCalled()) {
                throw new CalculatorException("afterBegin() was not called before this interceptor.");
            }
            TLogger.log((String[])new String[]{"good, isAfterBeginCalled: " + this.isAfterBeginCalled() + ", proceed..."});
            return AroundInvokeTestImpl.intercept2(ctx, orderInChain);
        }
        if (!"beforeCompletionTest".equals(methName)) {
            return AroundInvokeTestImpl.intercept2(ctx, orderInChain);
        }
        if (!"beforeCompletionTest".equals(methName)) {
            throw new IllegalStateException("Only beforeCompletionTest can get here, but current method name is " + methName);
        }
        try {
            result = ctx.proceed();
        }
        catch (CalculatorException e) {
            try {
                throw e;
                catch (RuntimeException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new IllegalStateException(e3);
                }
            }
            catch (Throwable throwable) {
                if (this.isBeforeCompletionCalled()) {
                    throw new CalculatorException("beforeCompletion must not be called before any interceptor.");
                }
                TLogger.log((String[])new String[]{"good, isBeforeCompletionCalled after proceed(): " + this.isBeforeCompletionCalled()});
                throw throwable;
            }
        }
        if (this.isBeforeCompletionCalled()) {
            throw new CalculatorException("beforeCompletion must not be called before any interceptor.");
        }
        TLogger.log((String[])new String[]{"good, isBeforeCompletionCalled after proceed(): " + this.isBeforeCompletionCalled()});
        return result;
    }

    public void afterCompletion(boolean param) {
        this.setAfterCompletionCalled(true);
    }

    public void beforeCompletion() {
        this.setBeforeCompletionCalled(true);
    }

    public void afterBegin() {
        this.setAfterBeginCalled(true);
    }

    private boolean isAfterCompletionCalled() {
        return this.afterCompletionCalled;
    }

    private void setAfterCompletionCalled(boolean afterCompletionCalled) {
        this.afterCompletionCalled = afterCompletionCalled;
    }

    private boolean isBeforeCompletionCalled() {
        return this.beforeCompletionCalled;
    }

    private void setBeforeCompletionCalled(boolean beforeCompletionCalled) {
        this.beforeCompletionCalled = beforeCompletionCalled;
    }

    private boolean isAfterBeginCalled() {
        return this.afterBeginCalled;
    }

    private void setAfterBeginCalled(boolean afterBeginCalled) {
        this.afterBeginCalled = afterBeginCalled;
    }

    @Override
    @Remove
    public void remove() {
    }
}

