/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.cache.basicTests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.cache.basicTests.Order;
import java.util.Properties;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void getcacheTest() throws EETest.Fault {
        boolean pass = false;
        int count = 5;
        if (this.cachingSupported) {
            try {
                EntityManager em2 = this.getEntityManager();
                EntityTransaction et = this.getEntityTransaction();
                Order[] orders = new Order[5];
                et.begin();
                for (int i = 1; i < 5; ++i) {
                    orders[i] = new Order(i, 100 * i);
                    em2.persist((Object)orders[i]);
                    TestUtil.logTrace((String)("persisted order " + orders[i]));
                }
                em2.flush();
                EntityManagerFactory emf = this.getEntityManagerFactory();
                Cache cache = emf.getCache();
                if (cache != null) {
                    pass = true;
                } else {
                    TestUtil.logErr((String)"Cache returned was null");
                }
                for (int i = 1; i < 5; ++i) {
                    em2.remove((Object)orders[i]);
                    TestUtil.logTrace((String)("Removed order " + orders[i]));
                }
                et.commit();
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            }
        } else {
            TestUtil.logMsg((String)"Cache not supported, bypassing test");
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault("getcacheTest failed");
        }
    }

    public void evictTest1() throws EETest.Fault {
        boolean pass2;
        boolean pass1;
        block10: {
            int count = 5;
            pass1 = false;
            pass2 = false;
            if (this.cachingSupported) {
                try {
                    this.getEntityTransaction().begin();
                    TestUtil.logTrace((String)("Transaction status after begin:" + this.getEntityTransaction().isActive()));
                    Order[] orders = new Order[5];
                    for (int i = 1; i < 5; ++i) {
                        orders[i] = new Order(i, 100 * i);
                        this.getEntityManager().persist((Object)orders[i]);
                        TestUtil.logTrace((String)("persisted order " + orders[i]));
                    }
                    this.getEntityManager().flush();
                    this.getEntityTransaction().commit();
                    TestUtil.logTrace((String)("Transaction status after commit:" + this.getEntityTransaction().isActive()));
                    Cache cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        pass1 = true;
                        TestUtil.logTrace((String)"cache was successfully obtained");
                        boolean cacheContains = cache.contains(Order.class, (Object)1);
                        if (cacheContains) {
                            TestUtil.logTrace((String)"Order 1 found, evicting it from cache");
                            cache.evict(Order.class, (Object)1);
                            cacheContains = cache.contains(Order.class, (Object)1);
                            if (!cacheContains) {
                                pass2 = true;
                                TestUtil.logTrace((String)"Order 1 was successfully evicted");
                            }
                        } else {
                            TestUtil.logErr((String)"cache did not contain Order 1");
                        }
                        break block10;
                    }
                    TestUtil.logErr((String)"Cache returned was null, eventhough Cache is supported.");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            } else {
                TestUtil.logMsg((String)"Cache not supported, bypassing test");
                pass1 = true;
                pass2 = true;
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("evictTest1 failed");
        }
    }

    public void evictTest2() throws EETest.Fault {
        boolean pass1;
        boolean pass2;
        block10: {
            int count = 5;
            pass2 = false;
            pass1 = false;
            if (this.cachingSupported) {
                try {
                    Order[] orders = new Order[5];
                    this.getEntityTransaction().begin();
                    for (int i = 1; i < 5; ++i) {
                        orders[i] = new Order(i, 100 * i);
                        this.getEntityManager().persist((Object)orders[i]);
                        TestUtil.logTrace((String)("persisted order " + orders[i]));
                    }
                    this.getEntityManager().flush();
                    this.getEntityTransaction().commit();
                    Cache cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        pass1 = true;
                        TestUtil.logTrace((String)"cache was successfully obtained");
                        boolean cacheContains = cache.contains(Order.class, (Object)1);
                        if (cacheContains) {
                            TestUtil.logTrace((String)"evicting Order 1 from cache");
                            cache.evict(Order.class);
                            cacheContains = cache.contains(Order.class, (Object)1);
                            if (!cacheContains) {
                                pass2 = true;
                                TestUtil.logTrace((String)"Order 1 was successfully evicted");
                            }
                        } else {
                            TestUtil.logErr((String)"Cache did not contain Order 1");
                        }
                        break block10;
                    }
                    TestUtil.logErr((String)"Cache returned was null, eventhough Cache is supported.");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            } else {
                TestUtil.logMsg((String)"Cache not supported, bypassing test");
                pass1 = true;
                pass2 = true;
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("evictTest2 failed");
        }
    }

    public void evictallTest() throws EETest.Fault {
        boolean pass2;
        boolean pass1;
        block10: {
            int count = 5;
            pass1 = false;
            pass2 = false;
            int pass2Count = 0;
            Order[] orders = new Order[5];
            int[] ids = new int[5];
            if (this.cachingSupported) {
                try {
                    this.getEntityTransaction().begin();
                    for (int i = 1; i < 5; ++i) {
                        orders[i] = new Order(i, 100 * i);
                        ids[i] = orders[i].getId();
                        this.getEntityManager().persist((Object)orders[i]);
                        TestUtil.logTrace((String)("persisted order " + orders[i]));
                    }
                    this.getEntityManager().flush();
                    this.getEntityTransaction().commit();
                    Cache cache = this.getEntityManagerFactory().getCache();
                    if (cache != null) {
                        pass1 = true;
                        TestUtil.logTrace((String)"cache was successfully obtained, evicting all Orders from cache");
                        cache.evictAll();
                        for (int i : ids) {
                            TestUtil.logTrace((String)("Testing order:" + i));
                            boolean cacheContains = cache.contains(Order.class, (Object)i);
                            if (cacheContains) continue;
                            ++pass2Count;
                            TestUtil.logTrace((String)("Order:" + i + " was successfully evicted"));
                        }
                        if (pass2Count == orders.length) {
                            pass2 = true;
                        } else {
                            TestUtil.logErr((String)"Not all orders were evicted.");
                        }
                        break block10;
                    }
                    TestUtil.logErr((String)"Cache returned was null, eventhough Cache is supported.");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            } else {
                TestUtil.logMsg((String)"Cache not supported, bypassing test");
                pass1 = true;
                pass2 = true;
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("evictallTest failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

