/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_msgPropsT;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import java.util.Enumeration;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageListener;
import javax.jms.MessageNotWriteableException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;

public class MsgBeanMsgTestPropsT
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private QueueConnectionFactory qFactory = null;
    private QueueConnection qConnection = null;
    private Queue queueR = null;
    private QueueSender mSender = null;
    private QueueSession qSession = null;
    private TopicConnectionFactory tFactory = null;
    private TopicConnection tConnection = null;
    private Topic topic = null;
    private TopicPublisher tPublisher = null;
    private TopicSession tSession = null;
    private TextMessage messageSent = null;

    public MsgBeanMsgTestPropsT() {
        TestUtil.logTrace((String)"@MsgBeanMsgTestPropsT()!");
    }

    public void ejbCreate() {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgPropsT  - @MsgBeanMsgTestPropsT-ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            if (this.qFactory == null) {
                TestUtil.logTrace((String)"qFactory error");
            }
            TestUtil.logTrace((String)"got a qFactory !!");
            this.queueR = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            if (this.queueR == null) {
                TestUtil.logTrace((String)"queueR error");
            }
            this.tFactory = (TopicConnectionFactory)this.context.lookup("java:comp/env/jms/MyTopicConnectionFactory");
            if (this.tFactory == null) {
                TestUtil.logTrace((String)"tFactory error");
            }
            TestUtil.logTrace((String)"got a tFactory !!");
            this.topic = (Topic)this.context.lookup("java:comp/env/jms/MDB_TOPIC");
            if (this.topic == null) {
                TestUtil.logTrace((String)"topic error");
            }
            this.p = new Properties();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    public void onMessage(Message msg) {
        JmsUtil.initHarnessProps(msg, this.p);
        TestUtil.logTrace((String)("from jms.ee.mdb.mdb_msgPropsT @onMessage!" + msg));
        try {
            TestUtil.logTrace((String)("onMessage will run TestCase: " + msg.getStringProperty("TestCase")));
            this.qConnection = this.qFactory.createQueueConnection();
            if (this.qConnection == null) {
                TestUtil.logTrace((String)"connection error");
            } else {
                this.qConnection.start();
                this.qSession = this.qConnection.createQueueSession(true, 0);
            }
            this.tConnection = this.tFactory.createTopicConnection();
            if (this.tConnection == null) {
                TestUtil.logTrace((String)"connection error");
            } else {
                this.tConnection.start();
                this.tSession = this.tConnection.createTopicSession(true, 0);
            }
            this.messageSent = this.tSession.createTextMessage();
            JmsUtil.addPropsToMessage((Message)this.messageSent, this.p);
            if (msg.getStringProperty("TestCase").equals("msgPropertiesTTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - running msgPropertiesTTestCreate - create the message");
                this.msgPropertiesTTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgPropertiesTTest")) {
                TestUtil.logTrace((String)"@onMessage - msgPropertiesTTest!");
                this.msgPropertiesTTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgPropertiesConversionTTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - msgPropertiesConversionTTestCreate!");
                this.msgPropertiesConversionTTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgPropertiesConversionTTest")) {
                TestUtil.logTrace((String)"@onMessage - msgPropertiesConversionTTest!");
                this.msgPropertiesConversionTTest(msg);
            } else {
                TestUtil.logTrace((String)"@onMessage - invalid message type found in StringProperty");
                TestUtil.logTrace((String)("Do not have a method for this testcase: " + msg.getStringProperty("TestCase")));
            }
            TestUtil.logTrace((String)"@onMessage - Finished for this test!");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.qConnection != null) {
                try {
                    this.qConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
            if (this.tConnection != null) {
                try {
                    this.tConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
    }

    private void msgPropertiesTTestCreate() {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        Object propertyNames = null;
        Object jmsxDefined = null;
        String testMessageBody = "Testing...";
        boolean NUMPROPS = false;
        JmsUtil.addPropsToMessage((Message)this.messageSent, this.p);
        try {
            this.messageSent.setText(testMessageBody);
            this.messageSent.setBooleanProperty("TESTBOOLEAN", bool);
            this.messageSent.setByteProperty("TESTBYTE", bValue);
            this.messageSent.setShortProperty("TESTSHORT", nShort);
            this.messageSent.setIntProperty("TESTINT", nInt);
            this.messageSent.setFloatProperty("TESTFLOAT", nFloat);
            this.messageSent.setDoubleProperty("TESTDOUBLE", nDouble);
            this.messageSent.setStringProperty("TESTSTRING", "test");
            this.messageSent.setLongProperty("TESTLONG", nLong);
            this.messageSent.setObjectProperty("OBJTESTBOOLEAN", (Object)bool);
            this.messageSent.setObjectProperty("OBJTESTBYTE", (Object)bValue);
            this.messageSent.setObjectProperty("OBJTESTSHORT", (Object)nShort);
            this.messageSent.setObjectProperty("OBJTESTINT", (Object)nInt);
            this.messageSent.setObjectProperty("OBJTESTFLOAT", (Object)new Float(nFloat));
            this.messageSent.setObjectProperty("OBJTESTDOUBLE", (Object)new Double(nDouble));
            this.messageSent.setObjectProperty("OBJTESTSTRING", (Object)"test");
            this.messageSent.setObjectProperty("OBJTESTLONG", (Object)new Long(nLong));
            this.messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgPropertiesTTest");
            this.messageSent.setStringProperty("TestCase", "msgPropertiesTTest");
            Enumeration e = this.messageSent.getPropertyNames();
            String key = null;
            int i = 0;
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                TestUtil.logTrace((String)("+++++++   Property Name is: " + key));
                if (key.indexOf("JMS") == 0) continue;
                ++i;
            }
            this.messageSent.setIntProperty("NUMPROPS", ++i);
            TestUtil.logTrace((String)"Sending message");
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)this.messageSent);
            try {
                this.messageSent.setObjectProperty("OBJTESTLONG", new Object());
                TestUtil.logMsg((String)"Error: expected MessageFormatException from invalid ");
                TestUtil.logMsg((String)"call to setObjectProperty did not occur!");
                pass = false;
            }
            catch (MessageFormatException fe) {
                TestUtil.logTrace((String)"Pass: ");
                TestUtil.logTrace((String)"      MessageFormatException as expected from invalid setObjectProperty call");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"from call to setObjectProperty!");
                TestUtil.logMsg((String)ee.getMessage());
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void msgPropertiesTTest(Message msg) {
        block79: {
            boolean pass = true;
            boolean bool = true;
            byte bValue = 127;
            short nShort = 10;
            int nInt = 5;
            long nLong = 333L;
            float nFloat = 1.0f;
            double nDouble = 100.0;
            String testString = "test";
            Enumeration propertyNames = null;
            Object jmsxDefined = null;
            String testCase = "msgPropertiesTTest";
            String testMessageBody = "Testing...";
            TextMessage messageReceived = (TextMessage)msg;
            try {
                String value;
                try {
                    messageReceived.setBooleanProperty("TESTBOOLEAN", bool);
                    TestUtil.logMsg((String)"Error: exception should have occurred for setBooleanProperty");
                    pass = false;
                }
                catch (MessageNotWriteableException aBool) {
                    TestUtil.logTrace((String)"Pass: exception as expected for setBooleanProperty ");
                }
                try {
                    messageReceived.setByteProperty("TESTBYTE", bValue);
                    TestUtil.logMsg((String)"Error: exception should have occurred for setByteProperty");
                    pass = false;
                }
                catch (MessageNotWriteableException aBool) {
                    TestUtil.logTrace((String)"Pass: exception as expected for setByteProperty ");
                }
                try {
                    messageReceived.setShortProperty("TESTSHORT", nShort);
                    pass = false;
                    TestUtil.logMsg((String)"Error: exception should have occurred for setShortProperty");
                }
                catch (MessageNotWriteableException aBool) {
                    TestUtil.logTrace((String)"Pass: exception as expected for setShortProperty ");
                }
                try {
                    messageReceived.setIntProperty("TESTINT", nInt);
                    TestUtil.logMsg((String)"Error: exception should have occurred for setIntProperty");
                    pass = false;
                }
                catch (MessageNotWriteableException aBool) {
                    TestUtil.logTrace((String)"Pass: exception as expected for setIntProperty ");
                }
                try {
                    messageReceived.setFloatProperty("TESTFLOAT", nFloat);
                    TestUtil.logMsg((String)"Error: exception should have occurred for setFloatProperty");
                    pass = false;
                }
                catch (MessageNotWriteableException aBool) {
                    TestUtil.logTrace((String)"Pass: exception as expected for setFloatProperty ");
                }
                try {
                    messageReceived.setDoubleProperty("TESTDOUBLE", nDouble);
                    TestUtil.logMsg((String)"Error: exception should have occurred for setDoubleProperty");
                    pass = false;
                }
                catch (MessageNotWriteableException aBool) {
                    TestUtil.logTrace((String)"Pass: exception as expected for setDoubleProperty ");
                }
                try {
                    messageReceived.setStringProperty("TESTSTRING", testString);
                    TestUtil.logMsg((String)"Error: exception should have occurred for setStringProperty");
                    pass = false;
                }
                catch (MessageNotWriteableException aBool) {
                    TestUtil.logTrace((String)"Pass: exception as expected for setStringProperty ");
                }
                try {
                    messageReceived.setLongProperty("TESTLONG", nLong);
                    TestUtil.logMsg((String)"Error: exception should have occurred for setLongProperty");
                    pass = false;
                }
                catch (MessageNotWriteableException aBool) {
                    TestUtil.logTrace((String)"Pass: exception as expected for setLongProperty ");
                }
                try {
                    messageReceived.setObjectProperty("OBJTESTBOOLEAN", (Object)bool);
                    TestUtil.logMsg((String)"Error: exception should have occurred for setObjectProperty");
                    pass = false;
                }
                catch (MessageNotWriteableException aBool) {
                    TestUtil.logTrace((String)"Pass: exception as expected for setObjectProperty ");
                }
                int numPropertyNames = messageReceived.getIntProperty("NUMPROPS");
                int i = 0;
                propertyNames = messageReceived.getPropertyNames();
                do {
                    String tmp = (String)propertyNames.nextElement();
                    TestUtil.logTrace((String)("+++++++   Property Name is: " + tmp));
                    if (tmp.indexOf("JMS") == 0) continue;
                    ++i;
                } while (propertyNames.hasMoreElements());
                if (i == numPropertyNames) {
                    TestUtil.logTrace((String)("Pass: # of properties is " + numPropertyNames + " as expected"));
                } else {
                    TestUtil.logMsg((String)("Error: expected " + numPropertyNames + "property names"));
                    TestUtil.logMsg((String)("       But " + i + " returned"));
                    pass = false;
                }
                if (messageReceived.getBooleanProperty("TESTBOOLEAN") == bool) {
                    TestUtil.logTrace((String)"Pass: getBooleanProperty returned correct value");
                } else {
                    TestUtil.logMsg((String)"Error: incorrect value returned from getBooleanProperty");
                    pass = false;
                }
                if (messageReceived.getByteProperty("TESTBYTE") == bValue) {
                    TestUtil.logTrace((String)"Pass: getByteProperty returned correct value");
                } else {
                    TestUtil.logMsg((String)"Error: incorrect value returned from getByteProperty");
                    pass = false;
                }
                if (messageReceived.getLongProperty("TESTLONG") == nLong) {
                    TestUtil.logTrace((String)"Pass: getLongProperty returned correct value");
                } else {
                    TestUtil.logMsg((String)"Error: incorrect value returned from getLongProperty");
                    pass = false;
                }
                if (messageReceived.getStringProperty("TESTSTRING").equals(testString)) {
                    TestUtil.logTrace((String)"Pass: getStringProperty returned correct value");
                } else {
                    TestUtil.logMsg((String)"Error: incorrect value returned from getStringProperty");
                    pass = false;
                }
                if (messageReceived.getDoubleProperty("TESTDOUBLE") == nDouble) {
                    TestUtil.logTrace((String)"Pass: getDoubleProperty returned correct value");
                } else {
                    TestUtil.logMsg((String)"Error: incorrect value returned from getDoubleProperty");
                    pass = false;
                }
                if (messageReceived.getFloatProperty("TESTFLOAT") == nFloat) {
                    TestUtil.logTrace((String)"Pass: getFloatProperty returned correct value");
                } else {
                    TestUtil.logMsg((String)"Error: incorrect value returned from getFloatProperty");
                    pass = false;
                }
                if (messageReceived.getIntProperty("TESTINT") == nInt) {
                    TestUtil.logTrace((String)"Pass: getIntProperty returned correct value");
                } else {
                    TestUtil.logMsg((String)"Error: incorrect value returned from getIntProperty");
                    pass = false;
                }
                if (messageReceived.getShortProperty("TESTSHORT") == nShort) {
                    TestUtil.logTrace((String)"Pass: getShortProperty returned correct value");
                } else {
                    TestUtil.logMsg((String)"Error: incorrect value returned from getShortProperty");
                    pass = false;
                }
                boolean b = messageReceived.getBooleanProperty("TESTDUMMY");
                if (b) {
                    TestUtil.logTrace((String)"Error: should havereceived false for getBooleanProperty");
                    pass = false;
                }
                if ((value = messageReceived.getStringProperty("TESTDUMMY")) == null) {
                    TestUtil.logTrace((String)"Pass: getStringProperty returned correct value");
                } else {
                    TestUtil.logMsg((String)"Error: expected a null return from getStringProperty for invalid property");
                    pass = false;
                }
                Boolean aBool = (Boolean)messageReceived.getObjectProperty("TESTDUMMY");
                if (aBool == null) {
                    TestUtil.logTrace((String)"Pass: getObjectProperty returned correct value for Boolean");
                } else {
                    TestUtil.logMsg((String)"Error: expected a null return from getObjectProperty for invalid property");
                    pass = false;
                }
                Boolean boolValue = (Boolean)messageReceived.getObjectProperty("OBJTESTBOOLEAN");
                if (boolValue == bool) {
                    TestUtil.logTrace((String)"Pass: getObjectProperty returned correct value for Boolean");
                } else {
                    TestUtil.logMsg((String)"Error: incorrect value returned for Boolean");
                    pass = false;
                }
                Byte byteValue = (Byte)messageReceived.getObjectProperty("OBJTESTBYTE");
                if (byteValue == bValue) {
                    TestUtil.logTrace((String)"Pass: getObjectProperty returned correct Byte value");
                } else {
                    TestUtil.logMsg((String)"Error: incorrect value returned from Byte");
                    pass = false;
                }
                Long lValue = (Long)messageReceived.getObjectProperty("OBJTESTLONG");
                if (lValue == nLong) {
                    TestUtil.logTrace((String)"Pass: getObjectProperty returned correct value for Long");
                } else {
                    TestUtil.logMsg((String)"Error: getObjectProperty returned incorrect value returned for Long");
                    pass = false;
                }
                if (messageReceived.getObjectProperty("OBJTESTSTRING").equals(testString)) {
                    TestUtil.logTrace((String)"Pass: getObjectProperty returned correct value for String");
                } else {
                    TestUtil.logMsg((String)"Error: getObjectProperty returned incorrect value for String");
                    pass = false;
                }
                Double dValue = (Double)messageReceived.getObjectProperty("OBJTESTDOUBLE");
                if (dValue == nDouble) {
                    TestUtil.logTrace((String)"Pass: getObjectProperty returned correct value for Double");
                } else {
                    TestUtil.logMsg((String)"Error: getObjectProperty returned incorrect value for Double");
                    pass = false;
                }
                Float fValue = (Float)messageReceived.getObjectProperty("OBJTESTFLOAT");
                if (fValue.floatValue() == nFloat) {
                    TestUtil.logTrace((String)"Pass: getObjectProperty returned correct value for Float");
                } else {
                    TestUtil.logMsg((String)"Error: getObjectProperty returned incorrect value for Float");
                    pass = false;
                }
                Integer iValue = (Integer)messageReceived.getObjectProperty("OBJTESTINT");
                if (iValue == nInt) {
                    TestUtil.logTrace((String)"Pass: getObjectProperty returned correct value for Integer");
                } else {
                    TestUtil.logMsg((String)"Error: getObjectProperty returned incorrect value for Integer");
                    pass = false;
                }
                Short sValue = (Short)messageReceived.getObjectProperty("OBJTESTSHORT");
                if (sValue == nShort) {
                    TestUtil.logTrace((String)"Pass: getObjectProperty returned correct value for Short");
                } else {
                    TestUtil.logMsg((String)"Error: getObjectProperty returned incorrect value for Short");
                    pass = false;
                }
                messageReceived.clearProperties();
                Long aLong = (Long)messageReceived.getObjectProperty("OBJTESTLONG");
                if (aLong == null) {
                    TestUtil.logTrace((String)"Pass: property was cleared");
                } else {
                    TestUtil.logMsg((String)"Error: getObjectProperty should have returned null for cleared property");
                    pass = false;
                }
                try {
                    short aShort = messageReceived.getShortProperty("TESTSHORT");
                    TestUtil.logMsg((String)"Error: NullPointerException should have occurred for getShortProperty");
                    TestUtil.logMsg((String)"Properties have been cleared!");
                    pass = false;
                }
                catch (NullPointerException np) {
                    TestUtil.logTrace((String)"Pass: NullPointerException as expected ");
                }
                catch (NumberFormatException nf) {
                    TestUtil.logTrace((String)"Pass: NumberFormatException as expected ");
                }
                try {
                    String newEntry = "new entry";
                    TestUtil.logTrace((String)"Verify that you can set a property after clearProperty");
                    messageReceived.setStringProperty("TESTSTRING", "new entry");
                    if (messageReceived.getStringProperty("TESTSTRING").equals(newEntry)) {
                        TestUtil.logTrace((String)"Pass: able to set a cleared property");
                    } else {
                        TestUtil.logTrace((String)"Error: was not able to new property setting after clearProperty");
                        pass = false;
                    }
                }
                catch (Exception exp) {
                    TestUtil.logTrace((String)"Unexpected Exception caught while testing set after clearProperty");
                    pass = false;
                    TestUtil.printStackTrace((Throwable)exp);
                }
                TestUtil.logMsg((String)("Message body is : " + messageReceived.getText()));
                if (messageReceived.getText().equals(testMessageBody)) {
                    TestUtil.logTrace((String)"Pass: able to read message body after clearProperties");
                } else {
                    TestUtil.logMsg((String)"Error: unable to read message body after clearProperties");
                    pass = false;
                }
                try {
                    ConnectionMetaData data = this.qConnection.getMetaData();
                    Enumeration cmd = data.getJMSXPropertyNames();
                    if (cmd == null) {
                        TestUtil.logMsg((String)"Error: no JMSX property names were returned!");
                        TestUtil.logMsg((String)"expected JMSXGroupID and JMSXGroupSeq at a miniumum");
                        pass = false;
                        break block79;
                    }
                    int iCount = 0;
                    while (cmd.hasMoreElements()) {
                        String propName = (String)cmd.nextElement();
                        TestUtil.logTrace((String)propName);
                        if (!propName.equals("JMSXGroupID") && !propName.equals("JMSXGroupSeq")) continue;
                        ++iCount;
                    }
                    if (iCount == 2) {
                        TestUtil.logTrace((String)"Pass:");
                        break block79;
                    }
                    TestUtil.logMsg((String)"Error: Expected property names not returned");
                    pass = false;
                }
                catch (Exception ee) {
                    TestUtil.printStackTrace((Throwable)ee);
                    TestUtil.logMsg((String)"attempting to read JMSX property names.");
                    TestUtil.logMsg((String)("Error: unexpected exception: " + ee.getClass().getName() + " was thrown"));
                    pass = false;
                }
            }
            catch (Exception ex) {
                TestUtil.printStackTrace((Throwable)ex);
                pass = false;
            }
            finally {
                this.sendTestResults(testCase, pass);
            }
        }
    }

    private void msgPropertiesConversionTTestCreate() {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        String testMessageBody = "Testing...";
        boolean ntest = false;
        try {
            this.messageSent.setText(testMessageBody);
            this.messageSent.setBooleanProperty("TESTBOOLEAN", bool);
            this.messageSent.setByteProperty("TESTBYTE", bValue);
            this.messageSent.setShortProperty("TESTSHORT", nShort);
            this.messageSent.setIntProperty("TESTINT", nInt);
            this.messageSent.setFloatProperty("TESTFLOAT", nFloat);
            this.messageSent.setDoubleProperty("TESTDOUBLE", nDouble);
            this.messageSent.setStringProperty("TESTSTRING", "test");
            this.messageSent.setLongProperty("TESTLONG", nLong);
            this.messageSent.setStringProperty("TESTSTRINGTRUE", "true");
            this.messageSent.setStringProperty("TESTSTRINGFALSE", "false");
            this.messageSent.setStringProperty("TESTSTRING1", "1");
            this.messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgPropertiesConversionTTest");
            this.messageSent.setStringProperty("TestCase", "msgPropertiesConversionTTest");
            TestUtil.logTrace((String)"Sending message");
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void msgPropertiesConversionTTest(Message messageReceived) {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        String testMessageBody = "Testing...";
        boolean ntest = false;
        String testCase = "msgPropertiesConversionTTest";
        try {
            String myBool = messageReceived.getStringProperty("TESTBOOLEAN");
            if (Boolean.valueOf(myBool) == bool) {
                TestUtil.logTrace((String)"Pass: conversion from boolean to string - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from boolean to string failed");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTBOOLEAN");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: boolean to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- boolean to byte");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTBOOLEAN");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: boolean to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- boolean to short");
                pass = false;
            }
            try {
                messageReceived.getIntProperty("TESTBOOLEAN");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: boolean to int ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception --boolean to int ");
                pass = false;
            }
            try {
                messageReceived.getLongProperty("TESTBOOLEAN");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: boolean to long ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- boolean to long");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTBOOLEAN");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: boolean to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- boolean to float");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTBOOLEAN");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: boolean to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- boolean to double");
                pass = false;
            }
            String myByte = messageReceived.getStringProperty("TESTBYTE");
            if (Byte.valueOf(myByte) == bValue) {
                TestUtil.logTrace((String)"Pass: conversion from byte to string - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from byte to string failed");
                pass = false;
            }
            if (messageReceived.getShortProperty("TESTBYTE") == bValue) {
                TestUtil.logTrace((String)"Pass: conversion from byte to short - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from byte to short failed");
                pass = false;
            }
            if (messageReceived.getIntProperty("TESTBYTE") == bValue) {
                TestUtil.logTrace((String)"Pass: conversion from byte to int - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from byte to int failed");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTBYTE") == (long)bValue) {
                TestUtil.logTrace((String)"Pass: conversion from byte to long - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from byte to long failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTBYTE");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: byte to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- byte to boolean");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTBYTE");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: byte to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception --byte to float ");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTBYTE");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: byte to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- byte to double");
                pass = false;
            }
            String myshort = messageReceived.getStringProperty("TESTSHORT");
            if (Short.valueOf(myshort) == nShort) {
                TestUtil.logTrace((String)"Pass: conversion from short to string - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from short to string failed");
                pass = false;
            }
            if (messageReceived.getIntProperty("TESTSHORT") == nShort) {
                TestUtil.logTrace((String)"Pass: conversion from short to int - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from short to int failed");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTSHORT") == (long)nShort) {
                TestUtil.logTrace((String)"Pass: conversion from short to long - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from short to long failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTSHORT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: short to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- short to boolean");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTSHORT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: short to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- short to byte");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTSHORT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: short to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- short to float");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTSHORT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: short to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- short to double");
                pass = false;
            }
            if (Integer.valueOf(messageReceived.getStringProperty("TESTINT")) == nInt) {
                TestUtil.logTrace((String)"Pass: conversion from int to string - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from int to string failed");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTINT") == (long)nInt) {
                TestUtil.logTrace((String)"Pass: conversion from int to long - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from int to long failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTINT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: int to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- int to boolean");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTINT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: int to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception --  int to byte");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTINT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: int to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected -- int to short ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception ");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTINT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: int to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- int to float");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTINT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: int to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- int to double");
                pass = false;
            }
            if (Long.valueOf(messageReceived.getStringProperty("TESTLONG")) == nLong) {
                TestUtil.logTrace((String)"Pass: conversion from long to string - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from long to string failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTLONG");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: long to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- long to boolean");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTLONG");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: long to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- long to byte");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTLONG");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: long to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- long to short ");
                pass = false;
            }
            try {
                messageReceived.getIntProperty("TESTLONG");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: long to int ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- long to int");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTLONG");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: long to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- long to float");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTLONG");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: long to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- long to double");
                pass = false;
            }
            if (Float.valueOf(messageReceived.getStringProperty("TESTFLOAT")).floatValue() == nFloat) {
                TestUtil.logTrace((String)"Pass: conversion from float to string - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from float to string failed");
                pass = false;
            }
            if (messageReceived.getDoubleProperty("TESTFLOAT") == (double)nFloat) {
                TestUtil.logTrace((String)"Pass: conversion from long to double - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from long to double failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTFLOAT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: float to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- float to boolean ");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTFLOAT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: float to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- float to byte");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTFLOAT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: float to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception - float to short ");
                pass = false;
            }
            try {
                messageReceived.getIntProperty("TESTFLOAT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: float to int ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception --- float to int");
                pass = false;
            }
            try {
                messageReceived.getLongProperty("TESTFLOAT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: float to long ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception --  float to long");
                pass = false;
            }
            if (Double.valueOf(messageReceived.getStringProperty("TESTDOUBLE")) == nDouble) {
                TestUtil.logTrace((String)"Pass: conversion from double to string - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from double to string failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTDOUBLE");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: double to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- double to boolean ");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTDOUBLE");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: double to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- double to byte ");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTDOUBLE");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: double to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- double to short");
                pass = false;
            }
            try {
                messageReceived.getIntProperty("TESTDOUBLE");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: double to int ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception --- double to int ");
                pass = false;
            }
            try {
                messageReceived.getLongProperty("TESTDOUBLE");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: double to long ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- double to long");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTDOUBLE");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: double to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logMsg((String)("Error: unexpected error " + ee.getClass().getName() + " was thrown"));
                TestUtil.logMsg((String)"Error: did not catch expected Exception -- double to float");
                pass = false;
            }
            if (messageReceived.getBooleanProperty("TESTSTRINGTRUE")) {
                TestUtil.logTrace((String)"Pass: conversion from string to boolean - expect true - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from string to boolean - expect true  - failed");
                pass = false;
            }
            if (!messageReceived.getBooleanProperty("TESTSTRINGFALSE")) {
                TestUtil.logTrace((String)"Pass: conversion from string to boolean expect false - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from string to boolean expect false - failed");
                pass = false;
            }
            if (messageReceived.getByteProperty("TESTSTRING1") == 1) {
                TestUtil.logTrace((String)"Pass: conversion from string to byte - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from string to byte failed");
                pass = false;
            }
            if (messageReceived.getShortProperty("TESTSTRING1") == 1) {
                TestUtil.logTrace((String)"Pass: conversion from string to short - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from string to short failed");
                pass = false;
            }
            if (messageReceived.getIntProperty("TESTSTRING1") == 1) {
                TestUtil.logTrace((String)"Pass: conversion from string to int - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from string to int failed");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTSTRING1") == 1L) {
                TestUtil.logTrace((String)"Pass: conversion from string to long - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from string to long failed");
                pass = false;
            }
            if (messageReceived.getFloatProperty("TESTSTRING1") == 1.0f) {
                TestUtil.logTrace((String)"Pass: conversion from string to float - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from string to float failed");
                pass = false;
            }
            if (messageReceived.getDoubleProperty("TESTSTRING1") == 1.0) {
                TestUtil.logTrace((String)"Pass: conversion from string to double - ok");
            } else {
                TestUtil.logMsg((String)"Error: conversion from string to double failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    private void sendTestResults(String testCase, boolean results) {
        TextMessage msg = null;
        try {
            this.mSender = this.qSession.createSender(this.queueR);
            msg = this.qSession.createTextMessage();
            msg.setStringProperty("TestCase", testCase);
            msg.setText(testCase);
            if (results) {
                msg.setStringProperty("Status", "Pass");
            } else {
                msg.setStringProperty("Status", "Fail");
            }
            TestUtil.logTrace((String)"Sending response message");
            TestUtil.logTrace((String)("==================================Test Results from: " + testCase));
            TestUtil.logTrace((String)("==================================Status: " + results));
            this.mSender.send((Message)msg);
        }
        catch (JMSException je) {
            TestUtil.printStackTrace((Throwable)je);
            TestUtil.logTrace((String)("Error: " + ((Object)((Object)je)).getClass().getName() + " was thrown"));
        }
        catch (Exception ee) {
            TestUtil.printStackTrace((Throwable)ee);
            TestUtil.logTrace((String)("Error: " + ee.getClass().getName() + " was thrown"));
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgPropsT  In MsgBeanMsgTestPropsT::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgPropsT  In MsgBeanMsgTestPropsT::remove()!!");
    }
}

