/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.validation;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.interop.csiv2.common.parser.AssertionEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.CSIv2LogEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ClientEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ClientInterceptorEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.EJBHomeEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.EJBRemoteEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.IOREntry;
import com.sun.ts.tests.interop.csiv2.common.parser.InvocationEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ParseException;
import com.sun.ts.tests.interop.csiv2.common.parser.Parser;
import com.sun.ts.tests.interop.csiv2.common.parser.ReplyEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ServerEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ServerInterceptorEntry;
import com.sun.ts.tests.interop.csiv2.common.validation.IORValidationStrategy;
import com.sun.ts.tests.interop.csiv2.common.validation.OutputLog;
import com.sun.ts.tests.interop.csiv2.common.validation.RequestValidationStrategy;
import com.sun.ts.tests.interop.csiv2.common.validation.ResponseValidationStrategy;
import com.sun.ts.tests.interop.csiv2.common.validation.ValidationException;
import java.util.Vector;

public class CSIv2LogValidator {
    private AssertionEntry assertionEntry;
    private IORValidationStrategy iorValidationStrategy;
    private RequestValidationStrategy requestValidationStrategy;
    private ResponseValidationStrategy responseValidationStrategy;
    private boolean validateRemote = true;
    private String expectedHome = "create-exception";
    private String expectedRemote = "no-exception";
    private static final String EJB_HOME = "EJBHome";
    private static final String EJB_REMOTE = "EJBRemote";
    private static final String REQUEST = "Request";
    private static final String RESPONSE = "Response";
    private static boolean isInterceptorLoggingRequired = true;
    private OutputLog log = new OutputLog();
    private static final String linePrefix = "----------[  ";
    private static final String lineSuffix = "  ]----------\n";

    public CSIv2LogValidator(String assertionName, CSIv2LogEntry csiv2LogEntry, IORValidationStrategy iorValidationStrategy, RequestValidationStrategy requestValidationStrategy, ResponseValidationStrategy responseValidationStrategy) throws ValidationException {
        if (isInterceptorLoggingRequired) {
            this.assertionEntry = this.findAssertionEntry(csiv2LogEntry, assertionName);
        }
        this.iorValidationStrategy = iorValidationStrategy;
        this.requestValidationStrategy = requestValidationStrategy;
        this.responseValidationStrategy = responseValidationStrategy;
    }

    public CSIv2LogValidator(String assertionName, CSIv2LogEntry csiv2LogEntry, IORValidationStrategy iorValidationStrategy, RequestValidationStrategy requestValidationStrategy, ResponseValidationStrategy responseValidationStrategy, String expectedHome, String expectedRemote) throws ValidationException {
        this(assertionName, csiv2LogEntry, iorValidationStrategy, requestValidationStrategy, responseValidationStrategy);
        this.expectedHome = expectedHome;
        this.expectedRemote = expectedRemote;
        this.validateRemote = false;
    }

    public static boolean validate(String assertionName, String logContents, IORValidationStrategy iorValidator, RequestValidationStrategy requestValidator, ResponseValidationStrategy responseValidator) {
        boolean pass = false;
        isInterceptorLoggingRequired = CSIv2LogValidator.getSysPropInterceptorLoggingRequired();
        if (isInterceptorLoggingRequired) {
            try {
                CSIv2LogEntry csiv2LogEntry = new Parser().parse(logContents);
                pass = new CSIv2LogValidator(assertionName, csiv2LogEntry, iorValidator, requestValidator, responseValidator).validate();
            }
            catch (ParseException e) {
                TestUtil.logErr((String)"CSIv2 Log Parser Exception: ", (Throwable)e);
            }
            catch (ValidationException e) {
                TestUtil.logErr((String)"CSIv2 Log Validation Exception: ", (Throwable)e);
            }
        } else {
            CSIv2LogValidator.interceptorLoggingDisabledMsg();
            pass = true;
        }
        return pass;
    }

    public static boolean validate(String assertionName, String logContents, IORValidationStrategy iorValidator, RequestValidationStrategy requestValidator, ResponseValidationStrategy responseValidator, String expectedHome, String expectedRemote) {
        boolean pass = false;
        isInterceptorLoggingRequired = CSIv2LogValidator.getSysPropInterceptorLoggingRequired();
        if (isInterceptorLoggingRequired) {
            try {
                CSIv2LogEntry csiv2LogEntry = new Parser().parse(logContents);
                pass = new CSIv2LogValidator(assertionName, csiv2LogEntry, iorValidator, requestValidator, responseValidator, expectedHome, expectedRemote).validate();
            }
            catch (ParseException e) {
                TestUtil.logErr((String)"CSIv2 Log Parser Exception: ", (Throwable)e);
            }
            catch (ValidationException e) {
                TestUtil.logErr((String)"CSIv2 Log Validation Exception: ", (Throwable)e);
            }
        } else {
            CSIv2LogValidator.interceptorLoggingDisabledMsg();
            pass = true;
        }
        return pass;
    }

    private static void interceptorLoggingDisabledMsg() {
        TestUtil.logMsg((String)"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$");
        TestUtil.logMsg((String)"$$ : Interceptor Logging disabled !!!             $$");
        TestUtil.logMsg((String)"$$ : This mode verifies ejb invocations only !!!  $$");
        TestUtil.logMsg((String)"$$ : CSIv2 Protocol elements not validated !!!    $$");
        TestUtil.logMsg((String)"$$ :                                              $$");
        TestUtil.logMsg((String)"$$ : Enable Interceptor logging using             $$");
        TestUtil.logMsg((String)"$$ :  -Dinterceptor.logging.required=true         $$");
        TestUtil.logMsg((String)"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$");
    }

    public boolean validate() throws ValidationException {
        boolean iorsValid = false;
        boolean replyValid = false;
        boolean invocationRequestValid = false;
        boolean invocationResponseValid = false;
        if (isInterceptorLoggingRequired) {
            this.log.logInfo("----------[  1) Validate Replies  ]----------\n");
            if (this.expectedHome != null && this.expectedRemote != null) {
                replyValid = this.validateReply(EJB_HOME, this.expectedHome) & (!this.validateRemote || this.validateReply(EJB_REMOTE, this.expectedRemote));
            } else {
                replyValid = true;
                this.log.logInfo("Not expecting reply. Skipping Reply validation.");
            }
            this.log.logInfo("----------[  2) Validate IORs  ]----------\n");
            if (this.iorValidationStrategy != null) {
                iorsValid = this.validateIOR(EJB_HOME) & (!this.validateRemote || this.validateIOR(EJB_REMOTE));
            } else {
                iorsValid = true;
                this.log.logInfo("Forward Test. Skipping IOR validation.");
            }
            this.log.logInfo("----------[  3) Validate Invocation Requests  ]----------\n");
            if (this.requestValidationStrategy != null) {
                invocationRequestValid = this.validateInvocation(EJB_HOME, REQUEST) & (!this.validateRemote || this.validateInvocation(EJB_REMOTE, REQUEST));
            } else {
                invocationRequestValid = true;
                this.log.logInfo("Reverse Test. Skipping invocation request validation.");
            }
            this.log.logInfo("----------[  4) Validate Invocation responses  ]----------\n");
            if (this.responseValidationStrategy != null) {
                invocationResponseValid = this.validateInvocation(EJB_HOME, RESPONSE) & (!this.validateRemote || this.validateInvocation(EJB_REMOTE, RESPONSE));
            } else {
                invocationResponseValid = true;
                this.log.logInfo("Forward Test. Skipping invocation response validation.");
            }
        } else {
            CSIv2LogValidator.interceptorLoggingDisabledMsg();
            iorsValid = true;
            replyValid = true;
            invocationRequestValid = true;
            invocationResponseValid = true;
        }
        return replyValid && iorsValid && invocationRequestValid && invocationResponseValid;
    }

    private boolean validateIOR(String whichIOR) throws ValidationException {
        boolean iorValid = false;
        if (isInterceptorLoggingRequired) {
            IOREntry iorEntry = this.findLastIOREntry(whichIOR);
            if (iorEntry == null) {
                throw new ValidationException("Could not find " + whichIOR + " IOR Entry.");
            }
            this.log.logInfo("Validating " + whichIOR + " IOR...");
            iorValid = this.iorValidationStrategy.validate(iorEntry);
            this.log.logInfo(whichIOR + " IOR " + (iorValid ? "Valid.\n" : "Invalid.\n"));
        } else {
            CSIv2LogValidator.interceptorLoggingDisabledMsg();
            iorValid = true;
        }
        return iorValid;
    }

    private boolean validateReply(String whichReply, String expectedReply) throws ValidationException {
        boolean replyValid = false;
        if (isInterceptorLoggingRequired) {
            ReplyEntry replyEntry = this.findLastReplyEntry(whichReply);
            if (replyEntry == null) {
                throw new ValidationException("Could not find " + whichReply + " Reply Entry.");
            }
            this.log.logInfo("Validating " + whichReply + " reply...");
            replyValid = replyEntry.getReplyType().equals(expectedReply);
            if (replyValid) {
                this.log.logInfo("Got expected " + expectedReply + " reply.");
            } else {
                this.log.logInfo("Got unexpected " + replyEntry.getReplyType() + ", expected " + expectedReply + " reply.");
            }
            this.log.logInfo(whichReply + " reply " + (replyValid ? "Valid." : "Invalid."));
        } else {
            CSIv2LogValidator.interceptorLoggingDisabledMsg();
            replyValid = true;
        }
        return replyValid;
    }

    private boolean validateInvocation(String whichInvocation, String requestOrResponse) throws ValidationException {
        String invocationName = whichInvocation + " Invocation " + requestOrResponse;
        boolean invocationValid = false;
        if (isInterceptorLoggingRequired) {
            ClientEntry clientEntry = this.findLastInvocationEntry(whichInvocation);
            if (clientEntry == null) {
                throw new ValidationException("Could not find " + invocationName + " Entry.");
            }
            this.log.logInfo("Validating " + invocationName + "...");
            invocationValid = requestOrResponse.equals(REQUEST) ? this.requestValidationStrategy.validate(clientEntry) : this.responseValidationStrategy.validate(clientEntry);
            this.log.logInfo(invocationName + " " + (invocationValid ? "Valid." : "Invalid."));
        } else {
            CSIv2LogValidator.interceptorLoggingDisabledMsg();
            invocationValid = true;
        }
        return invocationValid;
    }

    private AssertionEntry findAssertionEntry(CSIv2LogEntry csiv2LogEntry, String assertionName) throws ValidationException {
        AssertionEntry result = null;
        Vector assertions = csiv2LogEntry.getAssertions();
        for (int i = 0; i < assertions.size(); ++i) {
            AssertionEntry entry = (AssertionEntry)assertions.elementAt(i);
            if (!entry.getName().equals(assertionName)) continue;
            result = entry;
        }
        if (result == null) {
            throw new ValidationException("Could not find assertion node " + assertionName + " in CSIv2 log.");
        }
        return result;
    }

    private IOREntry findLastIOREntry(String whichIOR) throws ValidationException {
        InvocationEntry invocation = this.assertionEntry.getInvocation();
        return this.findLastIOREntryInInvocation(null, whichIOR, invocation);
    }

    private ReplyEntry findLastReplyEntry(String whichReply) {
        InvocationEntry invocation = this.assertionEntry.getInvocation();
        return this.findLastReplyEntryInInvocation(null, whichReply, invocation);
    }

    private IOREntry findLastIOREntryInInvocation(IOREntry lastFound, String whichIOR, InvocationEntry invocation) {
        ClientInterceptorEntry clientInterceptor;
        Vector ejbRemotes;
        IOREntry result = lastFound;
        ClientEntry clientHome = null;
        ClientEntry clientRemote = null;
        Vector ejbHomes = invocation.getEjbHomes();
        if (ejbHomes.size() > 0) {
            EJBHomeEntry lastEJBHome = (EJBHomeEntry)ejbHomes.elementAt(ejbHomes.size() - 1);
            clientHome = lastEJBHome.getClient();
        }
        if ((ejbRemotes = invocation.getEjbRemotes()).size() > 0) {
            EJBRemoteEntry lastEJBRemote = (EJBRemoteEntry)ejbRemotes.elementAt(ejbRemotes.size() - 1);
            clientRemote = lastEJBRemote.getClient();
        }
        if (whichIOR.equals(EJB_HOME) && clientHome != null) {
            clientInterceptor = clientHome.getClientInterceptor();
            if (clientInterceptor != null) {
                result = clientInterceptor.getIor();
            }
        } else if (whichIOR.equals(EJB_REMOTE) && clientRemote != null && (clientInterceptor = clientRemote.getClientInterceptor()) != null) {
            result = clientInterceptor.getIor();
        }
        if (clientRemote != null) {
            clientInterceptor = clientRemote.getClientInterceptor();
            ServerInterceptorEntry serverInterceptor = clientRemote.getServerInterceptor();
            ServerEntry server = clientRemote.getServer();
            if (clientInterceptor != null) {
                result = this.findLastIOREntryInClientInterceptor(result, whichIOR, clientInterceptor);
            } else if (serverInterceptor != null) {
                ServerEntry server2 = serverInterceptor.getServer();
                if (server2 != null) {
                    result = this.findLastIOREntryInServer(result, whichIOR, server2);
                }
            } else if (server != null) {
                result = this.findLastIOREntryInServer(result, whichIOR, server);
            }
        }
        return result;
    }

    private ReplyEntry findLastReplyEntryInInvocation(ReplyEntry lastFound, String whichReply, InvocationEntry invocation) {
        Vector ejbRemotes;
        ReplyEntry result = lastFound;
        ClientEntry clientHome = null;
        ClientEntry clientRemote = null;
        Vector ejbHomes = invocation.getEjbHomes();
        if (ejbHomes.size() > 0) {
            EJBHomeEntry lastEJBHome = (EJBHomeEntry)ejbHomes.elementAt(ejbHomes.size() - 1);
            clientHome = lastEJBHome.getClient();
        }
        if ((ejbRemotes = invocation.getEjbRemotes()).size() > 0) {
            EJBRemoteEntry lastEJBRemote = (EJBRemoteEntry)ejbRemotes.elementAt(ejbRemotes.size() - 1);
            clientRemote = lastEJBRemote.getClient();
        }
        if (whichReply.equals(EJB_HOME) && clientHome != null) {
            result = clientHome.getReply();
        } else if (whichReply.equals(EJB_REMOTE) && clientRemote != null) {
            result = clientRemote.getReply();
        }
        return result;
    }

    private IOREntry findLastIOREntryInClientInterceptor(IOREntry lastFound, String whichIOR, ClientInterceptorEntry clientInterceptor) {
        IOREntry result = lastFound;
        ServerInterceptorEntry serverInterceptor = clientInterceptor.getServerInterceptor();
        ServerEntry server = clientInterceptor.getServer();
        if (serverInterceptor != null) {
            ServerEntry server2 = serverInterceptor.getServer();
            if (server2 != null) {
                result = this.findLastIOREntryInServer(result, whichIOR, server2);
            }
        } else if (server != null) {
            result = this.findLastIOREntryInServer(result, whichIOR, server);
        }
        ClientInterceptorEntry clientInterceptor2 = clientInterceptor.getClientInterceptor();
        if (clientInterceptor2 != null) {
            result = this.findLastIOREntryInClientInterceptor(result, whichIOR, clientInterceptor2);
        }
        return result;
    }

    private IOREntry findLastIOREntryInServer(IOREntry lastFound, String whichIOR, ServerEntry server) {
        IOREntry result = lastFound;
        InvocationEntry invocation = server.getInvocation();
        if (invocation != null) {
            result = this.findLastIOREntryInInvocation(lastFound, whichIOR, invocation);
        }
        return result;
    }

    private ClientEntry findLastInvocationEntry(String whichInvocation) throws ValidationException {
        InvocationEntry invocation = this.assertionEntry.getInvocation();
        return this.findLastClientEntryInInvocation(null, whichInvocation, invocation);
    }

    private ClientEntry findLastClientEntryInInvocation(ClientEntry lastFound, String whichInvocation, InvocationEntry invocation) {
        Vector ejbRemotes;
        ClientEntry result = lastFound;
        ClientEntry clientHome = null;
        ClientEntry clientRemote = null;
        Vector ejbHomes = invocation.getEjbHomes();
        if (ejbHomes.size() > 0) {
            EJBHomeEntry lastEJBHome = (EJBHomeEntry)ejbHomes.elementAt(ejbHomes.size() - 1);
            clientHome = lastEJBHome.getClient();
        }
        if ((ejbRemotes = invocation.getEjbRemotes()).size() > 0) {
            EJBRemoteEntry lastEJBRemote = (EJBRemoteEntry)ejbRemotes.elementAt(ejbRemotes.size() - 1);
            clientRemote = lastEJBRemote.getClient();
        }
        if (whichInvocation.equals(EJB_HOME) && clientHome != null) {
            result = clientHome;
        } else if (whichInvocation.equals(EJB_REMOTE) && clientRemote != null) {
            result = clientRemote;
        }
        if (clientRemote != null) {
            ClientInterceptorEntry clientInterceptor = clientRemote.getClientInterceptor();
            ServerInterceptorEntry serverInterceptor = clientRemote.getServerInterceptor();
            ServerEntry server = clientRemote.getServer();
            if (clientInterceptor != null) {
                result = this.findLastClientEntryInClientInterceptor(result, whichInvocation, clientInterceptor);
            } else if (serverInterceptor != null) {
                ServerEntry server2 = serverInterceptor.getServer();
                if (server2 != null) {
                    result = this.findLastClientEntryInServer(result, whichInvocation, server2);
                }
            } else if (server != null) {
                result = this.findLastClientEntryInServer(result, whichInvocation, server);
            }
        }
        return result;
    }

    private ClientEntry findLastClientEntryInClientInterceptor(ClientEntry lastFound, String whichInvocation, ClientInterceptorEntry clientInterceptor) {
        ClientEntry result = lastFound;
        ServerInterceptorEntry serverInterceptor = clientInterceptor.getServerInterceptor();
        ServerEntry server = clientInterceptor.getServer();
        if (serverInterceptor != null) {
            ServerEntry server2 = serverInterceptor.getServer();
            if (server2 != null) {
                result = this.findLastClientEntryInServer(result, whichInvocation, server2);
            }
        } else if (server != null) {
            result = this.findLastClientEntryInServer(result, whichInvocation, server);
        }
        ClientInterceptorEntry clientInterceptor2 = clientInterceptor.getClientInterceptor();
        if (clientInterceptor2 != null) {
            result = this.findLastClientEntryInClientInterceptor(result, whichInvocation, clientInterceptor2);
        }
        return result;
    }

    private ClientEntry findLastClientEntryInServer(ClientEntry lastFound, String whichInvocation, ServerEntry server) {
        ClientEntry result = lastFound;
        InvocationEntry invocation = server.getInvocation();
        if (invocation != null) {
            result = this.findLastClientEntryInInvocation(lastFound, whichInvocation, invocation);
        }
        return result;
    }

    private static boolean getSysPropInterceptorLoggingRequired() {
        String sysPropText = System.getProperty("interceptor.logging.required");
        if (sysPropText != null) {
            isInterceptorLoggingRequired = Boolean.parseBoolean(sysPropText);
        }
        return isInterceptorLoggingRequired;
    }
}

