/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.validation;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.interop.csiv2.common.parser.ClientEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ClientInterceptorEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.CompleteEstablishContextEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ReplyServiceContextEntry;
import com.sun.ts.tests.interop.csiv2.common.validation.OutputLog;
import com.sun.ts.tests.interop.csiv2.common.validation.ValidationException;

public class ResponseValidationStrategy {
    private OutputLog log = new OutputLog();
    private boolean expectingServiceContext;
    private boolean errorExpected;

    public ResponseValidationStrategy(boolean expectingServiceContext, boolean errorExpected) {
        this.expectingServiceContext = expectingServiceContext;
        this.errorExpected = errorExpected;
    }

    public boolean validate(ClientEntry entry) throws ValidationException {
        boolean result = true;
        TestUtil.logTrace((String)("Validating the following invocation:\n-------------------------------------------\n" + entry.toString() + "-------------------------------------------"));
        boolean valid = this.verifyServiceContextPresence(entry);
        boolean bl = result = result && valid;
        if (!valid) {
            if (this.expectingServiceContext) {
                this.log.logMismatch("Expecting service context.");
            } else {
                this.log.logMismatch("Not expecting service context.");
            }
        }
        if (this.expectingServiceContext) {
            valid = this.verifyResponseMessageType(entry);
            boolean bl2 = result = result && valid;
            if (!valid) {
                this.log.logMismatch("Mismatched response message type.");
            }
        } else {
            this.log.logInfo("Not expecting service context - skipping response message type validation.");
        }
        return result;
    }

    private boolean verifyServiceContextPresence(ClientEntry entry) throws ValidationException {
        boolean present;
        boolean result = true;
        ReplyServiceContextEntry replyServiceContext = this.findReplyServiceContextEntry(entry);
        boolean bl = present = replyServiceContext != null && replyServiceContext.isPresent();
        result = this.expectingServiceContext ? present : !present;
        return result;
    }

    private boolean verifyResponseMessageType(ClientEntry entry) throws ValidationException {
        boolean result = true;
        ReplyServiceContextEntry replyServiceContext = this.findReplyServiceContextEntry(entry);
        if (replyServiceContext == null || !replyServiceContext.isPresent()) {
            this.log.logMismatch("Error: Reply service context expected to be present for reply.");
            result = false;
        } else if (this.errorExpected) {
            boolean bl = result = replyServiceContext.getContextError() != null;
            if (!result) {
                this.log.logMismatch("Error: Expecting ContextError message");
            }
        } else {
            CompleteEstablishContextEntry completeEstablishContext = replyServiceContext.getCompleteEstablishContext();
            boolean bl = result = completeEstablishContext != null;
            if (!result) {
                this.log.logMismatch("Error: Expecting CompleteEstablishContext message");
            }
        }
        return result;
    }

    private ReplyServiceContextEntry findReplyServiceContextEntry(ClientEntry entry) throws ValidationException {
        Object result = null;
        ClientInterceptorEntry clientInterceptor = entry.getClientInterceptor();
        if (clientInterceptor == null) {
            throw new ValidationException("Error: Expecting client-interceptor element.");
        }
        while (clientInterceptor != null && clientInterceptor.isLocationForward()) {
            clientInterceptor = clientInterceptor.getClientInterceptor();
        }
        if (clientInterceptor == null) {
            throw new ValidationException("Error: Could not find client-interceptor element with no locationForward.");
        }
        return clientInterceptor.getReplyServiceContext();
    }
}

