/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.common.tags;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.tagext.TagSupport;

public class ConfigTag
extends TagSupport {
    private static final String LOCALE = "locale";
    private static final String FALLBACK_LOCALE = "fallback";
    private static final String LOCALE_CTX = "localectx";
    private static final String TIMEZONE = "timezone";
    private static final String DATASOURCE = "datasource";
    private static final String MAX_ROW = "maxrows";
    private static final String PAGE = "page";
    private static final String REQUEST = "request";
    private static final String SESSION = "session";
    private static final String APPLICATION = "application";
    private static final String SET = "set";
    private static final String GET = "get";
    private static final String REMOVE = "remove";
    private String _configVar = null;
    private String _scope = "page";
    private Object _value = null;
    private String _operation = null;
    private String _var = null;

    public void setScope(String scope) {
        this._scope = scope;
    }

    public void setOp(String op) {
        this._operation = op;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setConfigVar(String configVar) {
        this._configVar = configVar;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public int doEndTag() throws JspException {
        String name = null;
        if (this._configVar.equals(LOCALE)) {
            name = "javax.servlet.jsp.jstl.fmt.locale";
        } else if (this._configVar.equals(FALLBACK_LOCALE)) {
            name = "javax.servlet.jsp.jstl.fmt.fallbackLocale";
        } else if (this._configVar.equals(LOCALE_CTX)) {
            name = "javax.servlet.jsp.jstl.fmt.localizationContext";
        } else if (this._configVar.equals(TIMEZONE)) {
            name = "javax.servlet.jsp.jstl.fmt.timeZone";
        } else if (this._configVar.equals(DATASOURCE)) {
            name = "javax.servlet.jsp.jstl.sql.dataSource";
        } else if (this._configVar.equals(MAX_ROW)) {
            name = "javax.servlet.jsp.jstl.sql.maxRows";
        } else {
            throw new IllegalArgumentException("[ERROR] Config variable: " + this._configVar + " is invalid.");
        }
        if (this._operation.equals(GET)) {
            Object o = Config.get((PageContext)this.pageContext, (String)name, (int)this.getScope(this._scope));
            if (o != null) {
                this.pageContext.setAttribute(this._var, o);
            }
        } else if (this._operation.equals(SET)) {
            Config.set((PageContext)this.pageContext, (String)name, (Object)this._value, (int)this.getScope(this._scope));
        } else if (this._operation.equals(REMOVE)) {
            Config.remove((PageContext)this.pageContext, (String)name, (int)this.getScope(this._scope));
        } else {
            throw new IllegalArgumentException("[Error] Invalid operation: " + this._operation);
        }
        return 6;
    }

    public void release() {
        this._configVar = null;
        this._value = null;
        this._scope = PAGE;
        this._var = null;
        this._operation = null;
    }

    private int getScope(String scopeName) throws JspException {
        if (scopeName.equals(PAGE)) {
            return 1;
        }
        if (scopeName.equals(REQUEST)) {
            return 2;
        }
        if (scopeName.equals(SESSION)) {
            return 3;
        }
        if (scopeName.equals(APPLICATION)) {
            return 4;
        }
        throw new IllegalArgumentException("[Error] Scope: " + this._scope + " is invalid.");
    }

    static {
        LOCALE = LOCALE;
        FALLBACK_LOCALE = FALLBACK_LOCALE;
        LOCALE_CTX = LOCALE_CTX;
        TIMEZONE = TIMEZONE;
        DATASOURCE = DATASOURCE;
        MAX_ROW = MAX_ROW;
        PAGE = PAGE;
        REQUEST = REQUEST;
        SESSION = SESSION;
        APPLICATION = APPLICATION;
        SET = SET;
        GET = GET;
        REMOVE = REMOVE;
    }
}

