/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jacc.util;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jacc.util.LogRecordEntry;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.SequenceInputStream;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LogFileProcessor {
    private String logFileLocation = null;
    private Collection recordCollection = new Vector();
    private Collection appIdRecordCollection = new Vector();
    private Collection linkRecordCollection = new Vector();
    private Collection appSpecificRecordCollection = new Vector();
    private Permissions appSpecificUnCheckedPermissions = new Permissions();
    private Permissions appSpecificExcludedPermissions = new Permissions();
    private Permissions appSpecificAddToRolePermissions = new Permissions();

    public LogFileProcessor() {
    }

    public LogFileProcessor(Properties props) {
        this.setup(props);
    }

    public void setup(Properties p) {
        boolean pass = true;
        try {
            if (p != null) {
                TestUtil.logMsg((String)"setting logFileLocation based on passed in Properties");
                this.logFileLocation = p.getProperty("log.file.location");
            } else {
                TestUtil.logMsg((String)"setting logFileLocation based on passed in System.getProperty()");
                this.logFileLocation = System.getProperty("log.file.location");
            }
            if (this.logFileLocation == null) {
                pass = false;
            }
            TestUtil.logMsg((String)("log.file.location = " + this.logFileLocation));
            if (!pass) {
                TestUtil.logErr((String)"Setup Failed ");
                TestUtil.logErr((String)"Please verify the following in ts.jte");
                TestUtil.logErr((String)"log.file.location");
            }
            TestUtil.logMsg((String)"Setup ok");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Setup Failed ");
            TestUtil.logErr((String)"Please verify the following in ts.jte");
            TestUtil.logErr((String)"log.file.location");
        }
    }

    public Permissions getAppSpecificUnCheckedPermissions() {
        return this.appSpecificUnCheckedPermissions;
    }

    public Permissions getAppSpecificExcludedPermissions() {
        return this.appSpecificExcludedPermissions;
    }

    public Permissions getAppSpecificAddToRolePermissions() {
        return this.appSpecificAddToRolePermissions;
    }

    public Permissions getAppSpecificPermissions(String permCat, String permType, String appContext) {
        Permissions permsToReturn = new Permissions();
        LogRecordEntry recordEntry2 = null;
        Permission p = null;
        if (this.appSpecificRecordCollection == null) {
            return null;
        }
        for (LogRecordEntry recordEntry2 : this.appSpecificRecordCollection) {
            p = this.getPermissionFromRecordEntry(recordEntry2, permCat, permType, appContext);
            if (p == null) continue;
            permsToReturn.add(p);
        }
        return permsToReturn;
    }

    public void fetchLogs(String accessMethod) {
        this.fetchLogs(accessMethod, null);
    }

    public void fetchLogs(String accessMethod, String appName) {
        File logfile = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.logFileLocation = this.logFileLocation + "/JACCLog.txt";
            if (this.logFileLocation != null) {
                logfile = new File(this.logFileLocation);
            }
            if (logfile == null || !logfile.exists()) {
                System.out.println("Log File : " + this.logFileLocation + " does not exists");
                System.out.println("Check permissions for log file ");
                System.out.println("See User guide for Configuring log file permissions");
            } else {
                String endLogTag = "</log>";
                ByteArrayInputStream bais = new ByteArrayInputStream(endLogTag.getBytes());
                SequenceInputStream sis = new SequenceInputStream(new FileInputStream(this.logFileLocation), bais);
                Document document = documentBuilder.parse(sis);
                Element rootElement = document.getDocumentElement();
                NodeList nodes = rootElement.getChildNodes();
                String queryString = "pullAllRecords";
                String queryParams = "fullLog";
                StringTokenizer strtoken = new StringTokenizer(accessMethod, "|");
                if (accessMethod.indexOf("|") > 0) {
                    queryString = strtoken.nextToken();
                    queryParams = strtoken.nextToken();
                }
                if (queryString.equals("pullAllRecords")) {
                    this.recordCollection = LogFileProcessor.pullAllLogRecords(queryParams, nodes);
                } else if (queryString.equals("getAppSpecificRecordCollection")) {
                    this.appIdRecordCollection = this.getAppIdRecordCollection("appId", nodes);
                    String applicationName = null;
                    applicationName = appName == null ? this.getCurrentApplicationName() : this.getCurrentApplicationName(appName);
                    Vector linkedApplicationNames = this.getLinkedApplicationNames();
                    Collection collection = this.getAppSpecificRecordCollection(applicationName, linkedApplicationNames);
                }
                this.getPermissionCollection();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            e.printStackTrace();
        }
    }

    public PermissionCollection getPermissionCollection() {
        Permissions pColl = new Permissions();
        LogRecordEntry recordEntry2 = null;
        Permission p = null;
        if (this.appSpecificRecordCollection == null) {
            return null;
        }
        for (LogRecordEntry recordEntry2 : this.appSpecificRecordCollection) {
            p = this.getPermissionFromRecordEntry(recordEntry2);
            if (p == null) continue;
            ((PermissionCollection)pColl).add(p);
        }
        return pColl;
    }

    public Permission getPermissionFromRecordEntry(LogRecordEntry recordEntry) {
        String permissionCategory = null;
        String applicationContext = null;
        String temp = null;
        String message = null;
        String permissionType = null;
        String permissionName = null;
        String permissionAction = null;
        String permissionNameAndAction = null;
        String applicationTimeStamp = null;
        String[] tokenArray = new String[2];
        StringTokenizer permCategoryToken = null;
        Object strtok = null;
        boolean isUnChecked = false;
        boolean isExcluded = false;
        boolean isAddToRole = false;
        WebResourcePermission p = null;
        if (recordEntry != null) {
            message = recordEntry.getMessage();
            permCategoryToken = new StringTokenizer(message, " :: ");
            if (message.indexOf(" :: ") > 0) {
                permissionCategory = permCategoryToken.nextToken();
                temp = message.substring(permissionCategory.length() + 4, message.length());
            }
            if (permissionCategory != null) {
                if (permissionCategory.equals("unchecked")) {
                    isUnChecked = true;
                } else if (permissionCategory.equals("excluded")) {
                    isExcluded = true;
                } else if (permissionCategory.equals("addToRole")) {
                    isAddToRole = true;
                }
            }
            if (isUnChecked || isExcluded || isAddToRole) {
                tokenArray = LogFileProcessor.getTokens(temp, " , ");
                applicationContext = tokenArray[0];
                temp = tokenArray[1];
                TestUtil.logTrace((String)("Application Context  =" + applicationContext));
                tokenArray = LogFileProcessor.getTokens(temp, " , ");
                applicationTimeStamp = tokenArray[0];
                temp = tokenArray[1];
                TestUtil.logTrace((String)("Application Time stamp =" + applicationTimeStamp));
                tokenArray = LogFileProcessor.getTokens(temp, " , ");
                permissionType = tokenArray[0];
                permissionNameAndAction = tokenArray[1];
                TestUtil.logTrace((String)("PermissionType =" + permissionType));
                tokenArray = LogFileProcessor.getTokens(permissionNameAndAction, " , ");
                permissionName = tokenArray[0];
                permissionAction = tokenArray[1];
                TestUtil.logTrace((String)("permissionName    = " + permissionName));
                TestUtil.logTrace((String)("permissionAction  = " + permissionAction));
                if (permissionAction.equals("null")) {
                    permissionAction = null;
                }
                if (permissionType.equals("WebResourcePermission")) {
                    p = new WebResourcePermission(permissionName, permissionAction);
                } else if (permissionType.equals("WebRoleRefPermission")) {
                    p = new WebRoleRefPermission(permissionName, permissionAction);
                } else if (permissionType.equals("WebUserDataPermission")) {
                    p = new WebUserDataPermission(permissionName, permissionAction);
                } else if (permissionType.equals("EJBMethodPermission")) {
                    p = new EJBMethodPermission(permissionName, permissionAction);
                } else if (permissionType.equals("EJBRoleRefPermission")) {
                    p = new EJBRoleRefPermission(permissionName, permissionAction);
                }
                if (isUnChecked) {
                    this.appSpecificUnCheckedPermissions.add((Permission)p);
                } else if (isExcluded) {
                    this.appSpecificExcludedPermissions.add((Permission)p);
                } else if (isAddToRole) {
                    this.appSpecificAddToRolePermissions.add((Permission)p);
                }
            }
        }
        return p;
    }

    public Permission getPermissionFromRecordEntry(LogRecordEntry recordEntry, String permCat, String permType, String appContext) {
        String permissionCategory = null;
        String applicationContext = null;
        String temp = null;
        String message = null;
        String permissionType = null;
        String permissionName = null;
        String permissionAction = null;
        String permissionNameAndAction = null;
        String applicationTimeStamp = null;
        String[] tokenArray = new String[2];
        StringTokenizer permCategoryToken = null;
        WebResourcePermission p = null;
        if (recordEntry != null) {
            message = recordEntry.getMessage();
            permCategoryToken = new StringTokenizer(message, " :: ");
            if (message.indexOf(" :: ") > 0) {
                permissionCategory = permCategoryToken.nextToken();
                temp = message.substring(permissionCategory.length() + 4, message.length());
            }
            if (permissionCategory == null || !permissionCategory.equals(permCat)) {
                TestUtil.logTrace((String)(permissionCategory + " != " + permCat));
                return null;
            }
            TestUtil.logTrace((String)(permissionCategory + " == " + permCat));
            tokenArray = LogFileProcessor.getTokens(temp, " , ");
            applicationContext = tokenArray[0];
            temp = tokenArray[1];
            if (!applicationContext.contains(appContext)) {
                TestUtil.logTrace((String)(applicationContext + " != " + appContext));
                return null;
            }
            TestUtil.logTrace((String)("applicationContext =" + applicationContext));
            tokenArray = LogFileProcessor.getTokens(temp, " , ");
            applicationTimeStamp = tokenArray[0];
            temp = tokenArray[1];
            TestUtil.logTrace((String)("Application Time stamp =" + applicationTimeStamp));
            tokenArray = LogFileProcessor.getTokens(temp, " , ");
            permissionType = tokenArray[0];
            permissionNameAndAction = tokenArray[1];
            TestUtil.logTrace((String)("PermissionType =" + permissionType));
            tokenArray = LogFileProcessor.getTokens(permissionNameAndAction, " , ");
            permissionName = tokenArray[0];
            permissionAction = tokenArray[1];
            TestUtil.logTrace((String)("permissionName    = " + permissionName));
            TestUtil.logTrace((String)("permissionAction  = " + permissionAction));
            if (permissionAction.equals("null")) {
                permissionAction = null;
            }
            if (!permissionType.equals(permType)) {
                return null;
            }
            if (permissionType.equals("WebResourcePermission")) {
                p = new WebResourcePermission(permissionName, permissionAction);
            } else if (permissionType.equals("WebRoleRefPermission")) {
                p = new WebRoleRefPermission(permissionName, permissionAction);
            } else if (permissionType.equals("WebUserDataPermission")) {
                p = new WebUserDataPermission(permissionName, permissionAction);
            } else if (permissionType.equals("EJBMethodPermission")) {
                p = new EJBMethodPermission(permissionName, permissionAction);
            } else if (permissionType.equals("EJBRoleRefPermission")) {
                p = new EJBRoleRefPermission(permissionName, permissionAction);
            }
        }
        return p;
    }

    public Permissions getSpecificPermissions(Permissions suppliedPermCollection, String permissionType) {
        Permissions expectedPermissionCollection;
        block6: {
            Permission p;
            block9: {
                block8: {
                    block7: {
                        block5: {
                            p = null;
                            expectedPermissionCollection = new Permissions();
                            if (!permissionType.equals("WebResourcePermission")) break block5;
                            Enumeration<Permission> en = suppliedPermCollection.elements();
                            while (en.hasMoreElements()) {
                                p = en.nextElement();
                                if (!(p instanceof WebResourcePermission)) continue;
                                expectedPermissionCollection.add(p);
                            }
                            break block6;
                        }
                        if (!permissionType.equals("WebUserDataPermission")) break block7;
                        Enumeration<Permission> en = suppliedPermCollection.elements();
                        while (en.hasMoreElements()) {
                            p = en.nextElement();
                            if (!(p instanceof WebUserDataPermission)) continue;
                            expectedPermissionCollection.add(p);
                        }
                        break block6;
                    }
                    if (!permissionType.equals("WebRoleRefPermission")) break block8;
                    Enumeration<Permission> en = suppliedPermCollection.elements();
                    while (en.hasMoreElements()) {
                        p = en.nextElement();
                        if (!(p instanceof WebRoleRefPermission)) continue;
                        expectedPermissionCollection.add(p);
                    }
                    break block6;
                }
                if (!permissionType.equals("EJBMethodPermission")) break block9;
                Enumeration<Permission> en = suppliedPermCollection.elements();
                while (en.hasMoreElements()) {
                    p = en.nextElement();
                    if (!(p instanceof EJBMethodPermission)) continue;
                    expectedPermissionCollection.add(p);
                }
                break block6;
            }
            if (!permissionType.equals("EJBRoleRefPermission")) break block6;
            Enumeration<Permission> en = suppliedPermCollection.elements();
            while (en.hasMoreElements()) {
                p = en.nextElement();
                if (!(p instanceof EJBRoleRefPermission)) continue;
                expectedPermissionCollection.add(p);
            }
        }
        return expectedPermissionCollection;
    }

    public static Collection pullAllLogRecords(String queryParams, NodeList nodes) throws Exception {
        Vector<LogRecordEntry> recordCollection = new Vector<LogRecordEntry>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node recordNode = nodes.item(i);
            if (!recordNode.getNodeName().equals("record")) continue;
            LogRecordEntry recordEntry = new LogRecordEntry(recordNode);
            recordCollection.add(recordEntry);
        }
        return recordCollection;
    }

    public void setAppIdRecordCollection(Collection recordCollection) {
        this.appIdRecordCollection = recordCollection;
    }

    public Collection getAppIdRecordCollection() {
        return this.appIdRecordCollection;
    }

    public void setRecordCollection(Collection recordCollection) {
        this.recordCollection = recordCollection;
    }

    public Collection getRecordCollection() {
        return this.recordCollection;
    }

    public void setAppSpecificRecordCollection(Collection recordCollection) {
        this.appSpecificRecordCollection = recordCollection;
    }

    public Collection getAppSpecificRecordCollection() {
        return this.appSpecificRecordCollection;
    }

    public boolean verifyLogContains(String[] args) {
        LogRecordEntry recordEntry2 = null;
        TestUtil.logMsg((String)("Searching log records for record :" + args[0]));
        if (this.recordCollection == null) {
            TestUtil.logMsg((String)"Record collection empty : No log records found");
            return false;
        }
        TestUtil.logMsg((String)("Record collection has:  " + this.recordCollection.size() + " records."));
        int numberOfArgs = args.length;
        int numberOfMatches = 0;
        boolean[] argsMatchIndex = new boolean[args.length];
        for (int i = 0; i < args.length; ++i) {
            argsMatchIndex[i] = false;
        }
        for (LogRecordEntry recordEntry2 : this.recordCollection) {
            String message = recordEntry2.getMessage();
            for (int i = 0; i < numberOfArgs; ++i) {
                if (argsMatchIndex[i] || message == null || !message.equals(args[i])) continue;
                TestUtil.logMsg((String)"Matching Record :");
                TestUtil.logMsg((String)recordEntry2.getMessage());
                ++numberOfMatches;
                argsMatchIndex[i] = true;
            }
            if (numberOfMatches != numberOfArgs) continue;
            return true;
        }
        TestUtil.logMsg((String)"No Matching log Record(s) found for the following String(s) :");
        for (int i = 0; i < numberOfArgs; ++i) {
            if (argsMatchIndex[i]) continue;
            TestUtil.logMsg((String)args[i]);
        }
        return false;
    }

    public boolean verifyLogContainsOneOf(String[] args) {
        LogRecordEntry recordEntry2 = null;
        boolean result = false;
        TestUtil.logMsg((String)"Searching log records for the presence of one of the String from a given string array");
        if (this.recordCollection == null) {
            TestUtil.logMsg((String)"Record collection empty : No log records found");
            return false;
        }
        TestUtil.logMsg((String)("Record collection has:  " + this.recordCollection.size() + " records."));
        int numberOfArgs = args.length;
        block0: for (LogRecordEntry recordEntry2 : this.recordCollection) {
            String message = recordEntry2.getMessage();
            for (int i = 0; i < numberOfArgs; ++i) {
                if (message == null || !message.equals(args[i])) continue;
                TestUtil.logMsg((String)"Matching Record :");
                TestUtil.logMsg((String)recordEntry2.getMessage());
                result = true;
                break block0;
            }
        }
        if (!result) {
            TestUtil.logMsg((String)"No Matching log Record(s) found for the following String(s) :");
            for (int i = 0; i < numberOfArgs; ++i) {
                TestUtil.logMsg((String)args[i]);
            }
        }
        return result;
    }

    public boolean verifyLogContainsOneOfSubString(String[] args, String srchStrPrefix) {
        LogRecordEntry recordEntry2 = null;
        boolean result = false;
        TestUtil.logMsg((String)"Searching log records for the presence of one of the String from a given string array");
        if (this.recordCollection == null) {
            TestUtil.logMsg((String)"Record collection empty : No log records found");
            return false;
        }
        TestUtil.logMsg((String)("Record collection has:  " + this.recordCollection.size() + " records."));
        int numberOfArgs = args.length;
        block0: for (LogRecordEntry recordEntry2 : this.recordCollection) {
            String message = recordEntry2.getMessage();
            for (int i = 0; i < numberOfArgs; ++i) {
                if (message == null || !message.startsWith(srchStrPrefix, 0) || message.indexOf(args[i]) <= 0) continue;
                TestUtil.logMsg((String)"Matching Record :");
                TestUtil.logMsg((String)recordEntry2.getMessage());
                result = true;
                break block0;
            }
        }
        if (!result) {
            TestUtil.logMsg((String)"No Matching log Record(s) found for the following String(s) :");
            for (int i = 0; i < numberOfArgs; ++i) {
                TestUtil.logMsg((String)args[i]);
            }
        }
        return result;
    }

    public boolean verifyLogImplies(Permissions expectedPermissions, Permissions generatedPermissions) {
        Permission p;
        boolean verified = false;
        Enumeration<Permission> en = expectedPermissions.elements();
        while (en.hasMoreElements()) {
            p = en.nextElement();
            verified = generatedPermissions.implies(p);
            if (verified) continue;
            TestUtil.logErr((String)"The following permission doesn't match with server generated Permissions");
            TestUtil.logErr((String)("permissionName   = " + p.getName()));
            TestUtil.logErr((String)("permissionAction = " + p.getActions()));
            TestUtil.logErr((String)"\n\n");
            TestUtil.logErr((String)"Print Expected Permissions :");
            this.printPermissions(expectedPermissions);
            TestUtil.logErr((String)"\n\n");
            TestUtil.logErr((String)"Print Generated Permissions :");
            this.printPermissions(generatedPermissions);
            return false;
        }
        en = generatedPermissions.elements();
        while (en.hasMoreElements()) {
            p = en.nextElement();
            verified = expectedPermissions.implies(p);
            if (verified) continue;
            TestUtil.logMsg((String)"The following server generated permission doesn't match with the expected Permissions");
            TestUtil.logMsg((String)("permissionName   = " + p.getName()));
            TestUtil.logMsg((String)("permissionAction = " + p.getActions()));
        }
        return true;
    }

    public void printCollection(Collection recordCollection) {
        LogRecordEntry recordEntry2 = null;
        for (LogRecordEntry recordEntry2 : recordCollection) {
            this.printRecordEntry(recordEntry2);
        }
    }

    public void printPermissions(Permissions perms) {
        int count = 0;
        Enumeration<Permission> en = perms.elements();
        while (en.hasMoreElements()) {
            Permission p = en.nextElement();
            TestUtil.logMsg((String)"-------------");
            TestUtil.logMsg((String)(++count + ") permissionType   = " + p.getClass().getName()));
            TestUtil.logMsg((String)(count + ") permissionName   = " + p.getName()));
            TestUtil.logMsg((String)(count + ") permissionAction = " + p.getActions()));
        }
    }

    public void printPermissionCollection(PermissionCollection permCollection) {
        String permissionType = null;
        int count = 0;
        Enumeration<Permission> en = permCollection.elements();
        while (en.hasMoreElements()) {
            ++count;
            Permission p = en.nextElement();
            if (p instanceof WebResourcePermission) {
                permissionType = "WebResourcePermission";
            } else if (p instanceof WebUserDataPermission) {
                permissionType = "WebUserDataPermission";
            } else if (p instanceof WebRoleRefPermission) {
                permissionType = "WebRoleRefPermission";
            } else if (p instanceof EJBMethodPermission) {
                permissionType = "EJBMethodPermission";
            } else if (p instanceof EJBRoleRefPermission) {
                permissionType = "EJBRoleRefPermission";
            }
            TestUtil.logMsg((String)"-------------");
            TestUtil.logMsg((String)(count + ") permissionType   = " + permissionType));
            TestUtil.logMsg((String)(count + ") permissionName   = " + p.getName()));
            TestUtil.logMsg((String)(count + ") permissionAction = " + p.getActions()));
        }
    }

    public void printRecordEntry(LogRecordEntry rec) {
        TestUtil.logMsg((String)"*******Log Content*******");
        TestUtil.logMsg((String)("Milli Seconds  =" + rec.getMilliSeconds()));
        TestUtil.logMsg((String)("Seqence no  =" + rec.getSequenceNumber()));
        TestUtil.logMsg((String)("Message     =" + rec.getMessage()));
        if (rec.getClassName() != null) {
            TestUtil.logMsg((String)("Class name  =" + rec.getClassName()));
        }
        if (rec.getMethodName() != null) {
            TestUtil.logMsg((String)("Method name =" + rec.getMethodName()));
        }
        if (rec.getLevel() != null) {
            TestUtil.logMsg((String)("Level        =" + rec.getLevel()));
        }
        if (rec.getThrown() != null) {
            TestUtil.logMsg((String)("Thrown       =" + rec.getThrown()));
        }
        TestUtil.logMsg((String)"");
    }

    public String extractQueryToken(String str, String ContextId) {
        String DELIMETER = "|";
        String qstring = null;
        String qparams = null;
        StringTokenizer strtok = new StringTokenizer(ContextId, DELIMETER);
        if (ContextId.indexOf(DELIMETER) > 0) {
            qstring = strtok.nextToken();
            if (strtok.hasMoreTokens()) {
                qparams = strtok.nextToken();
            }
        }
        if (str.equals("LogQueryString")) {
            return qstring;
        }
        return qparams;
    }

    public static String[] getTokens(String str, String delimeter) {
        String[] array = new String[2];
        StringTokenizer strtoken = new StringTokenizer(str, delimeter);
        if (str.indexOf(delimeter) > 0) {
            array[0] = strtoken.nextToken();
            array[1] = str.substring(array[0].length() + 3, str.length());
        } else {
            array[0] = "";
            array[1] = strtoken.nextToken();
        }
        return array;
    }

    public Collection findLogsByPrefix(String queryParams, NodeList nodes) throws Exception {
        Vector<LogRecordEntry> recordCollection = new Vector<LogRecordEntry>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node recordNode = nodes.item(i);
            NodeList recordNodeChildren = recordNode.getChildNodes();
            for (int j = 0; j < recordNodeChildren.getLength(); ++j) {
                String nodeValue;
                Node childNode = recordNodeChildren.item(j);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals("message") || !(nodeValue = this.getText(childNode)).startsWith(queryParams)) continue;
                LogRecordEntry recordEntry = new LogRecordEntry(recordNode);
                recordCollection.add(recordEntry);
            }
        }
        return recordCollection;
    }

    public String getText(Node textNode) {
        String result = "";
        NodeList nodes = textNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 3) continue;
            result = node.getNodeValue();
            break;
        }
        return result;
    }

    public Collection getAppIdRecordCollection(String queryParams, NodeList nodes) throws Exception {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node recordNode = nodes.item(i);
            NodeList recordNodeChildren = recordNode.getChildNodes();
            for (int j = 0; j < recordNodeChildren.getLength(); ++j) {
                Node childNode = recordNodeChildren.item(j);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals("message")) continue;
                String nodeValue = this.getText(childNode);
                if (nodeValue.startsWith(queryParams)) {
                    LogRecordEntry matchingRecordEntry = new LogRecordEntry(recordNode);
                    this.appIdRecordCollection.add(matchingRecordEntry);
                    continue;
                }
                if (nodeValue.startsWith("link")) {
                    LogRecordEntry linkRecordEntry = new LogRecordEntry(recordNode);
                    this.linkRecordCollection.add(linkRecordEntry);
                    continue;
                }
                LogRecordEntry nonMatchingRecordEntry = new LogRecordEntry(recordNode);
                this.recordCollection.add(nonMatchingRecordEntry);
            }
        }
        return this.appIdRecordCollection;
    }

    public String getCurrentApplicationName() {
        return this.getCurrentAppName(null);
    }

    public String getCurrentApplicationName(String appName) {
        return this.getCurrentAppName(appName);
    }

    private String getCurrentAppName(String matchAppName) {
        LogRecordEntry recordEntry2 = null;
        String temp = null;
        String timeStampString = null;
        String appName = null;
        Object prevAppName = null;
        long prevRecordTimeStamp = 0L;
        long recordTimeStamp = 0L;
        String[] tokenArray = new String[2];
        if (this.appIdRecordCollection == null || this.appIdRecordCollection.isEmpty()) {
            TestUtil.logMsg((String)"Record collection empty : No appId records found");
            return null;
        }
        for (LogRecordEntry recordEntry2 : this.appIdRecordCollection) {
            String message = recordEntry2.getMessage();
            temp = message.substring(9, message.length());
            tokenArray = temp.split(" , ");
            appName = tokenArray[0];
            timeStampString = tokenArray[1];
            appName = LogFileProcessor.unStuffData(appName);
            TestUtil.logMsg((String)("appName =" + appName));
            TestUtil.logMsg((String)("timeStampString =" + timeStampString));
            if (matchAppName == null) {
                recordTimeStamp = new Long(timeStampString);
                if (recordTimeStamp >= prevRecordTimeStamp) continue;
                recordTimeStamp = prevRecordTimeStamp;
                appName = prevAppName;
                continue;
            }
            if (!appName.contains(matchAppName)) continue;
            break;
        }
        return appName;
    }

    public Vector getLinkedApplicationNames() {
        LogRecordEntry recordEntry2 = null;
        String temp = null;
        String timeStampString = null;
        String appNames = null;
        Object prevAppName = null;
        long prevRecordTimeStamp = 0L;
        long recordTimeStamp = 0L;
        String[] tokenArray = new String[2];
        Vector<String> applicationNames = new Vector<String>();
        if (this.linkRecordCollection == null) {
            TestUtil.logMsg((String)"Record collection empty : No link records found");
            return null;
        }
        for (LogRecordEntry recordEntry2 : this.linkRecordCollection) {
            String message = recordEntry2.getMessage();
            temp = message.substring(8, message.length());
            tokenArray = temp.split(" : ");
            appNames = tokenArray[0];
            timeStampString = tokenArray[1];
            appNames = LogFileProcessor.unStuffData(appNames);
            recordTimeStamp = new Long(timeStampString);
            if (recordTimeStamp >= prevRecordTimeStamp) continue;
            recordTimeStamp = prevRecordTimeStamp;
            appNames = prevAppName;
        }
        if (appNames != null) {
            StringTokenizer strtoken = new StringTokenizer(appNames, ",");
            if (appNames.indexOf(",") > 0) {
                while (strtoken.hasMoreTokens()) {
                    applicationNames.add(strtoken.nextToken());
                }
            } else if (appNames != null) {
                applicationNames.add(appNames);
            }
        } else {
            return null;
        }
        return applicationNames;
    }

    public Collection<LogRecordEntry> getMsgTagRecordCollection() {
        LogRecordEntry recordEntry2 = null;
        Vector<LogRecordEntry> msgTagRecordCollection = new Vector<LogRecordEntry>();
        TestUtil.logTrace((String)("getMsgTagRecordCollection():  Record collection size : " + this.recordCollection.size()));
        if (this.recordCollection == null) {
            TestUtil.logTrace((String)"Record collection empty : No records found");
            return null;
        }
        for (LogRecordEntry recordEntry2 : this.recordCollection) {
            String message = recordEntry2.getMessage();
            if (message.indexOf("MSG_TAG") <= -1) continue;
            TestUtil.logTrace((String)("getMsgTagRecordCollection():  message = " + message));
            msgTagRecordCollection.add(recordEntry2);
        }
        TestUtil.logTrace((String)("getMsgTagRecordCollection():  returning collection size of: " + msgTagRecordCollection.size()));
        return msgTagRecordCollection;
    }

    public Collection getAppSpecificRecordCollection(String applicationName, Vector linkedApplicationNames) {
        LogRecordEntry recordEntry2 = null;
        if (this.recordCollection == null) {
            TestUtil.logMsg((String)"Record collection empty : No records found");
            return null;
        }
        for (LogRecordEntry recordEntry2 : this.recordCollection) {
            String message = recordEntry2.getMessage();
            if (message.indexOf(applicationName) <= 0) continue;
            this.appSpecificRecordCollection.add(recordEntry2);
        }
        if (linkedApplicationNames != null) {
            Enumeration appEnum = linkedApplicationNames.elements();
            while (appEnum.hasMoreElements()) {
                applicationName = (String)appEnum.nextElement();
                for (LogRecordEntry recordEntry2 : this.recordCollection) {
                    String message = recordEntry2.getMessage();
                    if (message.indexOf(applicationName) <= 0) continue;
                    this.appSpecificRecordCollection.add(recordEntry2);
                }
            }
        }
        return this.appSpecificRecordCollection;
    }

    public static String unStuffData(String inputStr) {
        char[] outStr = new char[2048];
        char[] str = inputStr.toCharArray();
        TestUtil.logMsg((String)("unStuffData called with:  " + inputStr));
        int i = 0;
        int j = 0;
        while (i < str.length) {
            int a = Character.getNumericValue(str[i]);
            if (a > 9 && a < 36) {
                outStr[j++] = str[i++];
                continue;
            }
            outStr[j] = str[i];
            if (i + 1 < str.length && str[i + 1] == str[i]) {
                ++i;
            }
            ++i;
            ++j;
        }
        TestUtil.logMsg((String)("unStuffData returning:  " + new String(outStr).trim()));
        return new String(outStr).trim();
    }
}

