/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import java.util.Random;
import java.util.logging.Logger;
import javax.batch.api.AbstractBatchlet;
import javax.batch.api.BatchProperty;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="startLimitStateMachineVariation1Batchlet")
public class StartLimitStateMachineVariation1Batchlet
extends AbstractBatchlet {
    private static final String sourceClass = StartLimitStateMachineVariation1Batchlet.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    @Inject
    JobContext jobCtx;
    @Inject
    StepContext stepCtx;
    @Inject
    @BatchProperty(name="runNumber")
    String runNumberString;

    public String process() throws Exception {
        logger.fine(sourceClass + ".process()");
        Random r = new Random();
        int x = r.nextInt();
        int y = r.nextInt();
        for (int i = 0; i < 10; ++i) {
            x = y * x % 3469;
            y = x * y % 3491;
        }
        String exitStatus = null;
        try {
            exitStatus = this.contributeToExitStatus();
            this.appendToJobContext(exitStatus);
        }
        catch (FailViaException e) {
            logger.fine(sourceClass + ".process(); Exiting with exitStatus = " + exitStatus);
            String errorAppend = (String)this.jobCtx.getTransientUserData();
            this.appendToJobContext(errorAppend);
            throw new RuntimeException("Throwing exception on purpose");
        }
        logger.fine(sourceClass + ".process(); Exiting with exitStatus = " + exitStatus);
        return null;
    }

    private void appendToJobContext(String exitStatus) {
        String es = this.jobCtx.getExitStatus();
        if (es == null) {
            logger.fine("First addition to Job ExitStatus = " + es);
            this.jobCtx.setExitStatus(exitStatus);
        } else {
            String newExitStatus = es.concat(",").concat(exitStatus);
            logger.fine("Existing Job ExitStatus = " + es + " ; Updating to : " + newExitStatus);
            this.jobCtx.setExitStatus(newExitStatus);
        }
    }

    public void stop() throws Exception {
        logger.fine(sourceClass + ".cancel()");
    }

    private String contributeToExitStatus() throws FailViaException {
        logger.fine(sourceClass + ".calculateExitStatus(), runNumberString = " + this.runNumberString);
        int execNum = Integer.parseInt(this.runNumberString.substring(new String("runNumber.").length()));
        String stepId = this.stepCtx.getStepName();
        logger.fine(sourceClass + ".calculateExitStatus(), execution # = " + execNum + ", stepId = " + stepId);
        if (stepId.equals("step1")) {
            switch (execNum) {
                case 1: {
                    return "c1";
                }
                case 2: {
                    return "c1";
                }
                case 3: {
                    return "c1";
                }
                case 4: {
                    return "c1";
                }
            }
            return "ILLEGAL.STATE";
        }
        if (stepId.equals("step2")) {
            switch (execNum) {
                case 1: {
                    return "c2";
                }
                case 2: {
                    return "c2";
                }
                case 3: {
                    return "c2";
                }
                case 4: {
                    return "c2";
                }
            }
            return "ILLEGAL.STATE";
        }
        if (stepId.equals("step3")) {
            switch (execNum) {
                case 1: {
                    throw new FailViaException();
                }
                case 2: {
                    throw new FailViaException();
                }
                case 3: {
                    throw new FailViaException();
                }
            }
            return "ILLEGAL.STATE";
        }
        return "ILLEGAL.STATE";
    }

    private class FailViaException
    extends Exception {
        private FailViaException() {
        }
    }
}

