/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxws.common;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.common.Handler_Util;
import com.sun.ts.tests.jaxws.wsi.constants.WSIConstants;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.Text;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public abstract class RequestConformanceChecker
implements SOAPHandler<SOAPMessageContext>,
WSIConstants {
    protected String response;

    public Set<QName> getHeaders() {
        return new HashSet<QName>();
    }

    public void init(Map<String, Object> config) {
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void destroy() {
    }

    public void close(MessageContext context) {
    }

    public abstract void test(SOAPMessageContext var1) throws SOAPException;

    public boolean handleMessage(SOAPMessageContext context) {
        System.out.println("HANDLER: RequestConformanceChecker.handleMessage() BEGIN");
        try {
            if (Handler_Util.getDirection((MessageContext)context).equals("Inbound")) {
                if (this.isRequestTest(context)) {
                    System.out.println("HANDLER: RequestConformanceChecker.handleMessage() HANDLING REQUEST");
                    this.test(context);
                }
            } else if (this.response != null) {
                System.out.println("HANDLER: RequestConformanceChecker.handleMessage() HANDLING RESPONSE");
                this.setResponse(context);
                this.response = null;
            }
        }
        catch (SOAPException se) {
            TestUtil.printStackTrace((Throwable)se);
        }
        System.out.println("HANDLER: RequestConformanceChecker.handleMessage() END");
        return true;
    }

    private void setResponse(SOAPMessageContext context) throws SOAPException {
        SOAPBody body = context.getMessage().getSOAPPart().getEnvelope().getBody();
        SOAPElement responseElement = this.getResponseElement(body);
        Iterator children = responseElement.getChildElements();
        ((Text)children.next()).detachNode();
        responseElement.addTextNode(this.response);
        context.getMessage().saveChanges();
    }

    private SOAPElement getResponseElement(SOAPBody body) {
        return this.getResponseElement((SOAPElement)body.getChildElements().next());
    }

    private SOAPElement getResponseElement(SOAPElement elem) {
        if (elem.getChildElements().next() instanceof Text) {
            return elem;
        }
        return this.getResponseElement((SOAPElement)elem.getChildElements().next());
    }

    private boolean isRequestTest(SOAPMessageContext context) throws SOAPException {
        SOAPHeader header = context.getMessage().getSOAPPart().getEnvelope().getHeader();
        if (header != null) {
            Iterator headers = header.examineHeaderElements("http://conformance-checker.org");
            while (headers.hasNext()) {
                SOAPHeaderElement headerElement = (SOAPHeaderElement)headers.next();
                if (!headerElement.getElementName().getLocalName().equals("test")) continue;
                if (headerElement.getValue().equals("request")) {
                    return true;
                }
                if (!headerElement.getValue().equals("response")) continue;
                return false;
            }
        }
        return true;
    }
}

