/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxws.sharedclients;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;
import com.sun.ts.tests.jaxws.sharedclients.SecureClient;
import com.sun.ts.tests.jaxws.wsi.utils.PropertyUtils;
import java.lang.reflect.Constructor;
import java.util.Properties;
import javax.xml.ws.Service;

public class ClientFactory {
    public static SOAPClient getClient(Class clazz, Properties properties) throws EETest.Fault {
        return ClientFactory.getClient(clazz, properties, null, null);
    }

    public static SOAPClient getClient(Class clazz, Properties properties, ServiceEETest theTest, Service theService) throws EETest.Fault {
        int mode;
        String property = properties.getProperty("platform.mode");
        if (property == null) {
            throw new EETest.Fault("The 'platform.mode' property value is not defined");
        }
        if (property.equalsIgnoreCase("standalone")) {
            mode = 0;
        } else if (property.equalsIgnoreCase("javaEE")) {
            mode = 1;
        } else {
            throw new EETest.Fault("The 'platform.mode' property value '" + property + "' is invalid");
        }
        String webServerHost = PropertyUtils.getProperty(properties, "webServerHost");
        int webServerPort = SecureClient.class.isAssignableFrom(clazz) ? PropertyUtils.getIntegerProperty(properties, "secureWebServerPort") : PropertyUtils.getIntegerProperty(properties, "webServerPort");
        try {
            if (mode == 0) {
                Constructor ctr = clazz.getConstructor(String.class, Integer.TYPE, Integer.TYPE);
                return (SOAPClient)ctr.newInstance(webServerHost, webServerPort, mode);
            }
            Constructor ctr = clazz.getConstructor(String.class, Integer.TYPE, Integer.TYPE, Service.class);
            return (SOAPClient)ctr.newInstance(webServerHost, webServerPort, mode, ClientFactory.getWebServiceRef(theTest, theService));
        }
        catch (NoSuchMethodException e) {
            throw new EETest.Fault("Client '" + clazz.getName() + "' does not have required constructor", e);
        }
        catch (ClassCastException e) {
            throw new EETest.Fault("Client '" + clazz.getName() + "' does not extend '" + SOAPClient.class.getName() + "'", e);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Unable to instantiate '" + clazz.getName() + "'", e);
        }
    }

    private static Service getWebServiceRef(ServiceEETest theTest, Service theService) {
        Service service = theService;
        TestUtil.logMsg((String)"WebServiceRef is not set in Client (get it from specific vehicle)");
        service = (Service)theTest.getSharedObject();
        TestUtil.logMsg((String)("service=" + service));
        return service;
    }

    private ClientFactory() {
    }
}

