/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry_infomodel.RegistryObject;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;

public class JAXRClient
extends JAXRCommonClient {
    Locale tsLocale = new Locale("en", "US");
    BusinessQueryManager bqm = null;

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            super.cleanUpRegistry();
            this.debug.clear();
            this.bqm = this.rs.getBusinessQueryManager();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            super.cleanup();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void registryObject_getSetKeyTest() throws EETest.Fault {
        String testName = "registryObject_getSetKeyTest";
        Key schemeKey = null;
        try {
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            ClassificationScheme scheme = bqm.findClassificationSchemeByName(null, "PhoneType");
            if (scheme == null) {
                this.debug.add("Error: unable to find PhoneType \n");
                throw new EETest.Fault(testName + "failed - test did not complete - unable to find classification scheme ");
            }
            schemeKey = scheme.getKey();
            String newKey = "urn:uuid:de111111-a1e1-11a1-abcc-ee6d11111111";
            Key newOne = this.blm.createKey(newKey);
            scheme.setKey(newOne);
            if (!scheme.getKey().getId().equals(newKey)) {
                throw new EETest.Fault(testName + " Error: get returned did not match get that was set ");
            }
            this.debug.add("good! ");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_DescriptionTest() throws EETest.Fault {
        String testName = "registryObject_DescriptionTest";
        String orgName = "TS Default Organization";
        String orgDescription = "Organization for RegistryObject.getDescription Test";
        try {
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            InternationalString iOrgDescription = this.blm.createInternationalString(this.tsLocale, orgDescription);
            org.setDescription(iOrgDescription);
            if (!org.getDescription().getValue(this.tsLocale).equals(orgDescription)) {
                this.debug.add("Unexpected description returned from org.getDescription() \n");
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("getDescription returned correct description: " + org.getDescription().getValue(this.tsLocale) + "\n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_getNameTest() throws EETest.Fault {
        String testName = "registryObject_getNameTest";
        String orgName = "TS Default Organization";
        try {
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            if (!org.getName().getValue(this.tsLocale).equals(orgName)) {
                this.debug.add("Unexpected name returned from org.getName() \n");
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("getName returned the correct name: " + org.getName().getValue(this.tsLocale) + "\n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_setNameTest() throws EETest.Fault {
        String testName = "registryObject_setNameTest";
        String orgName = "TS Default Organization";
        String oldName = "This is the old Name";
        try {
            InternationalString ioldName = this.blm.createInternationalString(this.tsLocale, oldName);
            Organization org = this.blm.createOrganization(ioldName);
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            org.setName(iorgName);
            if (!org.getName().getValue(this.tsLocale).equals(orgName)) {
                this.debug.add("Unexpected name returned from org.getName() \n");
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("getName returned the correct name: " + org.getName().getValue(this.tsLocale) + "\n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_addClassificationTest() throws EETest.Fault {
        String schemeName = "Geography";
        String schemeDescription = "North American Regions";
        String conceptNameUS = "United States";
        String conceptValueUS = "US";
        String testName = "registryObject_addClassificationTest";
        String orgName = "TS Default Organization";
        try {
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            ClassificationScheme scheme = this.blm.createClassificationScheme(schemeName, schemeDescription);
            Concept concept = this.blm.createConcept((RegistryObject)scheme, this.blm.createInternationalString(this.tsLocale, conceptNameUS), conceptValueUS);
            Classification classification = this.blm.createClassification(concept);
            org.addClassification(classification);
            Collection cls = org.getClassifications();
            this.debug.add("Expect number of Classifications returned from getClassifications to be 1\n");
            this.debug.add("getClassifications returned: " + cls.size() + "\n");
            if (cls.size() != 1) {
                throw new EETest.Fault(testName + " failed ");
            }
            Iterator iter = cls.iterator();
            Classification cl = null;
            while (iter.hasNext()) {
                cl = (Classification)iter.next();
            }
            Concept con = cl.getConcept();
            this.debug.add("Verify classification concept name and value\n");
            this.debug.add("expected name is " + conceptNameUS + "\n");
            this.debug.add("name is " + con.getName().getValue(this.tsLocale) + "\n");
            this.debug.add("expected value is " + conceptValueUS + "\n");
            this.debug.add("value is " + con.getValue() + "\n");
            if (!con.getName().getValue(this.tsLocale).equals(conceptNameUS)) {
                throw new EETest.Fault(testName + " failed  - Concept Name did not match");
            }
            if (!con.getValue().equals(conceptValueUS)) {
                throw new EETest.Fault(testName + " failed  - Concept Value did not match");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_addClassificationsTest() throws EETest.Fault {
        String schemeName = "Geography";
        String schemeDescription = "North American Regions";
        String conceptNameAZ = "Arizona";
        String conceptValueAZ = "US-AZ";
        String conceptNameCO = "Colorado";
        String conceptValueCO = "US-CO";
        String testName = "registryObject_addClassificationsTest";
        String orgName = "TS Default Organization";
        try {
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            ClassificationScheme scheme = this.blm.createClassificationScheme(schemeName, schemeDescription);
            Concept conceptAZ = this.blm.createConcept((RegistryObject)scheme, this.blm.createInternationalString(this.tsLocale, conceptNameAZ), conceptValueAZ);
            Concept conceptCO = this.blm.createConcept((RegistryObject)scheme, this.blm.createInternationalString(this.tsLocale, conceptNameCO), conceptValueCO);
            Classification clAZ = this.blm.createClassification(conceptAZ);
            Classification clCO = this.blm.createClassification(conceptCO);
            ArrayList<Classification> classifications = new ArrayList<Classification>();
            classifications.add(clAZ);
            classifications.add(clCO);
            org.addClassifications(classifications);
            Collection cls = org.getClassifications();
            this.debug.add("Expect number of Classifications returned from getClassifications to be 2 \n");
            this.debug.add("getClassifications returned: " + cls.size() + "\n");
            if (cls.size() != 2) {
                throw new EETest.Fault(testName + " failed ");
            }
            Iterator iter = cls.iterator();
            Classification cl = null;
            Concept con = null;
            int count = 0;
            while (iter.hasNext()) {
                cl = (Classification)iter.next();
                con = cl.getConcept();
                if (con.getName().getValue(this.tsLocale).equals(conceptNameAZ) && con.getValue().equals(conceptValueAZ)) {
                    this.debug.add("Found: " + con.getName().getValue(this.tsLocale) + " and " + con.getValue() + "\n");
                    ++count;
                }
                if (!con.getName().getValue(this.tsLocale).equals(conceptNameCO) || !con.getValue().equals(conceptValueCO)) continue;
                this.debug.add("Found: " + con.getName().getValue(this.tsLocale) + " and " + con.getValue() + "\n");
                ++count;
            }
            if (count != 2) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_removeClassificationTest() throws EETest.Fault {
        String schemeName = "Geography";
        String schemeDescription = "North American Regions";
        String conceptNameUS = "United States";
        String conceptValueUS = "US";
        String testName = "registryObject_removeClassificationTest";
        String orgName = "TS Default Organization";
        try {
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            ClassificationScheme scheme = this.blm.createClassificationScheme(schemeName, schemeDescription);
            Concept concept = this.blm.createConcept((RegistryObject)scheme, this.blm.createInternationalString(this.tsLocale, conceptNameUS), conceptValueUS);
            Classification classification = this.blm.createClassification(concept);
            org.addClassification(classification);
            Collection cls = org.getClassifications();
            this.debug.add("Expect number of Classifications returned from getClassifications to be 1\n");
            this.debug.add("getClassifications returned: " + cls.size() + "\n");
            if (cls.size() != 1) {
                throw new EETest.Fault(testName + " failed ");
            }
            Iterator iter = cls.iterator();
            Classification cl = null;
            while (iter.hasNext()) {
                cl = (Classification)iter.next();
            }
            Concept con = cl.getConcept();
            this.debug.add("Verify classification concept name and value\n");
            this.debug.add("expected name is " + conceptNameUS + "\n");
            this.debug.add("name is " + con.getName().getValue(this.tsLocale) + "\n");
            this.debug.add("expected value is " + conceptValueUS + "\n");
            this.debug.add("value is " + con.getValue() + "\n");
            if (!con.getName().getValue(this.tsLocale).equals(conceptNameUS)) {
                throw new EETest.Fault(testName + " failed  - Concept Name did not match");
            }
            if (!con.getValue().equals(conceptValueUS)) {
                throw new EETest.Fault(testName + " failed  - Concept Value did not match");
            }
            this.debug.add("Verified classification was added.  Now remove it\n");
            org.removeClassification(classification);
            this.debug.add("Removed the classification. getClassifications should return 0\n");
            cls = org.getClassifications();
            this.debug.add("getClassifications returned " + cls.size() + "\n");
            if (cls.size() != 0) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_removeClassificationsTest() throws EETest.Fault {
        String schemeName = "Geography";
        String schemeDescription = "North American Regions";
        String conceptNameAZ = "Arizona";
        String conceptValueAZ = "US-AZ";
        String conceptNameCO = "Colorado";
        String conceptValueCO = "US-CO";
        String testName = "registryObject_removeClassificationsTest";
        String orgName = "TS Default Organization";
        try {
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            ClassificationScheme scheme = this.blm.createClassificationScheme(schemeName, schemeDescription);
            Concept conceptAZ = this.blm.createConcept((RegistryObject)scheme, this.blm.createInternationalString(this.tsLocale, conceptNameAZ), conceptValueAZ);
            Concept conceptCO = this.blm.createConcept((RegistryObject)scheme, this.blm.createInternationalString(this.tsLocale, conceptNameCO), conceptValueCO);
            Classification clAZ = this.blm.createClassification(conceptAZ);
            Classification clCO = this.blm.createClassification(conceptCO);
            ArrayList<Classification> classifications = new ArrayList<Classification>();
            classifications.add(clAZ);
            classifications.add(clCO);
            org.addClassifications(classifications);
            Collection cls = org.getClassifications();
            this.debug.add("Expect number of Classifications returned from getClassifications to be 2 \n");
            this.debug.add("getClassifications returned: " + cls.size() + "\n");
            if (cls.size() != 2) {
                throw new EETest.Fault(testName + " failed ");
            }
            Iterator iter = cls.iterator();
            Classification cl = null;
            Concept con = null;
            int count = 0;
            while (iter.hasNext()) {
                cl = (Classification)iter.next();
                con = cl.getConcept();
                if (con.getName().getValue(this.tsLocale).equals(conceptNameAZ) && con.getValue().equals(conceptValueAZ)) {
                    this.debug.add("Found: " + con.getName().getValue(this.tsLocale) + " and " + con.getValue() + "\n");
                    ++count;
                }
                if (!con.getName().getValue(this.tsLocale).equals(conceptNameCO) || !con.getValue().equals(conceptValueCO)) continue;
                this.debug.add("Found: " + con.getName().getValue(this.tsLocale) + " and " + con.getValue() + "\n");
                ++count;
            }
            if (count != 2) {
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("Added Classifications and verified - now remove them \n");
            org.removeClassifications(cls);
            cls = org.getClassifications();
            this.debug.add("Removed classifications. getClassifications should return 0 classifications \n");
            this.debug.add("getClassifications returned: " + cls.size() + "\n");
            if (cls.size() != 0) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_setClassificationsTest() throws EETest.Fault {
        String schemeName = "Geography";
        String schemeDescription = "North American Regions";
        String conceptNameAZ = "Arizona";
        String conceptValueAZ = "US-AZ";
        String conceptNameCO = "Colorado";
        String conceptValueCO = "US-CO";
        String conceptNameCA = "California";
        String conceptValueCA = "US-CA";
        String conceptNameAK = "Alaska";
        String conceptValueAK = "US-AK";
        String testName = "registryObject_setClassificationsTest";
        String orgName = "TS Default Organization";
        try {
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            ClassificationScheme scheme = this.blm.createClassificationScheme(schemeName, schemeDescription);
            Concept conceptAZ = this.blm.createConcept((RegistryObject)scheme, this.blm.createInternationalString(this.tsLocale, conceptNameAZ), conceptValueAZ);
            Concept conceptCO = this.blm.createConcept((RegistryObject)scheme, this.blm.createInternationalString(this.tsLocale, conceptNameCO), conceptValueCO);
            Concept conceptAK = this.blm.createConcept((RegistryObject)scheme, this.blm.createInternationalString(this.tsLocale, conceptNameAK), conceptValueAK);
            Concept conceptCA = this.blm.createConcept((RegistryObject)scheme, this.blm.createInternationalString(this.tsLocale, conceptNameCA), conceptValueCA);
            Classification clAZ = this.blm.createClassification(conceptAZ);
            Classification clCO = this.blm.createClassification(conceptCO);
            Classification clAK = this.blm.createClassification(conceptAK);
            Classification clCA = this.blm.createClassification(conceptCA);
            ArrayList<Classification> classifications = new ArrayList<Classification>();
            classifications.add(clAZ);
            classifications.add(clCO);
            ArrayList<Classification> newClassifications = new ArrayList<Classification>();
            newClassifications.add(clAK);
            newClassifications.add(clCA);
            org.addClassifications(classifications);
            Collection cls = org.getClassifications();
            this.debug.add("Expect number of Classifications returned from getClassifications to be 2 \n");
            this.debug.add("getClassifications returned: " + cls.size() + "\n");
            if (cls.size() != 2) {
                throw new EETest.Fault(testName + " failed ");
            }
            Iterator iter = cls.iterator();
            Classification cl = null;
            Concept con = null;
            int count = 0;
            while (iter.hasNext()) {
                cl = (Classification)iter.next();
                con = cl.getConcept();
                if (con.getName().getValue(this.tsLocale).equals(conceptNameAZ) && con.getValue().equals(conceptValueAZ)) {
                    this.debug.add("Found: " + con.getName().getValue(this.tsLocale) + " and " + con.getValue() + "\n");
                    ++count;
                }
                if (!con.getName().getValue(this.tsLocale).equals(conceptNameCO) || !con.getValue().equals(conceptValueCO)) continue;
                this.debug.add("Found: " + con.getName().getValue(this.tsLocale) + " and " + con.getValue() + "\n");
                ++count;
            }
            if (count != 2) {
                throw new EETest.Fault(testName + " failed - test did not complete!");
            }
            this.debug.add("Added and verified classifications for Arizona and Colorado\n");
            this.debug.add("Now replace them with classifications for Alaska and California \n");
            org.setClassifications(newClassifications);
            this.debug.add("Verify the replacement\n");
            cls = org.getClassifications();
            this.debug.add("Expect number of Classifications returned from getClassifications to be 2 \n");
            this.debug.add("getClassifications returned: " + cls.size() + "\n");
            if (cls.size() != 2) {
                throw new EETest.Fault(testName + " failed ");
            }
            iter = cls.iterator();
            cl = null;
            con = null;
            count = 0;
            while (iter.hasNext()) {
                cl = (Classification)iter.next();
                con = cl.getConcept();
                if (con.getName().getValue(this.tsLocale).equals(conceptNameAK) && con.getValue().equals(conceptValueAK)) {
                    this.debug.add("Found: " + con.getName().getValue(this.tsLocale) + " and " + con.getValue() + "\n");
                    ++count;
                }
                if (!con.getName().getValue(this.tsLocale).equals(conceptNameCA) || !con.getValue().equals(conceptValueCA)) continue;
                this.debug.add("Found: " + con.getName().getValue(this.tsLocale) + " and " + con.getValue() + "\n");
                ++count;
            }
            if (count != 2) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_addExternalIdentifierTest() throws EETest.Fault {
        String testName = "registryObject_addExternalIdentifierTest";
        String cName = "Social Security";
        String cDescription = "Social Security Numbers";
        String name = "Social Security Number";
        String value = "026-10-5738";
        String orgName = "Test";
        try {
            this.debug.add("Create an organization registryObject \n");
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            this.debug.add("Create an ExternalIdentifier for the registryobject \n");
            ClassificationScheme scheme = this.blm.createClassificationScheme(cName, cDescription);
            InternationalString iName = this.blm.createInternationalString(this.tsLocale, name);
            ExternalIdentifier ei = this.blm.createExternalIdentifier(scheme, iName, value);
            this.debug.add("add the ExternalIdentifier to the organization \n");
            org.addExternalIdentifier(ei);
            this.debug.add("Verify the addition of the ExternalIdentifier \n");
            Collection eis = org.getExternalIdentifiers();
            this.debug.add("getExternalIdentifiers method should return 1 ExternalIdentifier \n");
            this.debug.add("getExternalIdentifiers returned: " + eis.size() + " ExternalIdentifier \n");
            if (eis.size() != 1) {
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("Value expected from external identifier: " + value + "\n");
            for (ExternalIdentifier e : eis) {
                this.debug.add("Value returned from external identifier: " + e.getValue() + "\n");
                if (e.getValue().equals(value)) continue;
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_addExternalIdentifiersTest() throws EETest.Fault {
        String testName = "registryObject_addExternalIdentifiersTest";
        String cName = "Social Security";
        String cDescription = "Social Security Numbers";
        String name = "Social Security Number";
        String[] value = new String[]{"026-10-5738", "032-09-3030", "025-15-2511"};
        String orgName = "Test";
        try {
            int i;
            ArrayList<String> values = new ArrayList<String>();
            this.debug.add("Create an organization registryObject \n");
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            this.debug.add("Create an ExternalIdentifiers for the registryobject \n");
            ClassificationScheme scheme = this.blm.createClassificationScheme(cName, cDescription);
            InternationalString iName = this.blm.createInternationalString(this.tsLocale, name);
            Collection eis = new ArrayList<ExternalIdentifier>();
            for (i = 0; i < value.length; ++i) {
                eis.add(this.blm.createExternalIdentifier(scheme, iName, value[i]));
                values.add(value[i]);
            }
            this.debug.add("add the ExternalIdentifieris to the organization \n");
            org.addExternalIdentifiers(eis);
            this.debug.add("Verify the addition of the ExternalIdentifiers \n");
            eis = null;
            eis = org.getExternalIdentifiers();
            this.debug.add("getExternalIdentifiers method should return " + value.length + " ExternalIdentifiers \n");
            this.debug.add("getExternalIdentifiers returned: " + eis.size() + " ExternalIdentifier \n");
            if (eis.size() != value.length) {
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("Values expected from external identifier: \n");
            for (i = 0; i < value.length; ++i) {
                this.debug.add("          value = " + value[i] + " \n");
            }
            this.debug.add("Values returned from external identifier: \n");
            Iterator iter = eis.iterator();
            int count = 0;
            while (iter.hasNext()) {
                ExternalIdentifier e = (ExternalIdentifier)iter.next();
                this.debug.add("          value = " + e.getValue() + "\n");
                if (!values.contains(e.getValue())) continue;
                ++count;
            }
            if (count != value.length) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_removeExternalIdentifierTest() throws EETest.Fault {
        String testName = "registryObject_removeExternalIdentifierTest";
        String cName = "Social Security";
        String cDescription = "Social Security Numbers";
        String name = "Social Security Number";
        String value = "026-10-5738";
        String orgName = "Test";
        try {
            this.debug.add("Create an organization registryObject \n");
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            this.debug.add("Create an ExternalIdentifier for the registryobject \n");
            ClassificationScheme scheme = this.blm.createClassificationScheme(cName, cDescription);
            InternationalString iName = this.blm.createInternationalString(this.tsLocale, name);
            ExternalIdentifier ei = this.blm.createExternalIdentifier(scheme, iName, value);
            this.debug.add("add the ExternalIdentifier to the organization \n");
            org.addExternalIdentifier(ei);
            this.debug.add("Verify the addition of the ExternalIdentifier \n");
            Collection eis = org.getExternalIdentifiers();
            this.debug.add("getExternalIdentifiers method should return 1 ExternalIdentifier \n");
            this.debug.add("getExternalIdentifiers returned: " + eis.size() + " ExternalIdentifier \n");
            if (eis.size() != 1) {
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("Value expected from external identifier: " + value + "\n");
            ExternalIdentifier e2 = null;
            for (ExternalIdentifier e2 : eis) {
                this.debug.add("Value returned from external identifier: " + e2.getValue() + "\n");
                if (e2.getValue().equals(value)) continue;
                throw new EETest.Fault(testName + " failed - test did not complete!");
            }
            this.debug.add("remove the external identifier from the registryobject\n");
            org.removeExternalIdentifier(e2);
            eis = org.getExternalIdentifiers();
            this.debug.add("getExternalIdentifiers method should return no ExternalIdentifiers \n");
            this.debug.add("getExternalIdentifiers returned: " + eis.size() + " ExternalIdentifiers \n");
            if (eis.size() != 0) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_removeExternalIdentifiersTest() throws EETest.Fault {
        String testName = "registryObject_removeExternalIdentifiersTest";
        String cName = "Social Security";
        String cDescription = "Social Security Numbers";
        String name = "Social Security Number";
        String[] value = new String[]{"026-10-5738", "032-09-3030", "025-15-2511"};
        String orgName = "Test";
        try {
            int i;
            ArrayList<String> values = new ArrayList<String>();
            this.debug.add("Create an organization registryObject \n");
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            this.debug.add("Create an ExternalIdentifiers for the registryobject \n");
            ClassificationScheme scheme = this.blm.createClassificationScheme(cName, cDescription);
            InternationalString iName = this.blm.createInternationalString(this.tsLocale, name);
            Collection eis = new ArrayList<ExternalIdentifier>();
            for (i = 0; i < value.length; ++i) {
                eis.add(this.blm.createExternalIdentifier(scheme, iName, value[i]));
                values.add(value[i]);
            }
            this.debug.add("add the ExternalIdentifieris to the organization \n");
            org.addExternalIdentifiers(eis);
            this.debug.add("Verify the addition of the ExternalIdentifiers \n");
            eis = null;
            eis = org.getExternalIdentifiers();
            this.debug.add("getExternalIdentifiers method should return " + value.length + " ExternalIdentifiers \n");
            this.debug.add("getExternalIdentifiers returned: " + eis.size() + " ExternalIdentifier \n");
            if (eis.size() != value.length) {
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("Values expected from external identifier: \n");
            for (i = 0; i < value.length; ++i) {
                this.debug.add("          value = " + value[i] + " \n");
            }
            this.debug.add("Values returned from external identifier: \n");
            Iterator iter = eis.iterator();
            int count = 0;
            while (iter.hasNext()) {
                ExternalIdentifier e = (ExternalIdentifier)iter.next();
                this.debug.add("          value = " + e.getValue() + "\n");
                if (!values.contains(e.getValue())) continue;
                ++count;
            }
            if (count != value.length) {
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("Added and verified external identifiers - now remove them\n");
            org.removeExternalIdentifiers(eis);
            eis = org.getExternalIdentifiers();
            this.debug.add("getExternalIdentifiers method should return no ExternalIdentifiers \n");
            this.debug.add("getExternalIdentifiers returned: " + eis.size() + " ExternalIdentifiers \n");
            if (eis.size() != 0) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_setExternalIdentifiersTest() throws EETest.Fault {
        String testName = "registryObject_setExternalIdentifiersTest";
        String cName = "Social Security";
        String cDescription = "Social Security Numbers";
        String name = "Social Security Number";
        String[] value = new String[]{"026-10-5738", "032-09-3030", "025-15-2511"};
        String[] newValue = new String[]{"029-10-5744", "030-09-3930", "028-15-2211", "020-19-2299"};
        String orgName = "Test";
        try {
            int i;
            ArrayList<String> values = new ArrayList<String>();
            ArrayList<String> newValues = new ArrayList<String>();
            this.debug.add("Create an organization registryObject \n");
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            this.debug.add("Create ExternalIdentifiers for the registryobject \n");
            ClassificationScheme scheme = this.blm.createClassificationScheme(cName, cDescription);
            InternationalString iName = this.blm.createInternationalString(this.tsLocale, name);
            Collection eis = new ArrayList<ExternalIdentifier>();
            for (int i2 = 0; i2 < value.length; ++i2) {
                eis.add(this.blm.createExternalIdentifier(scheme, iName, value[i2]));
                values.add(value[i2]);
            }
            ArrayList<ExternalIdentifier> newEis = new ArrayList<ExternalIdentifier>();
            for (i = 0; i < newValue.length; ++i) {
                newEis.add(this.blm.createExternalIdentifier(scheme, iName, newValue[i]));
                newValues.add(newValue[i]);
            }
            this.debug.add("add the ExternalIdentifieris to the organization \n");
            org.addExternalIdentifiers(eis);
            this.debug.add("Verify the addition of the ExternalIdentifiers \n");
            eis = null;
            eis = org.getExternalIdentifiers();
            this.debug.add("getExternalIdentifiers method should return " + value.length + " ExternalIdentifiers \n");
            this.debug.add("getExternalIdentifiers returned: " + eis.size() + " ExternalIdentifier \n");
            if (eis.size() != value.length) {
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("Values expected from external identifier: \n");
            for (i = 0; i < value.length; ++i) {
                this.debug.add("          value = " + value[i] + " \n");
            }
            this.debug.add("Values returned from external identifier: \n");
            Iterator iter = eis.iterator();
            int count = 0;
            while (iter.hasNext()) {
                ExternalIdentifier e = (ExternalIdentifier)iter.next();
                this.debug.add("          value = " + e.getValue() + "\n");
                if (!values.contains(e.getValue())) continue;
                ++count;
            }
            if (count != value.length) {
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("Added and verified external identifiers - now replace them\n");
            org.setExternalIdentifiers(newEis);
            eis = org.getExternalIdentifiers();
            this.debug.add("getExternalIdentifiers method should now return " + newValue.length + " ExternalIdentifiers \n");
            this.debug.add("getExternalIdentifiers returned: " + eis.size() + " ExternalIdentifiers \n");
            if (eis.size() != newValue.length) {
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("New external identifier values are:  \n");
            for (int i3 = 0; i3 < newValue.length; ++i3) {
                this.debug.add("          new value = " + newValue[i3] + " \n");
            }
            this.debug.add("Verify the replacement\n");
            iter = eis.iterator();
            count = 0;
            while (iter.hasNext()) {
                ExternalIdentifier e = (ExternalIdentifier)iter.next();
                this.debug.add("          value = " + e.getValue() + "\n");
                if (!newValues.contains(e.getValue())) continue;
                ++count;
            }
            if (count != newValue.length) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_addExternalLinkTest() throws EETest.Fault {
        String testName = "registryObject_addExternalLinkTest";
        String orgName = "TS Default Organization";
        String externalURI = this.baseuri + "jaxrTestPage1.html";
        String description = "JAXR Test Page";
        try {
            this.debug.add("Create an external link \n");
            ExternalLink el = this.blm.createExternalLink(externalURI, description);
            this.debug.add("Create an organization registryObject \n");
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            this.debug.add("add the external link to the organization \n");
            org.addExternalLink(el);
            this.debug.add("Verify the addition of the external link \n");
            Collection els = org.getExternalLinks();
            this.debug.add("getExternalLinks method should return 1 ExternalLink \n");
            this.debug.add("getExternalLinks returned: " + els.size() + " ExternalLink \n");
            if (els.size() != 1) {
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("URI expected from external link: " + externalURI + "\n");
            for (ExternalLink e : els) {
                this.debug.add("URI returned from external link: " + e.getExternalURI() + "\n");
                if (e.getExternalURI().equals(externalURI)) continue;
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_addExternalLinksTest() throws EETest.Fault {
        String testName = "registryObject_addExternalLinksTest";
        String orgName = "TS Default Organization";
        String description = "home page";
        String[] link = new String[]{this.baseuri + "jaxrTestPage1.html", this.baseuri + "jaxrTestPage2.html", this.baseuri + "jaxrTestPage3.html"};
        try {
            ArrayList<String> links = new ArrayList<String>();
            Collection els = new ArrayList<ExternalLink>();
            this.debug.add("Create an external link \n");
            for (int i = 0; i < link.length; ++i) {
                els.add(this.blm.createExternalLink(link[i], description));
                links.add(link[i]);
            }
            this.debug.add("Create an organization registryObject \n");
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            this.debug.add("add the external links to the organization \n");
            org.addExternalLinks(els);
            this.debug.add("Verify the addition of the external links \n");
            els = org.getExternalLinks();
            this.debug.add("getExternalLinks method should return " + link.length + " ExternalLinks \n");
            this.debug.add("getExternalLinks returned: " + els.size() + " ExternalLinks \n");
            if (els.size() != link.length) {
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("Expecting the following links from the registryobject\n");
            for (int i = 0; i < link.length; ++i) {
                this.debug.add("          link: " + link[i] + "\n");
            }
            Iterator iter = els.iterator();
            int count = 0;
            while (iter.hasNext()) {
                ExternalLink e = (ExternalLink)iter.next();
                this.debug.add("found link: " + e.getExternalURI() + "\n");
                if (!links.contains(e.getExternalURI())) continue;
                ++count;
            }
            if (count != link.length) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_removeExternalLinkTest() throws EETest.Fault {
        String testName = "registryObject_removeExternalLinkTest";
        String orgName = "TS Default Organization";
        String externalURI = this.baseuri + "jaxrTestPage1.html";
        String description = "JavaSoft home page";
        try {
            this.debug.add("Create an external link \n");
            ExternalLink el = this.blm.createExternalLink(externalURI, description);
            this.debug.add("Create an organization registryObject \n");
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            this.debug.add("add the external link to the organization \n");
            org.addExternalLink(el);
            this.debug.add("Verify the addition of the external link \n");
            Collection els = org.getExternalLinks();
            this.debug.add("getExternalLinks method should return 1 ExternalLink \n");
            this.debug.add("getExternalLinks returned: " + els.size() + " ExternalLink \n");
            if (els.size() != 1) {
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("URI expected from external link: " + externalURI + "\n");
            Iterator iter = els.iterator();
            ExternalLink e = null;
            while (iter.hasNext()) {
                e = (ExternalLink)iter.next();
                this.debug.add("URI returned from external link: " + e.getExternalURI() + "\n");
                if (e.getExternalURI().equals(externalURI)) continue;
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("Added and verified external link, now remove it \n");
            org.removeExternalLink(e);
            els = org.getExternalLinks();
            this.debug.add("Link removed.  Link count should be 0 \n");
            this.debug.add("Link count is " + els.size() + "\n");
            if (els.size() != 0) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_removeExternalLinksTest() throws EETest.Fault {
        String testName = "registryObject_removeExternalLinksTest";
        String orgName = "TS Default Organization";
        String description = "home page";
        String[] link = new String[]{this.baseuri + "jaxrTestPage1.html", this.baseuri + "jaxrTestPage2.html", this.baseuri + "jaxrTestPage3.html"};
        try {
            ArrayList<String> links = new ArrayList<String>();
            Collection els = new ArrayList<ExternalLink>();
            this.debug.add("Create an external link \n");
            for (int i = 0; i < link.length; ++i) {
                els.add(this.blm.createExternalLink(link[i], description));
                links.add(link[i]);
            }
            this.debug.add("Create an organization registryObject \n");
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            this.debug.add("add the external links to the organization \n");
            org.addExternalLinks(els);
            this.debug.add("Verify the addition of the external links \n");
            els = org.getExternalLinks();
            this.debug.add("getExternalLinks method should return " + link.length + " ExternalLinks \n");
            this.debug.add("getExternalLinks returned: " + els.size() + " ExternalLinks \n");
            if (els.size() != link.length) {
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("Expecting the following links from the registryobject\n");
            for (int i = 0; i < link.length; ++i) {
                this.debug.add("          link: " + link[i] + "\n");
            }
            Iterator iter = els.iterator();
            int count = 0;
            while (iter.hasNext()) {
                ExternalLink e = (ExternalLink)iter.next();
                this.debug.add("found link: " + e.getExternalURI() + "\n");
                if (!links.contains(e.getExternalURI())) continue;
                ++count;
            }
            if (count != link.length) {
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("Added and verified links.  Now remove them \n");
            org.removeExternalLinks(els);
            this.debug.add("Removed the links.  Number of links should be 0 \n");
            els = org.getExternalLinks();
            this.debug.add("getExternal links returns: " + els.size() + "\n");
            if (els.size() != 0) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_setExternalLinksTest() throws EETest.Fault {
        String testName = "registryObject_setExternalLinksTest";
        String orgName = "TS Default Organization";
        String description = "home page";
        String[] link = new String[]{this.baseuri + "jaxrTestPage1.html"};
        String[] newLink = new String[]{this.baseuri + "jaxrTestPage2.html", this.baseuri + "jaxrTestPage3.html"};
        try {
            int i;
            ArrayList<String> links = new ArrayList<String>();
            ArrayList<String> newLinks = new ArrayList<String>();
            Collection els = new ArrayList<ExternalLink>();
            ArrayList<ExternalLink> newEls = new ArrayList<ExternalLink>();
            this.debug.add("Create a external links \n");
            for (i = 0; i < link.length; ++i) {
                els.add(this.blm.createExternalLink(link[i], description));
                links.add(link[i]);
            }
            for (i = 0; i < newLink.length; ++i) {
                newEls.add(this.blm.createExternalLink(newLink[i], description));
                newLinks.add(newLink[i]);
            }
            this.debug.add("Create an organization registryObject \n");
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(orgName));
            this.debug.add("add the external links to the organization \n");
            org.addExternalLinks(els);
            this.debug.add("Verify the addition of the external links \n");
            els = org.getExternalLinks();
            this.debug.add("getExternalLinks method should return " + link.length + " ExternalLinks \n");
            this.debug.add("getExternalLinks returned: " + els.size() + " ExternalLinks \n");
            if (els.size() != link.length) {
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("Expecting the following links from the registryobject\n");
            for (int i2 = 0; i2 < link.length; ++i2) {
                this.debug.add("          link: " + link[i2] + "\n");
            }
            Iterator iter = els.iterator();
            int count = 0;
            while (iter.hasNext()) {
                ExternalLink e = (ExternalLink)iter.next();
                this.debug.add("found link: " + e.getExternalURI() + "\n");
                if (!links.contains(e.getExternalURI())) continue;
                ++count;
            }
            if (count != link.length) {
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("Added and verified links.  Now replace them with the setExternalLinksTest method.\n");
            org.setExternalLinks(newEls);
            this.debug.add("Replaced the links.  Number of links should now be " + newLink.length + "\n");
            els = org.getExternalLinks();
            this.debug.add("getExternal links returns: " + els.size() + "\n");
            this.debug.add("Now check the replacements \n");
            this.debug.add("Expecting the following links from the registryobject\n");
            for (int i3 = 0; i3 < newLink.length; ++i3) {
                this.debug.add("          link: " + newLink[i3] + "\n");
            }
            iter = els.iterator();
            count = 0;
            while (iter.hasNext()) {
                ExternalLink e = (ExternalLink)iter.next();
                this.debug.add("found link: " + e.getExternalURI() + "\n");
                if (!newLinks.contains(e.getExternalURI())) continue;
                ++count;
            }
            if (count != newLink.length) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_addAssociationTest() throws EETest.Fault {
        String testName = "registryObject_addAssociationTest";
        String orgName = "TS Default Organization";
        String orgSourceName = "ThisIsTheSourceOrganization";
        try {
            Organization target = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            Organization source = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgSourceName));
            Concept associationType = this.bqm.findConceptByPath("/AssociationType/Implements");
            Association a = this.blm.createAssociation((RegistryObject)target, associationType);
            source.addAssociation(a);
            Organization o = (Organization)a.getSourceObject();
            this.debug.add("source object returned is " + o.getName().getValue(this.tsLocale));
            if (!o.getName().getValue(this.tsLocale).equals(source.getName().getValue(this.tsLocale))) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_addAssociationsTest() throws EETest.Fault {
        String testName = "registryObject_addAssociationsTest";
        String orgSourceName = "ThisIsTheSourceOrganization";
        String orgTargetName = "ThisIsTargetOrganization_0";
        int count = 5;
        try {
            ArrayList<Organization> targets = new ArrayList<Organization>();
            for (int i = 0; i < count; ++i) {
                targets.add(this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgTargetName + i)));
            }
            Organization source = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgSourceName));
            Concept associationType = this.bqm.findConceptByPath("/AssociationType/EquivalentTo");
            ArrayList<Association> as = new ArrayList<Association>();
            Iterator iter = targets.iterator();
            while (iter.hasNext()) {
                as.add(this.blm.createAssociation((RegistryObject)((Organization)iter.next()), associationType));
            }
            source.addAssociations(as);
            iter = as.iterator();
            Organization o = null;
            Association a = null;
            while (iter.hasNext()) {
                a = (Association)iter.next();
                o = (Organization)a.getSourceObject();
                this.debug.add("Found " + o.getName().getValue(this.tsLocale) + "\n");
                if (!o.getName().getValue(this.tsLocale).equals(source.getName().getValue(this.tsLocale))) {
                    throw new EETest.Fault(testName + " failed ");
                }
                this.debug.add("And the target is: " + ((Organization)a.getTargetObject()).getName().getValue(this.tsLocale) + "\n");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_removeAssociationTest() throws EETest.Fault {
        String testName = "registryObject_removeAssociationTest";
        String orgTargetName = "ThisIsTheTargetOrganization";
        String orgSourceName = "ThisIsTheSourceOrganization";
        try {
            Organization target = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgTargetName));
            Organization source = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgSourceName));
            Concept associationType = this.bqm.findConceptByPath("/AssociationType/SubmitterOf");
            Association a = this.blm.createAssociation((RegistryObject)target, associationType);
            source.addAssociation(a);
            Organization o = (Organization)a.getSourceObject();
            this.debug.add("source object returned is " + o.getName().getValue(this.tsLocale) + "\n");
            if (!o.getName().getValue(this.tsLocale).equals(source.getName().getValue(this.tsLocale))) {
                this.debug.add("Error: source organization not returned as expected \n");
                throw new EETest.Fault(testName + " test did not complete!");
            }
            this.debug.add("good source object returned \n");
            source.removeAssociation(a);
            Collection associations = source.getAssociations();
            if (associations.contains(a)) {
                this.debug.add("Error: expected my association to be removed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add("Association was removed - good!\n");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_removeAssociationsTest() throws EETest.Fault {
        String testName = "registryObject_removeAssociationsTest";
        String orgSourceName = "ThisIsTheSourceOrganization";
        String orgTargetName = "ThisIsTargetOrganization_0";
        int count = 10;
        try {
            ArrayList<Organization> targets = new ArrayList<Organization>();
            for (int i = 0; i < count; ++i) {
                targets.add(this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgTargetName + i)));
            }
            Organization source = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgSourceName));
            Concept associationType = this.bqm.findConceptByPath("/AssociationType/ResponsibleFor");
            ArrayList<Association> as = new ArrayList<Association>();
            for (Object e : targets) {
                if (!(e instanceof Organization)) continue;
                Organization o = (Organization)e;
                as.add(this.blm.createAssociation((RegistryObject)o, associationType));
            }
            source.addAssociations(as);
            Iterator iter = as.iterator();
            Object var10_13 = null;
            Association a = null;
            while (iter.hasNext()) {
                a = (Association)iter.next();
                Organization organization = (Organization)a.getSourceObject();
                this.debug.add("Found " + organization.getName().getValue(this.tsLocale) + "\n");
                if (!organization.getName().getValue(this.tsLocale).equals(source.getName().getValue(this.tsLocale))) {
                    throw new EETest.Fault(testName + "Error: source not as expected.  test did not complete!");
                }
                this.debug.add("And the target is: " + ((Organization)a.getTargetObject()).getName().getValue(this.tsLocale) + "\n");
            }
            source.removeAssociations(as);
            Collection associations = source.getAssociations();
            for (Object obj : associations) {
                if (!(obj instanceof Association) || !as.contains(a = (Association)obj)) continue;
                this.debug.add("Found one of the removed associations");
                throw new EETest.Fault(testName + " Error: removeAssociations did not remove all of the assocations !");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObject_getSetAssociationsTest() throws EETest.Fault {
        String testName = "registryObject_getSetAssociationsTest";
        String orgSourceName = "ThisIsTheSourceOrganization";
        String orgTargetName = "ThisIsTargetOrganization_0";
        int count = 10;
        boolean pass = true;
        try {
            ArrayList<Organization> targets = new ArrayList<Organization>();
            for (int i = 0; i < count; ++i) {
                targets.add(this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgTargetName + i)));
            }
            ArrayList<Organization> replacementTargets = new ArrayList<Organization>();
            for (int i = count + 1; i < count + 11; ++i) {
                replacementTargets.add(this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgTargetName + i)));
            }
            Organization source = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgSourceName));
            Concept associationType = this.bqm.findConceptByPath("/AssociationType/Supersedes");
            ArrayList<Association> as = new ArrayList<Association>();
            Iterator iter = targets.iterator();
            while (iter.hasNext()) {
                as.add(this.blm.createAssociation((RegistryObject)((Organization)iter.next()), associationType));
            }
            source.addAssociations(as);
            ArrayList<Association> replacementAssociations = new ArrayList<Association>();
            iter = replacementTargets.iterator();
            while (iter.hasNext()) {
                replacementAssociations.add(this.blm.createAssociation((RegistryObject)((Organization)iter.next()), associationType));
            }
            source.setAssociations(replacementAssociations);
            Collection currentAssociations = source.getAssociations();
            if (currentAssociations.size() != count) {
                pass = false;
            }
            this.debug.add("Expecting " + count + " associations to be returned  \n");
            this.debug.add("Number of associations returned is " + currentAssociations.size() + "\n");
            if (currentAssociations.containsAll(replacementAssociations)) {
                this.debug.add("good! getAssociations returned all of the expected associations!\n");
            } else {
                this.debug.add("Error! getAssociations did not return all of the expected associations!\n");
                iter = currentAssociations.iterator();
                Object o = null;
                Association a2 = null;
                this.debug.add("Replacement Associations returned.....................\n");
                while (iter.hasNext()) {
                    a2 = (Association)iter.next();
                    this.debug.add("Target: " + ((Organization)a2.getTargetObject()).getName().getValue() + "\n");
                }
                this.debug.add("Replacement Associations expected.....................\n");
                for (Association a2 : replacementAssociations) {
                    this.debug.add("Target: " + ((Organization)a2.getTargetObject()).getName().getValue(this.tsLocale) + "\n");
                }
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }
}

