/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.customizedmapping.propertynames;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.customizedmapping.propertynames.model.DuplicateNameContainer;
import com.sun.ts.tests.jsonb.customizedmapping.propertynames.model.PropertyNameCustomizationAccessorsContainer;
import com.sun.ts.tests.jsonb.customizedmapping.propertynames.model.PropertyNameCustomizationContainer;
import com.sun.ts.tests.jsonb.customizedmapping.propertynames.model.StringContainer;
import com.sun.ts.tests.jsonb.customizedmapping.propertynames.model.TransientAnnotatedPropertyContainer;
import com.sun.ts.tests.jsonb.customizedmapping.propertynames.model.TransientGetterAnnotatedPropertyContainer;
import com.sun.ts.tests.jsonb.customizedmapping.propertynames.model.TransientGetterPlusCustomizationAnnotatedFieldContainer;
import com.sun.ts.tests.jsonb.customizedmapping.propertynames.model.TransientGetterPlusCustomizationAnnotatedGetterContainer;
import com.sun.ts.tests.jsonb.customizedmapping.propertynames.model.TransientPlusCustomizationAnnotatedGetterContainer;
import com.sun.ts.tests.jsonb.customizedmapping.propertynames.model.TransientPlusCustomizationAnnotatedPropertyContainer;
import com.sun.ts.tests.jsonb.customizedmapping.propertynames.model.TransientPlusCustomizationAnnotatedSetterContainer;
import com.sun.ts.tests.jsonb.customizedmapping.propertynames.model.TransientPropertyContainer;
import com.sun.ts.tests.jsonb.customizedmapping.propertynames.model.TransientSetterAnnotatedPropertyContainer;
import com.sun.ts.tests.jsonb.customizedmapping.propertynames.model.TransientSetterPlusCustomizationAnnotatedFieldContainer;
import com.sun.ts.tests.jsonb.customizedmapping.propertynames.model.TransientSetterPlusCustomizationAnnotatedSetterContainer;
import java.util.Properties;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.bind.JsonbException;

public class PropertyNameCustomizationTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;
    private final Jsonb jsonb = JsonbBuilder.create();

    public static void main(String[] args) {
        PropertyNameCustomizationTest t = new PropertyNameCustomizationTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testTransientField() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new TransientPropertyContainer(){
            {
                this.setInstance("String Value");
            }
        });
        if (!jsonString.matches("\\{\\s*\\}")) {
            throw new EETest.Fault("Failed to ignore transient property during marshalling.");
        }
        TransientPropertyContainer unmarshalledObject = (TransientPropertyContainer)this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", TransientPropertyContainer.class);
        if (unmarshalledObject.getInstance() != null) {
            throw new EETest.Fault("Failed to ignore transient property during unmarshalling.");
        }
        return Status.passed((String)"OK");
    }

    public Status testTransientAnnotatedField() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new TransientAnnotatedPropertyContainer(){
            {
                this.setInstance("String Value");
            }
        });
        if (!jsonString.matches("\\{\\s*\\}")) {
            throw new EETest.Fault("Failed to ignore JsonbTransient property during marshalling.");
        }
        TransientAnnotatedPropertyContainer unmarshalledObject = (TransientAnnotatedPropertyContainer)this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", TransientAnnotatedPropertyContainer.class);
        if (unmarshalledObject.getInstance() != null) {
            throw new EETest.Fault("Failed to ignore JsonbTransient property during unmarshalling.");
        }
        return Status.passed((String)"OK");
    }

    public void testTransientAnnotatedGetter() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new TransientGetterAnnotatedPropertyContainer(){
            {
                this.setInstance("String Value");
            }
        });
        if (!jsonString.matches("\\{\\s*\\}")) {
            throw new EETest.Fault("Failed to ignore @JsonbTransient on getter during marshalling.");
        }
    }

    public void testTransientAnnotatedSetter() throws EETest.Fault {
        TransientSetterAnnotatedPropertyContainer unmarshalledObject = (TransientSetterAnnotatedPropertyContainer)this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", TransientSetterAnnotatedPropertyContainer.class);
        if (unmarshalledObject.getInstance() != null) {
            throw new EETest.Fault("Failed to ignore @JsonbTransient on setter during unmarshalling.");
        }
    }

    public Status testTransientPlusCustomizationAnnotatedField() throws EETest.Fault {
        try {
            this.jsonb.toJson((Object)new TransientPlusCustomizationAnnotatedPropertyContainer());
            throw new EETest.Fault("JsonbException not thrown for property annotated with both JsonbTransient and other Jsonb customization annotation.");
        }
        catch (Exception x) {
            if (!JsonbException.class.isAssignableFrom(x.getClass())) {
                throw new EETest.Fault("JsonbException expected for property annotated with both JsonbTransient and other Jsonb customization annotation.");
            }
            try {
                this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", TransientPlusCustomizationAnnotatedPropertyContainer.class);
                throw new EETest.Fault("JsonbException not thrown for property annotated with both JsonbTransient and other Jsonb customization annotation.");
            }
            catch (Exception x2) {
                if (!JsonbException.class.isAssignableFrom(x2.getClass())) {
                    throw new EETest.Fault("JsonbException expected for property annotated with both JsonbTransient and other Jsonb customization annotation.");
                }
                return Status.passed((String)"OK");
            }
        }
    }

    public void testTransientPlusCustomizationAnnotatedGetter() throws EETest.Fault {
        try {
            this.jsonb.toJson((Object)new TransientPlusCustomizationAnnotatedGetterContainer());
            throw new EETest.Fault("JsonbException not thrown for property annotated with JsonbTransient and getter with other Jsonb customization annotation.");
        }
        catch (Exception x) {
            if (!JsonbException.class.isAssignableFrom(x.getClass())) {
                throw new EETest.Fault("JsonbException expected for property annotated with JsonbTransient and getter with other Jsonb customization annotation.");
            }
            try {
                this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", TransientPlusCustomizationAnnotatedGetterContainer.class);
                throw new EETest.Fault("JsonbException not thrown for property annotated with JsonbTransient and getter with other Jsonb customization annotation.");
            }
            catch (Exception x2) {
                if (!JsonbException.class.isAssignableFrom(x2.getClass())) {
                    throw new EETest.Fault("JsonbException expected for property annotated with JsonbTransient and getter with other Jsonb customization annotation.");
                }
                return;
            }
        }
    }

    public void testTransientPlusCustomizationAnnotatedSetter() throws EETest.Fault {
        try {
            this.jsonb.toJson((Object)new TransientPlusCustomizationAnnotatedSetterContainer());
            throw new EETest.Fault("JsonbException not thrown for property annotated with JsonbTransient and setter with other Jsonb customization annotation.");
        }
        catch (Exception x) {
            if (!JsonbException.class.isAssignableFrom(x.getClass())) {
                throw new EETest.Fault("JsonbException expected for property annotated with JsonbTransient and setter with other Jsonb customization annotation.");
            }
            try {
                this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", TransientPlusCustomizationAnnotatedSetterContainer.class);
                throw new EETest.Fault("JsonbException not thrown for property annotated with JsonbTransient and setter with other Jsonb customization annotation.");
            }
            catch (Exception x2) {
                if (!JsonbException.class.isAssignableFrom(x2.getClass())) {
                    throw new EETest.Fault("JsonbException expected for property annotated with JsonbTransient and setter with other Jsonb customization annotation.");
                }
                return;
            }
        }
    }

    public void testTransientGetterPlusCustomizationAnnotatedField() throws EETest.Fault {
        try {
            this.jsonb.toJson((Object)new TransientGetterPlusCustomizationAnnotatedFieldContainer());
            throw new EETest.Fault("JsonbException not thrown for getter annotated with JsonbTransient and property with other Jsonb customization annotation.");
        }
        catch (Exception x) {
            if (!JsonbException.class.isAssignableFrom(x.getClass())) {
                throw new EETest.Fault("JsonbException expected for getter annotated with JsonbTransient and property with other Jsonb customization annotation.");
            }
            try {
                this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", TransientGetterPlusCustomizationAnnotatedFieldContainer.class);
                throw new EETest.Fault("JsonbException not thrown for getter annotated with JsonbTransient and property with other Jsonb customization annotation.");
            }
            catch (Exception x2) {
                if (!JsonbException.class.isAssignableFrom(x2.getClass())) {
                    throw new EETest.Fault("JsonbException expected for getter annotated with JsonbTransient and property with other Jsonb customization annotation.");
                }
                return;
            }
        }
    }

    public void testTransientGetterPlusCustomizationAnnotatedGetter() throws EETest.Fault {
        try {
            this.jsonb.toJson((Object)new TransientGetterPlusCustomizationAnnotatedGetterContainer());
            throw new EETest.Fault("JsonbException not thrown for property annotated with JsonbTransient and getter with other Jsonb customization annotation.");
        }
        catch (Exception x) {
            if (!JsonbException.class.isAssignableFrom(x.getClass())) {
                throw new EETest.Fault("JsonbException expected for property annotated with JsonbTransient and getter with other Jsonb customization annotation.");
            }
            try {
                this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", TransientGetterPlusCustomizationAnnotatedGetterContainer.class);
                throw new EETest.Fault("JsonbException not thrown for property annotated with JsonbTransient and getter with other Jsonb customization annotation.");
            }
            catch (Exception x2) {
                if (!JsonbException.class.isAssignableFrom(x2.getClass())) {
                    throw new EETest.Fault("JsonbException expected for property annotated with JsonbTransient and getter with other Jsonb customization annotation.");
                }
                return;
            }
        }
    }

    public void testTransientSetterPlusCustomizationAnnotatedSetter() throws EETest.Fault {
        try {
            this.jsonb.toJson((Object)new TransientSetterPlusCustomizationAnnotatedSetterContainer());
            throw new EETest.Fault("JsonbException not thrown for property annotated with JsonbTransient and setter with other Jsonb customization annotation.");
        }
        catch (Exception x) {
            if (!JsonbException.class.isAssignableFrom(x.getClass())) {
                throw new EETest.Fault("JsonbException expected for property annotated with JsonbTransient and setter with other Jsonb customization annotation.");
            }
            try {
                this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", TransientSetterPlusCustomizationAnnotatedSetterContainer.class);
                throw new EETest.Fault("JsonbException not thrown for property annotated with JsonbTransient and setter with other Jsonb customization annotation.");
            }
            catch (Exception x2) {
                if (!JsonbException.class.isAssignableFrom(x2.getClass())) {
                    throw new EETest.Fault("JsonbException expected for property annotated with JsonbTransient and setter with other Jsonb customization annotation.");
                }
                return;
            }
        }
    }

    public void testTransientSetterPlusCustomizationAnnotatedField() throws EETest.Fault {
        try {
            this.jsonb.toJson((Object)new TransientSetterPlusCustomizationAnnotatedFieldContainer());
            throw new EETest.Fault("JsonbException not thrown for setter annotated with JsonbTransient and property with other Jsonb customization annotation.");
        }
        catch (Exception x) {
            if (!JsonbException.class.isAssignableFrom(x.getClass())) {
                throw new EETest.Fault("JsonbException expected for setter annotated with JsonbTransient and property with other Jsonb customization annotation.");
            }
            try {
                this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", TransientSetterPlusCustomizationAnnotatedFieldContainer.class);
                throw new EETest.Fault("JsonbException not thrown for setter annotated with JsonbTransient and property with other Jsonb customization annotation.");
            }
            catch (Exception x2) {
                if (!JsonbException.class.isAssignableFrom(x2.getClass())) {
                    throw new EETest.Fault("JsonbException expected for setter annotated with JsonbTransient and property with other Jsonb customization annotation.");
                }
                return;
            }
        }
    }

    public Status testPropertyNameCustomization() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new PropertyNameCustomizationContainer(){
            {
                this.setInstance("Test String");
            }
        });
        if (!jsonString.matches("\\{\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to customize property name during marshalling using JsonbProperty annotation.");
        }
        PropertyNameCustomizationContainer unmarshalledObject = (PropertyNameCustomizationContainer)this.jsonb.fromJson("{ \"stringInstance\" : \"Test String\" }", PropertyNameCustomizationContainer.class);
        if (!"Test String".equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to customize property name during unmarshalling using JsonbProperty annotation.");
        }
        return Status.passed((String)"OK");
    }

    public Status testPropertyNameCustomizationAccessors() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new PropertyNameCustomizationAccessorsContainer(){
            {
                this.setInstance("Test String");
            }
        });
        if (!jsonString.matches("\\{\\s*\"getterInstance\"\\s*\\:\\s*\"Test String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to customize property name during marshalling using JsonbProperty annotation on getter.");
        }
        PropertyNameCustomizationAccessorsContainer unmarshalledObject = (PropertyNameCustomizationAccessorsContainer)this.jsonb.fromJson("{ \"setterInstance\" : \"Test String\" }", PropertyNameCustomizationAccessorsContainer.class);
        if (!"Test String".equals(unmarshalledObject.getInstance())) {
            throw new EETest.Fault("Failed to customize property name during unmarshalling using JsonbProperty annotation on setter.");
        }
        return Status.passed((String)"OK");
    }

    public Status testIdentityPropertyNamingStrategy() throws EETest.Fault {
        JsonbConfig config = new JsonbConfig();
        config.setProperty("jsonb.property-naming-strategy", (Object)"IDENTITY");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new StringContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        if (!jsonString.matches("\\{\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly marshal property using PropertyNamingStrategy.IDENTITY.");
        }
        StringContainer unmarshalledObject = (StringContainer)jsonb.fromJson("{ \"stringInstance\" : \"Test String\" }", StringContainer.class);
        if (!"Test String".equals(unmarshalledObject.getStringInstance())) {
            throw new EETest.Fault("Failed to correctly unmarshal property using PropertyNamingStrategy.IDENTITY.");
        }
        return Status.passed((String)"OK");
    }

    public Status testLowerCaseWithDashesPropertyNamingStrategy() throws EETest.Fault {
        JsonbConfig config = new JsonbConfig();
        config.setProperty("jsonb.property-naming-strategy", (Object)"LOWER_CASE_WITH_DASHES");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new StringContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        if (!jsonString.matches("\\{\\s*\"string-instance\"\\s*\\:\\s*\"Test String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly marshal property using PropertyNamingStrategy.LOWER_CASE_WITH_DASHES.");
        }
        StringContainer unmarshalledObject = (StringContainer)jsonb.fromJson("{ \"string-instance\" : \"Test String\" }", StringContainer.class);
        if (!"Test String".equals(unmarshalledObject.getStringInstance())) {
            throw new EETest.Fault("Failed to correctly unmarshal property using PropertyNamingStrategy.LOWER_CASE_WITH_DASHES.");
        }
        return Status.passed((String)"OK");
    }

    public Status testLowerCaseWithUnderscoresPropertyNamingStrategy() throws EETest.Fault {
        JsonbConfig config = new JsonbConfig();
        config.setProperty("jsonb.property-naming-strategy", (Object)"LOWER_CASE_WITH_UNDERSCORES");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new StringContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        if (!jsonString.matches("\\{\\s*\"string_instance\"\\s*\\:\\s*\"Test String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly marshal property using PropertyNamingStrategy.LOWER_CASE_WITH_UNDERSCORES.");
        }
        StringContainer unmarshalledObject = (StringContainer)jsonb.fromJson("{ \"string_instance\" : \"Test String\" }", StringContainer.class);
        if (!"Test String".equals(unmarshalledObject.getStringInstance())) {
            throw new EETest.Fault("Failed to correctly unmarshal property using PropertyNamingStrategy.LOWER_CASE_WITH_UNDERSCORES.");
        }
        return Status.passed((String)"OK");
    }

    public Status testUpperCamelCasePropertyNamingStrategy() throws EETest.Fault {
        JsonbConfig config = new JsonbConfig();
        config.setProperty("jsonb.property-naming-strategy", (Object)"UPPER_CAMEL_CASE");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new StringContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        if (!jsonString.matches("\\{\\s*\"StringInstance\"\\s*\\:\\s*\"Test String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly marshal property using PropertyNamingStrategy.UPPER_CAMEL_CASE.");
        }
        StringContainer unmarshalledObject = (StringContainer)jsonb.fromJson("{ \"StringInstance\" : \"Test String\" }", StringContainer.class);
        if (!"Test String".equals(unmarshalledObject.getStringInstance())) {
            throw new EETest.Fault("Failed to correctly unmarshal property using PropertyNamingStrategy.UPPER_CAMEL_CASE.");
        }
        return Status.passed((String)"OK");
    }

    public Status testUpperCamelCaseWithSpacesPropertyNamingStrategy() throws EETest.Fault {
        JsonbConfig config = new JsonbConfig();
        config.setProperty("jsonb.property-naming-strategy", (Object)"UPPER_CAMEL_CASE_WITH_SPACES");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new StringContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        if (!jsonString.matches("\\{\\s*\"String Instance\"\\s*\\:\\s*\"Test String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly marshal property using PropertyNamingStrategy.UPPER_CAMEL_CASE_WITH_SPACES.");
        }
        StringContainer unmarshalledObject = (StringContainer)jsonb.fromJson("{ \"String Instance\" : \"Test String\" }", StringContainer.class);
        if (!"Test String".equals(unmarshalledObject.getStringInstance())) {
            throw new EETest.Fault("Failed to correctly unmarshal property using PropertyNamingStrategy.UPPER_CAMEL_CASE_WITH_SPACES.");
        }
        return Status.passed((String)"OK");
    }

    public Status testCaseInsensitivePropertyNamingStrategy() throws EETest.Fault {
        JsonbConfig config = new JsonbConfig();
        config.setProperty("jsonb.property-naming-strategy", (Object)"CASE_INSENSITIVE");
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)config);
        String jsonString = jsonb.toJson((Object)new StringContainer(){
            {
                this.setStringInstance("Test String");
            }
        });
        if (!jsonString.matches("\\{\\s*\"stringInstance\"\\s*\\:\\s*\"Test String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly marshal property using PropertyNamingStrategy.CASE_INSENSITIVE.");
        }
        StringContainer unmarshalledObject = (StringContainer)jsonb.fromJson("{ \"stringInstance\" : \"Test String\" }", StringContainer.class);
        if (!"Test String".equals(unmarshalledObject.getStringInstance())) {
            throw new EETest.Fault("Failed to correctly unmarshal property using PropertyNamingStrategy.CASE_INSENSITIVE.");
        }
        return Status.passed((String)"OK");
    }

    public Status testDuplicateName() throws EETest.Fault {
        try {
            this.jsonb.toJson((Object)new DuplicateNameContainer());
            throw new EETest.Fault("JsonbException not thrown for property name duplication as a result of property name customization.");
        }
        catch (Exception x) {
            if (!JsonbException.class.isAssignableFrom(x.getClass())) {
                throw new EETest.Fault("JsonbException expected for property name duplication as a result of property name customization.");
            }
            try {
                this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", DuplicateNameContainer.class);
                throw new EETest.Fault("JsonbException not thrown for property name duplication as a result of property name customization.");
            }
            catch (Exception x2) {
                if (!JsonbException.class.isAssignableFrom(x2.getClass())) {
                    throw new EETest.Fault("JsonbException expected for property name duplication as a result of property name customization.");
                }
                return Status.passed((String)"OK");
            }
        }
    }
}

