/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.xa.ee.resXcomp2;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSEISDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.sql.DataSource;

public class Ejb2TestEJB
implements SessionBean {
    private SessionContext sctx = null;
    private TSNamingContext context = null;
    private Properties testProps = null;
    private DataSource ds1 = null;
    private String dbTable1 = null;
    private transient Connection con1 = null;
    private transient Statement stmt;
    private TSEISDataSource ds2;
    private transient TSConnection con2 = null;

    public void ejbCreate(Properties props) throws CreateException {
        this.testProps = props;
        String eMsg = "";
        try {
            TestUtil.init((Properties)props);
            this.context = new TSNamingContext();
            TestUtil.logTrace((String)"got the context");
            eMsg = "Exception looking up JDBCwhitebox";
            this.ds1 = (DataSource)this.context.lookup("java:comp/env/eis/JDBCwhitebox-tx");
            eMsg = "Exception looking up EIS whitebox";
            this.ds2 = (TSEISDataSource)this.context.lookup("java:comp/env/eis/whitebox-tx");
            TestUtil.logMsg((String)("ds1 : " + this.ds1));
            TestUtil.logMsg((String)("ds2 : " + this.ds2));
        }
        catch (Exception e) {
            TestUtil.logTrace((String)eMsg);
            TestUtil.logErr((String)"EJB2: ejbCreate failed", (Throwable)e);
            throw new CreateException(e.getMessage());
        }
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"EJB2 @setSessionContext");
        try {
            this.sctx = sc;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception setting EJB context/DataSources", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"@ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"@ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"@ejbPassivate");
    }

    public void dbConnect(String tName) {
        TestUtil.logTrace((String)"dbConnect");
        try {
            if (tName.equals(this.dbTable1)) {
                this.conTable1();
                TestUtil.logMsg((String)("Made the JDBC connection to " + this.dbTable1 + " DB"));
            } else {
                this.conTable2();
                TestUtil.logMsg((String)"Made the connection to EIS");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception on JDBC connection", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void insert(String tName) {
        String key2 = null;
        TestUtil.logMsg((String)"Insert @Ejb2 ");
        try {
            if (tName.equals(this.dbTable1)) {
                TestUtil.logMsg((String)("Insert row in " + this.dbTable1));
                String key1 = new String(this.testProps.getProperty("Xa_Tab1_insert1"));
                key2 = new String(this.testProps.getProperty("Xa_Tab1_insert2"));
                this.stmt = this.con1.createStatement();
                this.stmt.executeUpdate(key1);
                this.stmt.executeUpdate(key2);
                TestUtil.logTrace((String)("Inserted two row in table " + tName));
            } else {
                TestUtil.logMsg((String)"Insert row in EIS");
                String key1 = new String(this.testProps.getProperty("TSEIS_insert1"));
                key2 = new String(this.testProps.getProperty("TSEIS_insert2"));
                this.con2.insert(key1, key1);
                this.con2.insert(key2, key2);
                TestUtil.logTrace((String)"Inserted two elements in EIS ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception inserting a row into table " + tName + ";\n" + e.getMessage()), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void dbUnConnect(String tName) {
        TestUtil.logTrace((String)"dbUnConnect");
        try {
            if (tName.equals(this.dbTable1)) {
                this.con1.close();
                this.con1 = null;
                TestUtil.logTrace((String)("Closed " + this.dbTable1 + " connection"));
            } else {
                this.con2.close();
                this.con2 = null;
                TestUtil.logTrace((String)"Closed EIS connection");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occured trying to close the DB connection", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging Ejb2");
        try {
            this.dbTable1 = TestUtil.getTableName((String)TestUtil.getProperty((String)"Xa_Tab1_Delete"));
            TestUtil.logMsg((String)(this.dbTable1 + " Ejb2 initLogging OK!"));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Inside Ejb2 initLogging" + e.getMessage());
        }
    }

    public void throwEJBException() throws EJBException {
        TestUtil.logTrace((String)"throwEJBException");
        throw new EJBException("EJBException from Ejb1TestEJB");
    }

    private void conTable1() {
        TestUtil.logTrace((String)"conTable1");
        try {
            this.con1 = this.ds1.getConnection();
            TestUtil.logTrace((String)("con1: " + this.con1.toString()));
        }
        catch (SQLException e) {
            TestUtil.logErr((String)("SQLException connecting to " + this.dbTable1 + " DB"), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        catch (Exception ee) {
            TestUtil.logErr((String)("Exception connecting to " + this.dbTable1 + " DB"), (Throwable)ee);
            throw new EJBException(ee.getMessage());
        }
    }

    private void conTable2() {
        TestUtil.logTrace((String)"conTable2");
        try {
            this.con2 = this.ds2.getConnection();
            TestUtil.logTrace((String)("con2: " + this.con2.toString()));
        }
        catch (Exception ee) {
            TestUtil.logErr((String)"Exception connecting to EIS ", (Throwable)ee);
            throw new EJBException(ee.getMessage());
        }
    }
}

