/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.concurrency.spec.ManagedScheduledExecutorService.inheritedapi;

import com.sun.ts.tests.concurrency.api.common.CommonTasks;
import com.sun.ts.tests.concurrency.api.common.Util;
import com.sun.ts.tests.concurrency.api.common.counter.CounterRemote;
import com.sun.ts.tests.concurrency.api.common.counter.CounterRunnableTask;
import com.sun.ts.tests.concurrency.spec.ManagedScheduledExecutorService.inheritedapi.TestEjbRemote;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.enterprise.concurrent.ManagedScheduledExecutorService;
import javax.naming.InitialContext;

@Stateless
public class TestEjb
implements TestEjbRemote {
    @EJB(beanName="CounterSingleton")
    private CounterRemote counter;
    private String COUNTER_SINGLETON_JNDI = "java:global/inheritedapi/counter_ejb/CounterSingleton";

    private ManagedScheduledExecutorService getService() {
        try {
            InitialContext context = new InitialContext();
            ManagedScheduledExecutorService executorService = (ManagedScheduledExecutorService)context.lookup("java:comp/DefaultManagedScheduledExecutorService");
            return executorService;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void testApiSubmit() {
        try {
            Future result = this.getService().submit((Callable)new CommonTasks.SimpleCallable());
            Util.waitTillFutureIsDone(result);
            Util.assertEquals("ok", result.get());
            result = this.getService().submit((Runnable)new CommonTasks.SimpleRunnable());
            Util.waitTillFutureIsDone(result);
            result.get();
            result = this.getService().submit((Runnable)new CommonTasks.SimpleRunnable(), (Object)"ok");
            Util.waitTillFutureIsDone(result);
            Util.assertEquals("ok", result.get());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void testApiExecute() {
        try {
            this.getService().execute((Runnable)new CounterRunnableTask(this.COUNTER_SINGLETON_JNDI));
            Thread.sleep(30000L);
            Util.assertEquals(1, this.counter.getCount());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void testApiInvokeAll() {
        List resultList;
        ArrayList<Callable> taskList;
        try {
            taskList = new ArrayList<Callable>();
            taskList.add(new CommonTasks.SimpleArgCallable(1));
            taskList.add(new CommonTasks.SimpleArgCallable(2));
            taskList.add(new CommonTasks.SimpleArgCallable(3));
            resultList = this.getService().invokeAll(taskList);
            for (Future each : resultList) {
                Util.waitTillFutureIsDone(each);
            }
            Util.assertEquals(1, ((Future)resultList.get(0)).get());
            Util.assertEquals(2, ((Future)resultList.get(1)).get());
            Util.assertEquals(3, ((Future)resultList.get(2)).get());
            resultList = this.getService().invokeAll(taskList, 30L, TimeUnit.SECONDS);
            for (Future each : resultList) {
                Util.waitTillFutureIsDone(each);
            }
            Util.assertEquals(1, ((Future)resultList.get(0)).get());
            Util.assertEquals(2, ((Future)resultList.get(1)).get());
            Util.assertEquals(3, ((Future)resultList.get(2)).get());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            taskList = new ArrayList();
            taskList.add(new CommonTasks.SimpleCallable(30000L));
            taskList.add(new CommonTasks.SimpleCallable(30000L));
            resultList = this.getService().invokeAll(taskList, 5L, TimeUnit.SECONDS);
            Thread.sleep(5000L);
            for (Future each : resultList) {
                each.get();
            }
        }
        catch (CancellationException e) {
            return;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        throw new RuntimeException("Task should be cancelled because of timeout");
    }

    @Override
    public void testApiInvokeAny() {
        ArrayList<Callable> taskList;
        try {
            taskList = new ArrayList<Callable>();
            taskList.add(new CommonTasks.SimpleArgCallable(1));
            taskList.add(new CommonTasks.SimpleArgCallable(2));
            taskList.add(new CommonTasks.SimpleArgCallable(3));
            Object result = this.getService().invokeAny(taskList);
            Util.assertInRange(new Integer[]{1, 2, 3}, result);
            result = this.getService().invokeAny(taskList, 30L, TimeUnit.SECONDS);
            Util.assertInRange(new Integer[]{1, 2, 3}, result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            taskList = new ArrayList();
            taskList.add(new CommonTasks.SimpleCallable(30000L));
            taskList.add(new CommonTasks.SimpleCallable(30000L));
            Object object = this.getService().invokeAny(taskList, 5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            return;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        throw new RuntimeException("Task should be cancelled because of timeout");
    }

    @Override
    public void testApiSchedule() {
        try {
            ScheduledFuture result = this.getService().schedule((Callable)new CommonTasks.SimpleCallable(), 5L, TimeUnit.SECONDS);
            Util.waitTillFutureIsDone(result);
            Util.assertEquals("ok", result.get());
            result = this.getService().schedule((Runnable)new CommonTasks.SimpleRunnable(), 5L, TimeUnit.SECONDS);
            Util.waitTillFutureIsDone(result);
            Util.assertEquals(null, result.get());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void testApiScheduleAtFixedRate() {
        Future result = null;
        try {
            result = this.getService().scheduleAtFixedRate((Runnable)new CounterRunnableTask(this.COUNTER_SINGLETON_JNDI), 5L, 5L, TimeUnit.SECONDS);
            Thread.sleep(30000L);
            Util.asserIntInRange(3, 7, this.counter.getCount());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (result != null) {
                result.cancel(true);
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void testApiScheduleWithFixedDelay() {
        Future result = null;
        try {
            result = this.getService().scheduleWithFixedDelay((Runnable)new CounterRunnableTask(this.COUNTER_SINGLETON_JNDI, 5000L), 5L, 5L, TimeUnit.SECONDS);
            Thread.sleep(30000L);
            Util.asserIntInRange(1, 3, this.counter.getCount());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (result != null) {
                result.cancel(true);
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
            }
        }
    }
}

