/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb32.lite.timer.timerconfig;

import com.sun.ts.tests.ejb30.timer.common.ClientBase;
import com.sun.ts.tests.ejb30.timer.common.TimerInfo;
import com.sun.ts.tests.ejb30.timer.common.TimerUtil;
import com.sun.ts.tests.ejb32.lite.timer.timerconfig.TimerConfigIF;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import javax.ejb.EJB;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;

public class Client
extends ClientBase {
    @EJB(beanName="TimerConfigBean")
    protected TimerConfigIF timerConfigBean;

    @Override
    public void setup(String[] args, Properties p) {
        super.setup(args, p);
        this.timerConfigBean.cancelAllTimers();
    }

    public void isPersistent() {
        String name = this.getTestName() + "-nonpersistent";
        ScheduleExpression exp = new ScheduleExpression();
        exp = exp.hour("*").minute("*").second("*/2");
        TimerConfig timerConfig = new TimerConfig();
        timerConfig.setInfo((Serializable)new TimerInfo(name));
        timerConfig.setPersistent(false);
        Timer timerNonPersistent = this.timerConfigBean.createTimer(exp, timerConfig);
        this.assertEquals(null, false, this.timerConfigBean.isPersistent(timerNonPersistent));
        this.passIfRecurringTimeout(name, new long[0]);
        this.timerConfigBean.cancelTimer(timerNonPersistent);
    }

    public void gettersSetters() {
        this.timerConfigBean.gettersSetters(this.getReasonBuffer());
    }

    public void illegalArgumentException() {
        TimerConfig timerConfig = new TimerConfig();
        timerConfig.setInfo((Serializable)new TimerInfo(this.getTestName()));
        timerConfig.setPersistent(false);
        this.timerConfigBean.illegalArgumentException(this.getReasonBuffer(), timerConfig);
    }

    public void resetTimerConfig() {
        this.timerConfigBean.resetTimerConfig(this.getTestName(), this.getReasonBuffer());
    }

    public void createTimerWithLong() {
        TimerConfig timerConfig = new TimerConfig();
        timerConfig.setInfo((Serializable)new TimerInfo(this.getTestName()));
        timerConfig.setPersistent(false);
        this.timerConfigBean.createTimer(100L, timerConfig);
        this.passIfTimeout(new long[0]);
    }

    public void createTimerWithLongRecurring() {
        try {
            TimerConfig timerConfig = new TimerConfig();
            timerConfig.setInfo((Serializable)new TimerInfo(this.getTestName()));
            timerConfig.setPersistent(false);
            this.timerConfigBean.createTimer(100L, 100L, timerConfig);
            this.passIfRecurringTimeout(new long[0]);
        }
        finally {
            this.timerConfigBean.cancelAllTimers();
        }
    }

    public void createTimerWithDate() {
        TimerConfig timerConfig = new TimerConfig();
        timerConfig.setInfo((Serializable)new TimerInfo(this.getTestName()));
        timerConfig.setPersistent(false);
        Date expirationDate = TimerUtil.getCurrentDatePlus(13, 1);
        this.timerConfigBean.createTimer(expirationDate, timerConfig);
        this.passIfTimeout(new long[0]);
    }

    public void createTimerWithDateRecurring() {
        try {
            TimerConfig timerConfig = new TimerConfig();
            timerConfig.setInfo((Serializable)new TimerInfo(this.getTestName()));
            timerConfig.setPersistent(false);
            Date expirationDate = TimerUtil.getCurrentDatePlus(13, 1);
            this.timerConfigBean.createTimer(expirationDate, 100L, timerConfig);
            this.passIfRecurringTimeout(new long[0]);
        }
        finally {
            this.timerConfigBean.cancelAllTimers();
        }
    }

    public void createTimerWithSchedule() {
        TimerConfig timerConfig = new TimerConfig();
        timerConfig.setInfo((Serializable)new TimerInfo(this.getTestName()));
        timerConfig.setPersistent(false);
        Calendar cal = Calendar.getInstance();
        cal.add(13, 1);
        this.timerConfigBean.createTimer(TimerUtil.getPreciseScheduleExpression(cal), timerConfig);
        this.passIfTimeout(new long[0]);
    }
}

