/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry.Query;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.util.Properties;
import javax.xml.registry.DeclarativeQueryManager;
import javax.xml.registry.Query;
import javax.xml.registry.UnsupportedCapabilityException;

public class JAXRClient
extends JAXRCommonClient {
    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            this.logMsg("in cleanup");
            if (this.conn != null) {
                this.logTrace("Cleanup is closing the connection");
                this.conn.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void queryTest() throws EETest.Fault {
        String testName = "queryTest";
        int providerlevel = 0;
        int failcount = 0;
        try {
            providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
            DeclarativeQueryManager dqm = this.rs.getDeclarativeQueryManager();
            String queryString = "SELECT * FROM ClassificationScheme";
            Query query = dqm.createQuery(0, queryString);
            if (query.getType() == 0) {
                this.debug.add("good - correct query - QUERY_TYPE_SQL - returned from getType\n");
            } else {
                ++failcount;
                this.debug.add("failed to return expected query type - QUERY_TYPE_SQL \n");
            }
            this.debug.add("query.toString = " + query.toString());
            if (query.toString().indexOf(queryString) == -1) {
                this.debug.add("failed to return expected query - SELECT * FROM ClassificationScheme \n");
                ++failcount;
            }
        }
        catch (UnsupportedCapabilityException uc) {
            if (providerlevel == 0) {
                this.debug.add(" Call to DeclarativeQueryManager.createQuery threw UnsupportedCapabilityException as expected\n");
            }
            throw new EETest.Fault(testName + " unexpected UnsupportedCapabilityException was caught \n", uc);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
        if (failcount > 0) {
            throw new EETest.Fault(testName + " failed ");
        }
    }
}

