/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.closedQueueReceiver;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import java.util.ArrayList;
import java.util.Properties;
import javax.jms.IllegalStateException;
import javax.jms.Message;
import javax.jms.Queue;

public class ClosedQueueReceiverTests
extends ServiceEETest {
    private static final String TestName = "com.sun.ts.tests.jms.core.closedQueueReceiver.ClosedQueueReceiverTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    public static void main(String[] args) {
        ClosedQueueReceiverTests theTests = new ClosedQueueReceiverTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void createAndCloseReceiver() throws Exception {
        this.tool = new JmsTool(0, this.user, this.password, this.mode);
        this.tool.getDefaultQueueConnection().start();
        this.logTrace("Closing queue receiver");
        this.tool.getDefaultQueueReceiver().close();
        this.logTrace("Receiver closed");
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            this.queues = new ArrayList(2);
            this.logTrace("Getting Administrator and deleting any leftover destinations.");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing Queue and Topic Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }

    public void closedQueueReceiverCloseTest() throws EETest.Fault {
        try {
            this.createAndCloseReceiver();
            this.logTrace("Try to call close again");
            this.tool.getDefaultQueueReceiver().close();
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueReceiverCloseTest", e);
        }
    }

    public void closedQueueReceiverGetMessageSelectorTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseReceiver();
            this.logTrace("Try to call getMessageSelector");
            try {
                String foo = this.tool.getDefaultQueueReceiver().getMessageSelector();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueReceiverGetMessageSelectorTest", e);
        }
    }

    public void closedQueueReceiverReceiveTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseReceiver();
            this.logTrace("Try to call receive");
            try {
                Message foo = this.tool.getDefaultQueueReceiver().receive();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueReceiverReceiveTest", e);
        }
    }

    public void closedQueueReceiverReceiveTimeoutTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseReceiver();
            this.logTrace("Try to call receive(timeout)");
            try {
                Message foo = this.tool.getDefaultQueueReceiver().receive(this.timeout);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueReceiverReceiveTimeoutTest", e);
        }
    }

    public void closedQueueReceiverReceiveNoWaitTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseReceiver();
            this.logTrace("Try to call receiveNoWait");
            try {
                Message foo = this.tool.getDefaultQueueReceiver().receiveNoWait();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueReceiverReceiveNoWaitTest", e);
        }
    }

    public void closedQueueReceiverGetQueueTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseReceiver();
            this.logTrace("Try to call getQueue");
            try {
                Queue foo = this.tool.getDefaultQueueReceiver().getQueue();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueReceiverGetQueueTest", e);
        }
    }
}

