/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.dbMeta.dbMeta11;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public class dbMetaClient11
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.dbMeta.dbMeta11";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private transient DatabaseMetaData dbmd = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private String dbName = null;
    private String dbUser = null;
    private String drManager = null;
    private String sCatalogName = null;
    private String sSchemaName = null;
    private String sPtable = null;
    private String sFtable = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        dbMetaClient11 theTests = new dbMetaClient11();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private boolean columnCompare(String[] sColumnNames, ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = null;
        boolean test_status = false;
        boolean statusColumnCount = true;
        boolean statusColumnMatch = true;
        int iColumnNamesLength = sColumnNames.length;
        rsmd = rs.getMetaData();
        int iCount = rsmd.getColumnCount();
        this.msg.setMsg("iColumnNamesLength " + iColumnNamesLength);
        this.msg.setMsg("iCount " + iCount);
        this.msg.setMsg("Minimum Column Count is:" + iColumnNamesLength);
        if (iColumnNamesLength <= iCount) {
            iCount = iColumnNamesLength;
            this.msg.setMsg("Setting iCount to " + iColumnNamesLength);
            statusColumnCount = true;
        } else {
            statusColumnCount = false;
        }
        this.msg.setMsg("Comparing Column Names...");
        while (iColumnNamesLength > 0) {
            this.msg.setMsg("sColumnNames[iColumnNamesLength-1] " + sColumnNames[iColumnNamesLength - 1] + " and iColumnNamesLength " + iColumnNamesLength);
            this.msg.setMsg("rsmd.getColumnName(iCount) " + rsmd.getColumnName(iCount));
            if (!sColumnNames[iColumnNamesLength - 1].equalsIgnoreCase(rsmd.getColumnName(iCount))) {
                statusColumnMatch = false;
                break;
            }
            statusColumnMatch = true;
            --iCount;
            --iColumnNamesLength;
        }
        this.msg.setMsg("statusColumnCount " + statusColumnCount + " and statusColumnMatch " + statusColumnMatch);
        if (statusColumnCount && statusColumnMatch) {
            test_status = true;
        }
        return test_status;
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                this.dbName = p.getProperty("db1", "");
                this.dbUser = p.getProperty("user1", "");
                this.sPtable = p.getProperty("ptable", "TSTABLE1");
                this.sFtable = p.getProperty("ftable", "TSTABLE2");
                if (this.dbName.length() == 0) {
                    throw new EETest.Fault("Invalid db1  Database Name");
                }
                if (this.dbUser.length() == 0) {
                    throw new EETest.Fault("Invalid Login Id");
                }
                if (this.sPtable.length() == 0) {
                    throw new EETest.Fault("Invalid Primary table");
                }
                if (this.sFtable.length() == 0) {
                    throw new EETest.Fault("Invalid Foreign table");
                }
                if (this.drManager.length() == 0) {
                    throw new EETest.Fault("Invalid DriverManager Name");
                }
                int nLocdbname = this.dbName.indexOf(61);
                this.sSchemaName = this.dbUser;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.dbSch.createData(p, this.conn);
                this.dbmd = this.conn.getMetaData();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testSupportsTransactionIsolationLevel2() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsTransactionIsolationLevel(TRANSACTION_READ_COMMITTED)");
            boolean retValue = this.dbmd.supportsTransactionIsolationLevel(2);
            if (retValue) {
                this.msg.setMsg("supportsTransactionIsolationLevel(TRANSACTION_READ_COMMITTED) is supported");
            } else {
                this.msg.setMsg("supportsTransactionIsolationLevel(TRANSACTION_READ_COMMITTED) is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsTransactionIsolationLevel2 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsTransactionIsolationLevel2 is Failed!");
        }
    }

    public void testSupportsTransactionIsolationLevel3() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsTransactionIsolationLevel(TRANSACTION_READ_UNCOMMITTED)");
            boolean retValue = this.dbmd.supportsTransactionIsolationLevel(1);
            if (retValue) {
                this.msg.setMsg("supportsTransactionIsolationLevel(TRANSACTION_READ_UNCOMMITTED) is supported");
            } else {
                this.msg.setMsg("supportsTransactionIsolationLevel(TRANSACTION_READ_UNCOMMITTED ) is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsTransactionIsolationLevel3 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsTransactionIsolationLevel3 is Failed!");
        }
    }

    public void testSupportsTransactionIsolationLevel4() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsTransactionIsolationLevel(TRANSACTION_REPEATABLE_READ)");
            boolean retValue = this.dbmd.supportsTransactionIsolationLevel(4);
            if (retValue) {
                this.msg.setMsg("supportsTransactionIsolationLevel(TRANSACTION_REPEATABLE_READ) is supported");
            } else {
                this.msg.setMsg("supportsTransactionIsolationLevel(TRANSACTION_REPEATABLE_READ) is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsTransactionIsolationLevel4 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsTransactionIsolationLevel4 is Failed!");
        }
    }

    public void testSupportsTransactionIsolationLevel5() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsTransactionIsolationLevel(TRANSACTION_SERIALIZABLE)");
            boolean retValue = this.dbmd.supportsTransactionIsolationLevel(8);
            if (retValue) {
                this.msg.setMsg("supportsTransactionIsolationLevel(TRANSACTION_SERIALIZABLE) is supported");
            } else {
                this.msg.setMsg("supportsTransactionIsolationLevel(TRANSACTION_SERIALIZABLE) is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsTransactionIsolationLevel5 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsTransactionIsolationLevel5 is Failed!");
        }
    }

    public void testGetColumnPrivileges() throws EETest.Fault {
        try {
            String[] sColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
            boolean test_status = true;
            this.msg.setMsg("Calling DatabaseMetaData.getColumnPrivileges");
            ResultSet oRet_ResultSet = this.dbmd.getColumnPrivileges(this.sCatalogName, this.sSchemaName, this.sFtable, "%");
            this.msg.setMsg("Call to columnCompare for the exact match of column names");
            test_status = this.columnCompare(sColumnNames, oRet_ResultSet);
            if (!test_status) {
                this.msg.printTestError("Columns return are not same either in order or name", "Call to getColumnPrivileges Failed!");
            }
            if (oRet_ResultSet.next()) {
                this.msg.setMsg("getColumnPrivileges returned some column names");
            } else {
                this.msg.setMsg("getColumnPrivileges did not return any column names");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getColumnPrivileges Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getColumnPrivileges Failed!");
        }
    }

    public void testGetTablePrivileges() throws EETest.Fault {
        try {
            String[] sColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
            boolean test_status = true;
            this.msg.setMsg("Calling DatabaseMetaData.getTablePrivileges");
            this.msg.setMsg("sCatalogName " + this.sCatalogName);
            this.msg.setMsg("sSchemaName " + this.sSchemaName);
            ResultSet oRet_ResultSet = this.dbmd.getTablePrivileges(this.sCatalogName, this.sSchemaName, this.sFtable);
            String sRetStr = new String();
            sRetStr = "";
            this.msg.setMsg("Call to columnCompare for the exact match of column names");
            test_status = this.columnCompare(sColumnNames, oRet_ResultSet);
            if (!test_status) {
                this.msg.printTestError("Columns return are not same either in order or name", "Call to getTablePrivileges Failed!");
            }
            while (oRet_ResultSet.next()) {
                sRetStr = sRetStr + oRet_ResultSet.getString(6) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getTablePrivileges did not return any privileges");
            } else {
                this.msg.setMsg("The privileges returned Are : " + sRetStr.substring(0, sRetStr.length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getTablePrivileges Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getTablePrivileges Failed!");
        }
    }

    public void testGetBestRowIdentifier1() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getBestRowIdentifier with scope bestRowTemporary with nullable columns");
            ResultSet oRet_ResultSet = this.dbmd.getBestRowIdentifier(this.sCatalogName, this.sSchemaName, this.sFtable, 0, true);
            String sRetStr = new String();
            sRetStr = "";
            this.msg.setMsg("Store all the Columns returned");
            while (oRet_ResultSet.next()) {
                sRetStr = sRetStr + oRet_ResultSet.getString(2) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getBestRowIdentifier with scope bestRowTemporary did not return any columns");
            } else {
                this.msg.setMsg("The columns returned Are : " + sRetStr.substring(0, sRetStr.length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBestRowIdentifier1 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBestRowIdentifier1 is Failed!");
        }
    }

    public void testGetBestRowIdentifier2() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getBestRowIdentifier with scope bestRowTransaction with nullable columns");
            ResultSet oRet_ResultSet = this.dbmd.getBestRowIdentifier(this.sCatalogName, this.sSchemaName, this.sFtable, 1, true);
            String sRetStr = new String();
            sRetStr = "";
            this.msg.setMsg("Store all the Columns returned");
            while (oRet_ResultSet.next()) {
                sRetStr = sRetStr + oRet_ResultSet.getString(2) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getBestRowIdentifier with scope bestRowTransaction did not return any columns");
            } else {
                this.msg.setMsg("The columns returned Are : " + sRetStr.substring(0, sRetStr.length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBestRowIdentifier2 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBestRowIdentifier2 is Failed!");
        }
    }

    public void testGetBestRowIdentifier3() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getBestRowIdentifier with scope bestRowSession with nullable columns");
            ResultSet oRet_ResultSet = this.dbmd.getBestRowIdentifier(this.sCatalogName, this.sSchemaName, this.sFtable, 2, true);
            String sRetStr = new String();
            sRetStr = "";
            while (oRet_ResultSet.next()) {
                sRetStr = sRetStr + oRet_ResultSet.getString(2) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getBestRowIdentifier with scope bestRowSession did not return any columns");
            } else {
                this.msg.setMsg("The columns returned Are : " + sRetStr.substring(0, sRetStr.length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBestRowIdentifier3 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBestRowIdentifier3 is Failed!");
        }
    }

    public void testGetBestRowIdentifier4() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getBestRowIdentifier with scope bestRowTemporary without nullable columns");
            ResultSet oRet_ResultSet = this.dbmd.getBestRowIdentifier(this.sCatalogName, this.sSchemaName, this.sFtable, 0, false);
            String sRetStr = new String();
            sRetStr = "";
            while (oRet_ResultSet.next()) {
                sRetStr = sRetStr + oRet_ResultSet.getString(2) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getBestRowIdentifier with scope bestRowTemporary did not return any columns");
            } else {
                this.msg.setMsg("The columns returned Are : " + sRetStr.substring(0, sRetStr.length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBestRowIdentifier4 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBestRowIdentifier4 is Failed!");
        }
    }

    public void testGetBestRowIdentifier5() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getBestRowIdentifier with scope bestRowTransaction without nullable columns");
            ResultSet oRet_ResultSet = this.dbmd.getBestRowIdentifier(this.sCatalogName, this.sSchemaName, this.sFtable, 1, true);
            String sRetStr = new String();
            sRetStr = "";
            while (oRet_ResultSet.next()) {
                sRetStr = sRetStr + oRet_ResultSet.getString(2) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getBestRowIdentifier with scope bestRowTransaction did not return any columns");
            } else {
                this.msg.setMsg("The columns returned Are : " + sRetStr.substring(0, sRetStr.length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBestRowIdentifier5 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBestRowIdentifier5 is Failed!");
        }
    }

    public void testGetBestRowIdentifier6() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getBestRowIdentifier with scope bestRowSession without nullable columns");
            ResultSet oRet_ResultSet = this.dbmd.getBestRowIdentifier(this.sCatalogName, this.sSchemaName, this.sFtable, 2, true);
            String sRetStr = new String();
            sRetStr = "";
            while (oRet_ResultSet.next()) {
                sRetStr = sRetStr + oRet_ResultSet.getString(2) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getBestRowIdentifier with scope bestRowSession did not return any columns");
            } else {
                this.msg.setMsg("The columns returned Are : " + sRetStr.substring(0, sRetStr.length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBestRowIdentifier6 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBestRowIdentifier6 is Failed!");
        }
    }

    public void testGetBestRowIdentifier7() throws EETest.Fault {
        try {
            String[] sColumnNames = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
            boolean test_status = true;
            this.msg.setMsg("Calling DatabaseMetaData.getBestRowIdentifier with scope bestRowSession without nullable columns");
            ResultSet oRet_ResultSet = this.dbmd.getBestRowIdentifier(this.sCatalogName, this.sSchemaName, this.sFtable, 2, true);
            this.msg.setMsg("Call columnCompare for the exact match of column names");
            test_status = this.columnCompare(sColumnNames, oRet_ResultSet);
            if (!test_status) {
                this.msg.printTestError("Columns return are not same either in order or name", "Call to getBestRowIdentifier7 Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getBestRowIdentifier7 Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getBestRowIdentifier7 Failed!");
        }
    }

    public void testGetVersionColumns() throws EETest.Fault {
        try {
            String[] sColumnNames = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
            boolean test_status = true;
            this.msg.setMsg("Calling DatabaseMetaData.getVersionColumns");
            ResultSet oRet_ResultSet = this.dbmd.getVersionColumns(this.sCatalogName, this.sSchemaName, this.sFtable);
            String sRetStr = new String();
            sRetStr = "";
            this.msg.setMsg("Call to columnCompare for the exact match of column names");
            test_status = this.columnCompare(sColumnNames, oRet_ResultSet);
            if (!test_status) {
                this.msg.printTestError("Columns return are not same either in order or name", "Call to getVersionColumns Failed!");
            }
            this.msg.setMsg("Store all the columns returned");
            while (oRet_ResultSet.next()) {
                sRetStr = sRetStr + oRet_ResultSet.getString(2) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getVersionColumns did not return any columns");
            } else {
                this.msg.setMsg("The columns returned Are : " + sRetStr.substring(0, sRetStr.length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getVersionColumns Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getVersionColumns Failed!");
        }
    }

    public void testGetPrimaryKeys() throws EETest.Fault {
        try {
            String[] sColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"};
            boolean test_status = true;
            this.msg.setMsg("Calling DatabaseMetaData.getPrimaryKeys");
            ResultSet oRet_ResultSet = this.dbmd.getPrimaryKeys(this.sCatalogName, this.sSchemaName, this.sFtable);
            String sRetStr = new String();
            sRetStr = "";
            this.msg.setMsg("Call to columnCompare for the exact match of column names");
            test_status = this.columnCompare(sColumnNames, oRet_ResultSet);
            if (!test_status) {
                this.msg.printTestError("Columns return are not same either in order or name", "Call to getPrimaryKeys Failed!");
            }
            this.msg.setMsg("Store all the columns returned");
            while (oRet_ResultSet.next()) {
                sRetStr = sRetStr + oRet_ResultSet.getString(4) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getPrimaryKeys did not return any columns");
            } else {
                this.msg.setMsg("The columns returned Are : " + sRetStr.substring(0, sRetStr.length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getPrimaryKeys Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getPrimaryKeys Failed!");
        }
    }

    public void testGetImportedKeys() throws EETest.Fault {
        try {
            String[] sColumnNames = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
            boolean test_status = true;
            this.msg.setMsg("Calling DatabaseMetaData.getImportedKeys");
            ResultSet oRet_ResultSet = this.dbmd.getImportedKeys(this.sCatalogName, this.sSchemaName, this.sFtable);
            String sRetStr = new String();
            sRetStr = "";
            this.msg.setMsg("Call columnCompare for the exact match of column names");
            test_status = this.columnCompare(sColumnNames, oRet_ResultSet);
            if (!test_status) {
                this.msg.printTestError("Columns return are not same either in order or name", "Call to getImportedKeys Failed!");
            }
            this.msg.setMsg("Store all the columns returned");
            while (oRet_ResultSet.next()) {
                sRetStr = sRetStr + oRet_ResultSet.getString(4) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getImportedKeys did not return any columns");
            } else {
                this.msg.setMsg("The columns returned Are : " + sRetStr.substring(0, sRetStr.length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getImportedKeys Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getImportedKeys Failed!");
        }
    }

    public void testGetExportedKeys() throws EETest.Fault {
        try {
            String[] sColumnNames = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
            boolean test_status = true;
            this.msg.setMsg("Calling DatabaseMetaData.getExportedKeys");
            ResultSet oRet_ResultSet = this.dbmd.getExportedKeys(this.sCatalogName, this.sSchemaName, this.sPtable);
            String sRetStr = new String();
            sRetStr = "";
            this.msg.setMsg("Call columnCompare for the exact match of column names");
            test_status = this.columnCompare(sColumnNames, oRet_ResultSet);
            if (!test_status) {
                this.msg.printTestError("Columns return are not same either in order or name", "Call to getExportedKeys Failed!");
            }
            this.msg.setMsg("Store all the columns returned");
            while (oRet_ResultSet.next()) {
                sRetStr = sRetStr + oRet_ResultSet.getString(8) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getExportedKeys did not return any columns");
            } else {
                this.msg.setMsg("The columns returned Are : " + sRetStr.substring(0, sRetStr.length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getExportedKeys is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getExportedKeys is Failed!");
        }
    }

    public void testGetCrossReference() throws EETest.Fault {
        try {
            String[] sColumnNames = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
            boolean test_status = true;
            this.msg.setMsg("Calling DatabaseMetaData.getCrossReference");
            ResultSet oRet_ResultSet = this.dbmd.getCrossReference(this.sCatalogName, this.sSchemaName, this.sPtable, this.sCatalogName, this.sSchemaName, this.sFtable);
            String sRetStr = new String();
            sRetStr = "";
            this.msg.setMsg("Call columnCompare for the exact match of column names");
            test_status = this.columnCompare(sColumnNames, oRet_ResultSet);
            if (!test_status) {
                this.msg.printTestError("Columns return are not same either in order or name", "Call to getCrossReference Failed!");
            }
            this.msg.setMsg("Store all the columns returned");
            while (oRet_ResultSet.next()) {
                sRetStr = sRetStr + oRet_ResultSet.getString(8) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getCrossReference did not return any columns");
            } else {
                this.msg.setMsg("The columns returned Are : " + sRetStr.substring(0, sRetStr.length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getCrossReference Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getCrossReference Failed!");
        }
    }

    public void testGetIndexInfo1() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getIndexInfo with approximate data and without accurate results");
            ResultSet oRet_ResultSet = this.dbmd.getIndexInfo(this.sCatalogName, this.sSchemaName, this.sFtable, true, true);
            String sRetStr = new String();
            sRetStr = "";
            this.msg.setMsg("Store all the index name returned");
            while (oRet_ResultSet.next()) {
                sRetStr = sRetStr + oRet_ResultSet.getString(6) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getIndexInfo did not return any index names");
            } else {
                this.msg.setMsg("The index names returned Are : " + sRetStr.substring(0, sRetStr.length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getIndexInfo1 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getIndexInfo1 is Failed!");
        }
    }

    public void testGetIndexInfo2() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getIndexInfo with approximate data and with accurate results");
            ResultSet oRet_ResultSet = this.dbmd.getIndexInfo(this.sCatalogName, this.sSchemaName, this.sFtable, true, false);
            String sRetStr = new String();
            sRetStr = "";
            this.msg.setMsg("Store all the index name returned");
            while (oRet_ResultSet.next()) {
                sRetStr = sRetStr + oRet_ResultSet.getString(6) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getIndexInfo did not return any index names");
            } else {
                this.msg.setMsg("The index names returned Are : " + sRetStr.substring(0, sRetStr.length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getIndexInfo2 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getIndexInfo2 is Failed!");
        }
    }

    public void testGetIndexInfo3() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getIndexInfo without approximate data and with accurate results");
            ResultSet oRet_ResultSet = this.dbmd.getIndexInfo(this.sCatalogName, this.sSchemaName, this.sFtable, false, false);
            String sRetStr = new String();
            sRetStr = "";
            this.msg.setMsg("Store all the index name returned");
            while (oRet_ResultSet.next()) {
                sRetStr = sRetStr + oRet_ResultSet.getString(6) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getIndexInfo did not return any index names");
            } else {
                this.msg.setMsg("The index names returned Are : " + sRetStr.substring(0, sRetStr.length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getIndexInfo3 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getIndexInfo3 is Failed!");
        }
    }

    public void testGetIndexInfo4() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getIndexInfo without approximate data and without accurate results");
            ResultSet oRet_ResultSet = this.dbmd.getIndexInfo(this.sCatalogName, this.sSchemaName, this.sFtable, false, true);
            String sRetStr = new String();
            sRetStr = "";
            this.msg.setMsg("Store all the index name returned");
            while (oRet_ResultSet.next()) {
                sRetStr = sRetStr + oRet_ResultSet.getString(6) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getIndexInfo did not return any index names");
            } else {
                this.msg.setMsg("The index names returned Are : " + sRetStr.substring(0, sRetStr.length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getIndexInfo4 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getIndexInfo4 is Failed!");
        }
    }

    public void testGetIndexInfo5() throws EETest.Fault {
        try {
            String[] sColumnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"};
            boolean test_status = true;
            this.msg.setMsg("Calling DatabaseMetaData.getIndexInfo without approximate data and without accurate results");
            ResultSet oRet_ResultSet = this.dbmd.getIndexInfo(this.sCatalogName, this.sSchemaName, this.sFtable, false, true);
            this.msg.setMsg("Call to columnCompare for the exact match of column names");
            test_status = this.columnCompare(sColumnNames, oRet_ResultSet);
            if (!test_status) {
                this.msg.printTestError("Columns return are not same either in order or name", "Call to getIndexInfo4 Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getIndexInfo4 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getIndexInfo4 is Failed!");
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.dbSch.destroyData(this.conn);
            this.dbSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

