/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.ee.javax_xml_registry.LifeCycleManager;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import com.sun.ts.tests.jaxr.common.JAXR_Util;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.Connection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;

public class JAXRClient
extends JAXRCommonClient {
    Locale tsLocale = new Locale("en", "US");
    RegistryService rs2 = null;
    BusinessLifeCycleManager blm2 = null;
    JAXR_Util util = null;
    Properties props;

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.props = p;
            super.setup(args, p);
            super.cleanUpRegistry();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            super.cleanup();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void lifeCycleManager_OrganizationDeleteObjectsTest() throws EETest.Fault {
        String testName = "lifeCycleManager_OrganizationDeleteObjectsTest()";
        String orgName = "TS Default Organization";
        Key orgKey2 = null;
        try {
            ArrayList<Organization> objects = new ArrayList<Organization>();
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            objects.add(org);
            BulkResponse br = this.blm.saveObjects(objects);
            if (!JAXR_Util.checkBulkResponse("saveObjects", br, this.debug)) {
                this.debug.add("Error:    saveOrganizations failed \n");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            Collection keys = br.getCollection();
            for (Key orgKey2 : keys) {
            }
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            Organization myOrg = (Organization)bqm.getRegistryObject(orgKey2.getId(), "Organization");
            if (!myOrg.getName().getValue(this.tsLocale).equals(orgName)) {
                throw new EETest.Fault(testName + "Error: organization was not created\n");
            }
            this.debug.add("Success: Organization was created\n");
            br = this.blm.deleteObjects(keys, "Organization");
            if (!JAXR_Util.checkBulkResponse("deleteObjects", br, this.debug)) {
                this.debug.add("Error:    deleteObjects failed \n");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            br = bqm.getRegistryObjects();
            if (!JAXR_Util.checkBulkResponse("getRegistryObjects", br, this.debug)) {
                this.debug.add("Error:    getRegistryObjects failed \n");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            Collection objs = br.getCollection();
            for (RegistryObject ro : objs) {
                if (!(ro instanceof Organization) || !ro.getKey().getId().equals(orgKey2.getId())) continue;
                throw new EETest.Fault(testName + "Error: organization was not deleted\n");
            }
        }
        catch (JAXRException je) {
            TestUtil.logErr((String)("Caught jaxr exception: " + je.getMessage()));
            TestUtil.printStackTrace((Throwable)je);
            throw new EETest.Fault(testName + "failed", je);
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    public void lifeCycleManager_ServiceSaveDeleteObjectsTest() throws EETest.Fault {
        String testName = "lifeCycleManager_ServiceSaveDeleteObjectsTest";
        String serviceName = "Service_saveDeleteObjectsTestForService";
        String orgName = "TS Default Organization";
        BulkResponse br = null;
        Key orgKey2 = null;
        Iterator iter = null;
        boolean pass = false;
        try {
            ArrayList<Service> services = new ArrayList<Service>();
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            Service service = this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName));
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org);
            br = this.blm.saveOrganizations(orgs);
            if (!JAXR_Util.checkBulkResponse("saveOrganization", br, this.debug)) {
                this.debug.add("Error:    saveOrganization failed \n");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            Collection orgKeys = br.getCollection();
            for (Key orgKey2 : orgKeys) {
            }
            br = bqm.getRegistryObjects(orgKeys, "Organization");
            if (br.getExceptions() != null) {
                this.debug.add("Error from saveOrganizations \n");
            }
            Collection myOrgs = br.getCollection();
            iter = myOrgs.iterator();
            Organization myOrg = null;
            while (iter.hasNext()) {
                myOrg = (Organization)iter.next();
                myOrg.addService(service);
                services.add(service);
            }
            br = this.blm.saveObjects(services);
            if (!JAXR_Util.checkBulkResponse("saveObjects", br, this.debug)) {
                this.debug.add("Error:    saveServices failed \n");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            Collection servicekeys = br.getCollection();
            ArrayList<String> serviceNames = new ArrayList<String>();
            serviceNames.add(serviceName);
            this.debug.add("And service count returns: " + this.serviceCount(orgKey2, serviceNames) + "\n");
            this.blm.deleteObjects(servicekeys, "Service");
            if (!JAXR_Util.checkBulkResponse("deleteObjects", br, this.debug)) {
                this.debug.add("Error:    deleteObjects failed \n");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            this.debug.add("deleteObject method called.  Service count should be 0\n");
            this.debug.add("Service count returns: " + this.serviceCount(orgKey2, serviceNames));
            if (this.serviceCount(orgKey2, serviceNames) == 0) {
                this.debug.add("Good service was deleted\n");
            } else {
                this.debug.add("Error: service was not deleted\n");
            }
            this.blm.deleteObjects(orgKeys, "Organization");
            if (!JAXR_Util.checkBulkResponse("deleteObjects", br, this.debug)) {
                this.debug.add("Error:    deleteObjects failed \n");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void lifeCycleManager_saveObjectsUpdateTest() throws EETest.Fault {
        String testName = "lifeCycleManager_saveObjectsUpdateTest()";
        String orgName = "TS Default Organization";
        String updOrgName = "MyUpdatedName";
        Collection keys = null;
        try {
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            ArrayList<Organization> objects = new ArrayList<Organization>();
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            objects.add(org);
            BulkResponse br = this.blm.saveObjects(objects);
            if (!JAXR_Util.checkBulkResponse("saveObjects", br, this.debug)) {
                this.debug.add("Error:    saveOrganizations failed \n");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            keys = br.getCollection();
            br = bqm.getRegistryObjects(keys, "Organization");
            Collection orgs = br.getCollection();
            Iterator iter = orgs.iterator();
            Organization myOrg = null;
            while (iter.hasNext()) {
                myOrg = (Organization)iter.next();
            }
            if (!myOrg.getName().getValue(this.tsLocale).equals(orgName)) {
                this.debug.add("Oops! org was not published!. Error!!.");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            this.debug.add("Good: org was published.  Now do an update.");
            myOrg.setName(this.blm.createInternationalString(this.tsLocale, updOrgName));
            objects.clear();
            objects.add(myOrg);
            br = this.blm.saveObjects(objects);
            if (!JAXR_Util.checkBulkResponse("saveObjects", br, this.debug)) {
                this.debug.add("Error:    saveOrganizations failed \n");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            br = bqm.getRegistryObjects(keys, "Organization");
            orgs = br.getCollection();
            iter = orgs.iterator();
            myOrg = null;
            while (iter.hasNext()) {
                myOrg = (Organization)iter.next();
            }
            if (!myOrg.getName().getValue(this.tsLocale).equals(updOrgName)) {
                this.debug.add("Oops! org was not updated!. Error!!.");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            this.debug.add("Good: org was updated.  ");
        }
        catch (Exception ue) {
            try {
                TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
                TestUtil.printStackTrace((Throwable)ue);
                throw new EETest.Fault(testName + "failed", ue);
            }
            catch (Throwable throwable) {
                try {
                    this.blm.deleteObjects(keys, "Organization");
                    throw throwable;
                }
                catch (JAXRException je) {
                    TestUtil.printStackTrace((Throwable)je);
                    this.debug.add("Warning: could not remove the organization\n");
                }
                throw throwable;
            }
        }
        try {
            this.blm.deleteObjects(keys, "Organization");
            return;
        }
        catch (JAXRException je) {
            TestUtil.printStackTrace((Throwable)je);
            this.debug.add("Warning: could not remove the organization\n");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void lifeCycleManager_saveMultiObjectsTest() throws EETest.Fault {
        String testName = "lifeCycleManager_saveMultiObjectsTest()";
        String orgName = "TS Default Organization";
        String serviceName = "myTestService";
        String updOrgName = "updatedOrgName";
        String updServiceName = "updatedTestService";
        Object keys = null;
        Collection orgKeys = null;
        Collection serviceKeys = null;
        try {
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            ArrayList<Object> objects = new ArrayList<Object>();
            Collection services = new ArrayList<Service>();
            Service service = this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName));
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            objects.add(org);
            BulkResponse br = this.blm.saveObjects(objects);
            if (!JAXR_Util.checkBulkResponse("saveObjects", br, this.debug)) {
                this.debug.add("Error:    saveObjects failed \n");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            this.debug.add("Good.  No errors were returned from saveObjects for organization \n");
            orgKeys = br.getCollection();
            br = bqm.getRegistryObjects(orgKeys, "Organization");
            if (br.getExceptions() != null) {
                this.debug.add("Error from saveOrganizations \n");
            }
            Collection myOrgs = br.getCollection();
            Iterator iter = myOrgs.iterator();
            Organization myOrg = null;
            while (iter.hasNext()) {
                myOrg = (Organization)iter.next();
                myOrg.addService(service);
                services.add(service);
            }
            br = this.blm.saveObjects(services);
            if (!JAXR_Util.checkBulkResponse("saveObjects", br, this.debug)) {
                this.debug.add("Error:    saveServices failed \n");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            serviceKeys = br.getCollection();
            this.debug.add("Good.  No errors were returned from saveObjects for service \n");
            br = bqm.getRegistryObjects(orgKeys, "Organization");
            Collection orgs = br.getCollection();
            iter = orgs.iterator();
            myOrg = null;
            while (iter.hasNext()) {
                myOrg = (Organization)iter.next();
            }
            myOrg.setName(this.blm.createInternationalString(this.tsLocale, updOrgName));
            br = bqm.getRegistryObjects(serviceKeys, "Service");
            services = br.getCollection();
            iter = services.iterator();
            Service myService = null;
            while (iter.hasNext()) {
                myService = (Service)iter.next();
            }
            myService.setName(this.blm.createInternationalString(this.tsLocale, updServiceName));
            objects.clear();
            objects.add(myOrg);
            objects.add(myService);
            br = this.blm.saveObjects(objects);
            if (!JAXR_Util.checkBulkResponse("saveObjects", br, this.debug)) {
                this.debug.add("Error:    saveObjects failed \n");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            br = bqm.getRegistryObjects(orgKeys, "Organization");
            orgs = br.getCollection();
            iter = orgs.iterator();
            myOrg = null;
            while (iter.hasNext()) {
                myOrg = (Organization)iter.next();
            }
            if (!myOrg.getName().getValue(this.tsLocale).equals(updOrgName)) {
                this.debug.add("Oops! org was not updated!. Error!!.");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            this.debug.add("Good: org was updated.  ");
            br = bqm.getRegistryObjects(serviceKeys, "Service");
            services = br.getCollection();
            iter = services.iterator();
            myService = null;
            while (iter.hasNext()) {
                myService = (Service)iter.next();
            }
            if (!myService.getName().getValue(this.tsLocale).equals(updServiceName)) {
                this.debug.add("Oops! Service was not updated!. Error!!.");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            this.debug.add("Good: service was updated.  ");
        }
        catch (Exception ue) {
            try {
                TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
                TestUtil.printStackTrace((Throwable)ue);
                throw new EETest.Fault(testName + "failed", ue);
            }
            catch (Throwable throwable) {
                try {
                    BulkResponse br3 = this.blm.deleteObjects(orgKeys, "Organization");
                    if (!JAXR_Util.checkBulkResponse("deleteObjects", br3, this.debug)) {
                        this.debug.add("Cleanup Error:    deleteObjects failed for Organization \n");
                    }
                    if (JAXR_Util.checkBulkResponse("deleteObjects", br3 = this.blm.deleteObjects(serviceKeys, "Service"), this.debug)) throw throwable;
                    this.debug.add("Cleanup Error:    deleteObjects failed for Service \n");
                    throw throwable;
                }
                catch (Exception ee) {
                    TestUtil.logErr((String)("Caught unexpected exception: " + ee.getMessage()));
                    TestUtil.printStackTrace((Throwable)ee);
                }
                throw throwable;
            }
        }
        try {
            BulkResponse br2 = this.blm.deleteObjects(orgKeys, "Organization");
            if (!JAXR_Util.checkBulkResponse("deleteObjects", br2, this.debug)) {
                this.debug.add("Cleanup Error:    deleteObjects failed for Organization \n");
            }
            if (JAXR_Util.checkBulkResponse("deleteObjects", br2 = this.blm.deleteObjects(serviceKeys, "Service"), this.debug)) return;
            this.debug.add("Cleanup Error:    deleteObjects failed for Service \n");
            return;
        }
        catch (Exception ee) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ee.getMessage()));
            TestUtil.printStackTrace((Throwable)ee);
            return;
        }
    }

    public void lifeCycleManager_saveObjectChangeCredTest() throws EETest.Fault {
        String testName = "lifeCycleManager_saveObjectChangeCredTest()";
        String orgName = "TS Default Organization";
        String updOrgName = "MyUpdatedName";
        Collection keys = null;
        boolean pass = false;
        try {
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            ArrayList<Organization> objects = new ArrayList<Organization>();
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            objects.add(org);
            BulkResponse br = this.blm.saveObjects(objects);
            if (!JAXR_Util.checkBulkResponse("saveObjects", br, this.debug)) {
                this.debug.add("Error:    saveOrganizations failed \n");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            keys = br.getCollection();
            br = bqm.getRegistryObjects(keys, "Organization");
            Collection orgs = br.getCollection();
            Iterator iter = orgs.iterator();
            Organization myOrg = null;
            while (iter.hasNext()) {
                myOrg = (Organization)iter.next();
            }
            if (!myOrg.getName().getValue(this.tsLocale).equals(orgName)) {
                this.debug.add("Oops! org was not published!. Error!!.");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            this.debug.add("Good: org was published.  Now change the user.");
            myOrg.setName(this.blm.createInternationalString(this.tsLocale, updOrgName));
            objects.clear();
            objects.add(myOrg);
            Set credentials = JAXR_Util.doCredentials(this.jaxrSecurityCredentialType, this.props, "user2");
            this.conn.setCredentials(credentials);
            this.rs = this.conn.getRegistryService();
            BusinessLifeCycleManager blm = this.rs.getBusinessLifeCycleManager();
            try {
                br = blm.saveObjects(objects);
                if (!JAXR_Util.checkBulkResponse("saveObjects", br, this.debug)) {
                    this.debug.add("Update to org from different user failed as expected");
                    pass = true;
                }
            }
            catch (Exception exx) {
                this.debug.add("Update to org from different user failed as expected");
                this.debug.add("Exception thrown:" + exx.getMessage());
            }
            credentials.clear();
            credentials = JAXR_Util.doCredentials(this.jaxrSecurityCredentialType, this.props, "user1");
            credentials.add(this.passwdAuth);
            this.conn.setCredentials(credentials);
            this.rs = this.conn.getRegistryService();
            blm = this.rs.getBusinessLifeCycleManager();
            br = blm.deleteObjects(keys, "Organization");
            if (!JAXR_Util.checkBulkResponse("deleteObjects", br, this.debug)) {
                this.debug.add("Cleanup Error:    deleteObjects failed \n");
            }
        }
        catch (Exception ue) {
            TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
            TestUtil.printStackTrace((Throwable)ue);
            throw new EETest.Fault(testName + "failed", ue);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void lifeCycleManager_deleteAssociationsTest() throws EETest.Fault {
        String testName = "lifeCycleManager_deleteAssociationsTest";
        String orgTarget = "Org Target";
        String orgSource = "Org Source";
        String type = "RelatedTo";
        BulkResponse br = null;
        Key savekey2222 = null;
        Key assockey = null;
        String objectType = "Organization";
        BusinessQueryManager bqm2 = null;
        Collection associationKeys = null;
        Collection sourceKeys = null;
        Collection targetKeys = null;
        String targetId = null;
        String sourceId = null;
        boolean pass = false;
        try {
            this.secondConnection();
            bqm2 = this.rs2.getBusinessQueryManager();
            this.debug.add("Create and publish a source and target organization \n");
            Organization target = this.blm2.createOrganization(this.blm.createInternationalString(this.tsLocale, orgTarget));
            Organization source = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgSource));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(source);
            br = this.blm.saveOrganizations(orgs);
            if (!JAXR_Util.checkBulkResponse("saveOrganizations", br, this.debug)) {
                this.debug.add("Error:    saveOrganizations failed \n");
                throw new EETest.Fault(testName + "did not complete due to errors");
            }
            sourceKeys = br.getCollection();
            Iterator iter = sourceKeys.iterator();
            while (iter.hasNext()) {
                this.debug.add("Saving the source key ");
                savekey2222 = (Key)iter.next();
            }
            sourceId = savekey2222.getId();
            this.debug.add("THe saved source key is " + sourceId);
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            Organization pubSource = (Organization)bqm.getRegistryObject(sourceId, objectType);
            this.debug.add("Verify the pub source retrieved from registry \n");
            this.debug.add("pubSource retrieved: " + pubSource.getName().getValue(this.tsLocale) + "\n");
            orgs.clear();
            orgs.add(target);
            br = this.blm2.saveOrganizations(orgs);
            if (!JAXR_Util.checkBulkResponse("saveOrganizations", br, this.debug)) {
                this.debug.add("Error:    saveOrganizations failed \n");
                throw new EETest.Fault(testName + "did not complete due to errors");
            }
            targetKeys = br.getCollection();
            for (Key savekey2222 : targetKeys) {
                this.debug.add("Saving the target key ");
            }
            targetId = savekey2222.getId();
            this.debug.add("THe saved target key is " + targetId);
            Organization pubTarget = (Organization)bqm2.getRegistryObject(targetId, objectType);
            this.debug.add("Verify the pub target retrieved from registry \n");
            this.debug.add("pubTarget retrieved: " + pubTarget.getName().getValue(this.tsLocale) + "\n");
            Concept associationType = this.getAssociationConcept(type);
            if (associationType == null) {
                throw new EETest.Fault(testName + " getAssociationConcept returned null associationType");
            }
            this.debug.add("create an association \n");
            Association a = this.blm2.createAssociation((RegistryObject)pubTarget, associationType);
            a.setSourceObject((RegistryObject)pubSource);
            this.debug.add("both users confirm the association");
            this.blm.confirmAssociation(a);
            this.blm2.confirmAssociation(a);
            ArrayList<Association> associations = new ArrayList<Association>();
            associations.add(a);
            br = this.blm2.saveAssociations(associations, false);
            associationKeys = br.getCollection();
            iter = associationKeys.iterator();
            Key assocKey = (Key)iter.next();
            this.debug.add("This is the key to the saved association: " + assocKey.getId());
            if (!JAXR_Util.checkBulkResponse("saveAssociations", br, this.debug)) {
                this.debug.add("Error:    saveAssociations failed \n");
                throw new EETest.Fault(testName + "did not complete due to errors");
            }
            br = bqm.findCallerAssociations(null, new Boolean(true), new Boolean(true), null);
            if (br.getExceptions() == null) {
                Collection results = br.getCollection();
                this.debug.add("Associations returned from findCallerAssociations is " + results.size() + "\n");
                if (results.size() > 0) {
                    iter = results.iterator();
                    a = null;
                    Association a1 = null;
                    while (iter.hasNext()) {
                        a1 = (Association)iter.next();
                        if (!a1.getKey().getId().equals(assocKey.getId())) continue;
                        this.debug.add(" found my key with findCallerAssociatons = " + a1.getKey().getId());
                        a = a1;
                        break;
                    }
                    if (a == null) {
                        throw new EETest.Fault(testName + "did not complete due to errors");
                    }
                    assockey = a1.getKey();
                    Organization o = (Organization)a1.getSourceObject();
                    this.debug.add("Source object " + o.getName().getValue(this.tsLocale) + "\n");
                    if (o.getName().getValue(this.tsLocale).equals(orgSource)) {
                        this.debug.add("Good - found association with findAssociation \n");
                    }
                    o = (Organization)a1.getTargetObject();
                    this.debug.add("Target object " + o.getName().getValue(this.tsLocale) + "\n");
                    Concept atype = a1.getAssociationType();
                    this.debug.add("type is " + atype.getName().getValue() + "\n");
                    this.debug.add("==================================\n");
                }
            }
            if (assockey != null) {
                ArrayList<Key> keys = new ArrayList<Key>();
                keys.add(assockey);
                this.debug.add("Now delete the association \n");
                this.blm2.deleteAssociations(keys);
                this.debug.add("Verify the delete - try to find the deleted associtaion \n");
                br = bqm.findCallerAssociations(null, new Boolean(true), new Boolean(true), null);
                if (br.getExceptions() == null) {
                    Collection retAssocs = br.getCollection();
                    iter = retAssocs.iterator();
                    a = null;
                    while (iter.hasNext()) {
                        Association ass = (Association)iter.next();
                        this.debug.add(" making sure my association is deleted");
                        if (!ass.getKey().getId().equals(assocKey.getId())) continue;
                        this.debug.add(" Found the deleted association -  this is unexpected");
                        this.debug.add(" Found this key " + ass.getKey().getId());
                        a = ass;
                        break;
                    }
                    if (a == null) {
                        this.debug.add("good - no association was found \n");
                        pass = true;
                    }
                }
            }
            if (!pass) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            try {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed ");
            }
            catch (Throwable throwable) {
                try {
                    this.debug.add(" Cleanup: Remove source organization\n");
                    this.blm.deleteOrganizations(sourceKeys);
                    this.debug.add(" Cleanup: Remove target organization\n");
                    this.blm2.deleteOrganizations(targetKeys);
                    throw throwable;
                }
                catch (JAXRException je) {
                    TestUtil.printStackTrace((Throwable)je);
                    this.debug.add("Error: not able to delete registry object\n");
                }
                throw throwable;
            }
        }
        try {
            this.debug.add(" Cleanup: Remove source organization\n");
            this.blm.deleteOrganizations(sourceKeys);
            this.debug.add(" Cleanup: Remove target organization\n");
            this.blm2.deleteOrganizations(targetKeys);
            return;
        }
        catch (JAXRException je) {
            TestUtil.printStackTrace((Throwable)je);
            this.debug.add("Error: not able to delete registry object\n");
            return;
        }
    }

    /*
     * Loose catch block
     */
    public void lifeCycleManager_deleteObjectsTest() throws EETest.Fault {
        block20: {
            String testName = "lifeCycleManager_deleteObjectsTest";
            String associationName = "associationSaveDeleteObjectsTest";
            String serviceName = "serviceSaveDeleteObjectsTest";
            Collection keys = null;
            int providerlevel = 0;
            providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
            ArrayList<Organization> objects = new ArrayList<Organization>();
            String orgName = "lifeCycleManager_deleteObjectsTest_organization";
            InternationalString iorgName = this.blm.createInternationalString(this.tsLocale, orgName);
            Organization org = this.blm.createOrganization(iorgName);
            objects.add(org);
            BulkResponse br = this.blm.saveObjects(objects);
            if (!JAXR_Util.checkBulkResponse("saveObjects", br, this.debug)) {
                this.debug.add("Error:    saveOrganizations failed \n");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            keys = br.getCollection();
            Iterator iter = keys.iterator();
            Key orgKey = null;
            while (iter.hasNext()) {
                orgKey = (Key)iter.next();
            }
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            Organization myOrg = (Organization)bqm.getRegistryObject(orgKey.getId(), "Organization");
            if (!myOrg.getName().getValue(this.tsLocale).equals(orgName)) {
                throw new EETest.Fault(testName + "Error: organization was not created\n");
            }
            this.debug.add("Success: Organization was created\n");
            br = this.blm.deleteObjects(keys);
            if (providerlevel == 0) {
                throw new EETest.Fault(testName + " expected UnsupportedCapabilityException \n");
            }
            if (!JAXR_Util.checkBulkResponse("deleteObjects", br, this.debug)) {
                this.debug.add("Error:    deleteObjects failed \n");
                throw new EETest.Fault(testName + " due to errors, test did not complete!");
            }
            Organization deletedOrg = (Organization)bqm.getRegistryObject(orgKey.getId(), "Organization");
            if (deletedOrg != null) {
                throw new EETest.Fault(testName + "Error: organization was not deleted\n");
            }
            this.debug.add("Success: Organization was deleted \n");
            this.debug.add("cleanup registry for level 0 - remove test organization\n");
            try {
                this.blm.deleteObjects(keys, "Organization");
            }
            catch (JAXRException je) {
                TestUtil.printStackTrace((Throwable)je);
                this.debug.add("Warning: could not remove the organization\n");
            }
            break block20;
            catch (UnsupportedCapabilityException uc) {
                if (providerlevel == 0) {
                    this.debug.add(" Call to deleteObjects(keys) threw UnsupportedCapabilityException as expected\n");
                    break block20;
                }
                throw new EETest.Fault(testName + " unexpected UnsupportedCapabilityException was caught \n", uc);
            }
            catch (Exception ue) {
                TestUtil.logErr((String)("Caught unexpected exception: " + ue.getMessage()));
                TestUtil.printStackTrace((Throwable)ue);
                throw new EETest.Fault(testName + "failed", ue);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.debug.add("cleanup registry for level 0 - remove test organization\n");
                try {
                    this.blm.deleteObjects(keys, "Organization");
                }
                catch (JAXRException je) {
                    TestUtil.printStackTrace((Throwable)je);
                    this.debug.add("Warning: could not remove the organization\n");
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void LifeCycleManager_deprecateObjectsTest() throws EETest.Fault {
        String testName = "LifeCycleManager_deprecateObjectsTest";
        int failcount = 0;
        Collection orgKeys = null;
        Collection serviceKeys = null;
        Collection myServiceKeys = null;
        Service service = null;
        Service myService = null;
        Organization myOrg = null;
        BusinessQueryManager bqm = null;
        int providerlevel = 0;
        ArrayList<String> debug = new ArrayList<String>();
        try {
            BulkResponse br;
            String serviceName = testName + "_service";
            bqm = this.rs.getBusinessQueryManager();
            debug.add("Create a service registryObject \n");
            service = this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName));
            orgKeys = new ArrayList();
            InternationalString iName = this.blm.createInternationalString(this.tsLocale, testName + "_organization");
            myOrg = this.blm.createOrganization(iName);
            orgKeys = this.saveMyOrg(myOrg);
            Iterator iter = orgKeys.iterator();
            Key orgKey = null;
            while (iter.hasNext()) {
                orgKey = (Key)iter.next();
            }
            myOrg = (Organization)bqm.getRegistryObject(orgKey.getId(), "Organization");
            myService = this.blm.createService(this.blm.createInternationalString(this.tsLocale, testName + "_myService"));
            myOrg.addService(myService);
            myServiceKeys = this.saveMyService(myService);
            if (myServiceKeys.size() == 0) {
                throw new EETest.Fault(testName + " due to save service errors , test did not complete!");
            }
            providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
            try {
                debug.add("Deprecate the service \n");
                br = this.blm.deprecateObjects(myServiceKeys);
                if (providerlevel == 0) {
                    debug.add("level 0 providers must throw UnsupportedCapabilityException \n");
                    throw new EETest.Fault(testName + " failed");
                }
                serviceKeys = this.saveMyService(service);
                br = this.blm.deprecateObjects(serviceKeys);
                boolean IllegalStateExceptionThrown = false;
                try {
                    myOrg.addService(service);
                }
                catch (IllegalStateException is) {
                    TestUtil.printStackTrace((Throwable)is);
                    IllegalStateExceptionThrown = true;
                    debug.add("IllegalStateException was thrown!!\n");
                }
                if (!IllegalStateExceptionThrown) {
                    failcount = 1;
                    failcount = 1;
                    debug.add("Expected IllegalStateException was not thrown\n");
                }
            }
            catch (UnsupportedCapabilityException uce) {
                TestUtil.printStackTrace((Throwable)uce);
                if (providerlevel != 0) {
                    failcount = 1;
                    failcount = 1;
                }
                debug.add("UnsupportedCapabilityException was thrown!!\n");
            }
            catch (Exception uk) {
                debug.add("Error: unexpected exception was thrown\n");
                TestUtil.printStackTrace((Throwable)uk);
                ++failcount;
            }
            debug.add("invoke unDeprecateObjects\n");
            try {
                br = this.blm.unDeprecateObjects(myServiceKeys);
                if (providerlevel == 0) {
                    debug.add("level 0 providers must throw UnsupportedCapabilityException \n");
                    throw new EETest.Fault(testName + " failed");
                }
                br = this.blm.unDeprecateObjects(serviceKeys);
                myOrg.addService(service);
                this.saveMyOrg(myOrg);
                Collection services = myOrg.getServices();
                for (Service s : services) {
                    debug.add("my org has this service: " + s.getName().getValue(this.tsLocale) + "\n");
                }
            }
            catch (IllegalStateException is) {
                TestUtil.printStackTrace((Throwable)is);
                ++failcount;
                debug.add("IllegalStateException was thrown!!\n");
            }
            catch (UnsupportedCapabilityException uce) {
                TestUtil.printStackTrace((Throwable)uce);
                if (providerlevel != 0) {
                    ++failcount;
                }
                debug.add("UnsupportedCapabilityException was thrown!!\n");
            }
            catch (Exception uk) {
                debug.add("Error: unexpected exception was thrown\n");
                TestUtil.printStackTrace((Throwable)uk);
                ++failcount;
            }
            debug.add("cleanup registry - remove test organization\n");
        }
        catch (JAXRException e) {
            try {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + "failed", e);
                catch (Exception ue) {
                    TestUtil.logErr((String)("Caught exception: " + ue.getMessage()));
                    TestUtil.printStackTrace((Throwable)ue);
                    throw new EETest.Fault(testName + "failed", ue);
                }
            }
            catch (Throwable throwable) {
                debug.add("cleanup registry - remove test organization\n");
                try {
                    if (providerlevel != 0) {
                        this.blm.deleteServices(serviceKeys);
                    }
                    this.blm.deleteServices(myServiceKeys);
                    this.blm.deleteOrganizations(orgKeys);
                    if (debug == null) throw throwable;
                    TestUtil.logTrace((String)((Object)debug).toString());
                    throw throwable;
                }
                catch (JAXRException je) {
                    TestUtil.printStackTrace((Throwable)je);
                    debug.add("Warning: could not remove the organization\n");
                }
                throw throwable;
            }
        }
        try {
            if (providerlevel != 0) {
                this.blm.deleteServices(serviceKeys);
            }
            this.blm.deleteServices(myServiceKeys);
            this.blm.deleteOrganizations(orgKeys);
            if (debug != null) {
                TestUtil.logTrace((String)((Object)debug).toString());
            }
        }
        catch (JAXRException je) {
            TestUtil.printStackTrace((Throwable)je);
            debug.add("Warning: could not remove the organization\n");
        }
        if (failcount == 0) return;
        throw new EETest.Fault(testName + "failed ");
    }

    private int serviceCount(Key orgKey, Collection services) {
        try {
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            BulkResponse br = bqm.findServices(orgKey, null, services, null, null);
            if (!JAXR_Util.checkBulkResponse("findServices ", br, this.debug)) {
                this.debug.add("Error reported - findServices failed \n");
                return -1;
            }
            Collection s = br.getCollection();
            return s.size();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            return -1;
        }
    }

    private Concept getAssociationConcept(String associationType) {
        ArrayList<String> atypes = new ArrayList<String>();
        atypes.add("AssociationType");
        try {
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            Collection associationTypes = bqm.findClassificationSchemes(null, atypes, null, null).getCollection();
            for (ClassificationScheme cs : associationTypes) {
                Collection types = cs.getChildrenConcepts();
                Iterator iter1 = types.iterator();
                Concept concept = null;
                while (iter1.hasNext()) {
                    concept = (Concept)iter1.next();
                    if (!concept.getName().getValue(this.tsLocale).equals(associationType)) continue;
                    return concept;
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.debug.add("getAssociationConcept caught an error!\n");
            return null;
        }
        return null;
    }

    private void secondConnection() throws EETest.Fault {
        Connection srcConnection = null;
        try {
            srcConnection = this.factory.createConnection();
            Set<PasswordAuthentication> credentials = null;
            switch (this.jaxrSecurityCredentialType) {
                case 0: {
                    credentials = new HashSet();
                    PasswordAuthentication passwdAuth = new PasswordAuthentication(this.jaxrUser2, this.jaxrPassword2.toCharArray());
                    credentials.add(passwdAuth);
                    break;
                }
                case 1: {
                    credentials = super.getDigitalCertificateCredentials(this.jaxrAlias2, this.jaxrAlias2Password);
                    break;
                }
                default: {
                    throw new EETest.Fault("second connection failed: jaxrSecurityCredentialType is invalid");
                }
            }
            srcConnection.setCredentials(credentials);
            this.rs2 = srcConnection.getRegistryService();
            this.blm2 = this.rs2.getBusinessLifeCycleManager();
        }
        catch (Exception e) {
            throw new EETest.Fault("Exception in secondConnection method", e);
        }
    }

    private Collection saveMyService(Service service) {
        ArrayList<Service> services = new ArrayList<Service>();
        Collection serviceKeys = null;
        services.add(service);
        try {
            BulkResponse br = this.blm.saveServices(services);
            if (br.getExceptions() != null) {
                this.debug.add("Error:   saveServices failed \n");
                return null;
            }
            serviceKeys = br.getCollection();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return serviceKeys;
    }

    private Collection saveMyOrg(Organization org) {
        ArrayList<Organization> orgs = new ArrayList<Organization>();
        Collection orgKeys = null;
        orgs.add(org);
        try {
            BulkResponse br = this.blm.saveOrganizations(orgs);
            if (br.getExceptions() != null) {
                this.debug.add("Error:   saveOrganizations failed \n");
                return null;
            }
            orgKeys = br.getCollection();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return orgKeys;
    }
}

