/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_holders.BigDecimalHolder;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import java.math.BigDecimal;
import java.util.Properties;
import javax.xml.rpc.holders.BigDecimalHolder;

public class Client
extends ServiceEETest {
    private Properties props = null;
    private static final BigDecimal myBigDecimal = new BigDecimal("3512359.1456");

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void BigDecimalHolderConstructorTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"BigDecimalHolderConstructorTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via BigDecimalHolder() ...");
            BigDecimalHolder n = new BigDecimalHolder();
            if (n != null) {
                TestUtil.logMsg((String)"BigDecimalHolder object created successfully");
            } else {
                TestUtil.logErr((String)"BigDecimalHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("BigDecimalHolderConstructorTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("BigDecimalHolderConstructorTest1 failed");
        }
    }

    public void BigDecimalHolderConstructorTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"BigDecimalHolderConstructorTest2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via BigDecimalHolder(BigDecimal) ...");
            BigDecimalHolder n = new BigDecimalHolder(myBigDecimal);
            if (n != null) {
                TestUtil.logMsg((String)"BigDecimalHolder object created successfully");
            } else {
                TestUtil.logErr((String)"BigDecimalHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("BigDecimalHolderConstructorTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("BigDecimalHolderConstructorTest2 failed");
        }
    }

    public void getValueTest() throws EETest.Fault {
        TestUtil.logTrace((String)"getValueTest");
        boolean pass = true;
        if (!this.getValueTest1()) {
            pass = false;
        }
        if (!this.getValueTest2()) {
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("getValueTest failed");
        }
    }

    private boolean getValueTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"getValueTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via BigDecimalHolder() ...");
            BigDecimalHolder n = new BigDecimalHolder();
            if (n != null) {
                BigDecimal v = n.value;
                if (v == null) {
                    TestUtil.logMsg((String)"Value set to null as expected");
                } else {
                    TestUtil.logErr((String)("Value: expected - null, received - " + v));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"BigDecimalHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    private boolean getValueTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"getValueTest2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create instance via BigDecimalHolder(BigDecimal) ...");
            BigDecimalHolder n = new BigDecimalHolder(myBigDecimal);
            if (n != null) {
                BigDecimal v = n.value;
                if (v.equals(myBigDecimal)) {
                    TestUtil.logMsg((String)("Value set as expected to " + myBigDecimal));
                } else {
                    TestUtil.logErr((String)("Value: expected - " + myBigDecimal + ", received - " + v));
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"BigDecimalHolder object not created");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }
}

