/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.servlet.ee.platform.negdep.urlpattern.ee;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.negdep.NegdepUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;

public class urlPatternClient
extends ServiceEETest {
    protected NegdepUtil ndu;
    protected String baseAppDir;
    protected Properties testProps;

    public static void main(String[] args) {
        urlPatternClient theTests = new urlPatternClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logMsg((String)"Setup");
        this.testProps = p;
        this.baseAppDir = this.testProps.getProperty("ts_home") + "/src/com/sun/ts/tests/servlet/ee/platform/negdep/urlpattern/apps/";
        this.ndu = new NegdepUtil(this.testProps);
    }

    public void cleanup() throws EETest.Fault {
        this.ndu.cleanup();
    }

    public void urlPatternNewlineTest() throws EETest.Fault {
        TestUtil.logMsg((String)"Starting urlPatternNewlineTest");
        boolean pass = false;
        String appDir = this.baseAppDir + "newline/";
        String badModuleName = appDir + "BadNewline.war";
        String goodModuleName = appDir + "GoodNewline.war";
        String badPlanName = appDir + "servlet_ee_platform_negdep_urlpattern_apps_badnewline_web.war.sun-web.xml";
        String goodPlanName = appDir + "servlet_ee_platform_negdep_urlpattern_apps_goodnewline_web.war.sun-web.xml";
        try {
            FileInputStream badModuleStream = new FileInputStream(new File(badModuleName));
            FileInputStream goodModuleStream = new FileInputStream(new File(goodModuleName));
            InputStream badPlanStream = this.ndu.getDeploymentPlan(badModuleName, new String[]{badPlanName});
            InputStream goodPlanStream = this.ndu.getDeploymentPlan(goodModuleName, new String[]{goodPlanName});
            if (goodPlanStream == null || badPlanStream == null) {
                throw new EETest.Fault("Failed: Null deployment plan received");
            }
            pass = this.ndu.negativeTestDistributeModule(badModuleStream, badPlanStream);
            this.logTrace("pass after bad module is " + pass);
            if (pass) {
                pass = this.ndu.positiveTestDistributeModule(goodModuleStream, goodPlanStream);
                this.logTrace("pass after good module is " + pass);
            }
            if (!pass) {
                throw new EETest.Fault("Failed: urlPatternNewlineTest");
            }
            this.logMsg("Passed: urlPatternNewlineTest");
        }
        catch (Exception ex) {
            TestUtil.printStackTrace((Throwable)ex);
            throw new EETest.Fault("Failed: " + ex.getMessage());
        }
    }
}

