/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.parser;

import com.sun.ts.tests.interop.csiv2.common.parser.Entry;
import com.sun.ts.tests.interop.csiv2.common.parser.IOREntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ParseException;
import com.sun.ts.tests.interop.csiv2.common.parser.ReplyServiceContextEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.RequestServiceContextEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ServerEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ServerInterceptorEntry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClientInterceptorEntry
extends Entry {
    private ServerEntry server;
    private String operation;
    private boolean sslUsed;
    private ServerInterceptorEntry serverInterceptor;
    private boolean locationForward;
    private RequestServiceContextEntry requestServiceContext;
    private ReplyServiceContextEntry replyServiceContext;
    private IOREntry ior;
    private ClientInterceptorEntry clientInterceptor;

    public ClientInterceptorEntry(Element element) throws ParseException {
        if (!element.getTagName().equals("client-interceptor")) {
            throw new ParseException("Unexpected tag: " + element.getTagName());
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("operation")) {
                this.operation = this.getText(node);
                continue;
            }
            if (node.getNodeName().equals("req-svc-context")) {
                this.requestServiceContext = new RequestServiceContextEntry((Element)node);
                continue;
            }
            if (node.getNodeName().equals("ssl-used")) {
                this.sslUsed = this.getText(node).equals("true");
                continue;
            }
            if (node.getNodeName().equals("ior")) {
                this.ior = new IOREntry((Element)node);
                continue;
            }
            if (node.getNodeName().equals("server-interceptor")) {
                this.serverInterceptor = new ServerInterceptorEntry((Element)node);
                continue;
            }
            if (node.getNodeName().equals("server")) {
                this.server = new ServerEntry((Element)node);
                continue;
            }
            if (node.getNodeName().equals("location-forward")) {
                this.locationForward = this.getText(node).equals("true");
                continue;
            }
            if (node.getNodeName().equals("reply-svc-context")) {
                this.replyServiceContext = new ReplyServiceContextEntry((Element)node);
                continue;
            }
            if (!node.getNodeName().equals("client-interceptor")) continue;
            this.clientInterceptor = new ClientInterceptorEntry((Element)node);
        }
    }

    public ServerInterceptorEntry getServerInterceptor() {
        return this.serverInterceptor;
    }

    public ServerEntry getServer() {
        return this.server;
    }

    public String getOperation() {
        return this.operation;
    }

    public RequestServiceContextEntry getRequestServiceContext() {
        return this.requestServiceContext;
    }

    public boolean isSslUsed() {
        return this.sslUsed;
    }

    public boolean isLocationForward() {
        return this.locationForward;
    }

    public ReplyServiceContextEntry getReplyServiceContext() {
        return this.replyServiceContext;
    }

    public ClientInterceptorEntry getClientInterceptor() {
        return this.clientInterceptor;
    }

    public String toString() {
        String result = "<client-interceptor>\n";
        result = result + "<operation>" + this.operation + "</operation>\n";
        result = result + this.requestServiceContext.toString();
        result = result + "<ssl-used>" + this.sslUsed + "</ssl-used>\n";
        result = result + this.ior.toString();
        if (this.serverInterceptor != null) {
            result = result + this.serverInterceptor.toString();
        }
        if (this.server != null) {
            result = result + this.server.toString();
        }
        result = result + "<location-forward>" + this.locationForward + "</location-forward>\n";
        result = result + this.replyServiceContext.toString();
        if (this.clientInterceptor != null) {
            result = result + "<client-interceptor>\n" + this.clientInterceptor.toString() + "</client-interceptor>\n";
        }
        result = result + "</client-interceptor>\n";
        return result;
    }

    public IOREntry getIor() {
        return this.ior;
    }
}

