/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.appclient.messageproducertests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.InvalidTextMessageTestImpl;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.core20.appclient.messageproducertests.MyCompletionListener;
import java.util.Properties;
import javax.jms.CompletionListener;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageFormatException;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;

public class Client
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core20.messageproducertests.Client";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private transient JmsTool toolForProducer = null;
    transient MessageProducer producer = null;
    transient MessageConsumer consumer = null;
    transient Connection connection = null;
    transient Session session = null;
    transient Destination destination = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    private static final int numMessages = 3;
    private static final int iterations = 5;
    boolean queueTest = false;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            TestUtil.logMsg((String)"Didn't get expected exception");
            throw new Exception("Didn't get expected exception");
        }
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            TestUtil.logMsg((String)"Closing default Connection");
            this.tool.getDefaultConnection().close();
            if (this.queueTest) {
                TestUtil.logMsg((String)"Flush any messages left on Queue");
                this.tool.flushDestination();
            }
            this.tool.closeAllResources();
            if (this.toolForProducer != null) {
                this.toolForProducer.getDefaultConnection().close();
                if (this.queueTest) {
                    TestUtil.logMsg((String)"Flush any messages left on Queue");
                    this.toolForProducer.flushDestination();
                }
                this.toolForProducer.closeAllResources();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("cleanup failed!", e);
        }
    }

    public void queueSendRecvCompletionListenerTest1() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueSendRecvCompletionListenerTest1");
            MyCompletionListener listener = new MyCompletionListener();
            TestUtil.logMsg((String)"Calling send(Destination,Message,CompletionListener)");
            this.producer.send(this.destination, (Message)expTextMessage, (CompletionListener)listener);
            TestUtil.logMsg((String)"Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("queueSendRecvCompletionListenerTest1", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("queueSendRecvCompletionListenerTest1 failed");
        }
    }

    public void queueSendRecvCompletionListenerTest2() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueSendRecvCompletionListenerTest2");
            MyCompletionListener listener = new MyCompletionListener();
            TestUtil.logMsg((String)"Calling send(Destination,Message,int,int,long,CompletionListener)");
            this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L, (CompletionListener)listener);
            TestUtil.logMsg((String)"Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the values in TextMessage, deliverymode, priority, time to live");
            if (!actTextMessage.getText().equals(expTextMessage.getText()) || actTextMessage.getJMSDeliveryMode() != 1 || actTextMessage.getJMSPriority() != 4 || actTextMessage.getJMSExpiration() != 0L) {
                TestUtil.logErr((String)"Didn't get the right message.");
                TestUtil.logErr((String)("text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText()));
                TestUtil.logErr((String)("DeliveryMode=" + actTextMessage.getJMSDeliveryMode() + ", expected " + expTextMessage.getJMSDeliveryMode()));
                TestUtil.logErr((String)("Priority=" + actTextMessage.getJMSPriority() + ", expected " + expTextMessage.getJMSPriority()));
                TestUtil.logErr((String)("TimeToLive=" + actTextMessage.getJMSExpiration() + ", expected " + expTextMessage.getJMSExpiration()));
                pass = false;
            } else {
                TestUtil.logMsg((String)"TextMessage is correct");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("queueSendRecvCompletionListenerTest2", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("queueSendRecvCompletionListenerTest2 failed");
        }
    }

    public void queueSendRecvCompletionListenerTest3() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueSendRecvCompletionListenerTest3");
            MyCompletionListener listener = new MyCompletionListener();
            TestUtil.logMsg((String)"Calling send(Message,CompletionListener)");
            this.producer.send((Message)expTextMessage, (CompletionListener)listener);
            TestUtil.logMsg((String)"Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("queueSendRecvCompletionListenerTest3", e);
        }
        if (!pass) {
            throw new EETest.Fault("queueSendRecvCompletionListenerTest3 failed");
        }
    }

    public void queueSendRecvCompletionListenerTest4() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = true;
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueSendRecvCompletionListeneTest4");
            MyCompletionListener listener = new MyCompletionListener();
            TestUtil.logMsg((String)"Calling send(Message,int,int,long,CompletionListener)");
            this.producer.send((Message)expTextMessage, 2, 4, 0L, (CompletionListener)listener);
            TestUtil.logMsg((String)"Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the values in TextMessage, deliverymode, priority, time to live");
            if (!actTextMessage.getText().equals(expTextMessage.getText()) || actTextMessage.getJMSDeliveryMode() != 2 || actTextMessage.getJMSPriority() != 4 || actTextMessage.getJMSExpiration() != 0L) {
                TestUtil.logErr((String)"Didn't get the right message.");
                TestUtil.logErr((String)("text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText()));
                TestUtil.logErr((String)("DeliveryMode=" + actTextMessage.getJMSDeliveryMode() + ", expected " + expTextMessage.getJMSDeliveryMode()));
                TestUtil.logErr((String)("Priority=" + actTextMessage.getJMSPriority() + ", expected " + expTextMessage.getJMSPriority()));
                TestUtil.logErr((String)("TimeToLive=" + actTextMessage.getJMSExpiration() + ", expected " + expTextMessage.getJMSExpiration()));
                pass = false;
            } else {
                TestUtil.logMsg((String)"TextMessage is correct");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("queueSendRecvCompletionListenerTest4", e);
        }
        if (!pass) {
            throw new EETest.Fault("queueSendRecvCompletionListenerTest4 failed");
        }
    }

    public void queueJMSExceptionTests() throws EETest.Fault {
        boolean pass;
        block19: {
            pass = true;
            Object tempMsg = null;
            String message = "Where are you!";
            try {
                int i;
                Exception exception;
                TestUtil.logMsg((String)"Setup JmsTool for COMMON QUEUE");
                this.tool = new JmsTool(13, this.user, this.password, this.mode);
                this.tool.getDefaultProducer().close();
                this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
                this.consumer = this.tool.getDefaultConsumer();
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = this.tool.getDefaultDestination();
                this.connection.start();
                this.queueTest = true;
                TestUtil.logMsg((String)"Creating TextMessage");
                TextMessage expTextMessage = this.session.createTextMessage(message);
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueJMSExceptionTests");
                MyCompletionListener listener = new MyCompletionListener();
                try {
                    TestUtil.logMsg((String)"Try and set an invalid mode of -1 on send");
                    this.producer.send(this.destination, (Message)expTextMessage, -1, 4, 0L, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof JMSException) {
                            TestUtil.logMsg((String)"Exception is expected JMSException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected JMSException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (JMSException e) {
                    TestUtil.logMsg((String)"Caught expected JMSException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected JMSException, received " + e));
                    pass = false;
                }
                try {
                    TestUtil.logMsg((String)"Try and set an invalid priority of -1 on send");
                    this.producer.send(this.destination, (Message)expTextMessage, 1, -1, 0L, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                        break block19;
                    }
                    TestUtil.logMsg((String)"Check the value in Exception");
                    if (exception instanceof JMSException) {
                        TestUtil.logMsg((String)"Exception is expected JMSException");
                        break block19;
                    }
                    TestUtil.logErr((String)("Exception is incorrect expected JMSException, received " + exception.getCause()));
                    pass = false;
                }
                catch (JMSException e) {
                    TestUtil.logMsg((String)"Caught expected JMSException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected JMSException, received " + e));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e));
                throw new EETest.Fault("queueJMSExceptionTests", e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("queueJMSExceptionTests failed");
        }
    }

    public void queueInvalidDestinationExceptionTests() throws EETest.Fault {
        boolean pass;
        block28: {
            pass = true;
            Object tempMsg = null;
            String message = "Where are you!";
            try {
                int i;
                Exception exception;
                TestUtil.logMsg((String)"Setup JmsTool for COMMON QUEUE");
                this.tool = new JmsTool(13, this.user, this.password, this.mode);
                this.toolForProducer = new JmsTool(13, this.user, this.password, this.mode);
                this.producer = this.toolForProducer.getDefaultProducer();
                this.consumer = this.tool.getDefaultConsumer();
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = null;
                this.connection.start();
                this.queueTest = true;
                MyCompletionListener listener = new MyCompletionListener();
                TestUtil.logMsg((String)"Creating TextMessage");
                TextMessage expTextMessage = this.session.createTextMessage(message);
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueInvalidDestinationExceptionTests");
                try {
                    TestUtil.logMsg((String)"Send message with invalid destination");
                    this.producer.send(this.destination, (Message)expTextMessage, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof InvalidDestinationException) {
                            TestUtil.logMsg((String)"Exception is expected InvalidDestinationException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected InvalidDestinationException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (InvalidDestinationException e) {
                    TestUtil.logMsg((String)"Caught expected InvalidDestinationException");
                }
                catch (UnsupportedOperationException e) {
                    TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected InvalidDestinationException, received " + e));
                    pass = false;
                }
                try {
                    TestUtil.logMsg((String)"Send message with invalid destination");
                    this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                        break block28;
                    }
                    TestUtil.logMsg((String)"Check the value in Exception");
                    if (exception instanceof InvalidDestinationException) {
                        TestUtil.logMsg((String)"Exception is expected InvalidDestinationException");
                        break block28;
                    }
                    TestUtil.logErr((String)("Exception is incorrect expected InvalidDestinationException, received " + exception.getCause()));
                    pass = false;
                }
                catch (InvalidDestinationException e) {
                    TestUtil.logMsg((String)"Caught expected InvalidDestinationException");
                }
                catch (UnsupportedOperationException e) {
                    TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected InvalidDestinationException, received " + e));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e));
                throw new EETest.Fault("queueInvalidDestinationExceptionTests", e);
            }
            finally {
                try {
                    this.producer.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new EETest.Fault("queueInvalidDestinationExceptionTests failed");
        }
    }

    public void queueUnsupportedOperationExceptionTests() throws EETest.Fault {
        boolean pass;
        block44: {
            pass = true;
            Object tempMsg = null;
            String message = "Where are you!";
            try {
                int i;
                Exception exception;
                TestUtil.logMsg((String)"Setup JmsTool for COMMON QUEUE");
                this.tool = new JmsTool(13, this.user, this.password, this.mode);
                this.producer = this.tool.getDefaultProducer();
                this.consumer = this.tool.getDefaultConsumer();
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = this.tool.getDefaultDestination();
                this.connection.start();
                this.queueTest = true;
                MyCompletionListener listener = new MyCompletionListener();
                TestUtil.logMsg((String)"Creating TextMessage");
                TextMessage expTextMessage = this.session.createTextMessage(message);
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueUnsupportedOperationExceptionTests");
                try {
                    TestUtil.logMsg((String)"Send message with invalid destination");
                    this.producer.send(this.destination, (Message)expTextMessage, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof UnsupportedOperationException) {
                            TestUtil.logMsg((String)"Exception is expected UnsupportedOperationException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected UnsupportedOperationException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (UnsupportedOperationException e) {
                    TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected UnsupportedOperationException, received " + e));
                    pass = false;
                }
                try {
                    TestUtil.logMsg((String)"Send message with invalid destination");
                    this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof UnsupportedOperationException) {
                            TestUtil.logMsg((String)"Exception is expected UnsupportedOperationException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected UnsupportedOperationException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (UnsupportedOperationException e) {
                    TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected UnsupportedOperationException, received " + e));
                    pass = false;
                }
                this.tool.getDefaultProducer().close();
                this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
                try {
                    TestUtil.logMsg((String)"Send message with invalid destination");
                    this.producer.send((Message)expTextMessage, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof UnsupportedOperationException) {
                            TestUtil.logMsg((String)"Exception is expected UnsupportedOperationException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected UnsupportedOperationException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (UnsupportedOperationException e) {
                    TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected UnsupportedOperationException, received " + e));
                    pass = false;
                }
                try {
                    TestUtil.logMsg((String)"Send message with invalid destination");
                    this.producer.send((Message)expTextMessage, 1, 4, 0L, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                        break block44;
                    }
                    TestUtil.logMsg((String)"Check the value in Exception");
                    if (exception instanceof UnsupportedOperationException) {
                        TestUtil.logMsg((String)"Exception is expected UnsupportedOperationException");
                        break block44;
                    }
                    TestUtil.logErr((String)("Exception is incorrect expected UnsupportedOperationException, received " + exception.getCause()));
                    pass = false;
                }
                catch (UnsupportedOperationException e) {
                    TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected UnsupportedOperationException, received " + e));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e));
                throw new EETest.Fault("queueUnsupportedOperationExceptionTests", e);
            }
            finally {
                try {
                    this.producer.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new EETest.Fault("queueUnsupportedOperationExceptionTests failed");
        }
    }

    public void queueIllegalArgumentExceptionTests() throws EETest.Fault {
        boolean pass;
        block44: {
            pass = true;
            Object tempMsg = null;
            String message = "Where are you!";
            try {
                int i;
                Exception exception;
                TestUtil.logMsg((String)"Setup JmsTool for COMMON QUEUE");
                this.tool = new JmsTool(13, this.user, this.password, this.mode);
                this.tool.getDefaultProducer().close();
                this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
                this.consumer = this.tool.getDefaultConsumer();
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = this.tool.getDefaultDestination();
                this.connection.start();
                this.queueTest = false;
                MyCompletionListener listener = new MyCompletionListener();
                TestUtil.logMsg((String)"Creating TextMessage");
                TextMessage expTextMessage = this.session.createTextMessage(message);
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueIllegalArgumentExceptionTests");
                try {
                    TestUtil.logMsg((String)"Send message with null CompletionListener");
                    this.producer.send(this.destination, (Message)expTextMessage, null);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof IllegalArgumentException) {
                            TestUtil.logMsg((String)"Exception is expected IllegalArgumentException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected IllegalArgumentException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    TestUtil.logMsg((String)"Caught expected IllegalArgumentException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected IllegalArgumentException, received " + e));
                    pass = false;
                }
                try {
                    TestUtil.logMsg((String)"Send message with null CompletionListener");
                    this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L, null);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof IllegalArgumentException) {
                            TestUtil.logMsg((String)"Exception is expected IllegalArgumentException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected IllegalArgumentException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    TestUtil.logMsg((String)"Caught expected IllegalArgumentException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected IllegalArgumentException, received " + e));
                    pass = false;
                }
                this.producer.close();
                this.producer = this.tool.getDefaultSession().createProducer(this.destination);
                try {
                    TestUtil.logMsg((String)"Send message with null CompletionListener");
                    this.producer.send((Message)expTextMessage, null);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof IllegalArgumentException) {
                            TestUtil.logMsg((String)"Exception is expected IllegalArgumentException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected IllegalArgumentException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    TestUtil.logMsg((String)"Caught expected IllegalArgumentException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected IllegalArgumentException, received " + e));
                    pass = false;
                }
                try {
                    TestUtil.logMsg((String)"Send message with null CompletionListener");
                    this.producer.send((Message)expTextMessage, 1, 4, 0L, null);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                        break block44;
                    }
                    TestUtil.logMsg((String)"Check the value in Exception");
                    if (exception instanceof IllegalArgumentException) {
                        TestUtil.logMsg((String)"Exception is expected IllegalArgumentException");
                        break block44;
                    }
                    TestUtil.logErr((String)("Exception is incorrect expected IllegalArgumentException, received " + exception.getCause()));
                    pass = false;
                }
                catch (IllegalArgumentException e) {
                    TestUtil.logMsg((String)"Caught expected IllegalArgumentException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected IllegalArgumentException, received " + e));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e));
                throw new EETest.Fault("queueIllegalArgumentExceptionTests", e);
            }
            finally {
                try {
                    this.producer.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new EETest.Fault("queueIllegalArgumentExceptionTests failed");
        }
    }

    public void queueMessageFormatExceptionTests() throws EETest.Fault {
        boolean pass;
        block37: {
            pass = true;
            try {
                int i;
                Exception exception;
                this.tool = new JmsTool(13, this.user, this.password, this.mode);
                this.producer = this.tool.getDefaultProducer();
                this.consumer = this.tool.getDefaultConsumer();
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = this.tool.getDefaultDestination();
                this.connection.start();
                this.queueTest = true;
                InvalidTextMessageTestImpl invalidTMsg = new InvalidTextMessageTestImpl();
                invalidTMsg.setText("hello");
                MyCompletionListener listener = new MyCompletionListener();
                try {
                    TestUtil.logMsg((String)"Calling MessageProducer.send(Message, CompletionListener) -> expect MessageFormatException");
                    this.producer.send((Message)invalidTMsg, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof MessageFormatException) {
                            TestUtil.logMsg((String)"Exception is expected MessageFormatException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected MessageFormatException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (MessageFormatException e) {
                    TestUtil.logMsg((String)"Got MessageFormatException as expected.");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected MessageFormatException, received " + e));
                    pass = false;
                }
                try {
                    TestUtil.logMsg((String)"Calling MessageProducer.send(Message, int, int, long, CompletionListener) -> expect MessageFormatException");
                    this.producer.send((Message)invalidTMsg, 2, 3, 0L, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof MessageFormatException) {
                            TestUtil.logMsg((String)"Exception is expected MessageFormatException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected MessageFormatException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (MessageFormatException e) {
                    TestUtil.logMsg((String)"Got MessageFormatException as expected.");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected MessageFormatException, received " + e));
                    pass = false;
                }
                this.tool.getDefaultProducer().close();
                this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
                try {
                    TestUtil.logMsg((String)"Calling MessageProducer.send(Destination, Message, CompletionListener) -> expect MessageFormatException");
                    this.producer.send(this.destination, (Message)invalidTMsg, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof MessageFormatException) {
                            TestUtil.logMsg((String)"Exception is expected MessageFormatException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected MessageFormatException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (MessageFormatException e) {
                    TestUtil.logMsg((String)"Got MessageFormatException as expected.");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected MessageFormatException, received " + e));
                    pass = false;
                }
                try {
                    TestUtil.logMsg((String)"Calling MessageProducer.send(Destination, Message, int, int, long, CompletionListener) -> expect MessageFormatException");
                    this.producer.send(this.destination, (Message)invalidTMsg, 2, 3, 0L, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 30; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                        break block37;
                    }
                    TestUtil.logMsg((String)"Check the value in Exception");
                    if (exception instanceof MessageFormatException) {
                        TestUtil.logMsg((String)"Exception is expected MessageFormatException");
                        break block37;
                    }
                    TestUtil.logErr((String)("Exception is incorrect expected MessageFormatException, received " + exception.getCause()));
                    pass = false;
                }
                catch (MessageFormatException e) {
                    TestUtil.logMsg((String)"Got MessageFormatException as expected.");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected MessageFormatException, received " + e));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                throw new EETest.Fault("queueMessageFormatExceptionTests", e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("queueMessageFormatExceptionTests failed");
        }
    }

    public void queueIllegalStateExceptionTests() throws EETest.Fault {
        boolean pass;
        block10: {
            pass = true;
            try {
                this.tool = new JmsTool(13, this.user, this.password, this.mode);
                this.tool.getDefaultProducer().close();
                this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = this.tool.getDefaultDestination();
                this.connection.start();
                this.queueTest = true;
                MyCompletionListener listener = new MyCompletionListener(this.producer);
                TestUtil.logMsg((String)"Testing MessageProducer.close() from CompletionListener (expect IllegalStateException)");
                try {
                    TestUtil.logMsg((String)"Creating TextMessage");
                    TextMessage expTextMessage = this.session.createTextMessage("Call close method");
                    TestUtil.logMsg((String)"Set some values in TextMessage");
                    expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueIllegalStateExceptionTests");
                    TestUtil.logMsg((String)"Send async message specifying CompletionListener to recieve async message");
                    TestUtil.logMsg((String)"CompletionListener will call MessageProducer.close() (expect IllegalStateException)");
                    this.producer.send(this.destination, (Message)expTextMessage, (CompletionListener)listener);
                    Object actTextMessage = null;
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    for (int i = 0; i < 30; ++i) {
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            break;
                        }
                        TestUtil.sleepSec((int)2);
                    }
                    TestUtil.logMsg((String)"Check if we got correct exception from MessageProducer.close()");
                    if (listener.gotException()) {
                        if (listener.gotCorrectException()) {
                            TestUtil.logMsg((String)"Got correct IllegalStateException");
                        } else {
                            TestUtil.logErr((String)("Expected IllegalStateException, received: " + listener.getException()));
                            pass = false;
                        }
                        break block10;
                    }
                    TestUtil.logErr((String)"Expected IllegalStateException, got no exception");
                    pass = false;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected IllegalStateException, received " + e));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                throw new EETest.Fault("queueIllegalStateExceptionTests", e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("queueIllegalStateExceptionTests failed");
        }
    }

    public void topicSendRecvCompletionListenerTest1() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicSendRecvCompletionListenerTest1");
            MyCompletionListener listener = new MyCompletionListener();
            TestUtil.logMsg((String)"Calling send(Destination,Message,CompletionListener)");
            this.producer.send(this.destination, (Message)expTextMessage, (CompletionListener)listener);
            TestUtil.logMsg((String)"Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("topicSendRecvCompletionListenerTest1", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("topicSendRecvCompletionListenerTest1 failed");
        }
    }

    public void topicSendRecvCompletionListenerTest2() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.producer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicSendRecvCompletionListenerTest2");
            MyCompletionListener listener = new MyCompletionListener();
            TestUtil.logMsg((String)"Calling send(Destination,Message,int,int,long,CompletionListener)");
            this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L, (CompletionListener)listener);
            TestUtil.logMsg((String)"Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the values in TextMessage, deliverymode, priority, time to live");
            if (!actTextMessage.getText().equals(expTextMessage.getText()) || actTextMessage.getJMSDeliveryMode() != 1 || actTextMessage.getJMSPriority() != 4 || actTextMessage.getJMSExpiration() != 0L) {
                TestUtil.logErr((String)"Didn't get the right message.");
                TestUtil.logErr((String)("text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText()));
                TestUtil.logErr((String)("DeliveryMode=" + actTextMessage.getJMSDeliveryMode() + ", expected " + expTextMessage.getJMSDeliveryMode()));
                TestUtil.logErr((String)("Priority=" + actTextMessage.getJMSPriority() + ", expected " + expTextMessage.getJMSPriority()));
                TestUtil.logErr((String)("TimeToLive=" + actTextMessage.getJMSExpiration() + ", expected " + expTextMessage.getJMSExpiration()));
                pass = false;
            } else {
                TestUtil.logMsg((String)"TextMessage is correct");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("topicSendRecvCompletionListenerTest2", e);
        }
        finally {
            try {
                this.producer.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("topicSendRecvCompletionListenerTest2 failed");
        }
    }

    public void topicSendRecvCompletionListenerTest3() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicSendRecvCompletionListenerTest3");
            MyCompletionListener listener = new MyCompletionListener();
            TestUtil.logMsg((String)"Calling send(Message,CompletionListener)");
            this.producer.send((Message)expTextMessage, (CompletionListener)listener);
            TestUtil.logMsg((String)"Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logMsg((String)"TextMessage is correct");
            } else {
                TestUtil.logErr((String)("TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText()));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("topicSendRecvCompletionListenerTest3", e);
        }
        if (!pass) {
            throw new EETest.Fault("topicSendRecvCompletionListenerTest3 failed");
        }
    }

    public void topicSendRecvCompletionListenerTest4() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        try {
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.producer = this.tool.getDefaultProducer();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.destination = this.tool.getDefaultDestination();
            this.connection.start();
            this.queueTest = false;
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.session.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicSendRecvCompletionListeneTest4");
            MyCompletionListener listener = new MyCompletionListener();
            TestUtil.logMsg((String)"Calling send(Message,int,int,long,CompletionListener)");
            this.producer.send((Message)expTextMessage, 2, 4, 0L, (CompletionListener)listener);
            TestUtil.logMsg((String)"Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; !listener.isComplete() && i < 60; ++i) {
                TestUtil.logMsg((String)("Loop " + i + ": sleep 2 seconds waiting for messages to arrive at listener"));
                TestUtil.sleepSec((int)2);
            }
            if (listener.isComplete()) {
                actTextMessage = (TextMessage)listener.getMessage();
            }
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage");
            }
            TestUtil.logMsg((String)"Check the values in TextMessage, deliverymode, priority, time to live");
            if (!actTextMessage.getText().equals(expTextMessage.getText()) || actTextMessage.getJMSDeliveryMode() != 2 || actTextMessage.getJMSPriority() != 4 || actTextMessage.getJMSExpiration() != 0L) {
                TestUtil.logErr((String)"Didn't get the right message.");
                TestUtil.logErr((String)("text=" + actTextMessage.getText() + ", expected " + expTextMessage.getText()));
                TestUtil.logErr((String)("DeliveryMode=" + actTextMessage.getJMSDeliveryMode() + ", expected " + expTextMessage.getJMSDeliveryMode()));
                TestUtil.logErr((String)("Priority=" + actTextMessage.getJMSPriority() + ", expected " + expTextMessage.getJMSPriority()));
                TestUtil.logErr((String)("TimeToLive=" + actTextMessage.getJMSExpiration() + ", expected " + expTextMessage.getJMSExpiration()));
                pass = false;
            } else {
                TestUtil.logMsg((String)"TextMessage is correct");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("topicSendRecvCompletionListenerTest4", e);
        }
        if (!pass) {
            throw new EETest.Fault("topicSendRecvCompletionListenerTest4 failed");
        }
    }

    public void topicJMSExceptionTests() throws EETest.Fault {
        boolean pass;
        block19: {
            pass = true;
            Object tempMsg = null;
            String message = "Where are you!";
            try {
                int i;
                Exception exception;
                TestUtil.logMsg((String)"Setup JmsTool for COMMON TOPIC");
                this.tool = new JmsTool(14, this.user, this.password, this.mode);
                this.tool.getDefaultProducer().close();
                this.producer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
                this.consumer = this.tool.getDefaultConsumer();
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = this.tool.getDefaultDestination();
                this.connection.start();
                this.queueTest = false;
                TestUtil.logMsg((String)"Creating TextMessage");
                TextMessage expTextMessage = this.session.createTextMessage(message);
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicJMSExceptionTests");
                MyCompletionListener listener = new MyCompletionListener();
                try {
                    TestUtil.logMsg((String)"Try and set an invalid mode of -1 on send");
                    this.producer.send(this.destination, (Message)expTextMessage, -1, 4, 0L, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof JMSException) {
                            TestUtil.logMsg((String)"Exception is expected JMSException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected JMSException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (JMSException e) {
                    TestUtil.logMsg((String)"Caught expected JMSException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected JMSException, received " + e));
                    pass = false;
                }
                try {
                    TestUtil.logMsg((String)"Try and set an invalid priority of -1 on send");
                    this.producer.send(this.destination, (Message)expTextMessage, 1, -1, 0L, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                        break block19;
                    }
                    TestUtil.logMsg((String)"Check the value in Exception");
                    if (exception instanceof JMSException) {
                        TestUtil.logMsg((String)"Exception is expected JMSException");
                        break block19;
                    }
                    TestUtil.logErr((String)("Exception is incorrect expected JMSException, received " + exception.getCause()));
                    pass = false;
                }
                catch (JMSException e) {
                    TestUtil.logMsg((String)"Caught expected JMSException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected JMSException, received " + e));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e));
                throw new EETest.Fault("topicJMSExceptionTests", e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("topicJMSExceptionTests failed");
        }
    }

    public void topicInvalidDestinationExceptionTests() throws EETest.Fault {
        boolean pass;
        block28: {
            pass = true;
            Object tempMsg = null;
            String message = "Where are you!";
            try {
                int i;
                Exception exception;
                TestUtil.logMsg((String)"Setup JmsTool for COMMON TOPIC");
                this.tool = new JmsTool(14, this.user, this.password, this.mode);
                this.toolForProducer = new JmsTool(14, this.user, this.password, this.mode);
                this.producer = this.toolForProducer.getDefaultProducer();
                this.consumer = this.tool.getDefaultConsumer();
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = null;
                this.connection.start();
                this.queueTest = false;
                MyCompletionListener listener = new MyCompletionListener();
                TestUtil.logMsg((String)"Creating TextMessage");
                TextMessage expTextMessage = this.session.createTextMessage(message);
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueInvalidDestinationExceptionTests");
                try {
                    TestUtil.logMsg((String)"Send message with invalid destination");
                    this.producer.send(this.destination, (Message)expTextMessage, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof InvalidDestinationException) {
                            TestUtil.logMsg((String)"Exception is expected InvalidDestinationException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected InvalidDestinationException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (InvalidDestinationException e) {
                    TestUtil.logMsg((String)"Caught expected InvalidDestinationException");
                }
                catch (UnsupportedOperationException e) {
                    TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected InvalidDestinationException, received " + e));
                    pass = false;
                }
                try {
                    TestUtil.logMsg((String)"Send message with invalid destination");
                    this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                        break block28;
                    }
                    TestUtil.logMsg((String)"Check the value in Exception");
                    if (exception instanceof InvalidDestinationException) {
                        TestUtil.logMsg((String)"Exception is expected InvalidDestinationException");
                        break block28;
                    }
                    TestUtil.logErr((String)("Exception is incorrect expected InvalidDestinationException, received " + exception.getCause()));
                    pass = false;
                }
                catch (InvalidDestinationException e) {
                    TestUtil.logMsg((String)"Caught expected InvalidDestinationException");
                }
                catch (UnsupportedOperationException e) {
                    TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected InvalidDestinationException, received " + e));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e));
                throw new EETest.Fault("queueInvalidDestinationExceptionTests", e);
            }
            finally {
                try {
                    this.producer.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new EETest.Fault("topicInvalidDestinationExceptionTests failed");
        }
    }

    public void topicUnsupportedOperationExceptionTests() throws EETest.Fault {
        boolean pass;
        block44: {
            pass = true;
            Object tempMsg = null;
            String message = "Where are you!";
            try {
                int i;
                Exception exception;
                TestUtil.logMsg((String)"Setup JmsTool for COMMON TOPIC");
                this.tool = new JmsTool(14, this.user, this.password, this.mode);
                this.producer = this.tool.getDefaultProducer();
                this.consumer = this.tool.getDefaultConsumer();
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = this.tool.getDefaultDestination();
                this.connection.start();
                this.queueTest = false;
                MyCompletionListener listener = new MyCompletionListener();
                TestUtil.logMsg((String)"Creating TextMessage");
                TextMessage expTextMessage = this.session.createTextMessage(message);
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicUnsupportedOperationExceptionTests");
                try {
                    TestUtil.logMsg((String)"Send message with invalid destination");
                    this.producer.send(this.destination, (Message)expTextMessage, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof UnsupportedOperationException) {
                            TestUtil.logMsg((String)"Exception is expected UnsupportedOperationException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected UnsupportedOperationException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (UnsupportedOperationException e) {
                    TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected UnsupportedOperationException, received " + e));
                    pass = false;
                }
                try {
                    TestUtil.logMsg((String)"Send message with invalid destination");
                    this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof UnsupportedOperationException) {
                            TestUtil.logMsg((String)"Exception is expected UnsupportedOperationException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected UnsupportedOperationException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (UnsupportedOperationException e) {
                    TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected UnsupportedOperationException, received " + e));
                    pass = false;
                }
                this.tool.getDefaultProducer().close();
                this.producer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
                try {
                    TestUtil.logMsg((String)"Send message with invalid destination");
                    this.producer.send((Message)expTextMessage, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof UnsupportedOperationException) {
                            TestUtil.logMsg((String)"Exception is expected UnsupportedOperationException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected UnsupportedOperationException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (UnsupportedOperationException e) {
                    TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected UnsupportedOperationException, received " + e));
                    pass = false;
                }
                try {
                    TestUtil.logMsg((String)"Send message with invalid destination");
                    this.producer.send((Message)expTextMessage, 1, 4, 0L, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                        break block44;
                    }
                    TestUtil.logMsg((String)"Check the value in Exception");
                    if (exception instanceof UnsupportedOperationException) {
                        TestUtil.logMsg((String)"Exception is expected UnsupportedOperationException");
                        break block44;
                    }
                    TestUtil.logErr((String)("Exception is incorrect expected UnsupportedOperationException, received " + exception.getCause()));
                    pass = false;
                }
                catch (UnsupportedOperationException e) {
                    TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected UnsupportedOperationException, received " + e));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e));
                throw new EETest.Fault("queueUnsupportedOperationExceptionTests", e);
            }
            finally {
                try {
                    this.producer.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new EETest.Fault("topicUnsupportedOperationExceptionTests failed");
        }
    }

    public void topicIllegalArgumentExceptionTests() throws EETest.Fault {
        boolean pass;
        block44: {
            pass = true;
            Object tempMsg = null;
            String message = "Where are you!";
            try {
                int i;
                Exception exception;
                TestUtil.logMsg((String)"Setup JmsTool for COMMON TOPIC");
                this.tool = new JmsTool(14, this.user, this.password, this.mode);
                this.tool.getDefaultProducer().close();
                this.producer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
                this.consumer = this.tool.getDefaultConsumer();
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = this.tool.getDefaultDestination();
                this.connection.start();
                this.queueTest = false;
                MyCompletionListener listener = new MyCompletionListener();
                TestUtil.logMsg((String)"Creating TextMessage");
                TextMessage expTextMessage = this.session.createTextMessage(message);
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicIllegalArgumentExceptionTests");
                try {
                    TestUtil.logMsg((String)"Send message with null CompletionListener");
                    this.producer.send(this.destination, (Message)expTextMessage, null);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof IllegalArgumentException) {
                            TestUtil.logMsg((String)"Exception is expected IllegalArgumentException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected IllegalArgumentException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    TestUtil.logMsg((String)"Caught expected IllegalArgumentException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected IllegalArgumentException, received " + e));
                    pass = false;
                }
                try {
                    TestUtil.logMsg((String)"Send message with null CompletionListener");
                    this.producer.send(this.destination, (Message)expTextMessage, 1, 4, 0L, null);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof IllegalArgumentException) {
                            TestUtil.logMsg((String)"Exception is expected IllegalArgumentException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected IllegalArgumentException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    TestUtil.logMsg((String)"Caught expected IllegalArgumentException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected IllegalArgumentException, received " + e));
                    pass = false;
                }
                this.producer.close();
                this.producer = this.tool.getDefaultSession().createProducer(this.destination);
                try {
                    TestUtil.logMsg((String)"Send message with null CompletionListener");
                    this.producer.send((Message)expTextMessage, null);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof IllegalArgumentException) {
                            TestUtil.logMsg((String)"Exception is expected IllegalArgumentException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected IllegalArgumentException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    TestUtil.logMsg((String)"Caught expected IllegalArgumentException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected IllegalArgumentException, received " + e));
                    pass = false;
                }
                try {
                    TestUtil.logMsg((String)"Send message with null CompletionListener");
                    this.producer.send((Message)expTextMessage, 1, 4, 0L, null);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    exception = null;
                    for (i = 0; i < 10; ++i) {
                        TestUtil.sleepSec((int)2);
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            exception = listener.getException();
                            TestUtil.logMsg((String)("Received Exception after polling loop " + (i + 1)));
                            break;
                        }
                        TestUtil.logMsg((String)("Completed polling loop " + i));
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                        break block44;
                    }
                    TestUtil.logMsg((String)"Check the value in Exception");
                    if (exception instanceof IllegalArgumentException) {
                        TestUtil.logMsg((String)"Exception is expected IllegalArgumentException");
                        break block44;
                    }
                    TestUtil.logErr((String)("Exception is incorrect expected IllegalArgumentException, received " + exception.getCause()));
                    pass = false;
                }
                catch (IllegalArgumentException e) {
                    TestUtil.logMsg((String)"Caught expected IllegalArgumentException");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected IllegalArgumentException, received " + e));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e));
                throw new EETest.Fault("queueIllegalArgumentExceptionTests", e);
            }
            finally {
                try {
                    this.producer.close();
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new EETest.Fault("topicIllegalArgumentExceptionTests failed");
        }
    }

    public void topicMessageFormatExceptionTests() throws EETest.Fault {
        boolean pass;
        block33: {
            pass = true;
            try {
                Exception exception;
                this.tool = new JmsTool(14, this.user, this.password, this.mode);
                this.producer = this.tool.getDefaultProducer();
                this.consumer = this.tool.getDefaultConsumer();
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = this.tool.getDefaultDestination();
                this.connection.start();
                this.queueTest = false;
                InvalidTextMessageTestImpl invalidTMsg = new InvalidTextMessageTestImpl();
                invalidTMsg.setText("hello");
                MyCompletionListener listener = new MyCompletionListener();
                try {
                    TestUtil.logMsg((String)"Calling MessageProducer.send(Message, CompletionListener) -> expect MessageFormatException");
                    this.producer.send((Message)invalidTMsg, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    TestUtil.sleepSec((int)5);
                    exception = null;
                    if (listener.isComplete()) {
                        listener.setComplete(false);
                        exception = listener.getException();
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof MessageFormatException) {
                            TestUtil.logMsg((String)"Exception is expected MessageFormatException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected MessageFormatException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (MessageFormatException e) {
                    TestUtil.logMsg((String)"Got MessageFormatException as expected.");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected MessageFormatException, received " + e));
                    pass = false;
                }
                try {
                    TestUtil.logMsg((String)"Calling MessageProducer.send(Message, int, int, long, CompletionListener) -> expect MessageFormatException");
                    this.producer.send((Message)invalidTMsg, 2, 3, 0L, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    TestUtil.sleepSec((int)5);
                    exception = null;
                    if (listener.isComplete()) {
                        listener.setComplete(false);
                        exception = listener.getException();
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof MessageFormatException) {
                            TestUtil.logMsg((String)"Exception is expected MessageFormatException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected MessageFormatException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (MessageFormatException e) {
                    TestUtil.logMsg((String)"Got MessageFormatException as expected.");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected MessageFormatException, received " + e));
                    pass = false;
                }
                this.tool.getDefaultProducer().close();
                this.producer = this.tool.getDefaultSession().createProducer((Destination)((Queue)null));
                try {
                    TestUtil.logMsg((String)"Calling MessageProducer.send(Destination, Message, CompletionListener) -> expect MessageFormatException");
                    this.producer.send(this.destination, (Message)invalidTMsg, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    TestUtil.sleepSec((int)5);
                    exception = null;
                    if (listener.isComplete()) {
                        listener.setComplete(false);
                        exception = listener.getException();
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                    } else {
                        TestUtil.logMsg((String)"Check the value in Exception");
                        if (exception instanceof MessageFormatException) {
                            TestUtil.logMsg((String)"Exception is expected MessageFormatException");
                        } else {
                            TestUtil.logErr((String)("Exception is incorrect expected MessageFormatException, received " + exception.getCause()));
                            pass = false;
                        }
                    }
                }
                catch (MessageFormatException e) {
                    TestUtil.logMsg((String)"Got MessageFormatException as expected.");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected MessageFormatException, received " + e));
                    pass = false;
                }
                try {
                    TestUtil.logMsg((String)"Calling MessageProducer.send(Destination, Message, int, int, long, CompletionListener) -> expect MessageFormatException");
                    this.producer.send(this.destination, (Message)invalidTMsg, 2, 3, 0L, (CompletionListener)listener);
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    TestUtil.sleepSec((int)5);
                    exception = null;
                    if (listener.isComplete()) {
                        listener.setComplete(false);
                        exception = listener.getException();
                    }
                    if (exception == null) {
                        pass = false;
                        TestUtil.logErr((String)"Didn't throw and exception");
                        break block33;
                    }
                    TestUtil.logMsg((String)"Check the value in Exception");
                    if (exception instanceof MessageFormatException) {
                        TestUtil.logMsg((String)"Exception is expected MessageFormatException");
                        break block33;
                    }
                    TestUtil.logErr((String)("Exception is incorrect expected MessageFormatException, received " + exception.getCause()));
                    pass = false;
                }
                catch (MessageFormatException e) {
                    TestUtil.logMsg((String)"Got MessageFormatException as expected.");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected MessageFormatException, received " + e));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                throw new EETest.Fault("topicMessageFormatExceptionTests", e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("topicMessageFormatExceptionTests failed");
        }
    }

    public void topicIllegalStateExceptionTests() throws EETest.Fault {
        boolean pass;
        block10: {
            pass = true;
            try {
                this.tool = new JmsTool(14, this.user, this.password, this.mode);
                this.tool.getDefaultProducer().close();
                this.producer = this.tool.getDefaultSession().createProducer((Destination)((Topic)null));
                this.connection = this.tool.getDefaultConnection();
                this.session = this.tool.getDefaultSession();
                this.destination = this.tool.getDefaultDestination();
                this.connection.start();
                this.queueTest = false;
                MyCompletionListener listener = new MyCompletionListener(this.producer);
                TestUtil.logMsg((String)"Testing MessageProducer.close() from CompletionListener (expect IllegalStateException)");
                try {
                    TestUtil.logMsg((String)"Creating TextMessage");
                    TextMessage expTextMessage = this.session.createTextMessage("Call close method");
                    TestUtil.logMsg((String)"Set some values in TextMessage");
                    expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicIllegalStateExceptionTests");
                    TestUtil.logMsg((String)"Send async message specifying CompletionListener to recieve async message");
                    TestUtil.logMsg((String)"CompletionListener will call MessageProducer.close() (expect IllegalStateException)");
                    this.producer.send(this.destination, (Message)expTextMessage, (CompletionListener)listener);
                    Object actTextMessage = null;
                    TestUtil.logMsg((String)"Poll listener until we receive message or exception");
                    for (int i = 0; i < 10; ++i) {
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            break;
                        }
                        TestUtil.sleepSec((int)2);
                    }
                    TestUtil.logMsg((String)"Check if we got correct exception from MessageProducer.close()");
                    if (listener.gotException()) {
                        if (listener.gotCorrectException()) {
                            TestUtil.logMsg((String)"Got correct IllegalStateException");
                        } else {
                            TestUtil.logErr((String)("Expected IllegalStateException, received: " + listener.getException()));
                            pass = false;
                        }
                        break block10;
                    }
                    TestUtil.logErr((String)"Expected IllegalStateException, got no exception");
                    pass = false;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected IllegalStateException, received " + e));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                throw new EETest.Fault("topicIllegalStateExceptionTests", e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("topicIllegalStateExceptionTests failed");
        }
    }
}

