/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.session.stateful.sessionbeantest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.session.util.DBSupport;
import java.sql.SQLException;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.SessionSynchronization;

public class TestBeanTxEJB
implements SessionBean,
SessionSynchronization {
    private SessionContext sctx = null;
    private Properties harnessProps = null;
    private boolean afterBeginFlag = false;
    private boolean beforeCompletionFlag = false;
    private boolean afterCompletionFlag = false;
    private boolean commitFlag;
    private boolean rollBack;
    private boolean syncLifeCycleFlag = true;
    private boolean syncTestComplete = false;
    private DBSupport db = null;
    private TSNamingContext nctx = null;

    public void ejbCreate(Properties p) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        this.harnessProps = p;
        try {
            TestUtil.logMsg((String)"initialize remote logging");
            TestUtil.init((Properties)p);
            TestUtil.logMsg((String)"obtaining naming context");
            this.nctx = new TSNamingContext();
            TestUtil.logMsg((String)"Initialize DBSupport");
            this.db = new DBSupport(this.sctx, this.harnessProps);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        this.sctx = sc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void afterBegin() {
        TestUtil.logTrace((String)"afterBegin");
        if (this.afterBeginFlag || this.syncTestComplete) {
            return;
        }
        this.afterBeginFlag = true;
        if (this.beforeCompletionFlag || this.afterCompletionFlag) {
            this.syncLifeCycleFlag = false;
        }
    }

    public void beforeCompletion() {
        TestUtil.logTrace((String)"beforeCompletion");
        if (this.beforeCompletionFlag || this.syncTestComplete) {
            return;
        }
        this.beforeCompletionFlag = true;
        if (!this.afterBeginFlag || this.afterCompletionFlag) {
            this.syncLifeCycleFlag = false;
        }
        if (this.rollBack) {
            TestUtil.logMsg((String)"Marking transaction for rollback only.");
            this.sctx.setRollbackOnly();
            this.rollBack = false;
        }
    }

    public void afterCompletion(boolean committed) {
        TestUtil.logTrace((String)"afterCompletion");
        if (this.afterCompletionFlag || this.syncTestComplete) {
            return;
        }
        this.afterCompletionFlag = true;
        if (!this.afterBeginFlag || !this.beforeCompletionFlag) {
            this.syncLifeCycleFlag = false;
        }
        this.commitFlag = committed;
        TestUtil.logMsg((String)("committed=" + committed));
    }

    public void syncTest(boolean b) {
        TestUtil.logTrace((String)"syncTest");
        this.rollBack = b;
    }

    public void syncTestWithDbConnection(boolean b1, boolean b2) {
        TestUtil.logTrace((String)"syncTestWithDbConnection");
        try {
            this.dbConnect();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception on database connection: " + e), (Throwable)e);
            throw new EJBException("database connection failed");
        }
        this.rollBack = b1;
        if (this.rollBack && b2) {
            TestUtil.logMsg((String)"Marking transaction for rollback only.");
            this.sctx.setRollbackOnly();
            this.rollBack = false;
        }
    }

    public boolean isSyncLifeCycle1(boolean b) {
        TestUtil.logTrace((String)"isSyncLifeCycle1");
        this.syncTestComplete = true;
        if (!b) {
            return this.syncLifeCycleFlag && this.commitFlag;
        }
        return this.syncLifeCycleFlag && !this.commitFlag;
    }

    public boolean isSyncLifeCycle2() {
        TestUtil.logTrace((String)"isSyncLifeCycle2");
        this.syncTestComplete = true;
        TestUtil.logMsg((String)("syncLifeCycleFlag=" + this.syncLifeCycleFlag));
        TestUtil.logMsg((String)("commitFlag=" + this.commitFlag));
        return this.syncLifeCycleFlag && !this.commitFlag;
    }

    public boolean isSyncLifeCycle3() {
        TestUtil.logTrace((String)"isSyncLifeCycle3");
        this.syncTestComplete = true;
        TestUtil.logMsg((String)("syncLifeCycleFlag=" + this.syncLifeCycleFlag));
        TestUtil.logMsg((String)("commitFlag=" + this.commitFlag));
        return !this.syncLifeCycleFlag && !this.commitFlag;
    }

    public boolean noSyncLifeCycle() {
        TestUtil.logTrace((String)"noSyncLifeCycle");
        return !this.afterBeginFlag && !this.beforeCompletionFlag && !this.afterCompletionFlag;
    }

    public void dbUnConnect() {
        TestUtil.logTrace((String)"dbUnConnect");
        try {
            this.db.closeDBConnection();
            TestUtil.logTrace((String)"closed connection");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred trying to close connection: " + e), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    private void dbConnect() {
        TestUtil.logTrace((String)"dbConnect");
        try {
            this.db.getDBConnection();
        }
        catch (SQLException e) {
            TestUtil.logErr((String)"SQLException connection to DB");
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }
}

