/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.appclient.listenerexceptiontests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.TextMessageTestImpl;
import com.sun.ts.tests.jms.core20.appclient.listenerexceptiontests.MyCompletionListener;
import com.sun.ts.tests.jms.core20.appclient.listenerexceptiontests.MyMessageListener;
import java.util.ArrayList;
import java.util.Properties;
import javax.jms.CompletionListener;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSProducer;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;

public class Client
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core20.appclient.listenerexceptiontests.Client";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private transient ConnectionFactory cf = null;
    private transient Queue queue = null;
    private transient Session session = null;
    private transient Destination destination = null;
    private transient Connection connection = null;
    private transient MessageConsumer consumer = null;
    private transient MessageProducer producer = null;
    private transient JMSContext context = null;
    private transient JMSContext contextToSendMsg = null;
    private transient JMSContext contextToCreateMsg = null;
    private transient JMSConsumer jmsconsumer = null;
    private transient JMSProducer jmsproducer = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;
    boolean jmscontextTest = false;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void setupForQueue2() throws EETest.Fault {
        try {
            TestUtil.logMsg((String)"Setup JmsTool for COMMON_Q setup");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.queue = (Queue)this.destination;
            this.tool.getDefaultConnection().close();
            TestUtil.logMsg((String)"Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.contextToSendMsg = this.cf.createContext(this.user, this.password, 1);
            this.contextToCreateMsg = this.cf.createContext(this.user, this.password, 1);
            this.jmsconsumer = this.context.createConsumer(this.destination);
            this.jmsproducer = this.contextToSendMsg.createProducer();
            this.jmscontextTest = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            throw new EETest.Fault("setupForQueue2 failed!", e);
        }
    }

    private void setupForQueue() throws EETest.Fault {
        try {
            TestUtil.logMsg((String)"Setup JmsTool for COMMON_Q setup");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.consumer = this.tool.getDefaultConsumer();
            this.producer = this.tool.getDefaultProducer();
            this.destination = this.tool.getDefaultDestination();
            this.queue = (Queue)this.destination;
            this.connection.start();
            this.jmscontextTest = false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            throw new EETest.Fault("setupForQueue failed!", e);
        }
    }

    private void setupForQueueWithMultipleSessions() throws EETest.Fault {
        Connection newConnection = null;
        Session newSession = null;
        boolean transacted = false;
        try {
            TestUtil.logMsg((String)"Setup JmsTool for COMMON_Q setup");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.connection = this.tool.getDefaultConnection();
            this.session = this.tool.getDefaultSession();
            this.producer = this.tool.getDefaultProducer();
            this.destination = this.tool.getDefaultDestination();
            this.queue = (Queue)this.destination;
            newConnection = this.tool.getNewConnection(0, this.user, this.password);
            newSession = newConnection.createSession(transacted, 1);
            this.consumer = newSession.createConsumer(this.destination);
            this.connection.start();
            this.jmscontextTest = false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            throw new EETest.Fault("setupForQueue failed!", e);
        }
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            this.queues = new ArrayList(3);
            this.connections = new ArrayList(5);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            throw new EETest.Fault("setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            TestUtil.logMsg((String)"Close Consumer objects");
            if (this.jmscontextTest) {
                if (this.jmsconsumer != null) {
                    this.jmsconsumer.close();
                    this.jmsconsumer = null;
                }
                TestUtil.logMsg((String)"Close JMSContext objects");
                if (this.context != null) {
                    this.context.close();
                    this.context = null;
                }
                if (this.contextToSendMsg != null) {
                    this.contextToSendMsg.close();
                    this.contextToSendMsg = null;
                }
                if (this.contextToCreateMsg != null) {
                    this.contextToCreateMsg.close();
                    this.contextToCreateMsg = null;
                }
            } else if (this.consumer != null) {
                this.consumer.close();
                this.consumer = null;
            }
            TestUtil.logMsg((String)"Flush any messages left on Queue");
            this.tool.flushDestination();
            this.tool.closeAllResources();
            this.tool.getDefaultConnection().close();
            this.producer = null;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            throw new EETest.Fault("cleanup failed!", e);
        }
    }

    public void illegalStateExceptionTest1() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Testing Connection.close() from CompletionListener (expect IllegalStateException)");
            try {
                this.setupForQueue();
                MyCompletionListener listener = new MyCompletionListener(this.connection);
                TestUtil.logMsg((String)"Creating TextMessage");
                TextMessage expTextMessage = this.session.createTextMessage("Call connection close method");
                TestUtil.logMsg((String)"Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateExceptionTest1");
                TestUtil.logMsg((String)"Send async message specifying CompletionListener to recieve async message");
                TestUtil.logMsg((String)"CompletionListener will call Connection.close() (expect IllegalStateException)");
                this.producer.send((Message)expTextMessage, (CompletionListener)listener);
                Object actTextMessage = null;
                TestUtil.logMsg((String)"Poll listener until we receive exception");
                for (int i = 0; i < 30; ++i) {
                    if (listener.isComplete()) {
                        listener.setComplete(false);
                        break;
                    }
                    TestUtil.sleepSec((int)2);
                }
                TestUtil.logMsg((String)"Check if we got correct exception from Connection.close()");
                if (listener.gotException()) {
                    if (listener.gotCorrectException()) {
                        TestUtil.logMsg((String)"Got correct IllegalStateException");
                    } else {
                        TestUtil.logErr((String)("Expected IllegalStateException, received: " + listener.getException()));
                        pass = false;
                    }
                } else {
                    TestUtil.logErr((String)"Expected IllegalStateException, got no exception");
                    pass = false;
                }
            }
            catch (IllegalStateException e) {
                TestUtil.logMsg((String)"Caught IllegalStateException as expected");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Expected IllegalStateException, received " + e));
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            try {
                this.cleanup();
            }
            catch (Exception e) {
                TestUtil.logMsg((String)("Exception during cleanup: " + e));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e));
            throw new EETest.Fault("illegalStateExceptionTest1", e);
        }
        if (!pass) {
            throw new EETest.Fault("illegalStateExceptionTest1 failed");
        }
    }

    public void illegalStateExceptionTest2() throws EETest.Fault {
        boolean pass;
        block22: {
            pass = true;
            try {
                int i;
                Object actTextMessage;
                TextMessage expTextMessage;
                MyMessageListener listener;
                TestUtil.logMsg((String)"Testing Connection.close() from MessageListener (expect IllegalStateException)");
                try {
                    this.setupForQueue();
                    listener = new MyMessageListener(this.connection);
                    TestUtil.logMsg((String)"Creating TextMessage");
                    expTextMessage = this.session.createTextMessage("Call connection close method");
                    TestUtil.logMsg((String)"Set some values in TextMessage");
                    expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateExceptionTest2");
                    TestUtil.logMsg((String)"Set MessageListener to receive async message");
                    this.consumer.setMessageListener((MessageListener)listener);
                    TestUtil.logMsg((String)"Send async message to MessageListener");
                    TestUtil.logMsg((String)"MessageListener will call Connection.close() (expect IllegalStateException)");
                    this.producer.send((Message)expTextMessage);
                    actTextMessage = null;
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    for (i = 0; i < 30; ++i) {
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            break;
                        }
                        TestUtil.sleepSec((int)2);
                    }
                    TestUtil.logMsg((String)"Check if we got correct exception from Connection.close()");
                    if (listener.gotException()) {
                        if (listener.gotCorrectException()) {
                            TestUtil.logMsg((String)"Got correct IllegalStateException");
                        } else {
                            TestUtil.logErr((String)("Expected IllegalStateException, received: " + listener.getException()));
                            pass = false;
                        }
                    } else {
                        TestUtil.logErr((String)"Expected IllegalStateException, got no exception");
                        pass = false;
                    }
                }
                catch (IllegalStateException e) {
                    TestUtil.logMsg((String)"Caught IllegalStateException as expected");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected IllegalStateException, received " + e));
                    TestUtil.printStackTrace((Throwable)e);
                    pass = false;
                }
                try {
                    this.cleanup();
                }
                catch (Exception e) {
                    TestUtil.logMsg((String)("Exception during cleanup: " + e));
                }
                TestUtil.logMsg((String)"Testing Connection.stop() from MessageListener (expect IllegalStateException)");
                try {
                    this.setupForQueue();
                    listener = new MyMessageListener(this.connection);
                    TestUtil.logMsg((String)"Creating TextMessage");
                    expTextMessage = this.session.createTextMessage("Call connection stop method");
                    TestUtil.logMsg((String)"Set some values in TextMessage");
                    expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateExceptionTest2");
                    TestUtil.logMsg((String)"Set MessageListener to receive async message");
                    this.consumer.setMessageListener((MessageListener)listener);
                    TestUtil.logMsg((String)"Send async message to MessageListener");
                    TestUtil.logMsg((String)"MessageListener will call Connection.stop() (expect IllegalStateException)");
                    this.producer.send((Message)expTextMessage);
                    actTextMessage = null;
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    for (i = 0; i < 30; ++i) {
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            break;
                        }
                        TestUtil.sleepSec((int)2);
                    }
                    TestUtil.logMsg((String)"Check if we got correct exception from Connection.stop()");
                    if (listener.gotException()) {
                        if (listener.gotCorrectException()) {
                            TestUtil.logMsg((String)"Got correct IllegalStateException");
                        } else {
                            TestUtil.logErr((String)("Expected IllegalStateException, received: " + listener.getException()));
                            pass = false;
                        }
                        break block22;
                    }
                    TestUtil.logErr((String)"Expected IllegalStateException, got no exception");
                    pass = false;
                }
                catch (IllegalStateException e) {
                    TestUtil.logMsg((String)"Caught IllegalStateException as expected");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected IllegalStateException, received " + e));
                    TestUtil.printStackTrace((Throwable)e);
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                throw new EETest.Fault("illegalStateExceptionTest2", e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("illegalStateExceptionTest2 failed");
        }
    }

    public void illegalStateExceptionTest3() throws EETest.Fault {
        boolean pass;
        block22: {
            pass = true;
            try {
                int i;
                Object actTextMessage;
                TextMessage expTextMessage;
                Object listener;
                TestUtil.logMsg((String)"Testing Session.close() from CompletionListener (expect IllegalStateException)");
                try {
                    this.setupForQueue();
                    listener = new MyCompletionListener(this.session);
                    TestUtil.logMsg((String)"Creating TextMessage");
                    expTextMessage = this.session.createTextMessage("Call session close method");
                    TestUtil.logMsg((String)"Set some values in TextMessage");
                    expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateExceptionTest3");
                    TestUtil.logMsg((String)"Send message specifying CompletionListener");
                    TestUtil.logMsg((String)"CompletionListener will call Session.close() (expect IllegalStateException)");
                    this.producer.send((Message)expTextMessage, (CompletionListener)listener);
                    actTextMessage = null;
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    for (i = 0; i < 30; ++i) {
                        if (((MyCompletionListener)listener).isComplete()) {
                            ((MyCompletionListener)listener).setComplete(false);
                            break;
                        }
                        TestUtil.sleepSec((int)2);
                    }
                    TestUtil.logMsg((String)"Check if we got correct exception from Session.close()");
                    if (((MyCompletionListener)listener).gotException()) {
                        if (((MyCompletionListener)listener).gotCorrectException()) {
                            TestUtil.logMsg((String)"Got correct IllegalStateException");
                        } else {
                            TestUtil.logErr((String)("Expected IllegalStateException, received: " + ((MyCompletionListener)listener).getException()));
                            pass = false;
                        }
                    } else {
                        TestUtil.logErr((String)"Expected IllegalStateException, got no exception");
                        pass = false;
                    }
                }
                catch (IllegalStateException e) {
                    TestUtil.logMsg((String)"Caught IllegalStateException as expected");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected IllegalStateException, received " + e));
                    TestUtil.printStackTrace((Throwable)e);
                    pass = false;
                }
                try {
                    this.cleanup();
                }
                catch (Exception e) {
                    TestUtil.logMsg((String)("Exception during cleanup: " + e));
                }
                TestUtil.logMsg((String)"Testing Session.close() from MessageListener (expect IllegalStateException)");
                try {
                    this.setupForQueue();
                    listener = new MyMessageListener(this.session);
                    TestUtil.logMsg((String)"Creating TextMessage");
                    expTextMessage = this.session.createTextMessage("Call session close method");
                    TestUtil.logMsg((String)"Set some values in TextMessage");
                    expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateExceptionTest6");
                    TestUtil.logMsg((String)"Set MessageListener to receive async message");
                    this.consumer.setMessageListener((MessageListener)listener);
                    TestUtil.logMsg((String)"Send async message to MessageListener");
                    TestUtil.logMsg((String)"MessageListener will call Session.close() (expect IllegalStateException)");
                    this.producer.send((Message)expTextMessage);
                    actTextMessage = null;
                    TestUtil.logMsg((String)"Poll listener until we receive exception");
                    for (i = 0; i < 30; ++i) {
                        if (((MyMessageListener)listener).isComplete()) {
                            ((MyMessageListener)listener).setComplete(false);
                            break;
                        }
                        TestUtil.sleepSec((int)2);
                    }
                    TestUtil.logMsg((String)"Check if we got correct exception from Session.close()");
                    if (((MyMessageListener)listener).gotException()) {
                        if (((MyMessageListener)listener).gotCorrectException()) {
                            TestUtil.logMsg((String)"Got correct IllegalStateException");
                        } else {
                            TestUtil.logErr((String)("Expected IllegalStateException, received: " + ((MyMessageListener)listener).getException()));
                            pass = false;
                        }
                        break block22;
                    }
                    TestUtil.logErr((String)"Expected IllegalStateException, got no exception");
                    pass = false;
                }
                catch (IllegalStateException e) {
                    TestUtil.logMsg((String)"Caught IllegalStateException as expected");
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Expected IllegalStateException, received " + e));
                    TestUtil.printStackTrace((Throwable)e);
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                throw new EETest.Fault("illegalStateExceptionTest3", e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("illegalStateExceptionTest3 failed");
        }
    }

    public void callingMessageConsumerCloseIsAllowed() throws EETest.Fault {
        boolean pass;
        block8: {
            pass = true;
            try {
                try {
                    this.setupForQueueWithMultipleSessions();
                    MyMessageListener listener = new MyMessageListener(this.consumer);
                    TestUtil.logMsg((String)"Creating TextMessage");
                    TextMessageTestImpl expTextMessage = new TextMessageTestImpl();
                    expTextMessage.setText("Call MessageConsumer close method");
                    TestUtil.logMsg((String)"Set some values in TextMessage");
                    expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "callingMessageConsumerCloseIsAllowed");
                    TestUtil.logMsg((String)"Set MessageListener to receive async message");
                    this.consumer.setMessageListener((MessageListener)listener);
                    TestUtil.logMsg((String)"Send async message to MessageListener");
                    TestUtil.logMsg((String)"MessageListener will call MessageConsumer.close() which is allowed");
                    this.producer.send((Message)expTextMessage);
                    Object actTextMessage = null;
                    TestUtil.logMsg((String)"Poll listener until complete");
                    for (int i = 0; i < 30; ++i) {
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            break;
                        }
                        TestUtil.sleepSec((int)2);
                    }
                    TestUtil.logMsg((String)"Make sure MessageConsumer.close() was allowed");
                    if (!listener.gotException()) {
                        TestUtil.logMsg((String)"MessageConsumer.close() was allowed");
                        break block8;
                    }
                    TestUtil.logErr((String)"MessageConsumer.close() through an exception");
                    pass = false;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Caught unexpected exception: " + e));
                    TestUtil.printStackTrace((Throwable)e);
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                throw new EETest.Fault("callingMessageConsumerCloseIsAllowed", e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("callingMessageConsumerCloseIsAllowed failed");
        }
    }

    public void callingJMSConsumerCloseIsAllowed() throws EETest.Fault {
        boolean pass;
        block8: {
            pass = true;
            try {
                try {
                    this.setupForQueue2();
                    MyMessageListener listener = new MyMessageListener(this.jmsconsumer);
                    TestUtil.logMsg((String)"Creating TextMessage");
                    TextMessage expTextMessage = this.contextToCreateMsg.createTextMessage("Call JMSConsumer close method");
                    TestUtil.logMsg((String)"Set some values in TextMessage");
                    expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "callingJMSConsumerCloseIsAllowed");
                    TestUtil.logMsg((String)"Set MessageListener to receive async message");
                    this.jmsconsumer.setMessageListener((MessageListener)listener);
                    TestUtil.logMsg((String)"Send async message to MessageListener");
                    TestUtil.logMsg((String)"MessageListener will call JMSConsumer.close() which is allowed");
                    this.jmsproducer.send(this.destination, (Message)expTextMessage);
                    Object actTextMessage = null;
                    TestUtil.logMsg((String)"Poll listener until complete");
                    for (int i = 0; i < 30; ++i) {
                        if (listener.isComplete()) {
                            listener.setComplete(false);
                            break;
                        }
                        TestUtil.sleepSec((int)2);
                    }
                    TestUtil.logMsg((String)"Make sure JMSConsumer.close() was allowed");
                    if (!listener.gotException()) {
                        TestUtil.logMsg((String)"JMSConsumer.close() was allowed");
                        break block8;
                    }
                    TestUtil.logErr((String)"JMSConsumer.close() through an exception");
                    pass = false;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Caught unexpected exception: " + e));
                    TestUtil.printStackTrace((Throwable)e);
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected exception: " + e));
                throw new EETest.Fault("callingJMSConsumerCloseIsAllowed", e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("callingJMSConsumerCloseIsAllowed failed");
        }
    }
}

