/*
 * Copyright (c) 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

// Stub class generated by rmic, do not edit.
// Contents subject to change without notice.

package org.omg.stub.com.sun.ts.tests.rmiiiop.ee.standalone;

import com.sun.ts.tests.rmiiiop.ee.marshaltests.Graph;
import com.sun.ts.tests.rmiiiop.ee.marshaltests.IDLStruct;
import com.sun.ts.tests.rmiiiop.ee.marshaltests.Multi;
import com.sun.ts.tests.rmiiiop.ee.marshaltests.UserException;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.util.Date;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.ServantObject;

import com.sun.ts.tests.rmiiiop.ee.standalone.*;

public class _RMIIIOPTests_Stub extends Stub implements RMIIIOPTests {

  private static final String[] _type_ids = {
      "RMI:com.sun.ts.tests.rmiiiop.ee.standalone.RMIIIOPTests:0000000000000000" };

  public String[] _ids() {
    return _type_ids;
  }

  public boolean pass_a_boolean(int arg0, boolean arg1)
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA.portable.InputStream in = null;
        try {
          OutputStream out = _request("pass_a_boolean", true);
          out.write_long(arg0);
          out.write_boolean(arg1);
          in = _invoke(out);
          return in.read_boolean();
        } catch (ApplicationException ex) {
          in = ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_a_boolean(arg0, arg1);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_a_boolean",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_a_boolean(arg0, arg1);
      }
      try {
        return ((RMIIIOPTests) so.servant).pass_a_boolean(arg0, arg1);
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public byte pass_a_byte(int arg0, byte arg1) throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA.portable.InputStream in = null;
        try {
          OutputStream out = _request("pass_a_byte", true);
          out.write_long(arg0);
          out.write_octet(arg1);
          in = _invoke(out);
          return in.read_octet();
        } catch (ApplicationException ex) {
          in = ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_a_byte(arg0, arg1);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_a_byte", RMIIIOPTests.class);
      if (so == null) {
        return pass_a_byte(arg0, arg1);
      }
      try {
        return ((RMIIIOPTests) so.servant).pass_a_byte(arg0, arg1);
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public char pass_a_char(int arg0, char arg1) throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA.portable.InputStream in = null;
        try {
          OutputStream out = _request("pass_a_char", true);
          out.write_long(arg0);
          out.write_wchar(arg1);
          in = _invoke(out);
          return in.read_wchar();
        } catch (ApplicationException ex) {
          in = ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_a_char(arg0, arg1);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_a_char", RMIIIOPTests.class);
      if (so == null) {
        return pass_a_char(arg0, arg1);
      }
      try {
        return ((RMIIIOPTests) so.servant).pass_a_char(arg0, arg1);
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public short pass_a_short(int arg0, short arg1)
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA.portable.InputStream in = null;
        try {
          OutputStream out = _request("pass_a_short", true);
          out.write_long(arg0);
          out.write_short(arg1);
          in = _invoke(out);
          return in.read_short();
        } catch (ApplicationException ex) {
          in = ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_a_short(arg0, arg1);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_a_short", RMIIIOPTests.class);
      if (so == null) {
        return pass_a_short(arg0, arg1);
      }
      try {
        return ((RMIIIOPTests) so.servant).pass_a_short(arg0, arg1);
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public int pass_a_int(int arg0, int arg1) throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA.portable.InputStream in = null;
        try {
          OutputStream out = _request("pass_a_int", true);
          out.write_long(arg0);
          out.write_long(arg1);
          in = _invoke(out);
          return in.read_long();
        } catch (ApplicationException ex) {
          in = ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_a_int(arg0, arg1);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_a_int", RMIIIOPTests.class);
      if (so == null) {
        return pass_a_int(arg0, arg1);
      }
      try {
        return ((RMIIIOPTests) so.servant).pass_a_int(arg0, arg1);
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public long pass_a_long(int arg0, long arg1) throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA.portable.InputStream in = null;
        try {
          OutputStream out = _request("pass_a_long", true);
          out.write_long(arg0);
          out.write_longlong(arg1);
          in = _invoke(out);
          return in.read_longlong();
        } catch (ApplicationException ex) {
          in = ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_a_long(arg0, arg1);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_a_long", RMIIIOPTests.class);
      if (so == null) {
        return pass_a_long(arg0, arg1);
      }
      try {
        return ((RMIIIOPTests) so.servant).pass_a_long(arg0, arg1);
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public float pass_a_float(int arg0, float arg1)
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA.portable.InputStream in = null;
        try {
          OutputStream out = _request("pass_a_float", true);
          out.write_long(arg0);
          out.write_float(arg1);
          in = _invoke(out);
          return in.read_float();
        } catch (ApplicationException ex) {
          in = ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_a_float(arg0, arg1);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_a_float", RMIIIOPTests.class);
      if (so == null) {
        return pass_a_float(arg0, arg1);
      }
      try {
        return ((RMIIIOPTests) so.servant).pass_a_float(arg0, arg1);
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public double pass_a_double(int arg0, double arg1)
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA.portable.InputStream in = null;
        try {
          OutputStream out = _request("pass_a_double", true);
          out.write_long(arg0);
          out.write_double(arg1);
          in = _invoke(out);
          return in.read_double();
        } catch (ApplicationException ex) {
          in = ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_a_double(arg0, arg1);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_a_double",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_a_double(arg0, arg1);
      }
      try {
        return ((RMIIIOPTests) so.servant).pass_a_double(arg0, arg1);
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public boolean[] pass_a_boolean_array(boolean[] arg0)
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) _request(
              "pass_a_boolean_array", true);
          out.write_value(cast_array(arg0), boolean[].class);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return (boolean[]) in.read_value(boolean[].class);
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_a_boolean_array(arg0);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_a_boolean_array",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_a_boolean_array(arg0);
      }
      try {
        boolean[] arg0Copy = (boolean[]) Util.copyObject(arg0, _orb());
        boolean[] result = ((RMIIIOPTests) so.servant)
            .pass_a_boolean_array(arg0Copy);
        return (boolean[]) Util.copyObject(result, _orb());
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public byte[] pass_a_byte_array(byte[] arg0) throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) _request(
              "pass_a_byte_array", true);
          out.write_value(cast_array(arg0), byte[].class);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return (byte[]) in.read_value(byte[].class);
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_a_byte_array(arg0);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_a_byte_array",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_a_byte_array(arg0);
      }
      try {
        byte[] arg0Copy = (byte[]) Util.copyObject(arg0, _orb());
        byte[] result = ((RMIIIOPTests) so.servant).pass_a_byte_array(arg0Copy);
        return (byte[]) Util.copyObject(result, _orb());
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public char[] pass_a_char_array(char[] arg0) throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) _request(
              "pass_a_char_array", true);
          out.write_value(cast_array(arg0), char[].class);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return (char[]) in.read_value(char[].class);
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_a_char_array(arg0);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_a_char_array",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_a_char_array(arg0);
      }
      try {
        char[] arg0Copy = (char[]) Util.copyObject(arg0, _orb());
        char[] result = ((RMIIIOPTests) so.servant).pass_a_char_array(arg0Copy);
        return (char[]) Util.copyObject(result, _orb());
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public short[] pass_a_short_array(short[] arg0)
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) _request(
              "pass_a_short_array", true);
          out.write_value(cast_array(arg0), short[].class);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return (short[]) in.read_value(short[].class);
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_a_short_array(arg0);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_a_short_array",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_a_short_array(arg0);
      }
      try {
        short[] arg0Copy = (short[]) Util.copyObject(arg0, _orb());
        short[] result = ((RMIIIOPTests) so.servant)
            .pass_a_short_array(arg0Copy);
        return (short[]) Util.copyObject(result, _orb());
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public int[] pass_a_int_array(int[] arg0) throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) _request(
              "pass_a_int_array", true);
          out.write_value(cast_array(arg0), int[].class);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return (int[]) in.read_value(int[].class);
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_a_int_array(arg0);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_a_int_array",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_a_int_array(arg0);
      }
      try {
        int[] arg0Copy = (int[]) Util.copyObject(arg0, _orb());
        int[] result = ((RMIIIOPTests) so.servant).pass_a_int_array(arg0Copy);
        return (int[]) Util.copyObject(result, _orb());
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public long[] pass_a_long_array(long[] arg0) throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) _request(
              "pass_a_long_array", true);
          out.write_value(cast_array(arg0), long[].class);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return (long[]) in.read_value(long[].class);
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_a_long_array(arg0);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_a_long_array",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_a_long_array(arg0);
      }
      try {
        long[] arg0Copy = (long[]) Util.copyObject(arg0, _orb());
        long[] result = ((RMIIIOPTests) so.servant).pass_a_long_array(arg0Copy);
        return (long[]) Util.copyObject(result, _orb());
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public float[] pass_a_float_array(float[] arg0)
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) _request(
              "pass_a_float_array", true);
          out.write_value(cast_array(arg0), float[].class);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return (float[]) in.read_value(float[].class);
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_a_float_array(arg0);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_a_float_array",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_a_float_array(arg0);
      }
      try {
        float[] arg0Copy = (float[]) Util.copyObject(arg0, _orb());
        float[] result = ((RMIIIOPTests) so.servant)
            .pass_a_float_array(arg0Copy);
        return (float[]) Util.copyObject(result, _orb());
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public double[] pass_a_double_array(double[] arg0)
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) _request(
              "pass_a_double_array", true);
          out.write_value(cast_array(arg0), double[].class);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return (double[]) in.read_value(double[].class);
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_a_double_array(arg0);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_a_double_array",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_a_double_array(arg0);
      }
      try {
        double[] arg0Copy = (double[]) Util.copyObject(arg0, _orb());
        double[] result = ((RMIIIOPTests) so.servant)
            .pass_a_double_array(arg0Copy);
        return (double[]) Util.copyObject(result, _orb());
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public int pass_a_date_object(Date arg0) throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) _request(
              "pass_a_date_object", true);
          out.write_value(arg0, Date.class);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return in.read_long();
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_a_date_object(arg0);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_a_date_object",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_a_date_object(arg0);
      }
      try {
        Date arg0Copy = (Date) Util.copyObject(arg0, _orb());
        return ((RMIIIOPTests) so.servant).pass_a_date_object(arg0Copy);
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public int pass_any_object(Object arg0) throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA.portable.InputStream in = null;
        try {
          OutputStream out = _request("pass_any_object", true);
          Util.writeAny(out, arg0);
          in = _invoke(out);
          return in.read_long();
        } catch (ApplicationException ex) {
          in = ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_any_object(arg0);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_any_object",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_any_object(arg0);
      }
      try {
        Object arg0Copy = (Object) Util.copyObject(arg0, _orb());
        return ((RMIIIOPTests) so.servant).pass_any_object(arg0Copy);
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public Date return_a_date_object() throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          OutputStream out = _request("return_a_date_object", true);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return (Date) in.read_value(Date.class);
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return return_a_date_object();
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("return_a_date_object",
          RMIIIOPTests.class);
      if (so == null) {
        return return_a_date_object();
      }
      try {
        Date result = ((RMIIIOPTests) so.servant).return_a_date_object();
        return (Date) Util.copyObject(result, _orb());
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public Object return_any_object() throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA.portable.InputStream in = null;
        try {
          OutputStream out = _request("return_any_object", true);
          in = _invoke(out);
          return Util.readAny(in);
        } catch (ApplicationException ex) {
          in = ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return return_any_object();
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("return_any_object",
          RMIIIOPTests.class);
      if (so == null) {
        return return_any_object();
      }
      try {
        Object result = ((RMIIIOPTests) so.servant).return_any_object();
        return (Object) Util.copyObject(result, _orb());
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public int pass_a_date_object_array(Date[] arg0)
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) _request(
              "pass_a_date_object_array", true);
          out.write_value(cast_array(arg0), Date[].class);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return in.read_long();
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_a_date_object_array(arg0);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_a_date_object_array",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_a_date_object_array(arg0);
      }
      try {
        Date[] arg0Copy = (Date[]) Util.copyObject(arg0, _orb());
        return ((RMIIIOPTests) so.servant).pass_a_date_object_array(arg0Copy);
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public int pass_any_object_array(Object[] arg0)
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) _request(
              "pass_any_object_array", true);
          out.write_value(cast_array(arg0), Object[].class);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return in.read_long();
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_any_object_array(arg0);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_any_object_array",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_any_object_array(arg0);
      }
      try {
        Object[] arg0Copy = (Object[]) Util.copyObject(arg0, _orb());
        return ((RMIIIOPTests) so.servant).pass_any_object_array(arg0Copy);
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public Date[] return_a_date_object_array() throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          OutputStream out = _request("return_a_date_object_array", true);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return (Date[]) in.read_value(Date[].class);
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return return_a_date_object_array();
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("return_a_date_object_array",
          RMIIIOPTests.class);
      if (so == null) {
        return return_a_date_object_array();
      }
      try {
        Date[] result = ((RMIIIOPTests) so.servant)
            .return_a_date_object_array();
        return (Date[]) Util.copyObject(result, _orb());
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public Object[] return_any_object_array() throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          OutputStream out = _request("return_any_object_array", true);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return (Object[]) in.read_value(Object[].class);
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return return_any_object_array();
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("return_any_object_array",
          RMIIIOPTests.class);
      if (so == null) {
        return return_any_object_array();
      }
      try {
        Object[] result = ((RMIIIOPTests) so.servant).return_any_object_array();
        return (Object[]) Util.copyObject(result, _orb());
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public int pass_a_remote_interface(CallBackInterface arg0)
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA.portable.InputStream in = null;
        try {
          OutputStream out = _request("pass_a_remote_interface", true);
          Util.writeRemoteObject(out, arg0);
          in = _invoke(out);
          return in.read_long();
        } catch (ApplicationException ex) {
          in = ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_a_remote_interface(arg0);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_a_remote_interface",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_a_remote_interface(arg0);
      }
      try {
        CallBackInterface arg0Copy = (CallBackInterface) Util.copyObject(arg0,
            _orb());
        return ((RMIIIOPTests) so.servant).pass_a_remote_interface(arg0Copy);
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public CallBackInterface return_a_remote_interface()
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA.portable.InputStream in = null;
        try {
          OutputStream out = _request("return_a_remote_interface", true);
          in = _invoke(out);
          return (CallBackInterface) PortableRemoteObject
              .narrow(in.read_Object(), CallBackInterface.class);
        } catch (ApplicationException ex) {
          in = ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return return_a_remote_interface();
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("return_a_remote_interface",
          RMIIIOPTests.class);
      if (so == null) {
        return return_a_remote_interface();
      }
      try {
        CallBackInterface result = ((RMIIIOPTests) so.servant)
            .return_a_remote_interface();
        return (CallBackInterface) Util.copyObject(result, _orb());
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public int pass_array_of_remote_interfaces(CallBackInterface[] arg0)
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) _request(
              "pass_array_of_remote_interfaces", true);
          out.write_value(cast_array(arg0), CallBackInterface[].class);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return in.read_long();
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_array_of_remote_interfaces(arg0);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_array_of_remote_interfaces",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_array_of_remote_interfaces(arg0);
      }
      try {
        CallBackInterface[] arg0Copy = (CallBackInterface[]) Util
            .copyObject(arg0, _orb());
        return ((RMIIIOPTests) so.servant)
            .pass_array_of_remote_interfaces(arg0Copy);
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public CallBackInterface[] return_array_of_remote_interfaces()
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          OutputStream out = _request("return_array_of_remote_interfaces",
              true);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return (CallBackInterface[]) in.read_value(CallBackInterface[].class);
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return return_array_of_remote_interfaces();
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("return_array_of_remote_interfaces",
          RMIIIOPTests.class);
      if (so == null) {
        return return_array_of_remote_interfaces();
      }
      try {
        CallBackInterface[] result = ((RMIIIOPTests) so.servant)
            .return_array_of_remote_interfaces();
        return (CallBackInterface[]) Util.copyObject(result, _orb());
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public int pass_verify_stub(CallBackInterface arg0)
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA.portable.InputStream in = null;
        try {
          OutputStream out = _request("pass_verify_stub", true);
          Util.writeRemoteObject(out, arg0);
          in = _invoke(out);
          return in.read_long();
        } catch (ApplicationException ex) {
          in = ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_verify_stub(arg0);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_verify_stub",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_verify_stub(arg0);
      }
      try {
        CallBackInterface arg0Copy = (CallBackInterface) Util.copyObject(arg0,
            _orb());
        return ((RMIIIOPTests) so.servant).pass_verify_stub(arg0Copy);
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public CallBackInterface return_verify_stub()
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA.portable.InputStream in = null;
        try {
          OutputStream out = _request("return_verify_stub", true);
          in = _invoke(out);
          return (CallBackInterface) PortableRemoteObject
              .narrow(in.read_Object(), CallBackInterface.class);
        } catch (ApplicationException ex) {
          in = ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return return_verify_stub();
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("return_verify_stub",
          RMIIIOPTests.class);
      if (so == null) {
        return return_verify_stub();
      }
      try {
        CallBackInterface result = ((RMIIIOPTests) so.servant)
            .return_verify_stub();
        return (CallBackInterface) Util.copyObject(result, _orb());
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public void throw_a_user_exception() throws java.rmi.RemoteException,
      com.sun.ts.tests.rmiiiop.ee.marshaltests.UserException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          OutputStream out = _request("throw_a_user_exception", true);
          _invoke(out);
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          if ($_id.equals(
              "IDL:com/sun/ts/tests/rmiiiop/ee/marshaltests/UserEx:1.0")) {
            throw (com.sun.ts.tests.rmiiiop.ee.marshaltests.UserException) in
                .read_value(
                    com.sun.ts.tests.rmiiiop.ee.marshaltests.UserException.class);
          }
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          throw_a_user_exception();
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("throw_a_user_exception",
          RMIIIOPTests.class);
      if (so == null) {
        throw_a_user_exception();
        return;
      }
      try {
        ((RMIIIOPTests) so.servant).throw_a_user_exception();
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        if (exCopy instanceof com.sun.ts.tests.rmiiiop.ee.marshaltests.UserException) {
          throw (com.sun.ts.tests.rmiiiop.ee.marshaltests.UserException) exCopy;
        }
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public int pass_a_graph_of_objects(Graph arg0)
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) _request(
              "pass_a_graph_of_objects", true);
          out.write_value(arg0, Graph.class);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return in.read_long();
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_a_graph_of_objects(arg0);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_a_graph_of_objects",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_a_graph_of_objects(arg0);
      }
      try {
        Graph arg0Copy = (Graph) Util.copyObject(arg0, _orb());
        return ((RMIIIOPTests) so.servant).pass_a_graph_of_objects(arg0Copy);
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public Graph return_a_graph_of_objects() throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          OutputStream out = _request("return_a_graph_of_objects", true);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return (Graph) in.read_value(Graph.class);
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return return_a_graph_of_objects();
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("return_a_graph_of_objects",
          RMIIIOPTests.class);
      if (so == null) {
        return return_a_graph_of_objects();
      }
      try {
        Graph result = ((RMIIIOPTests) so.servant).return_a_graph_of_objects();
        return (Graph) Util.copyObject(result, _orb());
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public int pass_array_of_graph_objects(Graph[] arg0)
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) _request(
              "pass_array_of_graph_objects", true);
          out.write_value(cast_array(arg0), Graph[].class);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return in.read_long();
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_array_of_graph_objects(arg0);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_array_of_graph_objects",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_array_of_graph_objects(arg0);
      }
      try {
        Graph[] arg0Copy = (Graph[]) Util.copyObject(arg0, _orb());
        return ((RMIIIOPTests) so.servant)
            .pass_array_of_graph_objects(arg0Copy);
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public Graph[] return_array_of_graph_objects()
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          OutputStream out = _request("return_array_of_graph_objects", true);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return (Graph[]) in.read_value(Graph[].class);
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return return_array_of_graph_objects();
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("return_array_of_graph_objects",
          RMIIIOPTests.class);
      if (so == null) {
        return return_array_of_graph_objects();
      }
      try {
        Graph[] result = ((RMIIIOPTests) so.servant)
            .return_array_of_graph_objects();
        return (Graph[]) Util.copyObject(result, _orb());
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public Object[][][] pass_return_object3_array(Object[][][] arg0)
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) _request(
              "pass_return_object3_array", true);
          out.write_value(cast_array(arg0), Object[][][].class);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return (Object[][][]) in.read_value(Object[][][].class);
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_return_object3_array(arg0);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_return_object3_array",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_return_object3_array(arg0);
      }
      try {
        Object[][][] arg0Copy = (Object[][][]) Util.copyObject(arg0, _orb());
        Object[][][] result = ((RMIIIOPTests) so.servant)
            .pass_return_object3_array(arg0Copy);
        return (Object[][][]) Util.copyObject(result, _orb());
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public Multi pass_return_multiclass_types(Multi arg0)
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) _request(
              "pass_return_multiclass_types", true);
          out.write_value(arg0, Multi.class);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return (Multi) in.read_value(Multi.class);
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_return_multiclass_types(arg0);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("pass_return_multiclass_types",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_return_multiclass_types(arg0);
      }
      try {
        Multi arg0Copy = (Multi) Util.copyObject(arg0, _orb());
        Multi result = ((RMIIIOPTests) so.servant)
            .pass_return_multiclass_types(arg0Copy);
        return (Multi) Util.copyObject(result, _orb());
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public IDLStruct pass_return_idl_entity_types(IDLStruct arg0)
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) _request(
              "pass_return_idl_entity_types__org_omg_boxedIDL_com_sun_ts_tests_rmiiiop_ee_marshaltests_IDLStruct",
              true);
          out.write_value(arg0, IDLStruct.class);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return (IDLStruct) in.read_value(IDLStruct.class);
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_return_idl_entity_types(arg0);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke(
          "pass_return_idl_entity_types__org_omg_boxedIDL_com_sun_ts_tests_rmiiiop_ee_marshaltests_IDLStruct",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_return_idl_entity_types(arg0);
      }
      try {
        IDLStruct arg0Copy = (IDLStruct) Util.copyObject(arg0, _orb());
        IDLStruct result = ((RMIIIOPTests) so.servant)
            .pass_return_idl_entity_types(arg0Copy);
        return (IDLStruct) Util.copyObject(result, _orb());
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public IDLStruct[] pass_return_idl_entity_types(IDLStruct[] arg0)
      throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA_2_3.portable.InputStream in = null;
        try {
          org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) _request(
              "pass_return_idl_entity_types__org_omg_boxedRMI_org_omg_boxedIDL_com_sun_ts_tests_rmiiiop_ee_marshaltests_seq1_IDLStruct",
              true);
          out.write_value(cast_array(arg0), IDLStruct[].class);
          in = (org.omg.CORBA_2_3.portable.InputStream) _invoke(out);
          return (IDLStruct[]) in.read_value(IDLStruct[].class);
        } catch (ApplicationException ex) {
          in = (org.omg.CORBA_2_3.portable.InputStream) ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          return pass_return_idl_entity_types(arg0);
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke(
          "pass_return_idl_entity_types__org_omg_boxedRMI_org_omg_boxedIDL_com_sun_ts_tests_rmiiiop_ee_marshaltests_seq1_IDLStruct",
          RMIIIOPTests.class);
      if (so == null) {
        return pass_return_idl_entity_types(arg0);
      }
      try {
        IDLStruct[] arg0Copy = (IDLStruct[]) Util.copyObject(arg0, _orb());
        IDLStruct[] result = ((RMIIIOPTests) so.servant)
            .pass_return_idl_entity_types(arg0Copy);
        return (IDLStruct[]) Util.copyObject(result, _orb());
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  public void shutdown_rmiiiop_server() throws java.rmi.RemoteException {
    if (!Util.isLocal(this)) {
      try {
        org.omg.CORBA.portable.InputStream in = null;
        try {
          OutputStream out = _request("shutdown_rmiiiop_server", true);
          _invoke(out);
        } catch (ApplicationException ex) {
          in = ex.getInputStream();
          String $_id = in.read_string();
          throw new UnexpectedException($_id);
        } catch (RemarshalException ex) {
          shutdown_rmiiiop_server();
        } finally {
          _releaseReply(in);
        }
      } catch (SystemException ex) {
        throw Util.mapSystemException(ex);
      }
    } else {
      ServantObject so = _servant_preinvoke("shutdown_rmiiiop_server",
          RMIIIOPTests.class);
      if (so == null) {
        shutdown_rmiiiop_server();
        return;
      }
      try {
        ((RMIIIOPTests) so.servant).shutdown_rmiiiop_server();
      } catch (Throwable ex) {
        Throwable exCopy = (Throwable) Util.copyObject(ex, _orb());
        throw Util.wrapException(exCopy);
      } finally {
        _servant_postinvoke(so);
      }
    }
  }

  // This method is required as a work-around for
  // a bug in the JDK 1.1.6 verifier.

  private Serializable cast_array(Object obj) {
    return (Serializable) obj;
  }
}
