/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonobjecttests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import com.sun.ts.tests.jsonp.api.common.ObjectBuilder;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class ObjectBuild {
    ObjectBuild() {
    }

    TestResult test() {
        TestResult result = new TestResult("JsonObjectBuilder API methods added in JSON-P 1.1.");
        TestUtil.logMsg((String)"JsonObjectBuilder API methods added in JSON-P 1.1.");
        this.testAddString(result);
        this.testAddInt(result);
        this.testAddBool(result);
        this.testAddObject(result);
        this.testAddAllNull(result);
        this.testRemoveString(result);
        this.testRemoveInt(result);
        this.testRemoveBool(result);
        this.testRemoveObject(result);
        this.testRemoveNull(result);
        return result;
    }

    private void testAddString(TestResult result) {
        TestUtil.logMsg((String)" - addAll(JsonObjectBuilder) for String");
        JsonObjectBuilder target = ObjectBuilder.add(Json.createObjectBuilder(), "name", "John Smith");
        JsonObjectBuilder arg = ObjectBuilder.add(Json.createObjectBuilder(), "address", "In a galaxy far far away");
        JsonObject check = SimpleValues.createSimpleObjectWithStr();
        this.verifyAddAll(result, check, target, arg);
    }

    private void testAddInt(TestResult result) {
        TestUtil.logMsg((String)" - addAll(JsonObjectBuilder) for int");
        JsonObjectBuilder target = ObjectBuilder.add(Json.createObjectBuilder(), "name", "John Smith");
        JsonObjectBuilder arg = ObjectBuilder.add(Json.createObjectBuilder(), "age", 42);
        JsonObject check = SimpleValues.createSimpleObjectWithInt();
        this.verifyAddAll(result, check, target, arg);
    }

    private void testAddBool(TestResult result) {
        TestUtil.logMsg((String)" - addAll(JsonObjectBuilder) for boolean");
        JsonObjectBuilder target = ObjectBuilder.add(Json.createObjectBuilder(), "name", "John Smith");
        JsonObjectBuilder arg = ObjectBuilder.add(Json.createObjectBuilder(), "married", true);
        JsonObject check = SimpleValues.createSimpleObjectWithBool();
        this.verifyAddAll(result, check, target, arg);
    }

    private void testAddObject(TestResult result) {
        TestUtil.logMsg((String)" - addAll(JsonObjectBuilder) for JsonObject");
        JsonObjectBuilder target = ObjectBuilder.add(Json.createObjectBuilder(), "name", "John Smith").add("child", (JsonValue)SimpleValues.DEF_OBJ_VALUE);
        JsonObjectBuilder arg = ObjectBuilder.add(Json.createObjectBuilder(), "wife", SimpleValues.OBJ_VALUE);
        JsonObject check = SimpleValues.createCompoundObjectWithObject();
        this.verifyAddAll(result, check, target, arg);
    }

    private void testAddAllNull(TestResult result) {
        TestUtil.logMsg((String)" - addAll(JsonObjectBuilder) for null builder argument");
        JsonObjectBuilder builder = Json.createObjectBuilder();
        try {
            builder.addAll((JsonObjectBuilder)null);
            result.fail("addAll(null)", "Calling method with null argument shall throw NullPointerException");
        }
        catch (NullPointerException e) {
            TestUtil.logMsg((String)("    - Expected exception: " + e.getMessage()));
        }
        catch (Throwable t) {
            result.fail("addAll(null)", "Calling method with null argument shall throw NullPointerException, not " + t.getClass().getSimpleName());
        }
    }

    private void testRemoveString(TestResult result) {
        TestUtil.logMsg((String)" - remove(String) for String");
        JsonObjectBuilder in = ObjectBuilder.add(Json.createObjectBuilder(), "name", "John Smith").add("address", "In a galaxy far far away");
        JsonObjectBuilder builder = in.remove("address");
        JsonObject check = SimpleValues.createSimpleObject();
        this.verifyRemovel(result, check, builder);
    }

    private void testRemoveInt(TestResult result) {
        TestUtil.logMsg((String)" - remove(String) for int");
        JsonObjectBuilder in = ObjectBuilder.add(Json.createObjectBuilder(), "name", "John Smith").add("age", 42);
        JsonObjectBuilder builder = in.remove("age");
        JsonObject check = SimpleValues.createSimpleObject();
        this.verifyRemovel(result, check, builder);
    }

    private void testRemoveBool(TestResult result) {
        TestUtil.logMsg((String)" - remove(String) for boolean");
        JsonObjectBuilder in = ObjectBuilder.add(Json.createObjectBuilder(), "name", "John Smith").add("married", true);
        JsonObjectBuilder builder = in.remove("married");
        JsonObject check = SimpleValues.createSimpleObject();
        this.verifyRemovel(result, check, builder);
    }

    private void testRemoveObject(TestResult result) {
        TestUtil.logMsg((String)" - remove(String) for JsonObject");
        JsonObjectBuilder in = ObjectBuilder.add(Json.createObjectBuilder(), "name", "John Smith").add("child", (JsonValue)SimpleValues.DEF_OBJ_VALUE).add("wife", (JsonValue)SimpleValues.OBJ_VALUE);
        JsonObjectBuilder builder = in.remove("wife");
        JsonObject check = SimpleValues.createCompoundObject();
        this.verifyRemovel(result, check, builder);
    }

    private void testRemoveNull(TestResult result) {
        TestUtil.logMsg((String)" - remove(String) for null name argument");
        JsonObjectBuilder builder = Json.createObjectBuilder();
        try {
            builder.remove((String)null);
            result.fail("remove(null)", "Calling method with null argument shall throw NullPointerException");
        }
        catch (NullPointerException e) {
            TestUtil.logMsg((String)("    - Expected exception: " + e.getMessage()));
        }
        catch (Throwable t) {
            result.fail("remove(null)", "Calling method with null argument shall throw NullPointerException, not " + t.getClass().getSimpleName());
        }
    }

    private void verifyAddAll(TestResult result, JsonObject check, JsonObjectBuilder target, JsonObjectBuilder arg) {
        target.addAll(arg);
        JsonObject out = target.build();
        if (this.operationFailed((JsonValue)check, (JsonValue)out)) {
            result.fail("addAll(JsonObjectBuilder)", "Output builder " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString((JsonValue)check));
        }
    }

    private void verifyRemovel(TestResult result, JsonObject check, JsonObjectBuilder builder) {
        JsonObject out = builder.build();
        if (this.operationFailed((JsonValue)check, (JsonValue)out)) {
            result.fail("remove(String)", "Output builder " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString((JsonValue)check));
        }
    }

    protected boolean operationFailed(JsonValue check, JsonValue out) {
        return out == null || !JsonAssert.assertEquals(check, out);
    }
}

