/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.ee.javax_xml_registry.BusinessLifeCycleManager;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import com.sun.ts.tests.jaxr.common.JAXR_Util;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.Connection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.SpecificationLink;

public class JAXRClient
extends JAXRCommonClient {
    Locale tsLocale = new Locale("en", "US");
    RegistryService rs2 = null;
    BusinessLifeCycleManager blm2 = null;

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            this.logMsg("in cleanup");
            if (this.conn != null) {
                this.logTrace("Cleanup is closing the connection");
                this.conn.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void businessLifeCycleManager_saveServiceBindingsTest() throws EETest.Fault {
        String testName = "businessLifeCycleManager_saveServiceBindingsTest";
        boolean pass = false;
        String serviceName = "testService";
        String sbDescription = "my sb description";
        String conceptName = "my concept";
        Collection sbKeys = null;
        Collection serviceKeys = null;
        Collection orgKeys = null;
        Collection conceptKeys = null;
        Key conceptKey2222 = null;
        Key serviceKey2222 = null;
        Object serviceBindingKey = null;
        Key orgKey2222 = null;
        Key sbKey2222 = null;
        String accessURI = this.baseuri + "jaxrTestPage1.html";
        String orgName = "TS Default Organization";
        try {
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveOrganizations failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            orgKeys = br.getCollection();
            for (Key orgKey2222 : orgKeys) {
            }
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            org = (Organization)bqm.getRegistryObject(orgKey2222.getId(), "Organization");
            Service service = this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName));
            org.addService(service);
            ArrayList<Service> services = new ArrayList<Service>();
            services.add(service);
            br = this.blm.saveServices(services);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveService failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            serviceKeys = br.getCollection();
            for (Key serviceKey2222 : serviceKeys) {
            }
            service = (Service)bqm.getRegistryObject(serviceKey2222.getId(), "Service");
            Concept myConcept = (Concept)this.blm.createObject("Concept");
            myConcept.setName(this.blm.createInternationalString(this.tsLocale, conceptName));
            ArrayList<Concept> concepts = new ArrayList<Concept>();
            concepts.add(myConcept);
            br = this.blm.saveConcepts(concepts);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveConcepts failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            conceptKeys = br.getCollection();
            for (Key conceptKey2222 : conceptKeys) {
            }
            myConcept = (Concept)bqm.getRegistryObject(conceptKey2222.getId(), "Concept");
            SpecificationLink sl = this.blm.createSpecificationLink();
            sl.setSpecificationObject((RegistryObject)myConcept);
            ServiceBinding sb2222 = this.blm.createServiceBinding();
            sb2222.setDescription(this.blm.createInternationalString(this.tsLocale, sbDescription));
            sb2222.setAccessURI(accessURI);
            sb2222.addSpecificationLink(sl);
            service.addServiceBinding(sb2222);
            this.debug.add("== Check sb before save \n");
            this.debug.add("==>> access uri is " + sb2222.getAccessURI() + "\n");
            this.debug.add("==>> sb description is " + sb2222.getDescription().getValue(this.tsLocale) + "\n");
            this.debug.add(" ================================================  \n");
            Collection sbs = new ArrayList<ServiceBinding>();
            sbs.add(sb2222);
            br = this.blm.saveServiceBindings(sbs);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveServiceBinding failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            sbKeys = br.getCollection();
            for (Key sbKey2222 : sbKeys) {
            }
            ArrayList<Concept> specifications = new ArrayList<Concept>();
            specifications.add(myConcept);
            br = bqm.findServiceBindings(serviceKey2222, null, null, specifications);
            sbs = br.getCollection();
            this.debug.add("==>>  Count of sbs found is : " + sbs.size() + "\n");
            for (ServiceBinding sb2222 : sbs) {
                Service myService = sb2222.getService();
                this.debug.add("==>> service name is : " + myService.getName().getValue(this.tsLocale) + "\n");
                this.debug.add("==>> access uri is " + sb2222.getAccessURI() + "\n");
                this.debug.add("==>> sb description is " + sb2222.getDescription().getValue(this.tsLocale) + "\n");
                boolean failures = false;
                if (!myService.getName().getValue(this.tsLocale).equals(serviceName)) {
                    this.debug.add("Error: unexpected service name \n");
                    failures = true;
                }
                if (!sb2222.getDescription().getValue(this.tsLocale).equals(sbDescription)) {
                    this.debug.add("Error: unexpected servicebinding description \n");
                    failures = true;
                }
                if (!sb2222.getAccessURI().equals(accessURI)) {
                    this.debug.add("Error: unexpected accessURI name \n");
                    failures = true;
                }
                if (failures) continue;
                pass = true;
            }
            if (!pass) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            try {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed ");
            }
            catch (Throwable throwable) {
                try {
                    if (conceptKeys != null) {
                        this.debug.add("==>>  Cleanup: delete concept\n");
                        this.blm.deleteConcepts(conceptKeys);
                    }
                    if (sbKeys != null) {
                        this.debug.add("==>>  Cleanup: delete serviceBinding\n");
                        this.blm.deleteServiceBindings(sbKeys);
                    }
                    if (serviceKeys != null) {
                        this.blm.deleteServices(serviceKeys);
                        this.debug.add("==>>   Cleanup: delete service\n");
                    }
                    if (orgKeys == null) throw throwable;
                    this.debug.add("==>>  Cleanup: delete organization\n");
                    this.blm.deleteOrganizations(orgKeys);
                    throw throwable;
                }
                catch (JAXRException je) {
                    TestUtil.printStackTrace((Throwable)je);
                    this.debug.add("Error: not able to delete organization \n");
                }
                throw throwable;
            }
        }
        try {
            if (conceptKeys != null) {
                this.debug.add("==>>  Cleanup: delete concept\n");
                this.blm.deleteConcepts(conceptKeys);
            }
            if (sbKeys != null) {
                this.debug.add("==>>  Cleanup: delete serviceBinding\n");
                this.blm.deleteServiceBindings(sbKeys);
            }
            if (serviceKeys != null) {
                this.blm.deleteServices(serviceKeys);
                this.debug.add("==>>   Cleanup: delete service\n");
            }
            if (orgKeys == null) return;
            this.debug.add("==>>  Cleanup: delete organization\n");
            this.blm.deleteOrganizations(orgKeys);
            return;
        }
        catch (JAXRException je) {
            TestUtil.printStackTrace((Throwable)je);
            this.debug.add("Error: not able to delete organization \n");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void businessLifeCycleManager_saveServiceBindingsUpdateTest() throws EETest.Fault {
        String testName = "businessLifeCycleManager_saveServiceBindingsUpdateTest";
        boolean pass = false;
        String serviceName = "testService";
        String conceptName = "myWSDLFile";
        Collection sbKeys = null;
        Collection serviceKeys = null;
        Collection orgKeys = null;
        Collection conceptKeys = null;
        Key conceptKey2222 = null;
        Key serviceKey2222 = null;
        Object serviceBindingKey = null;
        Key orgKey2222 = null;
        Key sbKey2222 = null;
        String accessURI = this.baseuri + "jaxrTestPage1.html";
        String accessURIUpd = "http://www.sun.com";
        String orgName = "TS Default Organization";
        try {
            Service myService;
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveOrganizations failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            orgKeys = br.getCollection();
            for (Key orgKey2222 : orgKeys) {
            }
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            org = (Organization)bqm.getRegistryObject(orgKey2222.getId(), "Organization");
            Service service = this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName));
            org.addService(service);
            ArrayList<Service> services = new ArrayList<Service>();
            services.add(service);
            br = this.blm.saveServices(services);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveService failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            serviceKeys = br.getCollection();
            for (Key serviceKey2222 : serviceKeys) {
            }
            service = (Service)bqm.getRegistryObject(serviceKey2222.getId(), "Service");
            Concept myConcept = (Concept)this.blm.createObject("Concept");
            myConcept.setName(this.blm.createInternationalString(this.tsLocale, conceptName));
            ArrayList<Concept> concepts = new ArrayList<Concept>();
            concepts.add(myConcept);
            br = this.blm.saveConcepts(concepts);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveConcepts failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            conceptKeys = br.getCollection();
            for (Key conceptKey2222 : conceptKeys) {
            }
            myConcept = (Concept)bqm.getRegistryObject(conceptKey2222.getId(), "Concept");
            SpecificationLink sl = this.blm.createSpecificationLink();
            sl.setSpecificationObject((RegistryObject)myConcept);
            ServiceBinding sb2222 = this.blm.createServiceBinding();
            sb2222.setAccessURI(accessURI);
            sb2222.addSpecificationLink(sl);
            service.addServiceBinding(sb2222);
            Collection<ServiceBinding> sbs = new ArrayList<ServiceBinding>();
            sbs.add(sb2222);
            br = this.blm.saveServiceBindings(sbs);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveServiceBinding failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            sbKeys = br.getCollection();
            for (Key sbKey2222 : sbKeys) {
            }
            ArrayList<Concept> specifications = new ArrayList<Concept>();
            specifications.add(myConcept);
            br = bqm.findServiceBindings(serviceKey2222, null, null, specifications);
            sbs = br.getCollection();
            this.debug.add("==>>  Count of sbs found is : " + sbs.size() + "\n");
            for (ServiceBinding sb2222 : sbs) {
                myService = sb2222.getService();
                Collection collection = sb2222.getSpecificationLinks();
            }
            this.debug.add("===> Update SB  \n");
            sb2222.setAccessURI(accessURIUpd);
            sbs.clear();
            sbs.add(sb2222);
            br = this.blm.saveServiceBindings(sbs);
            if (br.getExceptions() != null) {
                this.debug.add("==>> \n");
                this.debug.add("==>>  Error:    saveServiceBinding failed \n");
                this.debug.add("==>> \n");
                throw new EETest.Fault(testName + " failed ");
            }
            this.debug.add(" ===================Verify the Update of SB =============================  \n");
            br = bqm.findServiceBindings(serviceKey2222, null, null, specifications);
            sbs = br.getCollection();
            this.debug.add("==>> \n");
            this.debug.add("==>>  Count of sbs found is : " + sbs.size() + "\n");
            this.debug.add("==>> \n");
            for (ServiceBinding sb2222 : sbs) {
            }
            myService = sb2222.getService();
            this.debug.add("==>> service name is : " + myService.getName().getValue(this.tsLocale) + "\n");
            this.debug.add("==>> access uri is " + sb2222.getAccessURI() + "\n");
            boolean failures = false;
            if (!myService.getName().getValue(this.tsLocale).equals(serviceName)) {
                this.debug.add("Error: unexpected service name \n");
                failures = true;
            }
            if (!sb2222.getAccessURI().equals(accessURIUpd)) {
                this.debug.add("Error: unexpected accessURI name \n");
                failures = true;
            }
            if (!failures) {
                pass = true;
            }
            if (!pass) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            try {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed ");
            }
            catch (Throwable throwable) {
                try {
                    if (conceptKeys != null) {
                        this.debug.add("==>>  Cleanup: delete concept\n");
                        this.blm.deleteConcepts(conceptKeys);
                    }
                    if (sbKeys != null) {
                        this.debug.add("==>>  Cleanup: delete serviceBinding\n");
                        this.blm.deleteServiceBindings(sbKeys);
                    }
                    if (serviceKeys != null) {
                        this.blm.deleteServices(serviceKeys);
                        this.debug.add("==>>   Cleanup: delete service\n");
                    }
                    if (orgKeys == null) throw throwable;
                    this.debug.add("==>>  Cleanup: delete organization\n");
                    this.blm.deleteOrganizations(orgKeys);
                    throw throwable;
                }
                catch (JAXRException je) {
                    TestUtil.printStackTrace((Throwable)je);
                    this.debug.add("Error: not able to delete organization \n");
                }
                throw throwable;
            }
        }
        try {
            if (conceptKeys != null) {
                this.debug.add("==>>  Cleanup: delete concept\n");
                this.blm.deleteConcepts(conceptKeys);
            }
            if (sbKeys != null) {
                this.debug.add("==>>  Cleanup: delete serviceBinding\n");
                this.blm.deleteServiceBindings(sbKeys);
            }
            if (serviceKeys != null) {
                this.blm.deleteServices(serviceKeys);
                this.debug.add("==>>   Cleanup: delete service\n");
            }
            if (orgKeys == null) return;
            this.debug.add("==>>  Cleanup: delete organization\n");
            this.blm.deleteOrganizations(orgKeys);
            return;
        }
        catch (JAXRException je) {
            TestUtil.printStackTrace((Throwable)je);
            this.debug.add("Error: not able to delete organization \n");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void businessLifeCycleManager_saveOrganizationTest() throws EETest.Fault {
        Collection orgKeys;
        block11: {
            String testName = "businessLifeCycleManager_saveOrganizationTest";
            boolean pass = false;
            String orgName = "SaveOrganization organization";
            String orgDescription = "this is a test organization from businessLifeCycleManager_saveOrganizationTest";
            String orgNameUpd = "UpdatedSaveOrganization organization";
            String orgDescriptionUpd = "Updated-this is a test organization from businessLifeCycleManager_saveOrganizationTest";
            orgKeys = null;
            Key savekey2222 = null;
            String objectType = "Organization";
            try {
                BusinessQueryManager bqm;
                String orgId;
                block13: {
                    block14: {
                        block12: {
                            this.debug.add("Publish the organization \n");
                            Organization org = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
                            org.setDescription(this.blm.createInternationalString(this.tsLocale, orgDescription));
                            ArrayList<Organization> orgs = new ArrayList<Organization>();
                            orgs.add(org);
                            BulkResponse br = this.blm.saveOrganizations(orgs);
                            if (br.getExceptions() != null) {
                                this.debug.add("Error:    saveOrganizations failed \n");
                                throw new EETest.Fault(testName + " failed ");
                            }
                            orgKeys = br.getCollection();
                            for (Key savekey2222 : orgKeys) {
                            }
                            orgId = savekey2222.getId();
                            this.debug.add("Retrieve the published organization from the registry \n");
                            bqm = this.rs.getBusinessQueryManager();
                            Organization retOrg = (Organization)bqm.getRegistryObject(orgId, objectType);
                            if (!retOrg.getName().getValue(this.tsLocale).equals(orgName) || !retOrg.getDescription().getValue(this.tsLocale).equals(orgDescription)) break block12;
                            this.debug.add("Good - retrieved published org successfully! \n");
                            this.debug.add("Now update the organization \n");
                            retOrg.setName(this.blm.createInternationalString(this.tsLocale, orgNameUpd));
                            retOrg.setDescription(this.blm.createInternationalString(this.tsLocale, orgDescriptionUpd));
                            orgs.clear();
                            orgs.add(retOrg);
                            br = this.blm.saveOrganizations(orgs);
                            if (br.getExceptions() == null) break block13;
                            break block14;
                        }
                        this.debug.add("Failed to verify retrieved published org. \n");
                        throw new EETest.Fault(testName + " test failed to complete \n");
                    }
                    this.debug.add("Error:    update saveOrganizations failed \n");
                    throw new EETest.Fault(testName + " failed ");
                }
                this.debug.add("Retrieve the updated published organization from the registry \n");
                Organization updOrg = (Organization)bqm.getRegistryObject(orgId, objectType);
                if (updOrg.getName().getValue(this.tsLocale).equals(orgNameUpd) && updOrg.getDescription().getValue(this.tsLocale).equals(orgDescriptionUpd)) {
                    this.debug.add("Good - retrieved updated published org successfully! \n");
                    pass = true;
                    if (pass) break block11;
                    throw new EETest.Fault(testName + " failed ");
                }
                this.debug.add("Failed to verify retrieved updated published org. \n");
                throw new EETest.Fault(testName + " test failed to complete \n");
            }
            catch (Exception e) {
                try {
                    TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                    TestUtil.printStackTrace((Throwable)e);
                    throw new EETest.Fault(testName + " failed ");
                }
                catch (Throwable throwable) {
                    try {
                        this.debug.add(" Cleanup: delete organization\n");
                        this.blm.deleteOrganizations(orgKeys);
                        throw throwable;
                    }
                    catch (JAXRException je) {
                        TestUtil.printStackTrace((Throwable)je);
                        this.debug.add("Error: not able to delete organization \n");
                    }
                    throw throwable;
                }
            }
        }
        try {
            this.debug.add(" Cleanup: delete organization\n");
            this.blm.deleteOrganizations(orgKeys);
            return;
        }
        catch (JAXRException je) {
            TestUtil.printStackTrace((Throwable)je);
            this.debug.add("Error: not able to delete organization \n");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void businessLifeCycleManager_saveAssociationsUpdateTest() throws EETest.Fault {
        String testName = "businessLifeCycleManager_saveAssociationsUpdateTest";
        boolean pass = false;
        String orgTarget = "Org Target";
        String orgSource = "Org Source";
        String type = "EquivalentTo";
        BulkResponse br = null;
        Key savekey2222 = null;
        Key assockey = null;
        String objectType = "Organization";
        BusinessQueryManager bqm2 = null;
        Collection<Key> associationKeys = null;
        Collection sourceKeys = null;
        Collection targetKeys = null;
        String targetId = null;
        String sourceId = null;
        try {
            this.secondConnection();
            bqm2 = this.rs2.getBusinessQueryManager();
            Organization target = this.blm2.createOrganization(this.blm.createInternationalString(this.tsLocale, orgTarget));
            Organization source = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgSource));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(source);
            br = this.blm.saveOrganizations(orgs);
            if (br.getExceptions() != null) {
                this.debug.add("Error:    source  saveOrganizations failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            sourceKeys = br.getCollection();
            for (Key savekey2222 : sourceKeys) {
            }
            sourceId = savekey2222.getId();
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            Organization pubSource = (Organization)bqm.getRegistryObject(sourceId, objectType);
            this.debug.add("Verify the pub source retrieved from registry \n");
            this.debug.add("pubSource retrieved: " + pubSource.getName().getValue(this.tsLocale) + "\n");
            orgs.clear();
            orgs.add(target);
            br = this.blm2.saveOrganizations(orgs);
            if (br.getExceptions() != null) {
                this.debug.add("Error:    target saveOrganizations failed \n");
                throw new EETest.Fault(testName + " did not complete due to errors");
            }
            targetKeys = br.getCollection();
            for (Key savekey2222 : targetKeys) {
            }
            targetId = savekey2222.getId();
            Organization pubTarget = (Organization)bqm2.getRegistryObject(targetId, objectType);
            this.debug.add("Verify the pub target retrieved from registry \n");
            this.debug.add("pubTarget retrieved: " + pubTarget.getName().getValue(this.tsLocale) + "\n");
            Concept associationType = this.getAssociationConcept(type);
            if (associationType == null) {
                throw new EETest.Fault(testName + " getAssociationConcept returned null associationType");
            }
            Association a = this.blm.createAssociation((RegistryObject)pubTarget, associationType);
            a.setSourceObject((RegistryObject)pubSource);
            this.debug.add("users confirm the association");
            this.blm.confirmAssociation(a);
            this.blm2.confirmAssociation(a);
            ArrayList<Association> associations = new ArrayList<Association>();
            associations.add(a);
            br = this.blm.saveAssociations(associations, false);
            associationKeys = br.getCollection();
            Iterator iter = associationKeys.iterator();
            Key assocKey = (Key)iter.next();
            if (br.getExceptions() != null) {
                this.debug.add("Error:    saveAssociations failed \n");
                throw new EETest.Fault(testName + " did not complete due to errors");
            }
            BulkResponse targetBResp = bqm.findCallerAssociations(null, new Boolean(true), new Boolean(true), null);
            Association myAssoc = null;
            if (targetBResp.getExceptions() == null) {
                Collection targetResult = targetBResp.getCollection();
                this.debug.add("Associations returned from findCallerAssociations is " + targetResult.size() + "\n");
                if (targetResult.size() > 0) {
                    for (Association aa : targetResult) {
                        if (!aa.getKey().getId().equals(assocKey.getId())) continue;
                        myAssoc = aa;
                        break;
                    }
                    assockey = myAssoc.getKey();
                    Concept atype = myAssoc.getAssociationType();
                    this.debug.add("type is " + atype.getName().getValue(this.tsLocale) + "\n");
                }
            }
            if (assockey == null) {
                throw new EETest.Fault(testName + " failed to find association ");
            }
            String updateType = "RelatedTo";
            Concept myType = this.getAssociationConcept(updateType);
            this.debug.add(" changed association type to RelatedTo \n");
            myAssoc.setAssociationType(myType);
            associations.clear();
            associations.add(myAssoc);
            this.debug.add("Save updated association \n");
            br = this.blm.saveAssociations(associations, false);
            associationKeys = br.getCollection();
            iter = associationKeys.iterator();
            assocKey = (Key)iter.next();
            if (br.getExceptions() != null) {
                this.debug.add("Error:    saveAssociations failed \n");
                throw new EETest.Fault(testName + " did not complete due to errors");
            }
            this.debug.add("use findCallerAssociations to retrieve updated association \n");
            br = bqm.findCallerAssociations(null, new Boolean(true), new Boolean(false), null);
            if (br.getExceptions() == null) {
                Collection targetResult = br.getCollection();
                this.debug.add("Associations returned from findCallerAssociations is " + targetResult.size() + "\n");
                Association a1 = null;
                if (targetResult.size() > 0) {
                    for (Association aa : targetResult) {
                        if (!aa.getKey().getId().equals(assocKey.getId())) continue;
                        a1 = aa;
                        break;
                    }
                    if (a1 == null) {
                        new EETest.Fault(testName + " did not complete - association is null! ");
                    }
                    Concept atype = a1.getAssociationType();
                    this.debug.add("type is " + atype.getValue() + "\n");
                    Organization o = (Organization)a1.getSourceObject();
                    this.debug.add("Source object " + o.getName().getValue(this.tsLocale) + "\n");
                    if (o.getName().getValue(this.tsLocale).equals(orgSource)) {
                        this.debug.add("Good - org source name matched! \n");
                        if (a1.getAssociationType().getValue().equalsIgnoreCase(updateType)) {
                            this.debug.add("And the concept type was updated too! \n");
                            pass = true;
                        }
                    }
                }
            }
            if (!pass) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            try {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed ");
            }
            catch (Throwable throwable) {
                try {
                    if (assockey != null) {
                        associationKeys = new ArrayList<Key>();
                        associationKeys.add(assockey);
                        this.debug.add(" Cleanup: Remove association\n");
                        this.blm.deleteAssociations(associationKeys);
                    }
                    this.debug.add(" Cleanup: Remove source organization\n");
                    this.blm.deleteOrganizations(sourceKeys);
                    this.debug.add(" Cleanup: Remove target organization\n");
                    this.blm2.deleteOrganizations(targetKeys);
                    throw throwable;
                }
                catch (JAXRException je) {
                    TestUtil.printStackTrace((Throwable)je);
                    this.debug.add("Error: not able to delete registry object\n");
                }
                throw throwable;
            }
        }
        try {
            if (assockey != null) {
                associationKeys = new ArrayList();
                associationKeys.add(assockey);
                this.debug.add(" Cleanup: Remove association\n");
                this.blm.deleteAssociations(associationKeys);
            }
            this.debug.add(" Cleanup: Remove source organization\n");
            this.blm.deleteOrganizations(sourceKeys);
            this.debug.add(" Cleanup: Remove target organization\n");
            this.blm2.deleteOrganizations(targetKeys);
            return;
        }
        catch (JAXRException je) {
            TestUtil.printStackTrace((Throwable)je);
            this.debug.add("Error: not able to delete registry object\n");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void businessLifeCycleManager_saveAssociationsTest() throws EETest.Fault {
        String testName = "businessLifeCycleManager_saveAssociationsTest";
        boolean pass = false;
        String orgTarget = "Org Target";
        String orgSource = "Org Source";
        String type = "RelatedTo";
        BulkResponse br = null;
        Key savekey2222 = null;
        Key assockey = null;
        String objectType = "Organization";
        BusinessQueryManager bqm2 = null;
        Collection<Key> associationKeys = null;
        Collection sourceKeys = null;
        Collection targetKeys = null;
        String targetId = null;
        String sourceId = null;
        try {
            this.secondConnection();
            bqm2 = this.rs2.getBusinessQueryManager();
            Organization target = this.blm2.createOrganization(this.blm.createInternationalString(this.tsLocale, orgTarget));
            Organization source = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgSource));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(source);
            br = this.blm.saveOrganizations(orgs);
            if (br.getExceptions() != null) {
                this.debug.add("Error:    source  saveOrganizations failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            sourceKeys = br.getCollection();
            for (Key savekey2222 : sourceKeys) {
            }
            sourceId = savekey2222.getId();
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            Organization pubSource = (Organization)bqm.getRegistryObject(sourceId, objectType);
            this.debug.add("Verify the pub source retrieved from registry \n");
            this.debug.add("pubSource retrieved: " + pubSource.getName().getValue(this.tsLocale) + "\n");
            orgs.clear();
            orgs.add(target);
            br = this.blm2.saveOrganizations(orgs);
            if (br.getExceptions() != null) {
                this.debug.add("Error:    target saveOrganizations failed \n");
                throw new EETest.Fault(testName + " did not complete due to errors");
            }
            targetKeys = br.getCollection();
            for (Key savekey2222 : targetKeys) {
            }
            targetId = savekey2222.getId();
            Organization pubTarget = (Organization)bqm2.getRegistryObject(targetId, objectType);
            this.debug.add("Verify the pub target retrieved from registry \n");
            this.debug.add("pubTarget retrieved: " + pubTarget.getName().getValue(this.tsLocale) + "\n");
            Concept associationType = this.getAssociationConcept(type);
            if (associationType == null) {
                throw new EETest.Fault(testName + " getAssociationConcept returned null associationType");
            }
            Association a = this.blm.createAssociation((RegistryObject)pubTarget, associationType);
            a.setSourceObject((RegistryObject)pubSource);
            this.debug.add("users confirm the association");
            this.blm.confirmAssociation(a);
            ArrayList<Association> associations = new ArrayList<Association>();
            associations.add(a);
            br = this.blm.saveAssociations(associations, false);
            associationKeys = br.getCollection();
            Iterator iter = associationKeys.iterator();
            Key assocKey = (Key)iter.next();
            if (br.getExceptions() != null) {
                this.debug.add("Error:    saveAssociations failed \n");
                throw new EETest.Fault(testName + " did not complete due to errors");
            }
            BulkResponse targetBResp = bqm.findCallerAssociations(null, new Boolean(true), new Boolean(false), null);
            if (targetBResp.getExceptions() == null) {
                Collection targetResult = targetBResp.getCollection();
                this.debug.add("Associations returned from findCallerAssociations is " + targetResult.size() + "\n");
                Association a1 = null;
                if (targetResult.size() > 0) {
                    for (Association aa : targetResult) {
                        if (!aa.getKey().getId().equals(assocKey.getId())) continue;
                        a1 = aa;
                        break;
                    }
                    if (a1 == null) {
                        new EETest.Fault(testName + " did not complete - association is null! ");
                    }
                    assockey = a1.getKey();
                    Organization o = (Organization)a1.getSourceObject();
                    this.debug.add("Source object " + o.getName().getValue(this.tsLocale) + "\n");
                    if (o.getName().getValue(this.tsLocale).equals(orgSource)) {
                        this.debug.add("Good - verified save association \n");
                        pass = true;
                    }
                    o = (Organization)a1.getTargetObject();
                    this.debug.add("Target object " + o.getName().getValue(this.tsLocale) + "\n");
                    Concept atype = a1.getAssociationType();
                    this.debug.add("type is " + atype.getName().getValue(this.tsLocale) + "\n");
                    this.debug.add("==================================\n");
                }
            }
            if (!pass) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            try {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed ");
            }
            catch (Throwable throwable) {
                try {
                    if (assockey != null) {
                        associationKeys = new ArrayList<Key>();
                        associationKeys.add(assockey);
                        this.debug.add(" Cleanup: Remove association\n");
                        this.blm.deleteAssociations(associationKeys);
                    }
                    this.debug.add(" Cleanup: Remove source organization\n");
                    this.blm.deleteOrganizations(sourceKeys);
                    this.debug.add(" Cleanup: Remove target organization\n");
                    this.blm2.deleteOrganizations(targetKeys);
                    throw throwable;
                }
                catch (JAXRException je) {
                    TestUtil.printStackTrace((Throwable)je);
                    this.debug.add("Error: not able to delete registry object\n");
                }
                throw throwable;
            }
        }
        try {
            if (assockey != null) {
                associationKeys = new ArrayList();
                associationKeys.add(assockey);
                this.debug.add(" Cleanup: Remove association\n");
                this.blm.deleteAssociations(associationKeys);
            }
            this.debug.add(" Cleanup: Remove source organization\n");
            this.blm.deleteOrganizations(sourceKeys);
            this.debug.add(" Cleanup: Remove target organization\n");
            this.blm2.deleteOrganizations(targetKeys);
            return;
        }
        catch (JAXRException je) {
            TestUtil.printStackTrace((Throwable)je);
            this.debug.add("Error: not able to delete registry object\n");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void businessLifeCycleManager_deleteServiceBindingsTest() throws EETest.Fault {
        String testName = "businessLifeCycleManager_deleteServiceBindingsTest";
        String serviceName = "testService";
        String sbDescription = "my sb description";
        String conceptName = "my concept";
        Collection sbKeys = null;
        Collection serviceKeys = null;
        Collection orgKeys = null;
        Collection conceptKeys = null;
        Key conceptKey2222 = null;
        Key serviceKey2222 = null;
        Object serviceBindingKey = null;
        Key orgKey2222 = null;
        Key sbKey2222 = null;
        String accessURI = this.baseuri + "jaxrTestPage1.html";
        String orgName = "TS Default Organization";
        try {
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveOrganizations failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            orgKeys = br.getCollection();
            for (Key orgKey2222 : orgKeys) {
            }
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            org = (Organization)bqm.getRegistryObject(orgKey2222.getId(), "Organization");
            Service service = this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName));
            org.addService(service);
            ArrayList<Service> services = new ArrayList<Service>();
            services.add(service);
            br = this.blm.saveServices(services);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveService failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            serviceKeys = br.getCollection();
            for (Key serviceKey2222 : serviceKeys) {
            }
            service = (Service)bqm.getRegistryObject(serviceKey2222.getId(), "Service");
            Concept myConcept = (Concept)this.blm.createObject("Concept");
            myConcept.setName(this.blm.createInternationalString(this.tsLocale, conceptName));
            ArrayList<Concept> concepts = new ArrayList<Concept>();
            concepts.add(myConcept);
            br = this.blm.saveConcepts(concepts);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveConcepts failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            conceptKeys = br.getCollection();
            for (Key conceptKey2222 : conceptKeys) {
            }
            myConcept = (Concept)bqm.getRegistryObject(conceptKey2222.getId(), "Concept");
            SpecificationLink sl = this.blm.createSpecificationLink();
            sl.setSpecificationObject((RegistryObject)myConcept);
            ServiceBinding sb = this.blm.createServiceBinding();
            sb.setDescription(this.blm.createInternationalString(this.tsLocale, sbDescription));
            sb.setAccessURI(accessURI);
            sb.addSpecificationLink(sl);
            service.addServiceBinding(sb);
            Collection sbs = new ArrayList<ServiceBinding>();
            sbs.add(sb);
            br = this.blm.saveServiceBindings(sbs);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveServiceBinding failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            sbKeys = br.getCollection();
            for (Key sbKey2222 : sbKeys) {
            }
            ArrayList<Concept> specifications = new ArrayList<Concept>();
            specifications.add(myConcept);
            br = bqm.findServiceBindings(serviceKey2222, null, null, specifications);
            sbs = br.getCollection();
            this.debug.add("==>>  Published a service binding, Count found is : " + sbs.size() + "\n");
            Iterator iter = sbs.iterator();
            boolean found = false;
            while (iter.hasNext()) {
                sb = (ServiceBinding)iter.next();
                Service myService = sb.getService();
                if (myService.getName().getValue(this.tsLocale).equals(serviceName)) {
                    this.debug.add("==>> access uri is " + sb.getAccessURI() + "\n");
                    if (!sb.getAccessURI().equals(accessURI)) {
                        this.debug.add("Error: unexpected accessURI name \n");
                        throw new EETest.Fault(testName + " did not complete due to errors saveing service binding ");
                    }
                }
                if (found) continue;
            }
            this.blm.deleteServiceBindings(sbKeys);
            br = bqm.findServiceBindings(serviceKey2222, null, null, specifications);
            sbs = br.getCollection();
            if (sbs.contains(sb)) {
                this.debug.add("Failed! - sb was not removed \n");
                throw new EETest.Fault(testName + " Error: did not delete service binding ");
            }
        }
        catch (Exception e) {
            try {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed ");
            }
            catch (Throwable throwable) {
                try {
                    if (conceptKeys != null) {
                        this.debug.add("==>>  Cleanup: delete concept\n");
                        this.blm.deleteConcepts(conceptKeys);
                    }
                    if (serviceKeys != null) {
                        this.blm.deleteServices(serviceKeys);
                        this.debug.add("==>>   Cleanup: delete service\n");
                    }
                    if (orgKeys == null) throw throwable;
                    this.debug.add("==>>  Cleanup: delete organization\n");
                    this.blm.deleteOrganizations(orgKeys);
                    throw throwable;
                }
                catch (JAXRException je) {
                    TestUtil.printStackTrace((Throwable)je);
                    this.debug.add("Error: not able to delete organization \n");
                }
                throw throwable;
            }
        }
        try {
            if (conceptKeys != null) {
                this.debug.add("==>>  Cleanup: delete concept\n");
                this.blm.deleteConcepts(conceptKeys);
            }
            if (serviceKeys != null) {
                this.blm.deleteServices(serviceKeys);
                this.debug.add("==>>   Cleanup: delete service\n");
            }
            if (orgKeys == null) return;
            this.debug.add("==>>  Cleanup: delete organization\n");
            this.blm.deleteOrganizations(orgKeys);
            return;
        }
        catch (JAXRException je) {
            TestUtil.printStackTrace((Throwable)je);
            this.debug.add("Error: not able to delete organization \n");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void businessLifeCycleManager_saveServicesTest() throws EETest.Fault {
        String testName = "businessLifeCycleManager_saveServicesTest";
        String serviceName = "testService";
        String updServiceName = "UpdatedtestService";
        int passCount = 0;
        Collection serviceKeys = null;
        Collection orgKeys = null;
        Key serviceKey2222 = null;
        Key orgKey2222 = null;
        String orgName = "TS Default Organization";
        try {
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(this.tsLocale, orgName));
            ArrayList<Organization> orgs = new ArrayList<Organization>();
            orgs.add(org);
            BulkResponse br = this.blm.saveOrganizations(orgs);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveOrganizations failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            orgKeys = br.getCollection();
            for (Key orgKey2222 : orgKeys) {
            }
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            org = (Organization)bqm.getRegistryObject(orgKey2222.getId(), "Organization");
            Service service = this.blm.createService(this.blm.createInternationalString(this.tsLocale, serviceName));
            org.addService(service);
            ArrayList<Service> services = new ArrayList<Service>();
            services.add(service);
            br = this.blm.saveServices(services);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveService failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            serviceKeys = br.getCollection();
            for (Key serviceKey2222 : serviceKeys) {
            }
            service = (Service)bqm.getRegistryObject(serviceKey2222.getId(), "Service");
            if (service != null) {
                if (service.getName().getValue(this.tsLocale).equals(serviceName)) {
                    this.debug.add("Good - service was published\n");
                    passCount = 1;
                } else {
                    this.debug.add("Error: failed to get name of service \n");
                }
            }
            service.setName(this.blm.createInternationalString(this.tsLocale, updServiceName));
            services.clear();
            services.add(service);
            br = this.blm.saveServices(services);
            if (br.getExceptions() != null) {
                this.debug.add("==>>  Error:    saveService Update failed \n");
                throw new EETest.Fault(testName + " failed ");
            }
            service = (Service)bqm.getRegistryObject(serviceKey2222.getId(), "Service");
            if (service != null) {
                if (service.getName().getValue(this.tsLocale).equals(updServiceName)) {
                    this.debug.add("Good - service was update\n");
                    passCount = 2;
                } else {
                    this.debug.add("Error: failed to get updated name of service \n");
                }
            }
            if (passCount != 2) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            try {
                TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault(testName + " failed ");
            }
            catch (Throwable throwable) {
                try {
                    if (serviceKeys != null) {
                        this.blm.deleteServices(serviceKeys);
                        this.debug.add("Cleanup: delete service\n");
                    }
                    if (orgKeys == null) throw throwable;
                    this.debug.add("Cleanup: delete organization\n");
                    this.blm.deleteOrganizations(orgKeys);
                    throw throwable;
                }
                catch (JAXRException je) {
                    TestUtil.printStackTrace((Throwable)je);
                    this.debug.add("Error: not able to delete organization \n");
                }
                throw throwable;
            }
        }
        try {
            if (serviceKeys != null) {
                this.blm.deleteServices(serviceKeys);
                this.debug.add("Cleanup: delete service\n");
            }
            if (orgKeys == null) return;
            this.debug.add("Cleanup: delete organization\n");
            this.blm.deleteOrganizations(orgKeys);
            return;
        }
        catch (JAXRException je) {
            TestUtil.printStackTrace((Throwable)je);
            this.debug.add("Error: not able to delete organization \n");
            return;
        }
    }

    public void BusinessLifeCycleManager_SaveClassificationSchemes() throws EETest.Fault {
        String testName = "BusinessLifeCycleManager_SaveClassificationSchemes";
        boolean pass = true;
        BusinessQueryManager bqm = null;
        String name = "TS TEST Name:Test BusinessLifeCycleManager_SaveClassificationSchemes";
        String descr = "Description: Test BusinessLifeCycleManager_SaveClassificationSchemes";
        ClassificationScheme classificationscheme = null;
        BulkResponse br = null;
        Collection keys = null;
        Object classificationschemes = null;
        Key ClassificationschemeKey2 = null;
        try {
            bqm = this.rs.getBusinessQueryManager();
            classificationscheme = this.blm.createClassificationScheme(name, descr);
            this.debug.add("classificationscheme name is: " + classificationscheme.getName().getValue());
            ArrayList<ClassificationScheme> schemes = new ArrayList<ClassificationScheme>();
            schemes.add(classificationscheme);
            br = this.blm.saveClassificationSchemes(schemes);
            this.debug.add("check br for classificationscheme save\n");
            if (!JAXR_Util.checkBulkResponse("saveClassificationschemes", br, this.debug)) {
                this.debug.add("Error reported:  saveClassificationschemes\n");
                throw new EETest.Fault(testName + " Error from saveClassificationschemes - test did not complete!");
            }
            keys = br.getCollection();
            if (keys.size() == 0) {
                throw new EETest.Fault(testName + "Error: no key was returned \n");
            }
            if (keys.size() > 1) {
                throw new EETest.Fault(testName + "Error: too many keys were returned \n");
            }
            for (Key ClassificationschemeKey2 : keys) {
            }
            String keyId = ClassificationschemeKey2.getId();
            classificationscheme = (ClassificationScheme)bqm.getRegistryObject(keyId, "ClassificationScheme");
            if (classificationscheme.getName().getValue().equals(name)) {
                this.debug.add("Got back expected classificationscheme Name!\n");
            } else {
                pass = false;
                this.debug.add("Error: returned name not as expected! \n");
                this.debug.add("Expected name: " + name + "\n");
                this.debug.add("Returned name: " + classificationscheme.getName().getValue() + "\n");
            }
            if (classificationscheme.getDescription().getValue().equals(descr)) {
                this.debug.add("Got back expected classificationscheme Description! \n");
            } else {
                pass = false;
                this.debug.add("Error: returned description not as expected! \n");
                this.debug.add("Expected description: " + descr + "\n");
                this.debug.add("Returned description: " + classificationscheme.getDescription().getValue() + "\n");
            }
            br = this.blm.deleteClassificationSchemes(keys);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + " failed ");
        }
    }

    private Concept getAssociationConcept(String associationType) {
        ArrayList<String> atypes = new ArrayList<String>();
        atypes.add("AssociationType");
        try {
            Locale en_US = new Locale("en", "US");
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            Collection associationTypes = bqm.findClassificationSchemes(null, atypes, null, null).getCollection();
            for (ClassificationScheme cs : associationTypes) {
                Collection types = cs.getChildrenConcepts();
                Iterator iter1 = types.iterator();
                Concept concept = null;
                while (iter1.hasNext()) {
                    concept = (Concept)iter1.next();
                    if (!concept.getName().getValue(this.tsLocale).equals(associationType)) continue;
                    return concept;
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.debug.add("getAssociationConcept caught an error!\n");
            return null;
        }
        return null;
    }

    private void secondConnection() throws EETest.Fault {
        Connection srcConnection = null;
        try {
            srcConnection = this.factory.createConnection();
            Set<PasswordAuthentication> credentials = null;
            switch (this.jaxrSecurityCredentialType) {
                case 0: {
                    credentials = new HashSet();
                    PasswordAuthentication passwdAuth = new PasswordAuthentication(this.jaxrUser2, this.jaxrPassword2.toCharArray());
                    credentials.add(passwdAuth);
                    break;
                }
                case 1: {
                    credentials = super.getDigitalCertificateCredentials(this.jaxrAlias2, this.jaxrAlias2Password);
                    break;
                }
                default: {
                    throw new EETest.Fault("second connection failed: jaxrSecurityCredentialType is invalid");
                }
            }
            srcConnection.setCredentials(credentials);
            this.rs2 = srcConnection.getRegistryService();
            this.blm2 = this.rs2.getBusinessLifeCycleManager();
        }
        catch (Exception e) {
            throw new EETest.Fault("Exception in secondConnection method", e);
        }
    }
}

