/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.appclient.txqueuetests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import java.util.ArrayList;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;

public class TxQueueTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.appclient.txqueuetests.TxQueueTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    public static void main(String[] args) {
        TxQueueTests theTests = new TxQueueTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must be null");
            }
            if (this.mode == null) {
                throw new Exception("'mode' in ts.jte must be null");
            }
            this.queues = new ArrayList(2);
            this.connections = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing Queue and Topic Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }

    public void simpleSendReceiveTxQueueTest() throws EETest.Fault {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(2, this.user, this.password, this.mode);
            this.logMsg("Start connection");
            this.tool.getDefaultQueueConnection().start();
            this.logMsg("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("transaction message test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "simpleSendReceiveTxQueueTest");
            this.logMsg("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logMsg("Call commit");
            this.tool.getDefaultQueueSession().commit();
            this.logMsg("Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logMsg("Call commit");
            this.tool.getDefaultQueueSession().commit();
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            this.logMsg("Message text: \"" + messageReceived.getText() + "\"");
            this.logMsg("Received correct message");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("simpleSendReceiveQueueTxTest");
        }
    }

    public void commitAckMsgQueueTest() throws EETest.Fault {
        try {
            TextMessage mSent = null;
            TextMessage mReceived = null;
            QueueSession qSess = null;
            QueueSender qSender = null;
            QueueReceiver qRec = null;
            String msg = "test message for commitAckMsgTest";
            this.tool = new JmsTool(2, this.user, this.password, this.mode);
            this.tool.getDefaultQueueReceiver().close();
            qSess = this.tool.getDefaultQueueSession();
            qSender = this.tool.getDefaultQueueSender();
            qRec = qSess.createReceiver(this.tool.getDefaultQueue());
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Send first message");
            mSent = qSess.createTextMessage();
            mSent.setBooleanProperty("lastMessage", false);
            mSent.setText(msg);
            mSent.setStringProperty("COM_SUN_JMS_TESTNAME", "commitAckMsgQueueTest1");
            qSender.send((Message)mSent);
            qSess.commit();
            this.logTrace("Send second message");
            mSent.setBooleanProperty("lastMessage", true);
            qSender.send((Message)mSent);
            qSess.commit();
            this.logTrace("Message sent. Receive with tx session, do not call acknowledge().");
            mReceived = (TextMessage)qRec.receive(this.timeout);
            if (mReceived == null) {
                this.logMsg("Did not receive message!");
                throw new Exception("Did not receive message first time");
            }
            this.logTrace("Received message: \"" + mReceived.getText() + "\"");
            this.logTrace("Call commit() without calling acknowledge().");
            qSess.commit();
            this.logTrace("Close session and create new one.");
            qSess.close();
            qSess = this.tool.getDefaultQueueConnection().createQueueSession(false, 1);
            qRec = qSess.createReceiver(this.tool.getDefaultQueue());
            mReceived = (TextMessage)qRec.receive(this.timeout);
            if (mReceived == null) {
                this.logMsg("Did not receive message!");
                throw new Exception("Did not receive expected message");
            }
            if (!mReceived.getBooleanProperty("lastMessage")) {
                this.logMsg("Received orignal message again. Was not acknowledged by commit().");
                throw new Exception("Message not acknowledged by commit");
            }
            if (mReceived.getBooleanProperty("lastMessage")) {
                this.logMsg("Pass: received proper message");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("commitAckMsgQueueTest");
        }
    }

    public void rollbackRecoverQueueTest() throws EETest.Fault {
        try {
            TextMessage mSent = null;
            TextMessage mReceived = null;
            QueueSession qSess = null;
            QueueSender qSender = null;
            QueueReceiver qRec = null;
            String msg = "test message for rollbackRecoverTest";
            this.tool = new JmsTool(2, this.user, this.password, this.mode);
            this.tool.getDefaultQueueSession().close();
            qSess = this.tool.getDefaultQueueConnection().createQueueSession(true, 0);
            qSender = qSess.createSender(this.tool.getDefaultQueue());
            qRec = qSess.createReceiver(this.tool.getDefaultQueue());
            this.tool.getDefaultQueueConnection().start();
            mSent = qSess.createTextMessage();
            mSent.setText(msg);
            mSent.setStringProperty("COM_SUN_JMS_TESTNAME", "rollbackRecoverQueueTest");
            qSender.send((Message)mSent);
            qSess.commit();
            this.logTrace("Message sent. Receive with tx session, do not acknowledge.");
            mReceived = (TextMessage)qRec.receive(this.timeout);
            if (mReceived == null) {
                this.logMsg("Did not receive message!");
                throw new Exception("Did not receive message first time");
            }
            this.logTrace("Received message: \"" + mReceived.getText() + "\"");
            this.logTrace("Call rollback() without acknowledging message.");
            qSess.rollback();
            this.logTrace("Close session and create new one.");
            qSess.close();
            qSess = this.tool.getDefaultQueueConnection().createQueueSession(false, 1);
            qRec = qSess.createReceiver(this.tool.getDefaultQueue());
            mReceived = (TextMessage)qRec.receive(this.timeout);
            if (mReceived == null) {
                this.logMsg("Did not receive message!");
                throw new Exception("Did not receive expected message");
            }
            if (!mReceived.getText().equals(msg)) {
                throw new Exception("Received unexpected message");
            }
            this.logMsg("Received orignal message again. Was not acknowledged.");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("rollbackRecoverQueueTest");
        }
    }

    public void redeliveredFlagTxQueueTest() throws EETest.Fault {
        try {
            TextMessage tMsg = null;
            QueueSession qSess = null;
            QueueReceiver qRec = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueReceiver().close();
            qSess = this.tool.getDefaultQueueConnection().createQueueSession(true, 2);
            qRec = qSess.createReceiver(this.tool.getDefaultQueue());
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("send and receive one message");
            tMsg = this.tool.getDefaultQueueSession().createTextMessage();
            tMsg.setText("test message for redelivered flag");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "redeliveredFlagTxQueueTest");
            this.tool.getDefaultQueueSender().send((Message)tMsg);
            qSess.commit();
            tMsg = (TextMessage)qRec.receive(this.timeout);
            if (tMsg == null) {
                this.logMsg("Did not receive expected message!");
                throw new Exception("Did not receive message");
            }
            this.logTrace("Message received. Check redelivered flag.");
            boolean redelivered = tMsg.getJMSRedelivered();
            this.logTrace("redelivered = " + redelivered);
            if (redelivered) {
                throw new Exception("Message redelivered flag should be false");
            }
            this.logTrace("calling rollback()");
            qSess.rollback();
            this.logTrace("receive message again");
            tMsg = (TextMessage)qRec.receive(this.timeout);
            qSess.commit();
            redelivered = tMsg.getJMSRedelivered();
            this.logTrace("redelivered flag = " + redelivered);
            if (!redelivered) {
                throw new Exception("Message redelivered flag should be true");
            }
        }
        catch (Exception e) {
            this.logMsg("Error: " + e);
            throw new EETest.Fault("redeliveredFlagTxQueueTest", e);
        }
    }

    public void transactionRollbackOnSessionCloseRecQTest() throws EETest.Fault {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TextMessage messageReceived2 = null;
            this.tool = new JmsTool(2, this.user, this.password, this.mode);
            this.logTrace("Start connection");
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("transaction message test");
            this.logTrace("Sending message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "transactionRollbackOnSessionCloseRecQTest");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.tool.getDefaultQueueSession().commit();
            this.logTrace("Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.tool.getDefaultQueueSession().commit();
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            this.logTrace("Message text: \"" + messageReceived.getText() + "\"");
            this.logTrace("Received correct message");
            QueueSession newQSess = this.tool.getDefaultQueueConnection().createQueueSession(true, 0);
            messageSent.setText("part 2");
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.tool.getDefaultQueueSession().commit();
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("close session - don't do a commit on receive");
            this.tool.getDefaultQueueSession().close();
            QueueReceiver qReceiver = newQSess.createReceiver(this.tool.getDefaultQueue());
            messageReceived2 = (TextMessage)qReceiver.receive(this.timeout);
            newQSess.commit();
            if (!messageReceived.getText().equals(messageReceived2.getText())) {
                throw new EETest.Fault("received message not rolled back to q on close session");
            }
            this.logTrace("Message text: \"" + messageReceived.getText() + "\"");
            this.logTrace("Message2 text: \"" + messageReceived2.getText() + "\"");
            this.logTrace("Received correct message");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("transactionRollbackOnSessionCloseRecQTest");
        }
    }

    public void transactionRollbackOnSendQTest() throws EETest.Fault {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.logTrace("Start connection");
            this.tool.getDefaultQueueConnection().start();
            QueueSession newQSess = this.tool.getDefaultQueueConnection().createQueueSession(true, 0);
            QueueSender newSender = newQSess.createSender(this.tool.getDefaultQueue());
            this.logTrace("Creating 1 message");
            messageSent = newQSess.createTextMessage();
            messageSent.setBooleanProperty("lastMessage", false);
            messageSent.setText("transaction message test");
            this.logTrace("Sending message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "transactionRollbackOnSendQTest");
            newSender.send((Message)messageSent);
            this.logTrace("Call commit");
            newQSess.commit();
            this.logTrace("Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            this.logTrace("Message text: \"" + messageReceived.getText() + "\"");
            this.logTrace("Received correct message");
            this.logTrace("Send a message, but then rollback");
            newSender.send((Message)messageSent);
            newQSess.rollback();
            this.logTrace("Send 3rd message");
            messageSent.setBooleanProperty("lastMessage", true);
            newSender.send((Message)messageSent);
            newQSess.commit();
            this.logTrace("Attempt to receive last message only");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new EETest.Fault("Fail: Should have received message");
            }
            if (messageReceived.getBooleanProperty("lastMessage")) {
                this.logTrace("Pass: last msg received, proper message was rolledback");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("transactionRollbackOnSendQTest");
        }
    }

    public void transactionRollbackOnRecQTest() throws EETest.Fault {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TextMessage messageReceived2 = null;
            this.tool = new JmsTool(2, this.user, this.password, this.mode);
            this.logTrace("Start connection");
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("transaction message test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "transactionRollbackOnRecQTest");
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Call commit");
            this.tool.getDefaultQueueSession().commit();
            this.logTrace("Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("Call commit");
            this.tool.getDefaultQueueSession().commit();
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            this.logTrace("Message text: \"" + messageReceived.getText() + "\"");
            this.logTrace("Received correct message");
            messageSent.setText("receive rollback");
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.tool.getDefaultQueueSession().commit();
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("rollback session on receive");
            this.tool.getDefaultQueueSession().rollback();
            this.logTrace("Message should have been recovered");
            messageReceived2 = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.tool.getDefaultQueueSession().commit();
            if (messageReceived2 == null) {
                throw new EETest.Fault("Fail:  message not recovered");
            }
            if (messageReceived.getText().equals(messageReceived2.getText())) {
                this.logTrace("Message text: \"" + messageReceived.getText() + "\"");
                this.logTrace("Message2 text: \"" + messageReceived2.getText() + "\"");
                this.logTrace("Pass:  Message rolled back to the Q");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("transactionRollbackOnRecQTest");
        }
    }

    public void txRollbackOnConnectionCloseRecQTest() throws EETest.Fault {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TextMessage messageReceived2 = null;
            this.tool = new JmsTool(2, this.user, this.password, this.mode);
            this.logTrace("Start connection");
            this.tool.getDefaultQueueConnection().start();
            this.tool.getDefaultQueueReceiver().close();
            this.logTrace("Creating new Connection");
            QueueConnection newQConn = (QueueConnection)this.tool.getNewConnection(0, this.user, this.password);
            this.connections.add(newQConn);
            QueueSession newQSess = newQConn.createQueueSession(true, 1);
            QueueSender qSender = newQSess.createSender(this.tool.getDefaultQueue());
            QueueReceiver qReceiver = newQSess.createReceiver(this.tool.getDefaultQueue());
            newQConn.start();
            this.logTrace("Creating 1 message");
            messageSent = newQSess.createTextMessage();
            messageSent.setText("transaction message test");
            this.logTrace("Sending message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "txRollbackOnConnectionCloseRecQTest");
            qSender.send((Message)messageSent);
            this.logTrace("Call commit");
            newQSess.commit();
            this.logTrace("Receiving message");
            messageReceived = (TextMessage)qReceiver.receive(this.timeout);
            this.logTrace("Call commit");
            newQSess.commit();
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            this.logTrace("Message text: \"" + messageReceived.getText() + "\"");
            this.logTrace("Received correct message");
            messageSent.setText("part 2");
            this.logTrace("Sending message");
            qSender.send((Message)messageSent);
            newQSess.commit();
            messageReceived = (TextMessage)qReceiver.receive(this.timeout);
            this.logTrace("close connection - don't do a commit on receive");
            newQConn.close();
            this.tool.getDefaultQueueConnection().start();
            QueueReceiver qR = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue());
            messageReceived2 = (TextMessage)qR.receive(this.timeout);
            this.logTrace("Receive was not commited, message should be restored");
            this.tool.getDefaultQueueSession().commit();
            if (messageReceived == null) {
                throw new EETest.Fault("Fail:received message not rolled back to q on close session");
            }
            if (messageReceived.getText().equals(messageReceived2.getText())) {
                this.logTrace("Message text: \"" + messageReceived.getText() + "\"");
                this.logTrace("Message2 text: \"" + messageReceived2.getText() + "\"");
                this.logTrace("Pass: message restored to Q");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("txRollbackOnConnectionCloseRecQTest");
        }
    }

    public void txCloseRolledBackSessionRecQTest() throws EETest.Fault {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TextMessage messageReceived2 = null;
            this.tool = new JmsTool(2, this.user, this.password, this.mode);
            this.logTrace("Start connection");
            this.tool.getDefaultQueueConnection().start();
            QueueSession newQSess = this.tool.getDefaultQueueConnection().createQueueSession(true, 1);
            QueueSender qSender = newQSess.createSender(this.tool.getDefaultQueue());
            this.tool.getDefaultQueueReceiver().close();
            QueueReceiver qReceiver = newQSess.createReceiver(this.tool.getDefaultQueue());
            this.logTrace("Creating 1 message");
            messageSent = newQSess.createTextMessage();
            messageSent.setText("transaction message test");
            this.logTrace("Sending message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "txCloseRolledBackSessionRecQTest");
            qSender.send((Message)messageSent);
            this.logTrace("Call commit");
            newQSess.commit();
            this.logTrace("Receiving message");
            messageReceived = (TextMessage)qReceiver.receive(this.timeout);
            this.logTrace("Call commit");
            newQSess.commit();
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            this.logTrace("Message text: \"" + messageReceived.getText() + "\"");
            this.logTrace("Received correct message");
            messageSent.setText("part 2");
            this.logTrace("Sending message");
            qSender.send((Message)messageSent);
            newQSess.commit();
            messageReceived = (TextMessage)qReceiver.receive(this.timeout);
            newQSess.rollback();
            this.logTrace("close session - don't do a commit on receive");
            newQSess.close();
            this.tool.getDefaultQueueConnection().start();
            QueueReceiver qR = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue());
            messageReceived2 = (TextMessage)qR.receive(this.timeout);
            this.tool.getDefaultQueueSession().commit();
            if (!messageReceived.getText().equals(messageReceived2.getText())) {
                throw new EETest.Fault("received message not rolled back to q on close session");
            }
            this.logTrace("Message text: \"" + messageReceived.getText() + "\"");
            this.logTrace("Message2 text: \"" + messageReceived2.getText() + "\"");
            this.logTrace("Received correct message");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("txCloseRolledBackSessionRecQTest");
        }
    }

    public void txMultiQTest() throws EETest.Fault {
        try {
            TextMessage messageSent = null;
            TextMessage messageSent2 = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(2, this.user, this.password, this.mode);
            this.logTrace("Start connection");
            this.tool.getDefaultQueueConnection().start();
            QueueSession newQSess = this.tool.getDefaultQueueConnection().createQueueSession(true, 1);
            QueueSession newQSess1 = this.tool.getDefaultQueueConnection().createQueueSession(false, 1);
            Queue newQueue = this.tool.createNewQueue("Q2");
            QueueSender qSender = newQSess.createSender(newQueue);
            QueueReceiver qReceiver = newQSess1.createReceiver(newQueue);
            this.queues.add(newQueue);
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("This is from MY_QUEUE");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "txMultiQTest");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.tool.getDefaultQueueSession().commit();
            messageSent2 = newQSess.createTextMessage();
            messageSent2.setText("This is from Q2");
            messageSent2.setStringProperty("COM_SUN_JMS_TESTNAME", "txMultiQTest");
            qSender.send((Message)messageSent2);
            this.logTrace("Verify there is no msg to receive");
            messageReceived = (TextMessage)qReceiver.receive(this.timeout);
            if (messageReceived != null) {
                throw new EETest.Fault("Error: Did not commit send - should not have received a msg!");
            }
            newQSess.commit();
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new EETest.Fault("Did not get the committed msg from MY_QUEUE!");
            }
            this.logTrace(" msg received for default q is: " + messageReceived.getText());
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new EETest.Fault("This was not the expected message!!");
            }
            this.logTrace("Message text: \"" + messageReceived.getText() + "\"");
            this.tool.getDefaultQueueSession().commit();
            this.logTrace("Now there should be a message to receive");
            messageReceived = (TextMessage)qReceiver.receive(this.timeout);
            if (messageReceived == null) {
                throw new EETest.Fault("Error: Should have received a msg!");
            }
            this.logTrace("Msg recvd = " + messageReceived);
            this.logTrace(" msg received for Q2 is: " + messageReceived.getText());
            if (!messageReceived.getText().equals(messageSent2.getText())) {
                throw new EETest.Fault("This was not the expected message!!");
            }
            this.logTrace("Message text: \"" + messageReceived.getText() + "\"");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("txMultiQTest");
        }
    }

    public void commitRollbackMultiMsgsTest() throws EETest.Fault {
        boolean pass = true;
        int numMessages = 3;
        try {
            int i;
            TextMessage tempMsg = null;
            this.tool = new JmsTool(15, this.user, this.password, this.mode);
            Destination destination = this.tool.getDefaultDestination();
            Session session = this.tool.getDefaultSession();
            Connection connection = this.tool.getDefaultConnection();
            MessageProducer producer = this.tool.getDefaultProducer();
            MessageConsumer consumer = this.tool.getDefaultConsumer();
            Queue queue = (Queue)destination;
            connection.start();
            this.queues.add(queue);
            TestUtil.logMsg((String)("Send " + numMessages + " messages to Queue and call rollback()"));
            for (i = 1; i <= numMessages; ++i) {
                tempMsg = session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "commitRollbackMultiMsgsTest" + i);
                producer.send((Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            session.rollback();
            TestUtil.logMsg((String)"Should not consume any messages in Queue since rollback() was called");
            tempMsg = (TextMessage)consumer.receive(this.timeout);
            if (tempMsg != null) {
                TestUtil.logErr((String)("Received message " + tempMsg.getText() + ", expected NULL (NO MESSAGES)"));
                pass = false;
            }
            TestUtil.logMsg((String)("Send " + numMessages + " messages to Queue and call commit()"));
            for (i = 1; i <= numMessages; ++i) {
                tempMsg = session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "commitRollbackMultiMsgsTest" + i);
                producer.send((Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            session.commit();
            TestUtil.logMsg((String)"Should consume all messages in Queue since commit() was called");
            for (int msgCount = 1; msgCount <= numMessages; ++msgCount) {
                tempMsg = (TextMessage)consumer.receive(this.timeout);
                if (tempMsg == null) {
                    TestUtil.logErr((String)"MessageConsumer.receive() returned NULL");
                    TestUtil.logErr((String)("Message " + msgCount + " missing from Queue"));
                    pass = false;
                    continue;
                }
                if (!tempMsg.getText().equals("Message " + msgCount)) {
                    TestUtil.logErr((String)("Received [" + tempMsg.getText() + "] expected [Message " + msgCount + "]"));
                    pass = false;
                    continue;
                }
                TestUtil.logMsg((String)("Received message: " + tempMsg.getText()));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("commitRollbackMultiMsgsTest");
        }
        if (!pass) {
            throw new EETest.Fault("commitRollbackMultiMsgsTest failed");
        }
    }
}

