/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices13.servlet.WSAddressingFeaturesTestUsingAnnotations;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.webservices13.servlet.WSAddressingFeaturesTestUsingAnnotations.Echo;
import com.sun.ts.tests.webservices13.servlet.WSAddressingFeaturesTestUsingAnnotations.Echo2;
import com.sun.ts.tests.webservices13.servlet.WSAddressingFeaturesTestUsingAnnotations.EchoService;
import com.sun.ts.tests.webservices13.servlet.WSAddressingFeaturesTestUsingAnnotations.EjbClientIF;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.ejb.EJBException;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.soap.Addressing;

@Stateless(name="WSAddressingFeaturesTestUsingAnnotationsClntBean")
@Remote(value={EjbClientIF.class})
public class EjbClient
implements EjbClientIF {
    private Properties harnessProps = null;
    private static final boolean debug = false;
    @Addressing
    @WebServiceRef(name="service/wsaddrfeaturestestusingannotationsdefaultechoport", value=EchoService.class)
    Echo defaultEchoPort = null;
    @Addressing(enabled=true)
    @WebServiceRef(name="service/wsaddrfeaturestestusingannotationsenabledechoport", value=EchoService.class)
    Echo enabledEchoPort = null;
    @Addressing(enabled=true, required=true)
    @WebServiceRef(name="service/wsaddrfeaturestestusingannotationsrequiredechoport", value=EchoService.class)
    Echo requiredEchoPort = null;
    @Addressing(enabled=false)
    @WebServiceRef(name="service/wsaddrfeaturestestusingannotationsdisabledechoport", value=EchoService.class)
    Echo disabledEchoPort = null;
    @Addressing
    @WebServiceRef(name="service/wsaddrfeaturestestusingannotationsdefaultecho2port", value=EchoService.class)
    Echo2 defaultEcho2Port = null;
    @Addressing(enabled=true)
    @WebServiceRef(name="service/wsaddrfeaturestestusingannotationsenabledecho2port", value=EchoService.class)
    Echo2 enabledEcho2Port = null;
    @Addressing(enabled=true, required=true)
    @WebServiceRef(name="service/wsaddrfeaturestestusingannotationsrequiredecho2port", value=EchoService.class)
    Echo2 requiredEcho2Port = null;
    @Addressing(enabled=false)
    @WebServiceRef(name="service/wsaddrfeaturestestusingannotationsdisabledecho2port", value=EchoService.class)
    Echo2 disabledEcho2Port = null;
    @WebServiceRef(name="service/wsaddrfeaturestestusingannotationsservice")
    EchoService service = null;

    @PostConstruct
    public void postConstruct() {
        System.out.println("EjbClient:postConstruct()");
        System.out.println("EjbClient DEBUG: service=" + (Object)((Object)this.service));
        System.out.println("EjbClient DEBUG: defaultEchoPort=" + this.defaultEchoPort);
        System.out.println("EjbClient DEBUG: enabledEchoPort=" + this.enabledEchoPort);
        System.out.println("EjbClient DEBUG: requiredEchoPort=" + this.requiredEchoPort);
        System.out.println("EjbClient DEBUG: disabledEchoPort=" + this.disabledEchoPort);
        System.out.println("EjbClient DEBUG: defaultEcho2Port=" + this.defaultEcho2Port);
        System.out.println("EjbClient DEBUG: enabledEcho2Port=" + this.enabledEcho2Port);
        System.out.println("EjbClient DEBUG: requiredEcho2Port=" + this.requiredEcho2Port);
        System.out.println("EjbClient DEBUG: disabledEcho2Port=" + this.disabledEcho2Port);
        if (this.service == null || this.defaultEchoPort == null || this.enabledEchoPort == null || this.requiredEchoPort == null || this.disabledEchoPort == null || this.defaultEcho2Port == null || this.enabledEcho2Port == null || this.requiredEcho2Port == null || this.disabledEcho2Port == null) {
            throw new EJBException("postConstruct failed: injection failure");
        }
    }

    @Override
    public void init(Properties p) {
        this.harnessProps = p;
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("init: failed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("init: failed");
        }
    }

    @Override
    public boolean echo(String string, String testName) {
        if (testName.equals("VerifyAddrHeadersExistForRequiredEchoPort")) {
            return this.VerifyAddrHeadersExistForRequiredEchoPort();
        }
        if (testName.equals("VerifyAddrHeadersDoNotExistForDisabledEchoPort")) {
            return this.VerifyAddrHeadersDoNotExistForDisabledEchoPort();
        }
        if (testName.equals("VerifyAddrHeadersMayExistForEnabledEchoPort")) {
            return this.VerifyAddrHeadersMayExistForEnabledEchoPort();
        }
        if (testName.equals("VerifyExceptionThrownForRequiredEcho2Port")) {
            return this.VerifyExceptionThrownForRequiredEcho2Port();
        }
        if (testName.equals("VerifyAddrHeadersDoNotExistForDisabledEcho2Port")) {
            return this.VerifyAddrHeadersDoNotExistForDisabledEcho2Port();
        }
        return this.VerifyAddrHeadersMayExistForEnabledEcho2Port();
    }

    private boolean VerifyAddrHeadersExistForRequiredEchoPort() {
        try {
            TestUtil.logMsg((String)"EjbClient invoking EchoService echo() method");
            TestUtil.logMsg((String)"Addressing headers MUST be present on the SOAPRequest/SOAPResponse");
            TestUtil.logMsg((String)"VerifyAddrHeadersExistForRequiredEchoPort");
            Holder testName = new Holder((Object)"VerifyAddrHeadersExistForRequiredEchoPort");
            this.requiredEchoPort.echo("Echo from EjbClient on requiredEchoPort", (Holder<String>)testName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean VerifyAddrHeadersDoNotExistForDisabledEchoPort() {
        try {
            TestUtil.logMsg((String)"EjbClient invoking EchoService echo() method");
            TestUtil.logMsg((String)"Addressing headers MUST NOT be present on the SOAPRequest/SOAPResponse");
            TestUtil.logMsg((String)"VerifyAddrHeadersDoNotExistForDisabledEchoPort");
            Holder testName = new Holder((Object)"VerifyAddrHeadersDoNotExistForDisabledEchoPort");
            this.disabledEchoPort.echo("Echo from EjbClient on disabledEchoPort", (Holder<String>)testName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean VerifyAddrHeadersMayExistForEnabledEchoPort() {
        try {
            TestUtil.logMsg((String)"EjbClient invoking EchoService echo() method");
            TestUtil.logMsg((String)"Addressing headers MAY be present on the SOAPRequest/SOAPResponse");
            TestUtil.logMsg((String)"VerifyAddrHeadersMayExistForEnabledEchoPort");
            Holder testName = new Holder((Object)"VerifyAddrHeadersMayExistForEnabledEchoPort");
            this.enabledEchoPort.echo("Echo from EjbClient on enabledEchoPort", (Holder<String>)testName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean VerifyExceptionThrownForRequiredEcho2Port() {
        try {
            TestUtil.logMsg((String)"EjbClient invoking EchoService echo() method");
            TestUtil.logMsg((String)"Expect a WebServiceException to be thrown back");
            TestUtil.logMsg((String)"VerifyExceptionThrownForRequiredEcho2Port");
            Holder testName = new Holder((Object)"VerifyExceptionThrownForRequiredEcho2Port");
            this.requiredEcho2Port.echo("Echo from EjbClient on requiredEcho2Port", (Holder<String>)testName);
            TestUtil.logErr((String)"WebServiceException was not thrown back");
            return false;
        }
        catch (WebServiceException e) {
            TestUtil.logMsg((String)("Caught expected WebServiceException: " + e.getMessage()));
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            return false;
        }
    }

    private boolean VerifyAddrHeadersDoNotExistForDisabledEcho2Port() {
        try {
            TestUtil.logMsg((String)"EjbClient invoking EchoService echo() method");
            TestUtil.logMsg((String)"Addressing headers MUST NOT be present on the SOAPRequest/SOAPResponse");
            TestUtil.logMsg((String)"VerifyAddrHeadersDoNotExistForDisabledEcho2Port");
            Holder testName = new Holder((Object)"VerifyAddrHeadersDoNotExistForDisabledEcho2Port");
            this.disabledEcho2Port.echo("Echo from EjbClient on disabledEcho2Port", (Holder<String>)testName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean VerifyAddrHeadersMayExistForEnabledEcho2Port() {
        try {
            TestUtil.logMsg((String)"EjbClient invoking EchoService echo() method");
            TestUtil.logMsg((String)"Addressing headers MAY be present on the SOAPRequest/SOAPResponse");
            TestUtil.logMsg((String)"VerifyAddrHeadersMayExistForEnabledEcho2Port");
            Holder testName = new Holder((Object)"VerifyAddrHeadersMayExistForEnabledEcho2Port");
            this.enabledEcho2Port.echo("Echo from EjbClient on enabledEcho2Port", (Holder<String>)testName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

