/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.rmiiiop.ee.orbtests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.rmiiiop.ee.orbtests.HelloRMIIIOPObjectImpl;
import com.sun.ts.tests.rmiiiop.ee.orbtests.HelloRMIIIOPObjectIntf;
import com.sun.ts.tests.rmiiiop.ee.orbtests.TestBean;
import com.sun.ts.tests.rmiiiop.ee.orbtests.TestBeanHome;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.Remote;
import java.util.Properties;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class Client
extends EETest {
    private static final String testLookup = "java:comp/env/ejb/TestBean";
    private TestBean beanRef = null;
    private TestBeanHome beanHome = null;
    private Properties props = null;
    private TSNamingContext nctx = null;
    private HelloRMIIIOPObjectIntf rmiiiopRef = null;
    private HelloRMIIIOPObjectImpl rmiiiopObj = null;
    private Stub rmiiiopStub = null;
    private ORB orb = null;
    private Object obj = null;
    private POA rootPOA = null;
    private String ior = null;
    private TSURL ctsurl = new TSURL();
    private URL url = null;
    private URLConnection urlConn = null;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private String SERVLET = "/rmiiiop_orbtests_web/RmiiiopOrbtestsServletTest";
    private String webServerHost = "unknown";
    private int webServerPort = 8000;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
            TestUtil.logMsg((String)"Lookup EJBHome for: java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)this.nctx.lookup(testLookup, TestBeanHome.class);
            TestUtil.logMsg((String)"Create EJBObject instance");
            this.beanRef = this.beanHome.create(p);
            TestUtil.logMsg((String)"Get webServerHost and webServerPort settings");
            this.webServerHost = p.getProperty(WEBSERVERHOSTPROP);
            if (this.webServerHost == null) {
                pass = false;
            } else if (this.webServerHost.equals("")) {
                pass = false;
            }
            try {
                this.webServerPort = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)("webServerHost = " + this.webServerHost));
            TestUtil.logMsg((String)("webServerPort = " + this.webServerPort));
            if (!pass) {
                TestUtil.logErr((String)"Please specify host & port of web server in ts.jte file: webServerHost, webServerPort");
                throw new EETest.Fault("Setup failed:");
            }
            TestUtil.logMsg((String)"Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    private void SetupOrbAndRmiiiopObject() throws Exception {
        TestUtil.logTrace((String)"SetupOrbAndRmiiiopObject");
        TestUtil.logMsg((String)"Create an ORB instance using [ORB.init()]");
        this.orb = ORB.init((String[])new String[0], null);
        TestUtil.logMsg((String)("ORB = " + this.orb));
        TestUtil.logMsg((String)"Verify some basic ORB functionality");
        TestUtil.logMsg((String)"Look up the RootPOA");
        this.rootPOA = POAHelper.narrow((Object)this.orb.resolve_initial_references("RootPOA"));
        TestUtil.logMsg((String)"Activate the RootPOA Manager");
        this.rootPOA.the_POAManager().activate();
        TestUtil.logMsg((String)"Create rmiiiop object: HelloRMIIIOPObjectImpl");
        this.rmiiiopObj = new HelloRMIIIOPObjectImpl();
        TestUtil.logMsg((String)"Get Stub for HelloRMIIIOPObjectImpl object");
        this.rmiiiopStub = (Stub)PortableRemoteObject.toStub((Remote)this.rmiiiopObj);
        TestUtil.logMsg((String)"Connect/Attach HelloRMIIIOPObjectImpl object to ORB");
        this.rmiiiopStub.connect(this.orb);
        TestUtil.logMsg((String)"Convert HelloRMIIIOPObjectImpl to stringified IOR");
        this.ior = this.orb.object_to_string((Object)this.rmiiiopStub);
        TestUtil.logMsg((String)("IOR = " + this.ior));
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"cleanup ok");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ORBVerifyFromAppClientTest1() throws EETest.Fault {
        boolean pass = true;
        String expStr = "Hello from HelloRMIIIOPObjectImpl";
        try {
            TestUtil.logTrace((String)"ORBVerifyFromAppClientTest1");
            TestUtil.logMsg((String)"Setup an [ORB instance, RMIIIOP object, and save its IOR].");
            this.SetupOrbAndRmiiiopObject();
            TestUtil.logMsg((String)"Convert stringified IOR back to a CORBA object");
            this.obj = this.orb.string_to_object(this.ior);
            TestUtil.logMsg((String)"Narrow the CORBA object to interface HelloRMIIIOPObjectIntf");
            this.rmiiiopRef = (HelloRMIIIOPObjectIntf)PortableRemoteObject.narrow((java.lang.Object)this.obj, HelloRMIIIOPObjectIntf.class);
            TestUtil.logMsg((String)"Call hello method on interface HelloRMIIIOPObjectIntf");
            String hello = this.rmiiiopRef.hello();
            TestUtil.logMsg((String)"Verify the method call");
            if (!hello.equals(expStr)) {
                TestUtil.logErr((String)("Wrong message, got [" + hello + "]"));
                TestUtil.logErr((String)("Wrong message, expected [" + expStr + "]"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)e.toString());
            pass = false;
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("ORBVerifyFromAppClientTest1 failed");
        }
    }

    public void ORBVerifyFromEJBTest1() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"ORBVerifyFromEJBTest1");
            TestUtil.logMsg((String)"Setup an [ORB instance, RMIIIOP object, and save its IOR].");
            this.SetupOrbAndRmiiiopObject();
            TestUtil.logMsg((String)"Pass stringified IOR to TestBeanEJB.test1() method");
            TestUtil.logMsg((String)"Verify some basic ORB functionality from TestBeanEJB");
            pass = this.beanRef.test1(this.ior);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)e.toString());
            pass = false;
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("ORBVerifyFromEJBTest1 failed");
        }
    }

    public void ORBVerifyFromEJBTest2() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"ORBVerifyFromEJBTest2");
            TestUtil.logMsg((String)"Setup an [ORB instance, RMIIIOP object, and save its IOR].");
            this.SetupOrbAndRmiiiopObject();
            TestUtil.logMsg((String)"Pass stringified IOR to TestBeanEJB.test2() method");
            TestUtil.logMsg((String)"Verify some basic ORB functionality from TestBeanEJB");
            pass = this.beanRef.test2(this.ior);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)e.toString());
            pass = false;
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("ORBVerifyFromEJBTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ORBVerifyFromServletTest1() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"ORBVerifyFromServletTest1");
            TestUtil.logMsg((String)"Setup an [ORB instance, RMIIIOP object, and save its IOR].");
            this.SetupOrbAndRmiiiopObject();
            TestUtil.logMsg((String)"Pass stringified IOR to Servlet for test1");
            TestUtil.logMsg((String)"Verify some basic ORB functionality from Servlet");
            this.url = this.ctsurl.getURL("http", this.webServerHost, this.webServerPort, this.SERVLET);
            this.props.setProperty("TEST", "test1");
            this.props.setProperty("IOR", "" + this.ior);
            TestUtil.logMsg((String)"Send request to Servlet");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            TestUtil.logMsg((String)"Get response from Servlet");
            TestUtil.logMsg((String)"Response is ................");
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            TestUtil.list((Properties)p);
            String passStr = p.getProperty("TESTRESULT");
            TestUtil.logMsg((String)("TESTRESULT from Servlet = " + passStr));
            if (passStr.equals("false")) {
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)e.toString());
            pass = false;
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("ORBVerifyFromServletTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ORBVerifyFromServletTest2() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"ORBVerifyFromServletTest2");
            TestUtil.logMsg((String)"Setup an [ORB instance, RMIIIOP object, and save its IOR].");
            this.SetupOrbAndRmiiiopObject();
            TestUtil.logMsg((String)"Pass stringified IOR to Servlet for test2");
            TestUtil.logMsg((String)"Verify some basic ORB functionality from Servlet");
            this.url = this.ctsurl.getURL("http", this.webServerHost, this.webServerPort, this.SERVLET);
            this.props.setProperty("TEST", "test2");
            this.props.setProperty("IOR", "" + this.ior);
            TestUtil.logMsg((String)"Send request to Servlet");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            TestUtil.logMsg((String)"Get response from Servlet");
            TestUtil.logMsg((String)"Response is ................");
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            TestUtil.list((Properties)p);
            String passStr = p.getProperty("TESTRESULT");
            TestUtil.logMsg((String)("TESTRESULT from Servlet = " + passStr));
            if (passStr.equals("false")) {
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)e.toString());
            pass = false;
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("ORBVerifyFromServletTest2 failed");
        }
    }
}

