/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.interop.csiv2.common.CSIv2Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class CSIv2FileLoggerImpl {
    public static CSIv2FileLoggerImpl theLoggerImpl = null;
    String fullPathAndFilename = null;

    public static CSIv2FileLoggerImpl getFileLogger(String fileName) {
        if (theLoggerImpl == null) {
            theLoggerImpl = new CSIv2FileLoggerImpl(fileName);
        }
        return theLoggerImpl;
    }

    public CSIv2FileLoggerImpl(String fName) {
        this.debug("in CSIv2FileLoggerImpl constructor");
        this.debug("CSIv2FileLoggerImpl fName = " + fName);
        this.fullPathAndFilename = fName;
        try {
            File fp = new File(this.fullPathAndFilename);
            if (!fp.exists()) {
                this.debug("WARNING - file does not exist: " + this.fullPathAndFilename);
            }
        }
        catch (Exception ex) {
            this.debug("WARNING - CSIv2FileLoggerImpl constructor exception validating file: " + this.fullPathAndFilename);
            ex.printStackTrace();
        }
    }

    public void setFullPathAndFilename(String val) {
        this.fullPathAndFilename = val;
    }

    public String getFullPathAndFilename() {
        return this.fullPathAndFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void log(String message) {
        RandomAccessFile file = null;
        FileLock fileLock = null;
        AbstractInterruptibleChannel fileChannel = null;
        this.debug("CSIv2FileLoggerImpl:  logging to: " + this.fullPathAndFilename);
        this.debug("CSIv2FileLoggerImpl:  log message: " + message);
        try {
            file = new RandomAccessFile(this.fullPathAndFilename, "rw");
            file.seek(file.length());
            fileChannel = file.getChannel();
            this.debug("fileChannel.position() = " + ((FileChannel)fileChannel).position());
            boolean lockObtained = false;
            for (int ii = 0; !lockObtained && ii < 5; ++ii) {
                try {
                    fileLock = ((FileChannel)fileChannel).lock(file.length(), Long.MAX_VALUE - file.length(), false);
                    lockObtained = true;
                    this.debug("lock obtained in CSIv2FileLoggerImpl.log()");
                    continue;
                }
                catch (Exception e) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.debug("failed to get lock: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            if (fileLock != null) {
                file.writeBytes(message + "\n");
                if (message.indexOf("<assertion name") > 0) {
                    this.debug("message contains '<assertion name'");
                    int start = message.indexOf("\"") + 1;
                    int end = message.indexOf("\"", start);
                    CSIv2Log.assertion = message.substring(start, end);
                }
            } else {
                System.err.println("Error trying to secure lock of file: " + this.fullPathAndFilename);
                System.err.println("There is possibly a collision or other io related issue.");
            }
        }
        catch (Exception ex) {
            System.err.println("got exception in CSIv2FileLoggerImpl.log()" + ex);
            ex.printStackTrace();
        }
        finally {
            try {
                if (fileLock != null) {
                    fileLock.release();
                    fileLock = null;
                }
                if (fileChannel != null) {
                    fileChannel.close();
                    fileChannel = null;
                }
                if (file != null) {
                    file.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void debug(String str) {
        TestUtil.logTrace((String)str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get() {
        String rval = null;
        FileInputStream fis = null;
        AbstractInterruptibleChannel fChannel = null;
        FileLock fLock = null;
        BufferedReader br = null;
        try {
            this.debug("in CSIv2FileLoggerImpl get()");
            fis = new FileInputStream(new File(this.fullPathAndFilename));
            fChannel = fis.getChannel();
            fLock = ((FileChannel)fChannel).lock(0L, Long.MAX_VALUE, true);
            br = new BufferedReader(new InputStreamReader(fis));
            boolean lockObtained = false;
            for (int ii = 0; !lockObtained && ii < 5; ++ii) {
                try {
                    fLock = ((FileChannel)fChannel).lock(0L, Long.MAX_VALUE, false);
                    lockObtained = true;
                    continue;
                }
                catch (Exception e) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (fLock != null) {
                this.debug("in CSIv2FileLoggerImpl.get() - have file locked so can safely read it.");
                String strLine = null;
                while ((strLine = br.readLine()) != null) {
                    if (strLine == null) continue;
                    rval = strLine + "\n";
                }
            } else {
                System.err.println("ERROR CSIv2FileLoggerImpl.get() - can NOT lock file for reading: " + this.fullPathAndFilename);
            }
            String string = rval;
            return string;
        }
        catch (Exception ex) {
            System.err.println("Exception calling CSIv2FileLoggerImpl.get().");
            ex.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (fLock != null) {
                    fLock.release();
                    fLock = null;
                }
                if (fChannel != null) {
                    fChannel.close();
                    fChannel = null;
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public void purge() {
        this.purge(true);
    }

    public final synchronized boolean purge(boolean renameLogFile) {
        try {
            if (renameLogFile) {
                String aName = this.getAssertionName();
                if (aName != null) {
                    File newFName = new File(this.fullPathAndFilename + "." + aName);
                    try {
                        if (!newFName.delete()) {
                            System.err.println("ERROR:  could not delete existing file: " + this.fullPathAndFilename + "." + aName);
                        }
                    }
                    catch (Exception e) {
                        System.err.println("ERROR:  could not delete file: " + this.fullPathAndFilename + "." + aName);
                        e.printStackTrace();
                    }
                    File origName = new File(this.fullPathAndFilename);
                    this.debug("Renaming file   from:  " + this.fullPathAndFilename + "  to: " + this.fullPathAndFilename + "." + aName);
                    boolean bval = origName.renameTo(newFName);
                    if (!bval) {
                        System.err.println("ERROR:  could not rename file from:  " + this.fullPathAndFilename + "\t to: " + this.fullPathAndFilename + "." + aName);
                        System.err.println("likely failure is either that file already exists or you need permissions");
                        return false;
                    }
                } else {
                    System.out.println("WARNING - assertion name not foud - not renaming.");
                }
                return true;
            }
            File fp = new File(this.fullPathAndFilename);
            if (fp.delete()) {
                System.out.println("CSIv2FileLoggerImpl.purge() file deleted: " + this.fullPathAndFilename);
                return true;
            }
            System.err.println("ERROR:  CSIv2FileLoggerImpl.purge() delete failed: " + this.fullPathAndFilename);
        }
        catch (Exception ex) {
            System.err.println("got exception in CSIv2FileLoggerImpl.purge()");
            ex.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAssertionName() {
        String rval;
        block14: {
            rval = null;
            BufferedReader br = null;
            try {
                this.debug("in getAssertionName(), fullPathAndFilename = " + this.fullPathAndFilename);
                if (this.fullPathAndFilename != null) {
                    String strLine;
                    String assertion = null;
                    File fp = new File(this.fullPathAndFilename);
                    if (!fp.exists()) {
                        this.debug("WARNING:  file " + this.fullPathAndFilename + " does not exist.");
                        rval = null;
                        break block14;
                    }
                    br = new BufferedReader(new FileReader(this.fullPathAndFilename));
                    while ((strLine = br.readLine()) != null) {
                        if (!strLine.contains("assertion name=")) continue;
                        int ii = strLine.indexOf("=");
                        rval = assertion = strLine.substring(ii + 2, strLine.length() - 2);
                        break block14;
                    }
                    break block14;
                }
                this.debug("ERROR:  LoggerServlet.getAssertionName():  fullPathAndFilename = null");
                rval = null;
            }
            catch (Exception ex) {
                System.err.println("got exception in LoggerServlet.getAssertionName()");
                ex.printStackTrace();
            }
            finally {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
        return rval;
    }
}

