/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.appclient.closedQueueReceiver;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import java.util.ArrayList;
import java.util.Properties;
import javax.jms.IllegalStateException;
import javax.jms.Message;
import javax.jms.MessageListener;

public class ClosedQueueReceiverTests
extends ServiceEETest {
    private static final String TestName = "com.sun.ts.tests.jms.core.appclient.closedQueueReceiver.ClosedQueueReceiverTests";
    private static final String testDir = System.getProperty("user.dir");
    private static JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    public static void main(String[] args) {
        ClosedQueueReceiverTests theTests = new ClosedQueueReceiverTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void createAndCloseReceiver() throws Exception {
        tool = new JmsTool(0, this.user, this.password, this.mode);
        tool.getDefaultQueueConnection().start();
        this.logTrace("Closing queue receiver");
        tool.getDefaultQueueReceiver().close();
        this.logTrace("Receiver closed");
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must be null");
            }
            if (this.mode == null) {
                throw new Exception("'mode' in ts.jte must be null");
            }
            this.queues = new ArrayList(2);
            this.logTrace("Getting Administrator and deleting any leftover destinations.");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (tool != null) {
                this.logMsg("Cleanup: Closing Queue and Topic Connections");
                tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }

    public void closedQueueReceiverGetMessageListenerTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseReceiver();
            this.logTrace("Try to call getMessageListener");
            try {
                MessageListener foo = tool.getDefaultQueueReceiver().getMessageListener();
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueReceiverGetMessageListenerTest", e);
        }
    }

    public void closedQueueReceiverSetMessageListenerTest() throws EETest.Fault {
        boolean passed = false;
        try {
            this.createAndCloseReceiver();
            this.logTrace("Try to call setMessageListener");
            try {
                MessageListener foo = new MessageListener(){

                    public void onMessage(Message m) {
                    }
                };
                tool.getDefaultQueueReceiver().setMessageListener(foo);
                this.logTrace("Fail: Exception was not thrown!");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Pass: threw expected error");
                passed = true;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logTrace("Fail: wrong exception: " + e.getClass().getName() + " was returned");
            }
            if (!passed) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("closedQueueReceiverSetMessageListenerTest", e);
        }
    }
}

