/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_handler.Handler;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_handler.Handler.Hello;
import com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_handler.Handler.Hello2;
import com.sun.ts.tests.jaxrpc.common.HandlerTracker;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.rpc.Service;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerRegistry;

public class Client
extends ServiceEETest {
    private Service service = null;
    private HandlerRegistry hr = null;
    private HandlerChain hc = null;
    private Properties props = null;
    Hello port1 = null;
    Hello2 port2 = null;

    private void getStub() throws Exception {
        try {
            InitialContext ic = new InitialContext();
            TestUtil.logMsg((String)"Obtained InitialContext");
            TestUtil.logMsg((String)"Lookup java:comp/env/service/handler1");
            Service svc = (Service)ic.lookup("java:comp/env/service/handler1");
            TestUtil.logMsg((String)"Obtained service 1");
            this.port1 = (Hello)svc.getPort(Hello.class);
            TestUtil.logMsg((String)"Obtained port 1");
            TestUtil.logMsg((String)"Lookup java:comp/env/service/handler2");
            Service svc2 = (Service)ic.lookup("java:comp/env/service/handler2");
            TestUtil.logMsg((String)"Obtained service 2");
            this.port2 = (Hello2)svc2.getPort(Hello2.class);
            TestUtil.logMsg((String)"Obtained port 2");
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault(t.toString());
        }
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        boolean pass = true;
        try {
            this.getStub();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void DoHandlerTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"DoHandlerTest1");
        boolean pass = true;
        boolean fault = false;
        try {
            TestUtil.logMsg((String)"This is a test to verify the JAXRPC Soap Message Handler Functionality");
            TestUtil.logMsg((String)"Register Client-Side handlers: ClientHandler1,ClientHandler2,ClientHandler3");
            TestUtil.logMsg((String)"Register Server-Side handlers: ServeServerer1,ServerHandler2,ServerHandler3");
            TestUtil.logMsg((String)"Invoking RPC method port1.doHandlerTest1()");
            String serverSideMsgs = this.port1.doHandlerTest1();
            String clientSideMsgs = HandlerTracker.get();
            HandlerTracker.purge();
            TestUtil.logMsg((String)"Verify handleRequest()/handleResponse() callbacks");
            TestUtil.logMsg((String)"Verifying Client-Side JAXRPC-RUNTIME Callbacks");
            if (!this.VerifyCallBacks("client", fault, clientSideMsgs)) {
                TestUtil.logErr((String)"Client-Side Callbacks are (incorrect)");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Client-Side Callbacks are (correct)");
            }
            TestUtil.logMsg((String)"Verifying Server-Side JAXRPC-RUNTIME Callbacks");
            if (!this.VerifyCallBacks("server", fault, serverSideMsgs)) {
                TestUtil.logErr((String)"Server-Side Callbacks are (incorrect)");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Server-Side Callbacks are (correct)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("DoHandlerTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("DoHandlerTest1 failed");
        }
    }

    public void DoHandlerTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"DoHandlerTest2");
        boolean pass = true;
        boolean fault = true;
        try {
            TestUtil.logMsg((String)"This is a test to verify the JAXRPC Soap Message Handler Functionality");
            TestUtil.logMsg((String)"Now invoke RPC method and verify the JAXRPC Soap Message Handler Functionality");
            TestUtil.logMsg((String)"Register Client-Side handlers: ClientHandler4,ClientHandler5");
            TestUtil.logMsg((String)"Register Server-Side handlers: ServeServerer4,ServerHandler5");
            TestUtil.logMsg((String)"Invoking RPC method port2.doHandlerTest2()");
            TestUtil.logMsg((String)"Expecting RemoteException to be thrown which wraps a JAXRPCException");
            String serverSideMsgs = null;
            try {
                serverSideMsgs = this.port2.doHandlerTest2();
                TestUtil.logErr((String)"Did not get expected RemoteException");
                pass = false;
            }
            catch (RemoteException e) {
                TestUtil.logMsg((String)("Did get expected RemoteException: " + e.getMessage()));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("DoHandlerTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("DoHandlerTest2 failed");
        }
    }

    private boolean VerifyCallBacks(String who, boolean fault, String calls) {
        boolean startIdx = false;
        boolean endIdx = false;
        boolean pass = true;
        if (who.equals("client")) {
            if (calls == null) {
                TestUtil.logErr((String)"Callback string is null (unexpected)");
                return false;
            }
            if (fault) {
                if (calls.indexOf("ClientHandler4.handleFault()") == -1) {
                    TestUtil.logErr((String)"ClientHandler4.handleFault() was not called");
                    pass = false;
                }
                return pass;
            }
            if (calls.indexOf("ClientHandler1.init()") == -1) {
                TestUtil.logErr((String)"ClientHandler1.init() was not called");
                pass = false;
            }
            if (calls.indexOf("ClientHandler2.init()") == -1) {
                TestUtil.logErr((String)"ClientHandler2.init() was not called");
                pass = false;
            }
            if (calls.indexOf("ClientHandler3.init()") == -1) {
                TestUtil.logErr((String)"ClientHandler3.init() was not called");
                pass = false;
            }
            if (calls.indexOf("ClientHandler1.handleRequest()") == -1) {
                TestUtil.logErr((String)"ClientHandler1.handleRequest() was not called");
                pass = false;
            }
            if (calls.indexOf("ClientHandler2.handleRequest()") == -1) {
                TestUtil.logErr((String)"ClientHandler2.handleRequest() was not called");
                pass = false;
            }
            if (calls.indexOf("ClientHandler3.handleRequest()") == -1) {
                TestUtil.logErr((String)"ClientHandler3.handleRequest() was not called");
                pass = false;
            }
            if (calls.indexOf("ClientHandler1.handleResponse()") == -1) {
                TestUtil.logErr((String)"ClientHandler1.handleResponse() was not called");
                pass = false;
            }
            if (calls.indexOf("ClientHandler2.handleResponse()") == -1) {
                TestUtil.logErr((String)"ClientHandler2.handleResponse() was not called");
                pass = false;
            }
            if (calls.indexOf("ClientHandler3.handleResponse()") == -1) {
                TestUtil.logErr((String)"ClientHandler3.handleResponse() was not called");
                pass = false;
            }
        } else {
            if (calls == null) {
                TestUtil.logErr((String)"Callback string is null (unexpected)");
                return false;
            }
            if (fault) {
                if (calls.indexOf("ServerHandler4.handleFault()") == -1) {
                    TestUtil.logErr((String)"ServerHandler4.handleFault() was not called");
                    pass = false;
                }
                return pass;
            }
            if (calls.indexOf("ServerHandler1.handleRequest()") == -1) {
                TestUtil.logErr((String)"ServerHandler1.handleRequest() was not called");
                pass = false;
            }
            if (calls.indexOf("ServerHandler2.handleRequest()") == -1) {
                TestUtil.logErr((String)"ServerHandler2.handleRequest() was not called");
                pass = false;
            }
            if (calls.indexOf("ServerHandler3.handleRequest()") == -1) {
                TestUtil.logErr((String)"ServerHandler3.handleRequest() was not called");
                pass = false;
            }
        }
        return pass;
    }
}

