/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.basic;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.annotations.basic.A;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setupData(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setupData");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin persistBasicTest1");
        boolean pass = false;
        try {
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            A aRef = new A("1", "a1", 1, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            this.getEntityTransaction().begin();
            if (!this.getInstanceStatus(aRef)) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persistBasicTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin persistBasicTest2");
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"new A");
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            A aRef = new A("2", "a2", 2, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            this.createA(aRef);
            A newA = this.findA("2");
            if (newA != null) {
                TestUtil.logTrace((String)"A IS NOT NULL");
            }
            this.getEntityTransaction().begin();
            pass = this.getInstanceStatus(this.findA("2"));
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persistBasicTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest3() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin persistBasicTest3");
        Object aName = null;
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            A a1 = new A("3", "a3", 3, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            TestUtil.logTrace((String)"Persist Instance");
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().flush();
            TestUtil.logTrace((String)"find By Name");
            A result = (A)this.findByName("a3");
            TestUtil.logTrace((String)"Check to see that the entities are identical");
            if (result == a1) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back transaction", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persistBasicTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest4() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin persistBasicTest4");
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"Persist Instance");
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            A aRef = new A("4", "a4", 4, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            this.createA(aRef);
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"get Instance Status ");
            if (this.getInstanceStatus(this.findA("4"))) {
                try {
                    TestUtil.logTrace((String)"entity is managed, try to persist again ");
                    A newA = this.findA("4");
                    this.getEntityManager().persist((Object)newA);
                    TestUtil.logTrace((String)"Persist ignored on an already persisted entity as expected");
                    pass = true;
                }
                catch (Exception ee) {
                    TestUtil.logErr((String)"Unexpected exception trying to persist an already persisted entity", (Throwable)ee);
                    pass = false;
                }
            } else {
                TestUtil.logTrace((String)"Instance is not managed. Test Fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected exception rolling back transaction", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persistBasicTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistBasicTest5() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin persistBasicTest5");
        boolean pass = true;
        try {
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            A aRef = new A("5", null, 5, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            TestUtil.logTrace((String)"Persist Instance");
            this.createA(aRef);
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"get Instance Status ");
            if (this.getInstanceStatus(this.findA("5"))) {
                try {
                    TestUtil.logTrace((String)"entity is managed, try to change name and flush ");
                    A a2 = this.findA("5");
                    if (a2.getName() == null) {
                        TestUtil.logTrace((String)"Received Name as null");
                    } else {
                        TestUtil.logErr((String)("Expected null name, actual:" + a2.getName()));
                        pass = false;
                    }
                    a2.setName("a2");
                    this.getEntityManager().flush();
                    if (a2.getName().equals("a2")) {
                        TestUtil.logTrace((String)"sync to database successful");
                    }
                }
                catch (Exception ee) {
                    TestUtil.logErr((String)"Unexpected exception trying to flush apersisted entity", (Throwable)ee);
                    pass = false;
                }
            } else {
                TestUtil.logTrace((String)"Instance is not already persisted. Test Fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected exception rolling back transaction", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("persistBasicTest5 failed");
        }
    }

    @SetupMethod(name="setupData")
    public void DoubleOperandResultTypeTests() throws EETest.Fault {
        Object p;
        double whereValue;
        boolean pass8 = false;
        boolean pass7 = false;
        boolean pass6 = false;
        boolean pass5 = false;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            TestUtil.logMsg((String)"Testing + Double operand:");
            this.getEntityTransaction().begin();
            whereValue = 1234.5;
            p = this.getEntityManager().createQuery("Select (a.basicBigDouble + 1) From A a where (a.basicBigDouble = ?1)").setParameter(1, (Object)whereValue).getSingleResult();
            if (p instanceof Double) {
                TestUtil.logTrace((String)"Received expected Double type");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Double:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing - Double operand:");
            this.getEntityTransaction().begin();
            whereValue = 1234.0;
            p = this.getEntityManager().createQuery("Select (a.basicBigDouble - 1) From A a where (a.basicBigDouble > ?1)").setParameter(1, (Object)whereValue).getSingleResult();
            if (p instanceof Double) {
                TestUtil.logTrace((String)"Received expected Double type");
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Double:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing * Double operand:");
            this.getEntityTransaction().begin();
            double whereValue2 = 1235.0;
            p = this.getEntityManager().createQuery("Select (a.basicBigDouble * 1) From A a where (a.basicBigDouble < ?1)").setParameter(1, (Object)whereValue2).getSingleResult();
            if (p instanceof Double) {
                TestUtil.logTrace((String)"Received expected Double type");
                pass3 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Double:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing / Double operand:");
            this.getEntityTransaction().begin();
            double whereValue3 = 1235.0;
            p = this.getEntityManager().createQuery("Select (a.basicBigDouble / 1) From A a where (a.basicBigDouble <> ?1)").setParameter(1, (Object)whereValue3).getSingleResult();
            if (p instanceof Double) {
                TestUtil.logTrace((String)"Received expected Double type");
                pass4 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Double:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing + double operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicDouble + 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Double) {
                TestUtil.logTrace((String)"Received expected double type");
                pass5 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type double:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing - double operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicDouble - 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Double) {
                TestUtil.logTrace((String)"Received expected double type");
                pass6 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type double:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing * double operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicDouble * 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Double) {
                TestUtil.logTrace((String)"Received expected double type");
                pass7 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type double:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing / double operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicDouble / 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Double) {
                TestUtil.logTrace((String)"Received expected double type");
                pass8 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type double:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6 && pass7 && pass8)) {
            throw new EETest.Fault("DoubleOperandResultTypeTests failed");
        }
    }

    @SetupMethod(name="setupData")
    public void FloatOperandResultTypeTests() throws EETest.Fault {
        Object p;
        boolean pass8 = false;
        boolean pass7 = false;
        boolean pass6 = false;
        boolean pass5 = false;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            TestUtil.logMsg((String)"Testing + Float operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigFloat + 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Float) {
                TestUtil.logTrace((String)"Received expected Float type");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Float:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing - Float operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigFloat - 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Float) {
                TestUtil.logTrace((String)"Received expected Float type");
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Float:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing * Float operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigFloat * 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Float) {
                TestUtil.logTrace((String)"Received expected Float type");
                pass3 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Float:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing / Float operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigFloat / 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Float) {
                TestUtil.logTrace((String)"Received expected Float type");
                pass4 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Float:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing + float operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicFloat + 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Float) {
                TestUtil.logTrace((String)"Received expected float type");
                pass5 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type float:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing - float operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicFloat - 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Float) {
                TestUtil.logTrace((String)"Received expected float type");
                pass6 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type float:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing * float operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicFloat * 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Float) {
                TestUtil.logTrace((String)"Received expected float type");
                pass7 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type float:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing / float operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigFloat / 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Float) {
                TestUtil.logTrace((String)"Received expected Float type");
                pass8 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Float:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6 && pass7 && pass8)) {
            throw new EETest.Fault("FloatOperandResultTypeTests failed");
        }
    }

    @SetupMethod(name="setupData")
    public void BigDecimalOperandResultTypeTests() throws EETest.Fault {
        Object p;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            TestUtil.logMsg((String)"Testing + BigDecimal operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigDecimal + 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof BigDecimal) {
                TestUtil.logTrace((String)"Received expected BigDecimal type");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type BigDecimal:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing - BigDecimal operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigDecimal - 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof BigDecimal) {
                TestUtil.logTrace((String)"Received expected BigDecimal type");
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type BigDecimal:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing * BigDecimal operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigDecimal * 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof BigDecimal) {
                TestUtil.logTrace((String)"Received expected BigDecimal type");
                pass3 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type BigDecimal:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing / BigDecimal operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigDecimal / 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof BigDecimal) {
                TestUtil.logTrace((String)"Received expected BigDecimal type");
                pass4 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type BigDecimal:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("BigDecimalOperandResultTypeTests failed");
        }
    }

    @SetupMethod(name="setupData")
    public void BigIntegerOperandResultTypeTests() throws EETest.Fault {
        Object p;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            TestUtil.logMsg((String)"Testing + BigInteger operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigInteger + 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof BigInteger) {
                TestUtil.logTrace((String)"Received expected BigInteger type");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type BigInteger:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing - BigInteger operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigInteger - 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof BigInteger) {
                TestUtil.logTrace((String)"Received expected BigInteger type");
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type BigInteger:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing * BigInteger operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigInteger * 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof BigInteger) {
                TestUtil.logTrace((String)"Received expected BigInteger type");
                pass3 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type BigInteger:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new EETest.Fault("BigIntegerOperandResultTypeTests failed");
        }
    }

    @SetupMethod(name="setupData")
    public void LongOperandResultTypeTests() throws EETest.Fault {
        Object p;
        boolean pass6 = false;
        boolean pass5 = false;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            TestUtil.logMsg((String)"Testing + Long operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigLong + 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Long) {
                TestUtil.logTrace((String)"Received expected Long type");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Long:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing - Long operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigLong - 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Long) {
                TestUtil.logTrace((String)"Received expected Long type");
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Long:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing * Long operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigLong * 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Long) {
                TestUtil.logTrace((String)"Received expected Long type");
                pass3 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Long:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing + long operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicLong + 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Long) {
                TestUtil.logTrace((String)"Received expected long type");
                pass4 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type long:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing - long operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicLong - 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Long) {
                TestUtil.logTrace((String)"Received expected long type");
                pass5 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type long:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing * long operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicLong * 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Long) {
                TestUtil.logTrace((String)"Received expected long type");
                pass6 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type long:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6)) {
            throw new EETest.Fault("LongOperandResultTypeTests failed");
        }
    }

    @SetupMethod(name="setupData")
    public void ShortOperandResultTypeTests() throws EETest.Fault {
        Object p;
        boolean pass6 = false;
        boolean pass5 = false;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            TestUtil.logMsg((String)"Testing + Short operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigShort + 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Integer) {
                TestUtil.logTrace((String)"Received expected Integer type");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Integer:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing - Short operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigShort - 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Integer) {
                TestUtil.logTrace((String)"Received expected Integer type");
                pass2 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Integer:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing * Short operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicBigShort * 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Integer) {
                TestUtil.logTrace((String)"Received expected Integer type");
                pass3 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Integer:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing + short operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicShort + 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Integer) {
                TestUtil.logTrace((String)"Received expected Integer type");
                pass4 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Integer:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing - short operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicShort - 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Integer) {
                TestUtil.logTrace((String)"Received expected Integer type");
                pass5 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Integer:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing * short operand:");
            this.getEntityTransaction().begin();
            p = this.getEntityManager().createQuery("Select (a.basicShort * 1) From A a where (a.id = '9')").getSingleResult();
            if (p instanceof Integer) {
                TestUtil.logTrace((String)"Received expected Integer type");
                pass6 = true;
            } else {
                TestUtil.logErr((String)("Result was not of type Integer:" + p.getClass().getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6)) {
            throw new EETest.Fault("ShortOperandResultTypeTests failed");
        }
    }

    private void createA(A a) {
        TestUtil.logTrace((String)"Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityManager().flush();
        this.getEntityTransaction().commit();
    }

    private A findA(String id) {
        TestUtil.logTrace((String)"Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private Object findByName(String name) {
        TestUtil.logTrace((String)"Entered findByName method");
        return this.getEntityManager().createQuery("select a from A a where a.name = :name").setParameter("name", (Object)name).getSingleResult();
    }

    private boolean getInstanceStatus(Object o) {
        TestUtil.logTrace((String)"Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTestData() {
        try {
            this.getEntityTransaction().begin();
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            A aRef = new A("9", null, 9, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            this.getEntityManager().persist((Object)aRef);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception in createTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM A_BASIC").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

