/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.j2eetools.mgmt.common;

import com.sun.ts.lib.util.TestUtil;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.j2ee.Management;

public class MOUtils {
    public static final String NAME_ATR = "objectName";
    public static final String SESSION_BEAN = "SessionBean";
    public static final String J2EE_MOD = "J2EEModule";
    public static final String EJB = "EJB";
    public static final String J2EE_DEPLOYED_OBJ = "J2EEDeployedObject";
    public static final String J2EE_RESOURCE = "J2EEResource";
    public static final String J2EE_DOMAIN = "J2EEDomain";
    public static final String J2EE_SERVER = "J2EEServer";
    public static final String J2EE_APP = "J2EEApplication";
    public static final String APP_CLIENT_MOD = "AppClientModule";
    public static final String EJB_MOD = "EJBModule";
    public static final String WEB_MOD = "WebModule";
    public static final String RES_ADP_MOD = "ResourceAdapterModule";
    public static final String ENTITY_BEAN = "EntityBean";
    public static final String STATEFUL_SES_BEAN = "StatefulSessionBean";
    public static final String STATELESS_SES_BEAN = "StatelessSessionBean";
    public static final String MESSAGE_DR_BEAN = "MessageDrivenBean";
    public static final String SERVLET = "Servlet";
    public static final String RESOURCE_ADP = "ResourceAdapter";
    public static final String JAVA_MAIL_RES = "JavaMailResource";
    public static final String JCA_RES = "JCAResource";
    public static final String JCA_CONN_FACT = "JCAConnectionFactory";
    public static final String JCA_MNGD_CONN_FACT = "JCAManagedConnectionFactory";
    public static final String JDBC_RES = "JDBCResource";
    public static final String JDBC_DATA_SRC = "JDBCDataSource";
    public static final String JDBC_DRV = "JDBCDriver";
    public static final String JMS_RES = "JMSResource";
    public static final String JNDI_RES = "JNDIResource";
    public static final String JTA_RES = "JTAResource";
    public static final String RMI_IIOP_RES = "RMI_IIOPResource";
    public static final String URL_RES = "URLResource";
    public static final String JVM = "JVM";

    private static boolean checkValueType(Object a, Object b) {
        TestUtil.logMsg((String)"*** checkValueType() invoked");
        if (a == null || b == null) {
            TestUtil.logMsg((String)("*** a = " + a));
            TestUtil.logMsg((String)("*** b = " + b));
            return false;
        }
        TestUtil.logMsg((String)("*** a.toString() = " + a.toString()));
        TestUtil.logMsg((String)("*** b.toString() = " + b.toString()));
        String aName = a.getClass().getName();
        String bName = b.getClass().getName();
        return aName.equals(bName);
    }

    private static void checkSetAttribute(Management mejb, ObjectName oName, Attribute attr) throws Exception {
        Attribute clearAttr = new Attribute(attr.getName(), null);
        mejb.setAttribute(oName, clearAttr);
        Object obj = mejb.getAttribute(oName, attr.getName());
        if (obj != null) {
            throw new Exception("Error clearing attribute \"" + attr.getName() + "\"");
        }
        mejb.setAttribute(oName, attr);
        obj = mejb.getAttribute(oName, attr.getName());
        if (obj == null || !obj.equals(attr.getValue())) {
            throw new Exception("Error setting attribute \"" + attr.getName() + "\"");
        }
    }

    private static boolean arrayContains(Object obj, Object[] objs) {
        boolean result = false;
        for (int i = 0; i < objs.length; ++i) {
            Object o = objs[i];
            if (!obj.equals(o)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean arrayIsSubset(Object[] a, Object[] b) {
        boolean result = true;
        for (int i = 0; i < a.length; ++i) {
            Object obj = a[i];
            if (MOUtils.arrayContains(obj, b)) continue;
            result = false;
            break;
        }
        return result;
    }

    private static boolean objectsEqual(Object a, Object b) {
        Object[] bArray;
        Object[] aArray;
        boolean result = false;
        result = a == null ? b == null : (a.getClass().isArray() && b.getClass().isArray() ? (aArray = (Object[])a).length == (bArray = (Object[])b).length && MOUtils.arrayIsSubset(aArray, bArray) && MOUtils.arrayIsSubset(bArray, aArray) : a.equals(b));
        return result;
    }

    public static void checkAttributes(Management mejb, ObjectName oName, Map attributes, boolean compareValues) throws Exception {
        Iterator iter = attributes.keySet().iterator();
        while (iter.hasNext()) {
            TestUtil.logMsg((String)"*** checkAttributes() invoked");
            String key = (String)iter.next();
            TestUtil.logMsg((String)("*** Key: " + key));
            Object expectedValue = attributes.get(key);
            Object mejbAttrObj = mejb.getAttribute(oName, key);
            if (key.equals(NAME_ATR) && mejbAttrObj == null) {
                throw new Exception("objectName must not be null");
            }
            if (mejbAttrObj == null) {
                throw new Exception("Attribute value types not equal for attribute '" + key + "' - with expected type = '" + expectedValue.getClass() + "'  but received NULL AttrObj from mejb.getAttribute() call");
            }
            if (!MOUtils.checkValueType(mejbAttrObj, expectedValue)) {
                throw new Exception("Attribute value types not equal for attribute '" + key + "' - with expected type '" + expectedValue.getClass() + "' but received type '" + mejbAttrObj.getClass() + "'");
            }
            if (compareValues && !MOUtils.objectsEqual(expectedValue, mejbAttrObj)) {
                throw new Exception("Attribute values are not equal for attribute \"" + key + "\"");
            }
            TestUtil.logMsg((String)(key + ": " + mejbAttrObj));
        }
    }

    public static void checkAttributes(Management mejb, ObjectName oName, Map attributes) throws Exception {
        MOUtils.checkAttributes(mejb, oName, attributes, false);
    }

    public static boolean mapIsSubset(Map a, Map b, boolean compareValues) {
        boolean result = true;
        if (a == null) {
            return result;
        }
        if (b == null) {
            return a == null;
        }
        for (String aKey : a.keySet()) {
            Object bObject;
            Object aObject;
            if (!b.containsKey(aKey)) {
                result = false;
                break;
            }
            if (!compareValues || (result = MOUtils.objectsEqual(aObject = a.get(aKey), bObject = b.get(aKey)))) continue;
            break;
        }
        return result;
    }

    public static boolean mapIsSubset(Map a, Map b) {
        return MOUtils.mapIsSubset(a, b, false);
    }

    public static boolean mapsEqual(Map a, Map b, boolean compareValues) {
        return MOUtils.mapIsSubset(a, b, compareValues) && MOUtils.mapIsSubset(a, b, compareValues);
    }

    public static boolean mapsEqual(Map a, Map b) {
        return MOUtils.mapsEqual(a, b, false);
    }

    public static void checkObjectName(String oName) throws MalformedObjectNameException {
        TestUtil.logMsg((String)("Verifying: " + oName));
        ObjectName newOname = new ObjectName(oName);
    }

    public static Set getManagedObjects(Management mejb, String searchpattern) throws RemoteException, MalformedObjectNameException {
        QueryExp myq = null;
        ObjectName onamesearch = new ObjectName(searchpattern);
        return mejb.queryNames(onamesearch, myq);
    }
}

