/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry_infomodel.LocalizedString;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.util.Locale;
import java.util.Properties;
import javax.xml.registry.infomodel.LocalizedString;

public class JAXRClient
extends JAXRCommonClient {
    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            super.cleanUpRegistry();
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            super.cleanup();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void localizedString_getValue() throws EETest.Fault {
        String testName = "localizedString_getValue";
        String value = "testValue";
        try {
            this.debug.add("Create a LocalizedString with the default locale and value of " + value + " \n");
            LocalizedString ls = this.blm.createLocalizedString(Locale.getDefault(), value);
            this.debug.add("Verify that LocalizedString.getValue returns " + value + " \n");
            if (!ls.getValue().equals(value)) {
                this.debug.add("Error: unexpected String returned for value \n");
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void localizedString_setValue() throws EETest.Fault {
        String testName = "localizedString_setValue";
        String value = "testValue";
        String setValue = "fromSetValueMethod";
        try {
            this.debug.add("Create a LocalizedString with the default locale and value of " + value + " \n");
            LocalizedString ls = this.blm.createLocalizedString(Locale.getDefault(), value);
            this.debug.add("Call LocalizedString.setValue(fromSetValueMethod) \n");
            ls.setValue(setValue);
            this.debug.add("Verify that LocalizedString.getValue returns: " + setValue + "\n");
            if (!ls.getValue().equals(setValue)) {
                this.debug.add("Error: unexpected String returned for value \n");
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void localizedString_getLocale() throws EETest.Fault {
        String testName = "localizedString_getLocale";
        String value = "testValue";
        try {
            this.debug.add("Create a LocalizedString with the default locale and value of " + value + " \n");
            LocalizedString ls = this.blm.createLocalizedString(Locale.getDefault(), value);
            this.debug.add("Verify that LocalizedString.getLocale returns the default locale: " + Locale.getDefault().toString() + " \n");
            this.debug.add("LocalizedString.getLocale: " + ls.getLocale().toString() + "\n");
            if (!ls.getLocale().toString().equals(Locale.getDefault().toString())) {
                this.debug.add("Error: unexpected String returned for default locale  \n");
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void localizedString_setLocale() throws EETest.Fault {
        String testName = "localizedString_setLocale()";
        String value = "testValue";
        try {
            this.debug.add("Create a LocalizedString with the default locale and value of " + value + " \n");
            LocalizedString ls = this.blm.createLocalizedString(Locale.getDefault(), value);
            this.debug.add("Set LocalizedString Locale to UK \n");
            Locale l = Locale.UK;
            ls.setLocale(l);
            this.debug.add("Verify that LocalizedString.getLocale returns: " + l.toString() + "\n");
            if (!ls.getLocale().toString().equals(l.toString())) {
                this.debug.add("Error: unexpected Locale returned from getLocale \n");
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void localizedString_getCharsetName() throws EETest.Fault {
        String testName = "localizedString_getCharsetName";
        String charName = "US-ASCII";
        String value = "testValue";
        try {
            LocalizedString ls = this.blm.createLocalizedString(Locale.getDefault(), value, charName);
            this.debug.add("In the create method set the char set name to " + charName + "\n");
            this.debug.add("ls.getCharsetName() should return " + charName + "\n");
            this.debug.add("ls.getCharsetName() returns: " + ls.getCharsetName() + "\n");
            if (!ls.getCharsetName().equals(charName)) {
                this.debug.add("Error: unexpected String returned for charsetname \n");
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void localizedString_getCharsetNameDefault() throws EETest.Fault {
        String testName = "localizedString_getCharsetNameDefault";
        String value = "testValue";
        try {
            this.debug.add("Create a LocalizedString with the default locale and value of " + value + " \n");
            LocalizedString ls = this.blm.createLocalizedString(Locale.getDefault(), value);
            this.debug.add("Verify that ls.getcharsetName returns the default charsetName which is: UTF-8\n");
            this.debug.add("ls.getCharsetName() returns: " + ls.getCharsetName() + "\n");
            if (!ls.getCharsetName().equals("UTF-8")) {
                this.debug.add("Error: unexpected String returned for charsetname \n");
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void localizedString_setCharsetName() throws EETest.Fault {
        String testName = "localizedString_setCharsetName()";
        String charName = "UTF-16";
        String value = "testValue";
        try {
            LocalizedString ls = this.blm.createLocalizedString(Locale.getDefault(), value);
            ls.setCharsetName(charName);
            this.debug.add("Verify that LocalizedString.getCharsetName returns: " + charName + "\n");
            this.debug.add("LocalizedString.getCharsetName returned " + ls.getCharsetName() + "\n");
            if (!ls.getCharsetName().equals(charName)) {
                this.debug.add("Error: unexpected charsetName returned from getCharsetName\n");
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }
}

