/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.entity.util;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityContext;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;

public class DBSupport
implements Serializable {
    private static final String DATASOURCE1 = "java:comp/env/jdbc/DB1";
    private transient Connection dbConnection = null;
    private EntityContext ectx = null;
    private SessionContext sctx = null;
    private TSNamingContext nctx = null;
    private UserTransaction ut = null;
    private String user1 = null;
    private String password1 = null;
    private String dsname1 = null;
    private DataSource ds1 = null;
    private int cofID = 0;
    private String cofName = null;
    private float cofPrice = 0.0f;
    private boolean debug = true;

    public DBSupport(EntityContext ectx) throws Exception {
        this(ectx, null);
    }

    public DBSupport(EntityContext ectx, Properties p) throws Exception {
        TestUtil.logTrace((String)"DBSupport");
        this.ectx = ectx;
        if (this.debug) {
            TestUtil.logMsg((String)"Initializing DBSupport for an Entity Bean");
        }
        try {
            if (this.debug) {
                TestUtil.logMsg((String)"Get naming context");
            }
            this.nctx = new TSNamingContext();
        }
        catch (NamingException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Unable to get naming context");
        }
        if (this.debug) {
            TestUtil.logMsg((String)"Lookup DataSource DB1 from JNDI : java:comp/env/jdbc/DB1");
        }
        try {
            this.dsname1 = DATASOURCE1;
            this.ds1 = (DataSource)this.nctx.lookup(this.dsname1);
            if (this.debug) {
                TestUtil.logMsg((String)("dsname1=" + this.dsname1));
            }
            if (this.debug) {
                TestUtil.logMsg((String)("ds1=" + this.ds1));
            }
        }
        catch (NamingException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Unable to lookup java:comp/env/jdbc/DB1");
        }
    }

    public DBSupport(SessionContext sctx) throws Exception {
        this(sctx, null);
    }

    public DBSupport(SessionContext sctx, Properties p) throws Exception {
        TestUtil.logTrace((String)"DBSupport");
        TestUtil.logMsg((String)"DBSupport");
        this.sctx = sctx;
        if (this.debug) {
            TestUtil.logMsg((String)"Initializing DBSupport for an Session Bean");
        }
        try {
            if (this.debug) {
                TestUtil.logMsg((String)"Get naming context");
            }
            this.nctx = new TSNamingContext();
        }
        catch (NamingException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Unable to get naming context");
        }
        if (this.debug) {
            TestUtil.logMsg((String)"Lookup DataSource DB1 from JNDI : java:comp/env/jdbc/DB1");
        }
        try {
            this.dsname1 = DATASOURCE1;
            this.ds1 = (DataSource)this.nctx.lookup(DATASOURCE1);
            if (this.debug) {
                TestUtil.logMsg((String)("dsname1=" + this.dsname1));
            }
            if (this.debug) {
                TestUtil.logMsg((String)("ds1=" + this.ds1));
            }
        }
        catch (NamingException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Unable to lookup java:comp/env/jdbc/DB1");
        }
    }

    public void tableInit() throws SQLException {
        Statement stmt = null;
        TestUtil.logTrace((String)"tableInit");
        this.getDBConnection();
        try {
            stmt = this.dbConnection.createStatement();
            String sqlStr = TestUtil.getProperty((String)"BB_Tab_Delete");
            stmt.executeUpdate(sqlStr);
            TestUtil.logMsg((String)("Deleted all rows from table " + TestUtil.getTableName((String)sqlStr)));
        }
        catch (SQLException s) {
            TestUtil.printStackTrace((Throwable)s);
            throw new SQLException("SQL Exception in tableInit:" + s.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void tableDrop() throws SQLException {
        Statement stmt = null;
        TestUtil.logTrace((String)"tableDrop");
        this.getDBConnection();
        try {
            stmt = this.dbConnection.createStatement();
            String sqlStr = TestUtil.getProperty((String)"BB_Tab_Delete");
            stmt.executeUpdate(sqlStr);
            TestUtil.logMsg((String)("Deleted all rows from table " + TestUtil.getTableName((String)sqlStr)));
        }
        catch (SQLException s) {
            TestUtil.printStackTrace((Throwable)s);
            throw new SQLException("SQL Exception in tableDrop:" + s.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void tablePopulate(int[] cofID, String[] cofName, float[] cofPrice) throws SQLException {
        Statement pStmt = null;
        TestUtil.logTrace((String)"tablePopulate");
        this.tableInit();
        this.getDBConnection();
        TestUtil.logMsg((String)("Inserting " + cofID.length + " rows of data into table"));
        try {
            String sqlStr = TestUtil.getProperty((String)"BB_Insert1");
            TestUtil.logMsg((String)sqlStr);
            pStmt = this.dbConnection.prepareStatement(sqlStr);
            for (int i = 0; i < cofID.length; ++i) {
                pStmt.setInt(1, cofID[i]);
                pStmt.setString(2, cofName[i]);
                pStmt.setFloat(3, cofPrice[i]);
                if (pStmt.executeUpdate() == 1) continue;
                throw new SQLException("SQL INSERT failed in tablePopulate");
            }
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new SQLException("SQL Exception in tablePopulate" + e.getMessage());
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public boolean keyExists(int pkey) throws SQLException {
        Statement pStmt = null;
        ResultSet result = null;
        TestUtil.logTrace((String)"keyExists");
        this.getDBConnection();
        try {
            String sqlStr = TestUtil.getProperty((String)"BB_Select1");
            TestUtil.logMsg((String)sqlStr);
            pStmt = this.dbConnection.prepareStatement(sqlStr);
            pStmt.setInt(1, pkey);
            result = pStmt.executeQuery();
            if (!result.next()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new SQLException("SQL Exception in keyExists");
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public Collection nameToKeyCollection(String name) throws SQLException {
        Statement pStmt = null;
        ResultSet result = null;
        TestUtil.logTrace((String)"nameToKey");
        this.getDBConnection();
        try {
            String sqlStr = TestUtil.getProperty((String)"BB_Select2");
            TestUtil.logMsg((String)sqlStr);
            pStmt = this.dbConnection.prepareStatement(sqlStr);
            pStmt.setString(1, name);
            result = pStmt.executeQuery();
            ArrayList<Integer> a = new ArrayList<Integer>();
            while (result.next()) {
                Integer pkey = new Integer(result.getInt(1));
                a.add(pkey);
            }
            ArrayList<Integer> arrayList = a;
            return arrayList;
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new SQLException("SQL Exception in nameToKey: " + e.getMessage());
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public Collection priceToKeyCollection(float price) throws SQLException {
        Statement pStmt = null;
        ResultSet result = null;
        TestUtil.logTrace((String)"priceToKey");
        this.getDBConnection();
        try {
            String sqlStr = TestUtil.getProperty((String)"BB_Select3");
            TestUtil.logMsg((String)sqlStr);
            pStmt = this.dbConnection.prepareStatement(sqlStr);
            pStmt.setFloat(1, price);
            result = pStmt.executeQuery();
            ArrayList<Integer> a = new ArrayList<Integer>();
            while (result.next()) {
                Integer pkey = new Integer(result.getInt(1));
                a.add(pkey);
            }
            ArrayList<Integer> arrayList = a;
            return arrayList;
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new SQLException("SQL Exception in priceToKey" + e.getMessage());
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public Collection priceRangeToCollection(float min, float max) throws SQLException {
        Statement pStmt = null;
        ResultSet result = null;
        TestUtil.logTrace((String)"priceRangeToCollection");
        this.getDBConnection();
        try {
            String sqlStr = TestUtil.getProperty((String)"BB_Select4");
            TestUtil.logMsg((String)sqlStr);
            pStmt = this.dbConnection.prepareStatement(sqlStr);
            pStmt.setFloat(1, min);
            pStmt.setFloat(2, max);
            result = pStmt.executeQuery();
            ArrayList<Integer> a = new ArrayList<Integer>();
            while (result.next()) {
                Integer pkey = new Integer(result.getInt(1));
                a.add(pkey);
            }
            ArrayList<Integer> arrayList = a;
            return arrayList;
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new SQLException("SQL Exception in priceRangeToCollection" + e.getMessage());
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public Collection primaryKeyRangeToCollection(Integer min, Integer max) throws SQLException {
        Statement pStmt = null;
        ResultSet result = null;
        TestUtil.logTrace((String)"primaryKeyRangeToCollection");
        this.getDBConnection();
        try {
            String sqlStr = TestUtil.getProperty((String)"BB_Select5");
            TestUtil.logMsg((String)sqlStr);
            pStmt = this.dbConnection.prepareStatement(sqlStr);
            pStmt.setInt(1, min);
            pStmt.setInt(2, max);
            result = pStmt.executeQuery();
            ArrayList<Integer> a = new ArrayList<Integer>();
            while (result.next()) {
                Integer pkey = new Integer(result.getInt(1));
                a.add(pkey);
            }
            ArrayList<Integer> arrayList = a;
            return arrayList;
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new SQLException("SQL Exception in primaryKeyRangeToCollection: " + e.getMessage());
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void createNewRow(int cofID, String cofName, float cofPrice) throws CreateException, SQLException {
        Statement pStmt = null;
        TestUtil.logTrace((String)"createNewRow");
        this.getDBConnection();
        try {
            String sqlStr = TestUtil.getProperty((String)"BB_Insert1");
            TestUtil.logMsg((String)sqlStr);
            pStmt = this.dbConnection.prepareStatement(sqlStr);
            pStmt.setInt(1, cofID);
            pStmt.setString(2, cofName);
            pStmt.setFloat(3, cofPrice);
            if (pStmt.executeUpdate() != 1) {
                throw new CreateException("SQL INSERT failed in createNewRow");
            }
            this.cofID = cofID;
            this.cofName = cofName;
            this.cofPrice = cofPrice;
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new SQLException("SQL Exception in createNewRow" + e.getMessage());
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public float loadPrice(int pkey) throws SQLException {
        Statement pStmt = null;
        ResultSet result = null;
        TestUtil.logTrace((String)"loadPrice");
        this.getDBConnection();
        try {
            String sqlStr = TestUtil.getProperty((String)"BB_Select6");
            TestUtil.logMsg((String)sqlStr);
            pStmt = this.dbConnection.prepareStatement(sqlStr);
            pStmt.setInt(1, pkey);
            result = pStmt.executeQuery();
            if (!result.next()) {
                throw new SQLException("SQL SELECT failed: no record for primary key = " + pkey);
            }
            float f = result.getFloat(1);
            return f;
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new SQLException("SQL Exception in loadPrice: " + e.getMessage());
        }
        finally {
            try {
                if (result != null) {
                    result.close();
                }
                if (pStmt != null) {
                    pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void storePrice(int pkey, float cofPrice) throws SQLException {
        Statement pStmt = null;
        TestUtil.logTrace((String)"storePrice");
        this.getDBConnection();
        try {
            String sqlStr = TestUtil.getProperty((String)"BB_Update1");
            TestUtil.logMsg((String)sqlStr);
            pStmt = this.dbConnection.prepareStatement(sqlStr);
            pStmt.setFloat(1, cofPrice);
            pStmt.setInt(2, pkey);
            if (pStmt.executeUpdate() != 1) {
                throw new SQLException("SQL UPDATE failed in storePrice");
            }
            this.cofPrice = cofPrice;
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new SQLException("SQL Exception in storePrice: " + e.getMessage());
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void removeRow(int pkey) throws SQLException {
        Statement pStmt = null;
        TestUtil.logTrace((String)"removeRow");
        this.getDBConnection();
        try {
            String sqlStr = TestUtil.getProperty((String)"BB_Delete1");
            TestUtil.logMsg((String)sqlStr);
            pStmt = this.dbConnection.prepareStatement(sqlStr);
            pStmt.setInt(1, pkey);
            if (pStmt.executeUpdate() != 1) {
                throw new SQLException("SQL DELETE failed in removeRow");
            }
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new SQLException("SQL Exception in removeRow: " + e.getMessage());
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
                this.closeDBConnection();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    public void getDBConnection() throws SQLException {
        TestUtil.logTrace((String)"getDBConnection");
        if (this.dbConnection != null) {
            try {
                this.closeDBConnection();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        this.dbConnection = this.ds1.getConnection();
    }

    public void closeDBConnection() throws SQLException {
        TestUtil.logTrace((String)"closeDBConnection");
        if (this.dbConnection != null) {
            this.dbConnection.close();
            this.dbConnection = null;
        }
    }

    public void beginUserTransaction() throws Exception {
        this.ut.begin();
    }

    public void commitUserTransaction() throws Exception {
        this.ut.commit();
    }
}

