/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.session.lrapitest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.session.lrapitest.A;
import com.sun.ts.tests.ejb.ee.bb.session.lrapitest.AHome;
import com.sun.ts.tests.ejb.ee.bb.session.lrapitest.ALocal;
import com.sun.ts.tests.ejb.ee.bb.session.lrapitest.ALocalHome;
import com.sun.ts.tests.ejb.ee.bb.session.lrapitest.B;
import com.sun.ts.tests.ejb.ee.bb.session.lrapitest.BHome;
import com.sun.ts.tests.ejb.ee.bb.session.lrapitest.CLocal;
import com.sun.ts.tests.ejb.ee.bb.session.lrapitest.CLocalHome;
import com.sun.ts.tests.ejb.ee.bb.session.lrapitest.DLocal;
import com.sun.ts.tests.ejb.ee.bb.session.lrapitest.DLocalHome;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.rmi.PortableRemoteObject;

public class TestBeanEJB
implements SessionBean {
    private SessionContext sctx = null;
    private Properties harnessProps = null;
    private TSNamingContext nctx = null;
    private static final String ARemote = "java:comp/env/ejb/AEJB";
    private static final String BRemote = "java:comp/env/ejb/BEJB";
    private static final String ALocal = "java:comp/env/ejb/AEJBLocal";
    private static final String CLocal = "java:comp/env/ejb/CEJBLocal";
    private static final String DLocal = "java:comp/env/ejb/DEJBLocal";
    private A aRef = null;
    private AHome aHome = null;
    private ALocal aLocalRef = null;
    private ALocalHome aLocalHome = null;
    private B bRef = null;
    private BHome bHome = null;
    private CLocal cLocalRef = null;
    private CLocalHome cLocalHome = null;
    private DLocal dLocalRef = null;
    private DLocalHome dLocalHome = null;

    private A createA(String s) throws Exception {
        TestUtil.logTrace((String)"createA");
        this.aHome = (AHome)this.nctx.lookup(ARemote, AHome.class);
        this.aRef = this.aHome.createA(s);
        this.aRef.init(this.harnessProps);
        return this.aRef;
    }

    private ALocal createALocal(String s) throws Exception {
        TestUtil.logTrace((String)"createALocal");
        this.aLocalHome = (ALocalHome)this.nctx.lookup(ALocal);
        return this.aLocalHome.createA(s);
    }

    private B createB(String s) throws Exception {
        TestUtil.logTrace((String)"createB");
        this.bHome = (BHome)this.nctx.lookup(BRemote, BHome.class);
        this.bRef = this.bHome.createB(s);
        this.bRef.init(this.harnessProps);
        return this.bRef;
    }

    private CLocal createCLocal(String s) throws Exception {
        TestUtil.logTrace((String)"createCLocal");
        this.cLocalHome = (CLocalHome)this.nctx.lookup(CLocal);
        return this.cLocalHome.createC(s);
    }

    private DLocal createDLocal() throws Exception {
        TestUtil.logTrace((String)"createDLocal");
        this.dLocalHome = (DLocalHome)this.nctx.lookup(DLocal);
        return this.dLocalHome.create();
    }

    private boolean createTest() {
        TestUtil.logTrace((String)"createTest");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Create local Session Bean object");
            this.cLocalRef = this.createCLocal("C1");
            TestUtil.logMsg((String)"Object was created successfully");
            TestUtil.logMsg((String)this.cLocalRef.whoAmILocal());
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                this.cLocalRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        return pass;
    }

    private boolean removeLocalHomeTest() {
        TestUtil.logTrace((String)"removeLocalHomeTest");
        boolean pass = true;
        try {
            this.cLocalRef = this.createCLocal("C1");
            try {
                this.cLocalHome.remove("C1");
                TestUtil.logErr((String)"RemoveException did not occur - unexpected");
                pass = false;
            }
            catch (RemoveException e) {
                TestUtil.logMsg((String)"RemoveException did occur - expected");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                this.cLocalRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getPrimaryKeyTest() {
        TestUtil.logTrace((String)"getPrimaryKeyTest");
        boolean pass = true;
        String pk = "1";
        try {
            this.cLocalRef = this.createCLocal("C1");
            Object primaryKey = this.cLocalRef.getPrimaryKey();
            TestUtil.logErr((String)"EJBException did not occur - unexpected");
            pass = false;
        }
        catch (EJBException e) {
            TestUtil.logMsg((String)"EJBException did occur - expected");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                this.cLocalRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        return pass;
    }

    private boolean getEJBLocalHomeTest() {
        TestUtil.logTrace((String)"getEJBLocalHomeTest");
        boolean pass = true;
        try {
            this.cLocalRef = this.createCLocal("C1");
            CLocalHome beanHome = (CLocalHome)this.cLocalRef.getEJBLocalHome();
            if (beanHome != null) {
                pass = true;
            } else {
                TestUtil.logErr((String)"LocalHome returned was null");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                this.cLocalRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        return pass;
    }

    private boolean callBusinessMethodTest() {
        TestUtil.logTrace((String)"callBusinessMethodTest");
        boolean pass = true;
        try {
            this.cLocalRef = this.createCLocal("C1");
            TestUtil.logMsg((String)("calling business method: " + this.cLocalRef.whoAmILocal()));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                this.cLocalRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isIdenticalStatefulTest() {
        TestUtil.logTrace((String)"isIdenticalStatefulTest");
        boolean pass = true;
        CLocal cLocalRef1 = null;
        CLocal cLocalRef2 = null;
        try {
            cLocalRef1 = this.createCLocal("C1");
            cLocalRef2 = this.createCLocal("C2");
            TestUtil.logMsg((String)"Do isIdentical test with same object");
            if (cLocalRef1.isIdentical(cLocalRef1)) {
                TestUtil.logMsg((String)"isIdentical same object test - okay");
            } else {
                TestUtil.logErr((String)"isIdentical same object test - not okay");
                pass = false;
            }
            TestUtil.logMsg((String)"Do isIdentical test with different objects");
            if (cLocalRef1.isIdentical(cLocalRef2)) {
                TestUtil.logErr((String)"isIdentical diff object test - not okay");
                pass = false;
            } else {
                TestUtil.logErr((String)"isIdentical diff object test - okay");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                cLocalRef1.remove();
                cLocalRef2.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isIdenticalStatelessTest() {
        TestUtil.logTrace((String)"isIdenticalStatelessTest");
        boolean pass = true;
        DLocal dLocalRef1 = null;
        DLocal dLocalRef2 = null;
        try {
            dLocalRef1 = this.createDLocal();
            dLocalRef2 = this.createDLocal();
            TestUtil.logMsg((String)"Do isIdentical test with same object");
            if (dLocalRef1.isIdentical(dLocalRef1)) {
                TestUtil.logMsg((String)"isIdentical same object test - okay");
            } else {
                TestUtil.logErr((String)"isIdentical same object test - not okay");
                pass = false;
            }
            TestUtil.logMsg((String)"Do isIdentical test with different objects");
            if (dLocalRef1.isIdentical(dLocalRef2)) {
                TestUtil.logMsg((String)"isIdentical same object test - okay");
            } else {
                TestUtil.logErr((String)"isIdentical same object test - not okay");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                dLocalRef1.remove();
                dLocalRef2.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        return pass;
    }

    private boolean removeLocalObjectTest() {
        TestUtil.logTrace((String)"removeLocalObjectTest");
        boolean pass = true;
        try {
            this.cLocalRef = this.createCLocal("C1");
            this.cLocalRef.remove();
            try {
                this.cLocalRef.whoAmILocal();
                TestUtil.logErr((String)"object was found after removal");
                pass = false;
            }
            catch (EJBException e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logMsg((String)"object was not found after removal");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                this.cLocalRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        return pass;
    }

    public void ejbCreate(Properties p) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        this.harnessProps = p;
        try {
            TestUtil.logMsg((String)"initialize remote logging");
            TestUtil.init((Properties)p);
            TestUtil.logMsg((String)"obtain naming context");
            this.nctx = new TSNamingContext();
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("exception occurred: " + e);
        }
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        this.sctx = sc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean test1() {
        boolean pass = true;
        try {
            this.aRef = this.createA("A1");
            pass = this.aRef.test1();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.aRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean test2() {
        boolean pass = true;
        try {
            this.bRef = this.createB("B1");
            pass = this.bRef.test2();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.bRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean test3() {
        boolean pass = true;
        try {
            this.cLocalRef = this.createCLocal("C1");
            pass = this.cLocalRef.test3();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.cLocalRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        return pass;
    }

    public boolean test4() {
        boolean pass = true;
        if (this.createTest()) {
            TestUtil.logMsg((String)"EJBLocalHome.create ... PASSED");
        } else {
            TestUtil.logMsg((String)"EJBLocalHome.create ... FAILED");
            pass = false;
        }
        if (this.removeLocalHomeTest()) {
            TestUtil.logMsg((String)"EJBLocalHome.remove ... PASSED");
        } else {
            TestUtil.logMsg((String)"EJBLocalHome.remove ... FAILED");
            pass = false;
        }
        return pass;
    }

    public boolean test5() {
        boolean pass = true;
        if (this.getPrimaryKeyTest()) {
            TestUtil.logMsg((String)"EJBLocalObject.getPrimaryKey ... PASSED");
        } else {
            TestUtil.logMsg((String)"EJBLocalObject.getPrimaryKey ... FAILED");
            pass = false;
        }
        if (this.isIdenticalStatefulTest()) {
            TestUtil.logMsg((String)"EJBLocalObject.isIdentical (Stateful) ... PASSED");
        } else {
            TestUtil.logMsg((String)"EJBLocalObject.isIdentical (Stateful) ... FAILED");
            pass = false;
        }
        if (this.isIdenticalStatelessTest()) {
            TestUtil.logMsg((String)"EJBLocalObject.isIdentical (Stateless) ... PASSED");
        } else {
            TestUtil.logMsg((String)"EJBLocalObject.isIdentical (Stateless) ... FAILED");
            pass = false;
        }
        if (this.getEJBLocalHomeTest()) {
            TestUtil.logMsg((String)"EJBLocalObject.getEJBLocalHome ... PASSED");
        } else {
            TestUtil.logMsg((String)"EJBLocalObject.getEJBLocalHome ... FAILED");
            pass = false;
        }
        if (this.callBusinessMethodTest()) {
            TestUtil.logMsg((String)"businessMethod ... PASSED");
        } else {
            TestUtil.logMsg((String)"businessMethod ... FAILED");
            pass = false;
        }
        if (this.removeLocalObjectTest()) {
            TestUtil.logMsg((String)"EJBLocalObject.remove ... PASSED");
        } else {
            TestUtil.logMsg((String)"EJBLocalObject.remove ... FAILED");
            pass = false;
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean test6() {
        boolean pass = true;
        try {
            this.aRef = this.createA("A1");
            this.aLocalRef = this.createALocal("A1");
            TestUtil.logMsg((String)"call method to return a remote ref");
            A aRef1 = (A)PortableRemoteObject.narrow((Object)this.aRef.getRemoteRef(), A.class);
            TestUtil.logMsg((String)"call business method on remote ref returned");
            String whoami = aRef1.whoAmIRemote();
            if (!whoami.equals("Remote-A1")) {
                TestUtil.logErr((String)("Expected: (Remote-A1), Received: (" + whoami + ")"));
                pass = false;
            }
            TestUtil.logMsg((String)"call method to return a local ref");
            ALocal aLocalRef1 = (ALocal)this.aLocalRef.getLocalRef();
            TestUtil.logMsg((String)"call business method on local ref returned");
            whoami = aLocalRef1.whoAmILocal();
            if (!whoami.equals("Local-A1")) {
                TestUtil.logErr((String)("Expected: (Local-A1), Received: (" + whoami + ")"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.aRef.remove();
                this.aLocalRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        return pass;
    }

    public boolean test7() {
        boolean pass = true;
        try {
            this.cLocalRef = this.createCLocal("C1");
            this.cLocalRef.remove();
            try {
                this.cLocalRef.whoAmILocal();
                TestUtil.logErr((String)"NoSuchObjectLocalException did not occur - unexpected");
                pass = false;
            }
            catch (NoSuchObjectLocalException e) {
                TestUtil.logMsg((String)"NoSuchObjectLocalException did occur - expected");
            }
            catch (Exception e) {
                TestUtil.logMsg((String)("Exception: " + e));
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    public boolean test8() {
        TestUtil.logTrace((String)"test8");
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Lookup local home of Session Bean (SF) and do create");
            this.aLocalRef = this.createALocal("8");
            TestUtil.logMsg((String)"Calling local business method: whoAmILocal");
            String string = this.aLocalRef.whoAmILocal();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught Unexpected Exception in test8: " + e.getMessage()));
        }
        finally {
            try {
                TestUtil.logMsg((String)"Attempt Removal of bean while participating in TX");
                this.aLocalRef.remove();
            }
            catch (RemoveException re) {
                TestUtil.logMsg((String)"RemoveException did occur - expected");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"RemoveException did not occur - unexpected", (Throwable)e);
            }
        }
        return pass;
    }

    public boolean test9() {
        TestUtil.logTrace((String)"test9");
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Lookup remote home of Session Bean (SF) and do create");
            this.aRef = this.createA("9");
            TestUtil.logMsg((String)"Calling remote business method: whoAmIRemote");
            String string = this.aRef.whoAmIRemote();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught Unexpected Exception in test9: " + e.getMessage()));
        }
        finally {
            try {
                TestUtil.logMsg((String)"Attempt Removal of bean while participating in TX");
                this.aRef.remove();
            }
            catch (RemoveException re) {
                TestUtil.logMsg((String)"RemoveException did occur - expected");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"RemoveException did not occur - unexpected", (Throwable)e);
            }
        }
        return pass;
    }

    public boolean test10() {
        TestUtil.logTrace((String)"test10");
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Lookup local home of Session Bean (SF) and do create");
            this.aLocalRef = this.createALocal("10");
            TestUtil.logMsg((String)"Calling local business method: whoAmILocal");
            String string = this.aLocalRef.whoAmILocal();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught Unexpected Exception in test10: " + e.getMessage()));
        }
        finally {
            try {
                TestUtil.logMsg((String)"Attempt Removal of bean while participating in TX");
                this.aLocalHome.remove(this.aLocalRef);
            }
            catch (RemoveException re) {
                TestUtil.logMsg((String)"RemoveException did occur - expected");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"RemoveException did not occur - unexpected", (Throwable)e);
            }
        }
        return pass;
    }

    public boolean test11() {
        TestUtil.logTrace((String)"test11");
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Lookup remote home of Session Bean (SF) and do create");
            this.aRef = this.createA("11");
            TestUtil.logMsg((String)"Calling remote business method: whoAmIRemote");
            String string = this.aRef.whoAmIRemote();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught Unexpected Exception in test11: " + e.getMessage()));
        }
        finally {
            try {
                TestUtil.logMsg((String)"Attempt Removal of bean while participating in TX");
                this.aHome.remove(this.aRef);
            }
            catch (RemoveException re) {
                TestUtil.logMsg((String)"RemoveException did occur - expected");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"RemoveException did not occur - unexpected", (Throwable)e);
            }
        }
        return pass;
    }

    public boolean test12() {
        boolean pass = this.test10();
        return pass &= this.test11();
    }

    public void cleanUpStatefulBean() {
        TestUtil.logTrace((String)"cleanUpStatefulBean");
        try {
            if (this.aRef != null) {
                TestUtil.logTrace((String)"cleanUp Remote Session Stateful Bean");
                this.aRef.remove();
                this.aRef = null;
            }
            if (this.aLocalRef != null) {
                TestUtil.logTrace((String)"cleanUp Local Session Stateful Bean");
                this.aLocalRef.remove();
                this.aLocalRef = null;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught trying to remove Stateful Session beans", (Throwable)e);
        }
    }
}

