/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.bb.mdb.activationconfig.common;

import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.messaging.StatusReporter;
import javax.annotation.Resource;
import javax.ejb.EJBContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;

public abstract class ActivationConfigBeanBase {
    public static final String test1 = "test1";
    @Resource(name="qFactory")
    private QueueConnectionFactory qFactory;
    @Resource(name="replyQueue")
    private Queue replyQueue;

    public abstract EJBContext getEJBContext();

    public void onMessage(Message msg) {
        TLogger.log("Entering onMessage method of: " + this.getClass().getName());
        boolean status = false;
        String reason = null;
        String testname = null;
        int testNumber = 0;
        try {
            testname = msg.getStringProperty("COM_SUN_JMS_TESTNAME");
            testNumber = msg.getIntProperty("TestCaseNum");
        }
        catch (JMSException e) {
            status = false;
            reason = "Failed to get test name/number from message: " + msg;
            TLogger.log(reason);
            StatusReporter.report(testname, status, reason, (QueueConnectionFactory)this.getEJBContext().lookup("qFactory"), (Queue)this.getEJBContext().lookup("replyQueue"));
            return;
        }
        if (testname == null) {
            return;
        }
        status = true;
        reason = "ActivationConfigBeanBase received message from " + testname + ", testnum " + testNumber;
        TLogger.log(reason);
        StatusReporter.report(testname, status, reason, (QueueConnectionFactory)this.getEJBContext().lookup("qFactory"), (Queue)this.getEJBContext().lookup("replyQueue"));
    }
}

