/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.ee.packaging.appclient.descriptor;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.ee.packaging.appclient.descriptor.Coffee;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;

public class Client
extends EETest {
    private static final Coffee[] cRef = new Coffee[5];
    private EntityManagerFactory emf;
    private EntityManager em;
    private EntityTransaction et;
    private TSNamingContext nctx = null;
    private static final String emfRef = "java:comp/env/persistence/MyPersistenceUnit";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            TestUtil.logTrace((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
            if (this.nctx == null) {
                TestUtil.logErr((String)"NCTX is null");
                throw new EETest.Fault("Setup Failed!");
            }
            this.emf = (EntityManagerFactory)this.nctx.lookup(emfRef);
            if (this.emf == null) {
                TestUtil.logErr((String)"EMF is null");
                throw new EETest.Fault("Setup Failed!");
            }
            this.em = this.emf.createEntityManager();
            if (this.em == null) {
                TestUtil.logErr((String)"EM is null");
                throw new EETest.Fault("Setup Failed!");
            }
            this.removeTestData();
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup Failed!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin test1");
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"getEntityTransaction");
            if (null != this.em) {
                this.et = this.em.getTransaction();
                if (this.et != null) {
                    TestUtil.logTrace((String)"createTestData");
                    this.et.begin();
                    TestUtil.logTrace((String)"Create 5 Coffees");
                    Client.cRef[0] = new Coffee(1, "hazelnut", 1.0f);
                    Client.cRef[1] = new Coffee(2, "vanilla creme", 2.0f);
                    Client.cRef[2] = new Coffee(3, "decaf", 3.0f);
                    Client.cRef[3] = new Coffee(4, "breakfast blend", 4.0f);
                    Client.cRef[4] = new Coffee(5, "mocha", 5.0f);
                    TestUtil.logTrace((String)"Start to persist coffees ");
                    for (Coffee c : cRef) {
                        if (c == null) continue;
                        this.em.persist((Object)c);
                        TestUtil.logTrace((String)("persisted coffee " + c));
                    }
                    this.et.commit();
                    TestUtil.logTrace((String)"Clearing the persistence context");
                    this.em.clear();
                    this.et.begin();
                    for (Coffee c : cRef) {
                        if (c == null) continue;
                        Coffee newcoffee = (Coffee)this.em.find(Coffee.class, (Object)c.getId());
                        if (newcoffee != null) {
                            this.em.remove((Object)newcoffee);
                            TestUtil.logTrace((String)("removed coffee " + newcoffee));
                            continue;
                        }
                        TestUtil.logErr((String)("find of coffee[" + c.getId() + "] returned null"));
                        pass = false;
                    }
                    this.et.commit();
                } else {
                    TestUtil.logErr((String)"EntityTransaction is null");
                    pass = false;
                }
            } else {
                TestUtil.logErr((String)"EntityManager is null");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected while creating test data:", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.et.isActive()) {
                    this.et.rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test1 failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"Clearing cache");
        this.emf.getCache().evictAll();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (null == this.em) {
            this.em = this.emf.createEntityManager();
        }
        if (null == this.et) {
            this.et = this.em.getTransaction();
        }
        if (this.et.isActive()) {
            this.et.rollback();
        }
        try {
            this.et.begin();
            this.em.createNativeQuery("DELETE FROM COFFEE").executeUpdate();
            this.et.commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.et.isActive()) {
                    this.et.rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

