/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.customizedmapping.ijson;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.customizedmapping.ijson.model.BinaryDataContainer;
import com.sun.ts.tests.jsonb.customizedmapping.ijson.model.CalendarContainer;
import com.sun.ts.tests.jsonb.customizedmapping.ijson.model.DateContainer;
import com.sun.ts.tests.jsonb.customizedmapping.ijson.model.DurationContainer;
import com.sun.ts.tests.jsonb.customizedmapping.ijson.model.GregorianCalendarContainer;
import com.sun.ts.tests.jsonb.customizedmapping.ijson.model.InstantContainer;
import com.sun.ts.tests.jsonb.customizedmapping.ijson.model.LocalDateContainer;
import com.sun.ts.tests.jsonb.customizedmapping.ijson.model.LocalDateTimeContainer;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.TimeZone;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.bind.JsonbException;

public class IJsonSupportTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;

    public static void main(String[] args) {
        IJsonSupportTest t = new IJsonSupportTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testStrictNonObjectOrArrayTopLevel() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withStrictIJSON(Boolean.valueOf(true)));
        try {
            jsonb.toJson((Object)"Test String");
            throw new EETest.Fault("Failed to restrict serialization of top-level JSON texts that are neither objects nor arrays when JsonbConfig.withStrictIJSON is used.");
        }
        catch (JsonbException x) {
            return Status.passed((String)"OK");
        }
    }

    public Status testStrictBinaryDataEncoding() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withStrictIJSON(Boolean.valueOf(true)));
        String jsonString = jsonb.toJson((Object)new BinaryDataContainer());
        if (!jsonString.matches("\\{\\s*\"data\"\\s*:\\s*\"VGVzdCBTdHJpbmc=\"\\s*}")) {
            throw new EETest.Fault("Failed to correctly marshal binary data using BASE_64_URL binary data encoding when JsonbConfig.withStrictIJSON is used.");
        }
        return Status.passed((String)"OK");
    }

    public Status testStrictDate() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withStrictIJSON(Boolean.valueOf(true)));
        final Calendar instance = Calendar.getInstance();
        instance.clear();
        instance.set(1970, 0, 1);
        instance.setTimeZone(TimeZone.getTimeZone("UTC"));
        String jsonString = jsonb.toJson((Object)new DateContainer(){
            {
                this.setInstance(instance.getTime());
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"1970-01-01T00:00:00Z\\+00:00\"\\s*}")) {
            throw new EETest.Fault("Failed to serialize java.util.Date in the same format as java.time.ZonedDateTime when JsonbConfig.withStrictIJSON is used.");
        }
        return Status.passed((String)"OK");
    }

    public Status testStrictCalendar() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withStrictIJSON(Boolean.valueOf(true)));
        final Calendar calendarProperty = Calendar.getInstance();
        calendarProperty.clear();
        calendarProperty.set(1970, 0, 1);
        calendarProperty.setTimeZone(TimeZone.getTimeZone("Europe/Paris"));
        String jsonString = jsonb.toJson((Object)new CalendarContainer(){
            {
                this.setInstance(calendarProperty);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"1970-01-01T00:00:00Z\\+01:00\"\\s*}")) {
            throw new EETest.Fault("Failed to serialize java.util.Calendar in the same format as java.time.ZonedDateTime when JsonbConfig.withStrictIJSON is used.");
        }
        return Status.passed((String)"OK");
    }

    public Status testStrictGregorianCalendar() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withStrictIJSON(Boolean.valueOf(true)));
        final GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1970, 0, 1, 0, 0, 0);
        gregorianCalendar.setTimeZone(TimeZone.getTimeZone("Europe/Paris"));
        String jsonString = jsonb.toJson((Object)new GregorianCalendarContainer(){
            {
                this.setInstance(gregorianCalendar);
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"1970-01-01T00:00:00Z\\+01:00\"\\s*}")) {
            throw new EETest.Fault("Failed to serialize java.util.GregorianCalendar in the same format as java.time.ZonedDateTime when JsonbConfig.withStrictIJSON is used.");
        }
        return Status.passed((String)"OK");
    }

    public Status testStrictLocalDate() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withStrictIJSON(Boolean.valueOf(true)));
        String jsonString = jsonb.toJson((Object)new LocalDateContainer(){
            {
                this.setInstance(LocalDate.of(1970, 1, 1));
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"1970-01-01T00:00:00Z\\+00:00\"\\s*}")) {
            throw new EETest.Fault("Failed to serialize java.time.LocalDate in the same format as java.time.ZonedDateTime when JsonbConfig.withStrictIJSON is used.");
        }
        return Status.passed((String)"OK");
    }

    public Status testStrictLocalDateTime() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withStrictIJSON(Boolean.valueOf(true)));
        String jsonString = jsonb.toJson((Object)new LocalDateTimeContainer(){
            {
                this.setInstance(LocalDateTime.of(1970, 1, 1, 1, 1, 1));
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"1970-01-01T01:01:01Z\\+00:00\"\\s*}")) {
            throw new EETest.Fault("Failed to serialize java.time.LocalDate in the same format as java.time.ZonedDateTime when JsonbConfig.withStrictIJSON is used.");
        }
        return Status.passed((String)"OK");
    }

    public Status testStrictInstant() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withStrictIJSON(Boolean.valueOf(true)));
        String jsonString = jsonb.toJson((Object)new InstantContainer(){
            {
                this.setInstance(Instant.ofEpochMilli(0L));
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"1970-01-01T00:00:00Z\\+00:00\"\\s*}")) {
            throw new EETest.Fault("Failed to serialize java.time.Instant in the same format as java.time.ZonedDateTime when JsonbConfig.withStrictIJSON is used.");
        }
        return Status.passed((String)"OK");
    }

    public Status testStrictDuration() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withStrictIJSON(Boolean.valueOf(true)));
        String jsonString = jsonb.toJson((Object)new DurationContainer(){
            {
                this.setInstance(Duration.ofDays(1L).plus(Duration.ofHours(1L)).plus(Duration.ofSeconds(1L)));
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"PT25H1S\"\\s*}")) {
            throw new EETest.Fault("Failed to serialize java.time.Duration in the same format as in Appendix A of RFC 3339.");
        }
        return Status.passed((String)"OK");
    }
}

